/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: LL_IOf.h
;
;  Header file for low-level core interface layer.
;
*****************************************************************************/

//
// History
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 09/08/2011 Vinjam/SriRam: Integrated code which finds "OOS" anamoly by reading the PPE register.
//                           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//                           Grep for Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
// ******************************************************************

#ifndef _LL_IOF_H
#define _LL_IOF_H

#include "typedef.h"

#define READ_16BIT_LSW  1
#define READ_16BIT_MSW  2
#define READ_32BIT      3

#ifdef TARGET_HW
void SetUpDMAFill(uint32 SourceAddr, uint32 SourceEnd, uint32 DestAddr, uint32 ul_DspAdmaCtrl_FillMask, int32 ul_FillValue);
void SetUpDMATransfer(uint32 SourceAddr, uint32 SourceEnd, uint32 DestAddr);
void ReadCoreBuf32_DMA(uint32 ul_addr, int16 *psa_words, uint16 us_num);
void WriteCoreBuf32_DMA(uint32 ul_addr, int16 *psa_words, uint16 us_num);
#endif // TARGET_HW

#ifdef LL_IO_MACROS
#include "zep_ilv_memmap.h"

    #define ReadCoreReg(ul_addr, pul_data) *(pul_data) = *((volatile uint32*)((uint32)ul_addr))
   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
   #define ReadPpeReg(ul_addr, pul_data) {\
                                 *(pul_data) = *((volatile uint32*)((uint32)ul_addr));\
                                 *((volatile uint32*)((uint32)V_OVERFLOW_ADDR));\
                              }
   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)
    #define WriteCoreReg(ul_addr, ul_data) *((volatile uint32*)((uint32)ul_addr)) = (ul_data)
   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
   #define WritePpeReg(ul_addr, ul_data)  {\
                                 *((volatile uint32*)((uint32)ul_addr)) = (ul_data);\
                                 *((volatile uint32*)((uint32)V_OVERFLOW_ADDR));\
                                 }
   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)

    #define SetCoreReg(ul_addr, ul_mask) *((volatile uint32*)((uint32)ul_addr)) |= ul_mask
    #define ResetCoreReg(ul_addr, ul_mask) *((volatile uint32*)((uint32)ul_addr)) &= (~(ul_mask))

    #define GetDspReg(l_RegAddr) (*((volatile int32 *)l_RegAddr))
    #define MEI_RegisterRead(l_RegAddr, pul_data) *(pul_data) = *((volatile uint32*)((uint32)l_RegAddr))

    #define SetDspReg(l_RegAddr, l_Value) *((volatile int32 *)l_RegAddr) = l_Value
    #define MEI_RegisterWrite(l_RegAddr, l_Value) *((volatile int32 *)l_RegAddr) = l_Value

   #define mComputeHerculesOffsetAddress(ul_StartAddress, RealPart) { (ul_StartAddress) = ((uint32)(RealPart)); }


#define GetBitAllocationTableAddress(uc_port)   (uint8*)(IRI_QT_RAM_INACTIVE_BAT_ADDR)
#define GetGainScaleTableAddress(uc_port)       (uint16*)(IRI_QT_RAM_INACTIVE_GAIN_SCALE_ADDR)
#define GetSFDQMantissaTableAddress(uc_port) (int16*)(IRI_QT_RAM_FDQ_MANT_ADDR)
#define GetExtendedGainTableAddress(uc_port) (uint8*)(IRI_QT_RAM_INACTIVE_EGT_ADDR)
#define GetToneReorderingTableAddress(uc_port)  (uint16*)(IRI_QT_RAM_INACTIVE_TOT_ADDR)
#define GetActiveBGTNTableAddress(path, uc_port)(uint32*)(IRI_QT_RAM_ACTIVE_BGTN_ADDR)
#define GetActiveEGTTableAddress(uc_port)       (uint8*)(IRI_QT_RAM_TX_ACTIVE_EGT_ADDR)
#define GetSFDQExponentTableAddress(uc_port)    (uint8*)(IRI_QT_RAM_FDQ_EXP_ADDR)

#define GetMFDQFFMantissaTableAddress()         (int16*)((uint32)(IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_ADDR) )
#define GetMFDQFBMantissaTableAddress()         (int16*)((uint32)(IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_ADDR) )
#define GetMFDQFBExponentTableAddress()         (int32*)((uint32)(IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_ADDR) )

#else  //#ifdef LL_IO_MACROS

//XDSLRTFW-3365 (Start)
#define GetDspReg(l_RegAddr) (*((volatile int32 *)l_RegAddr))
#define SetDspReg(l_RegAddr, l_Value) *((volatile int32 *)l_RegAddr) = l_Value
//XDSLRTFW-3365 (End)

void ReadCoreReg(uint32 ul_addr, uint32 *pul_word);
void WriteCoreReg(uint32 ul_addr, uint32 ul_word);
void SetCoreReg(uint32 ul_addr, uint32 ul_mask);
void ResetCoreReg(uint32 ul_addr, uint32 ul_mask);

uint16* GetTxIFMFifoBaseAddress(void);
uint32* GetTxIFMFifoWrPtrAddress(void);
uint32* GetTxIFMFifoRdPtrAddress(void);
uint16* GetRxDFMFifoBaseAddress(void);
uint32* GetRxDFMFifoWrPtrAddress(void);
uint32* GetRxDFMFifoRdPtrAddress(void);

extern    uint16* GetToneReorderingTableAddress(uint8 uc_port);
extern    uint16* GetGainScaleTableAddress(uint8 uc_port);
extern    uint32* GetRxConstellationGainsTableAddress(void);
extern    uint8* GetBitAllocationTableAddress(uint8 uc_port);
extern    uint8* GetExtendedGainTableAddress(uint8 uc_port);
extern    int16* GetSFDQMantissaTableAddress(uint8 uc_port);
extern    int16* GetMFDQFFMantissaTableAddress(uint8 uc_port);
extern    int16* GetMFDQFBMantissaTableAddress(uint8 uc_port);
extern    uint32* GetMFDQFBExponentTableAddress(uint8 uc_port);
extern    uint32* GetMFDQFBToneTableAddress(uint8 uc_port);
extern   int16* GetRTVBuffer0Address(uint8 uc_port);
extern    int16* GetRTVBuffer1Address(uint8 uc_port);


   //These functions only exist for the 6.2 platform
extern   uint32* GetActiveBGTNTableAddress(int32 s_Path,uint8 uc_port);
extern   uint8* GetActiveEGTTableAddress(uint8 uc_port);
extern   uint8* GetSFDQExponentTableAddress(uint8 uc_port);


#endif   //#ifdef  LL_IO_MACROS


void ReadCoreBuf32(uint32 ul_addr, int16 *psa_words, uint16 us_num);
void WriteCoreBuf32(uint32 ul_addr, int16 *psa_words, uint16 us_num);
void WriteCoreBuf32NoDMA(uint32 ul_addr, int16 *psa_words, uint16 us_num);

void FillCoreBuf32(uint32 ul_addr, int32 l_value, uint16 us_num);

void WriteCoreBuf8(uint32 ul_addr, uint8 *pca_words, uint16 us_num);
void ReadCoreBuf8(uint32 ul_src_addr, int8 *pus_dst_addr, uint16 us_NWords);


#endif /*_LL_IOF_H */
