/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: RxFFTBufSTrans.h
*
*   Header file for RxFFTBufSTrans.c.
*
*-------------------------------------------------------------------------------
*/
//*-------------------------------------------------------------------------------//
// RxFFTBufSTrans.h
//
// History
//
// 21/11/2012 Kannan:
//   1. Added function declaration to notify PPE that Rx starts receiving data
//      in showtime.
//      Grep for "XDSLRTFW-541: Platform_VRX318"
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//*-------------------------------------------------------------------------------//

#ifndef _RXFFTBUFSTRANS_H
#define _RXFFTBUFSTRANS_H

void UpdateNumBuffersToRotate(void);
void UpdateLogicalBuffer1ProcBlocks(void);
void UpdateLogicalBuffer2ProcBlocks(void);
void TriggerShowtimeScenarioTransition(void);
void DoRxFFTBufferScenarioTransition(int16 s_currStateSymbolCount, int16 s_currStateLen);
void RShowtimeRxDummyInterruptTC(void);
void StartRxDataPath(void);

//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)
//XDSLRTFW-541: Platform_VRX318 (START_END)
void DFE_PPE_RxDataStatus_EnterShow(void);

#endif // _RXFFTBUFSTRANS_H
