/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_Filt.h
;
;  Header file for Strymon CPE core interface layer.
;
*****************************************************************************/
// ******************************************************************************
// STR_Filt.h
//
// History
//
// 22/11/2011 Hanyu:  Ported MFD code to VR9. Added code to initialize Rx IIR filter
//                    in G.dmt Annex A for NLNF measurement.
//                    This can be enabled by CMV bit-15 (default "0" means enabled)
//                    of INFO 121 0 in persistent memory
//                    and "cw test 7 0 0x0D" without SW API support
//                    or enabaled by cw cntl 0 0 0x09 with SW API support.
//                    Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// ******************************************************************************

#ifndef _STR_FILT_H
#define _STR_FILT_H

#include "typedef.h"

#define RX_WINDOW_LEN            16


//ADSL_62

//TX interp is symmetric, so only half of the filter length is strored
//RX decim length has to be a multiple of 8, the acutal length depends on the decim factor
#define MAX_LENGTH_TXINTERP_DIV_2   (192)
#define MAX_LENGTH_RXDECIM_DIV_2 (120)
#ifdef ISDN
#define PHASE_LENGTH_TXINTERP_PLUS  (16)
#else
#define PHASE_LENGTH_TXINTERP_PLUS  (16)
#endif

#ifdef ISDN
#define PHASE_LENGTH_TXINTERP_BIS   (16)
#else
#define PHASE_LENGTH_TXINTERP_BIS   (16)  //Check this is it 16 or 24?
#endif

#define PHASE_LENGTH_RXDECIM_PLUS   (15) //decim length [RX.DECIM.LEN]= DECIM_FIR actual length /8 -1
#define PHASE_LENGTH_RXDECIM_BIS    (29) //decim length [RX.DECIM.LEN]= DECIM_FIR actual length /8 -1

//iir are stored as shifts[2], inscale[1] and 5 coefs per biquad, Rx has an outScale
#define TX_IIR_SIZE (34)
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start)
//iir are stored as shifts[2], inscale[1] and 5 coefs per biquad, Rx has an outScale
//#define TX_IIR_SIZE (34)
//#define RX_IIR_SIZE (14)
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End)


// structure used for fir
struct StrymonCPE_FilterTable {
   uint16 us_Length_TxInterp_Plus;  //phase length for interp
   uint16 us_Length_TxInterp_Bis;   //phase length for interp
   uint16 us_Length_RxDecim_Plus;   //filter length/8 -1
   uint16 us_Length_RxDecim_Bis;    //filter length/8 -1
   int16 *psa_StrymonTxInterp_Plus;
   int16 *psa_StrymonTxInterp_Bis;
   int16 *psa_StrymonRxDecim_Plus;
   int16 *psa_StrymonRxDecim_Bis;
   int16 s_OS_TxInterp_Plus_AB;  // Annex A/B ADSL 2+
   int16 s_OS_TxInterp_Bis_AB;      // Annex A/B ADSL 2
   int16 s_OS_TxInterp_Plus_M;      // Annex M ADSL 2+
   int16 s_OS_TxInterp_Bis_M;    // Annex M ADSL 2
   int16 s_OS_RxDecim_Plus;
   int16 s_OS_RxDecim_Bis;
};



/* Global variables */
extern struct StrymonCPE_FilterTable gt_StrymonCPE_FilterTable;
//Txiir
#ifndef ISDN
extern uint32 *gula_Strymon_TxIir_Pots_Plus;
extern uint32 *gula_Strymon_TxIir_Pots_Bis;
#else
extern uint32 *gula_Strymon_TxIir_Isdn_Plus;
extern uint32 *gula_Strymon_TxIir_Isdn_Bis;
#endif
//Rx IIR
#ifndef ISDN
extern uint32 gula_Strymon_RxIir_Pots_Plus[];
extern uint32 gula_Strymon_RxIir_Pots_Bis[] ;
extern int16 gsa_StrymonFir_Filter_TxInterp_AnxM[];
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
extern uint32 gula_Strymon_RxIir_Nlnf_Bis[] ;
#endif
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
#else
extern uint32 gula_Strymon_RxIir_Isdn_Plus[];
extern uint32 gula_Strymon_RxIir_Isdn_Bis[] ;
#endif

//FIR Filters
extern int16 gsa_StrymonFir_Filter_TxInterp_Plus[];
#ifdef ISDN
extern int16 gsa_StrymonFir_Filter_TxInterp_AnxJ[];
#endif

extern int16 gsa_StrymonFir_Filter_TxInterp_Bis[];
extern int16 gsa_StrymonFir_Filter_RxDecim_Plus[];
extern int16 gsa_StrymonFir_Filter_RxDecim_Bis[];

#ifndef ISDN
extern int16 gsa_StrymonFir_Filter_TxInterp_AnxM_bis[];
#endif
#endif /*_STR_FILT_H */
