/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_IOf.h
;
;  Header file for Strymon CPE core interface layer.
;
*****************************************************************************/
//*******************************************************************
// STR_IOf.h
//
// History
//
// 20/09/2011 Anantha Ramu: Brought up Annex M feature
//                   Grep for XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M
//
// 22/11/2011 Hanyu:  Ported MFD code to VR9. Added code to initialize Rx IIR filter
//                    in G.dmt Annex A for NLNF measurement.
//                    This can be enabled by CMV bit-15 (default "0" means enabled)
//                    of INFO 121 0 in persistent memory
//                    and "cw test 7 0 0x0D" without SW API support
//                    or enabaled by cw cntl 0 0 0x09 with SW API support.
//                    Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
//*****************************************************************************

#ifndef _STR_IOF_H
#define _STR_IOF_H

/* Global variables */

extern uint16 gus_SMODE1, gus_SMODE2;

extern uint16 gus_SCONTROL, gus_SE_DECTRAIN;

/* Filter labels */
//FIR
#define TXINTERPFIR (1)
#define RXDECIMFIR   (2)

//RxIIR
#define RXIIR_POTS_PLUS (1)
#define RXIIR_POTS_BIS  (2)
#define RXIIR_ISDN_PLUS (3)
#define RXIIR_ISDN_BIS  (4)
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#define RXIIR_NLNF_BIS  (5)
#endif
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)

//TxIIR
#define TXIIR_POTS_PLUS (1)
#define TXIIR_POTS_BIS  (2)
#define TXIIR_ISDN_PLUS (3)
#define TXIIR_ISDN_BIS  (4)
//XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M (Start)
#define TXIIR_5M_LOW_BAND (5)
#define TXIIR_5M_HIGH_BAND (6)
#define TXIIR_3M_LOW_BAND  (7)
#define TXIIR_3M_HIGH_BAND (8)
//XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M (End)


extern struct StrymonCPE_FilterTable gt_StrymonCPE_FilterTable;

/* Function prototypes */
extern void MaskRxInput(void);
extern void UnmaskRxInput(void);
extern void LoadTxSineGain(void);
extern void SetTxSineGainUnity(void);
//XDSLRTFW-1611 (Start)
extern void Reconfig_HBFILT_scaling(void);
//XDSLRTFW-1611 (End)
extern int16 Init_StrymonCPE_Filter(uint16 us_FilterID, uint32 ul_CntlReg, uint16 us_NCo, uint16 us_offset, uint16 *pusa_Co);
extern void ReorderDEC(int16 *ps_data);
extern void ClearDEC(void);
extern void ClearAEC(void);
extern void Strymon_ClearResetState(void);
extern void Strymon_DisableAECPath(void);
extern void Strymon_SetAfeMode(int16 s_afe_mode);

//IIR loading functions
extern void LoadTxIir();
extern void LoadRxIir();
extern void TxLoadIir(void *p_filter );
extern void RxLoadIir(void *p_filter );
extern void LoadIir(void *p_filter, uint32 pul_register , uint32 ul_coefs_addr);

//FIR loading functions
void LoadDecim(void);
void LoadDecim2_Bypass(void);

#endif /*_STR_IOF_H */
