/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: ZPH_IOf.h
;
;  Header file for Zephyr CPE core interface layer.
;
*****************************************************************************/
//****************************************************************************
//ZPH_IOf.h
//
// History
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 14/06/2012 Kannan:
//          1. FIFO3 may be used to capture the RxData at the TC Layer Input
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//*****************************************************************************************

#ifndef _ZPH_IOF_H
#define _ZPH_IOF_H

#define NUM_OF_UPROCESSORS  (10)
#define NUM_OF_UPROC_STATES   (5)


typedef struct {
   uint32 base;
   uint32 lines;
   uint32 state[NUM_OF_UPROC_STATES];
} t_code_engine_info;


typedef struct {
   uint32 version;
   uint32 uproc_ena;
   t_code_engine_info engine[NUM_OF_UPROCESSORS];
   uint32 flags0;
   uint32 flags1;
   uint32 total_lines;
} t_microcode_header;


uint8   getNumValidBytes( uint16 s_LatencyPath , uint8 fifoNum , uint16 us_Tx_Rx);

void ReadHwFifo(uint16 fifoLP , uint16 fifoNum , uint16 us_Tx_Rx , uint16 us_numReqBytes, uint8 *puc_outbuf);
void WriteHwFifo(uint16 fifoLP , uint16 fifoNum , uint16 us_Tx_Rx , uint16 us_numReqBytes, uint8 *puc_inbuf);

extern uint32 fci_prog_tx_adsl2_2bc_ibits[];
extern uint32 fci_prog_rx_adsl2_2bc_ibits[];
extern uint32 fci_prog_rx_adsl2_retx_lp1[]; //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (START_END)
extern uint32 fci_prog_tx_gdmt3_lp0[];
extern uint32 fci_prog_tx_gdmt3_lp1[];
extern uint32 fci_prog_rx_gdmt3_lp0[];
extern uint32 fci_prog_rx_gdmt3_lp1[];

#define RX_SEQP_DONE (1)
#define EOC_FIFO    (0)
#define HDLC_FIFO   (0)
#define AOC_FIFO    (1)
#define IBITS_FIFO   (2)
#define IBITS_FIFO_WRITE  ((LP0_DATA_PATH << 12)|(IBITS_FIFO<<8)|(1<<10))
#define IBITS_FIFO_UPDATE ((LP0_DATA_PATH << 12)|(IBITS_FIFO<<8)|(1<<16))
#define USE_RX_FIFO (0)
#define USE_TX_FIFO (1)


//Zephyr debug code

#ifdef ZEP_DEBUG_BLD
   void EnableTxFifo3Capture(void);
   void DisableTxFifo3Capture(void);
   void UpdateTxFifo3Stat(void);
#endif //#ifdef ZEP_DEBUG_BLD
#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)
   void EnableRxFifo3Capture(void);
   void DisableRxFifo3Capture(void);
   void UpdateRxFifo3Stat(void);
   void ReadFifo3Data(FlagT gft_TxRxFlag, int16 s_NumBytes, uint8 *puc_buf);
#endif //#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)


#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)
   #define FIFO3_CAPTURE_DISABLE (0)
   #define FIFO3_CAPTURE_ENABLE  (1)
   #define FIFO3_CAPTURE_GETDATA (2)
   #define FIFO3_CAPTURE_ERROR      (3)
#endif //#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)

#endif /*_ZPH_IOF_H */
