/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: cri_iof.h
;
;  Header file for CRI core interface layer function.
;
*****************************************************************************/
//*-------------------------------------------------------------------------------//
// cri_iof.h
//
// History
//
// 21/11/2012 Kannan:
//   1. Added function declaration to notify PPE that both TX and RX left showtime.
//      Grep for "XDSLRTFW-541: Platform_VRX318"
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//*-------------------------------------------------------------------------------//

#ifndef _CRI_IOF_H
#define _CRI_IOF_H

// Global array to map f/w interrupts to cri register mask
extern uint32 gula_MapInterruptToMask[NUM_INTERRUPTS];

/* Function prototypes */

void SetupL2StateInterruptProcessing(void);


void ModifyTxInterruptReg(int16 s_enable, uint32 ul_bitmask);
void ModifyRxInterruptReg(int16 s_enable, uint32 ul_bitmask);


FlagT CheckQtStall(uint8 uc_TxRxIndicator);
void ClearTxStall(void);
void ClearRxStall(void);
void EnableTxPms(void);
void EnableRxPms(void);
void DisableTxPms(void);
void DisableRxPms(void);
void EnableTxQtp(void);
void EnableRxQtp(void);
void DisableTxQtp(void);
void DisableRxQtp(void);
void Reconfig_CRI(void);
void InitCRI_ForLinkStart(void);
extern int16 gs_CRI_DbgCntl;

//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)
//XDSLRTFW-541: Platform_VRX318 (START_END)
void DFE_PPE_LinkStatus_TxRxLeaveShow(void);
void DFE_PPE_RxDataStatus_LeaveShow(void);


//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
void DFE_PPE_Shared_PPE_Reg_Init(void);
void DFE_PPE_PDBRAM_S_44K_Mem_Owner(void);
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

void Ppe_clockChange(void);   // XDSLRTFW-3566 (Start_End)
#endif /*_CRI_IOF_H */
