/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: memrymap.h
*
*   This file contains a congregated memory map for all ADSL cores.
*
*-------------------------------------------------------------------------------
*/

#ifndef _MEMRYMAP_H
#define _MEMRYMAP_H

#include "alp_memmap.h"
#include "bcr_memmap.h"
#include "cri_memmap.h"
#include "ft_memmap.h"
#include "ftb_memmap.h"
#include "qt_memmap.h"
#include "qtp_memmap.h"
#include "str_memmap.h"
#include "zep_memmap.h"
#include "zep_memmap_cnfg.h" // mem map for buffers in iibram.
//#include "zep_ilv_memmap.h"

#include "afe.h"



#define MASK_BIT0             (0x0001)
#define MASK_BIT1             (0x0002)
#define MASK_BIT2             (0x0004)
#define MASK_BIT3             (0x0008)
#define MASK_BIT4             (0x0010)
#define MASK_BIT5             (0x0020)
#define MASK_BIT6             (0x0040)
#define MASK_BIT7             (0x0080)
#define MASK_BIT8             (0x0100)
#define MASK_BIT9             (0x0200)
#define MASK_BIT10               (0x0400)
#define MASK_BIT11               (0x0800)
#define MASK_BIT12               (0x1000)
#define MASK_BIT13               (0x2000)
#define MASK_BIT14               (0x4000)
#define MASK_BIT15               (0x8000)
#define MASK_BIT16               (0x00010000)
#define MASK_BIT17               (0x00020000)
#define MASK_BIT18               (0x00040000)
#define MASK_BIT19               (0x00080000)
#define MASK_BIT20               (0x00100000)
#define MASK_BIT21               (0x00200000)
#define MASK_BIT22               (0x00400000)
#define MASK_BIT23               (0x00800000)
#define MASK_BIT24               (0x01000000)
#define MASK_BIT25               (0x02000000)
#define MASK_BIT26               (0x04000000)
#define MASK_BIT27               (0x08000000)
#define MASK_BIT28               (0x10000000)
#define MASK_BIT29               (0x20000000)
#define MASK_BIT30               (0x40000000)
#define MASK_BIT31               (0x80000000)

//==============================================================================
// BCR constants - HW specific
//==============================================================================
#define ABC0                  (0x1)
#define ABC1                  (0x2)
#define EBC                   (0x3)

//==============================================================================
// Alphaeus constants - HW specific
//==============================================================================
// assume there are no gap between these registers
// the order is important
#define ATM_RX_NUM_COUNTERS         (6)
#define ATM_RX_CELL_CNT          (0) // DREG_AR_CELL0_ADDR
#define ATM_RX_IDLE_CNT          (1) // DREG_AR_IDLE_CNT0_ADDR
#define ATM_RX_AIDLE_CNT         (2) // DREG_AR_AIIDLE_CNT0_ADDR
#define ATM_RX_BE_CNT            (3) // DREG_AR_BE_CNT0_ADDR
#define ATM_RX_HEC_CNT           (4) // DREG_AR_HEC_CNT0_ADDR
#define ATM_RX_CD_CNT            (5) // DREG_AR_CD_CNT0_ADDR

#ifdef PPE_ENGINE

//PPE PTM registers
#define NUM_READ_TX_PTM_REGS  (1)
#define TX_CW_CNT          (0)
//#define TX_IDLE_CNT            (1)

#define NUM_READ_RX_PTM_REGS  (6)
#define RX_PTM_STAT           (0)
#define RX_CW_CNT          (1)
#define RX_CERRN_CNT       (2)
#define RX_CERRNP_CNT         (3)
#define RX_CVN_CNT            (4)
#define RX_CVNP_CNT           (5)
#endif //#ifdef PPE_ENGINE

#define TX_IDLE_CELL_PAYLOAD     (0x6A)
#define RX_IDLE_CELL_PAYLOAD     (0x6A)

#define CELL_DELIN_DELTA         (6) // # good HEC needed to enter sync state
#define CELL_DELIN_ALPHA         (7) // # HEC errors needed to jump out of sync state

#define CBPAGE_SIZE              (28) // # of words per cell page
#define NUM_TX_CBPAGE            (8)
#define NUM_RX_CBPAGE            (18)

//==============================================================================
// CRI constants - HW specific
//==============================================================================
#define MAX_TIME_PER_FRAME_4K    (26496)
#define MAX_TIME_PER_TXFC_4K     (5000)
#define MAX_TIME_PER_TXQT_4K     (4000)
#define MAX_TIME_PER_IFFT_4K     (7000)
#define MAX_TIME_PER_PARR_4K     (9000)
#define MAX_TIME_PER_RXFC_4K     (15000)
#define MAX_TIME_PER_RXQT_4K     (14000)
#define MAX_TIME_PER_FFT_4K         (7000)

#define TX_FC_TIMER_CNT_4K       (0)
#define TX_QT_TIMER_CNT_4K       (TX_FC_TIMER_CNT_4K+MAX_TIME_PER_TXFC_4K)
#define TX_DSP_LPBK_TIMER_CNT_4K (MAX_TIME_PER_FRAME_4K-MAX_TIME_PER_FFT_4K-MAX_TIME_PER_RXQT_4K)

//==============================================================================
// Iridia-FT constants - HW specific
//==============================================================================
#define FT_RX_CTRL_FFT_TSIZE_MASK   (0x0000001C)
#define FT_RX_CTRL_FFT_TSIZE_64     (0x00000000)
#define FT_RX_CTRL_FFT_TSIZE_256 (0x00000008)
#define FT_RX_CTRL_FFT_TSIZE_512 (0x0000000C)
#define FT_RX_CTRL_FFT_TSIZE_1024   (0x00000010)
#define FT_RX_CTRL_FFT_TSIZE_2048   (0x00000014)
#define FT_RX_CTRL_FFT_TSIZE_4096   (0x00000018)

#define FT_TX_CTRL_IFFT_TSIZE_MASK  (0x00000038)
#define FTB_RX_CTRL_FFT_TSIZE_MASK  (0x00000070)
#define FTB_IFFT_TSIZE_MASK         (0x00007777)

#define FT_RX_CTRL_RX_SYNC_ENABLE   (0x00000200)

#define FT_RX_CTRL_RX_PAD_MASK      (0x00000800)
#define FT_RX_CTRL_RX_PAD_ENABLE (0x00000800)
#define FT_RX_CTRL_RX_PAD_DISABLE   (0x00000000)



//==============================================================================
// Iridia-QT constants - HW specific
//==============================================================================
#define QT_I_CONFIG_I_NSC_MASK      (0x00000007)
#define QT_I_CONFIG_I_NSC_32     (0x00000000)
#define QT_I_CONFIG_I_NSC_64     (0x00000001)
#define QT_I_CONFIG_I_NSC_128    (0x00000002)
#define QT_I_CONFIG_I_NSC_256    (0x00000003)
#define QT_I_CONFIG_I_NSC_512    (0x00000004)
#define QT_I_CONFIG_I_NSC_1024      (0x00000005)
#define QT_I_CONFIG_I_NSC_2048      (0x00000006)
#define QT_I_CONFIG_I_NSC_4096      (0x00000007)

#define QT_IR_CONFIG_NSC_RX_MASK (0x00000007)
#define QT_IR_CONFIG_NSC_RX_32      (0x00000000)
#define QT_IR_CONFIG_NSC_RX_64      (0x00000001)
#define QT_IR_CONFIG_NSC_RX_128     (0x00000002)
#define QT_IR_CONFIG_NSC_RX_256     (0x00000003)
#define QT_IR_CONFIG_NSC_RX_512     (0x00000004)
#define QT_IR_CONFIG_NSC_RX_1024 (0x00000005)
#define QT_IR_CONFIG_NSC_RX_2048 (0x00000006)
#define QT_IR_CONFIG_NSC_RX_4096 (0x00000007)

// ping-pong table related constants
#define TX_INACTIVE_SEG0            (0)
#define RX_INACTIVE_SEG0                (1)
#define TX_INACTIVE_SEG1            (2)
#define RX_INACTIVE_SEG1                (3)
// ping-pong table ID
#define TX_BAT                (0x00)
#define TX_GST                (0x01)
#define TX_TRT                (0x02)
#define TX_EGT                (0x03)
#define RX_BAT                (0x10)
#define RX_GST                (0x11)
#define RX_TRT                (0x12)
#define RX_EGT                (0x13)


// QAM encoder gain exponent table
#define ENCGAINEXP1        0 // b=1 constellation
#define ENCGAINEXP2        0 // b=2 constellation
#define ENCGAINEXP3     1 // b=3 constellation
#define ENCGAINEXP4     1
#define ENCGAINEXP5     2
#define ENCGAINEXP6     2
#define ENCGAINEXP7     3
#define ENCGAINEXP8     3
#define ENCGAINEXP9     4
#define ENCGAINEXP10       4
#define ENCGAINEXP11    5
#define ENCGAINEXP12    5
#define ENCGAINEXP13    6
#define ENCGAINEXP14    6
#define ENCGAINEXP15    7

// QAM decoder gain exponent table
#define DECGAINEXP1        0 // b=1 constellation
#define DECGAINEXP2        0 // b=2 constellation
#define DECGAINEXP3     0 // b=3 constellation
#define DECGAINEXP4     1
#define DECGAINEXP5     1
#define DECGAINEXP6     2
#define DECGAINEXP7     2
#define DECGAINEXP8     3
#define DECGAINEXP9     3
#define DECGAINEXP10       4
#define DECGAINEXP11    4
#define DECGAINEXP12    5
#define DECGAINEXP13    5
#define DECGAINEXP14    6
#define DECGAINEXP15    6

// following constants are originally defined in QT BM
#define FRAC_BITS_DESCALED_XY_TCM         (7)
#define FRAC_BITS_DEC_COMBGAIN_MANTISSA      (13)
#define FRAC_BITS_DESCALE_INPUT           (13)

//==============================================================================
// Zephyr-FC constants - HW specific
//==============================================================================
#define TX_FIFO0_VALID_BYTES_MASK   (0x3F)
#define TX_FIFO1_VALID_BYTES_MASK   (0x3F)
#define TX_FIFO2_VALID_BYTES_MASK   (0x7)

#define RX_FIFO0_VALID_BYTES_MASK   (0x3F)
#define RX_FIFO1_VALID_BYTES_MASK   (0x3F)
#define RX_FIFO2_VALID_BYTES_MASK   (0x7)

#endif // _MEMRYMAP_H
