/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_MEMMAP_CNFG_H
#define _ZEP_MEMMAP_CNFG_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zep_memmap_cnfg.h
 * DESCRIPTION:      Memory map definition
 *
 **********************************************************************/
//****************************************************************************
//zep_memmap_cnfg.h
//
// History
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 14/06/2012 Kannan:
//          1. FIFO3 can be used to get the debug data in Rx Path
//          2. Micro code length is changed for Tx to 70 & Rx to 120
//             This is changed to have more headroom in Rx Path
//             micro code as we add more debug code to capture the
//             data at Zephyr.
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 05/09/2014 Ram: Added fix for the issue "ADSL ReTX link drop when DS NDR > 26 Mbps".
//                 Memory allocated to LP1 section of RX-DTB wasn't sufficient to handle case
//                 where DS data rate > 26 Mbps, hence re-allocated memory from LP0 section.
//                 Grep for: XDSLRTFW-1381
//
// 04/01/2015 Anantha Ramu/TV Ram: Added fix for uncorrected DTUs due to Q full condition.
//            Grep for XDSLRTFW-1223
//*****************************************************************************************

#include "zep_memmap.h"

#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)
extern uint32 gula_fifo3_dbg[];
#endif //#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)

//defined in zep_memmap.h
/**************************************************************
#define ZEP_REG_TX_BASE_GLOBAL         (uint32)(0x20D800)
#define ZEP_REG_RX_BASE_GLOBAL         (uint32)(0x20DC00)

#define ZEP_RAM_RX_CW_ADDR             (uint32)(0x20C000)
#define ZEP_RAM_RX_CW_SIZE             (2*512)

#define ZEP_RAM_IIBRAM_ADDR            (uint32)(0x40000)
#define ZEP_RAM_IIBRAM_SIZE            (2*84*1024)

// Data Transfer Buffer
#define ZEP_ILV_RAM_DTB_ADDR           (uint32)(0x254000)   //Tx/Rx Data Transfer Buffer
#define ZEP_ILV_RAM_DTB_SIZE           (4*2816)

////////////////////////////////////
#define ZEP_ILV_RAM_DMET_ADDR          (uint32)(0x257000) // RX Deinterleave Metric RAM (byte access)
#define ZEP_ILV_RAM_DMET_SIZE          (4*512)

****************************************************************/

// ===== Define three sections of memory blocks that reside in IIBRAM =================
// ===== 1) PRAM registers, 2) Interleaver memory, 3)  MicroCode =====================

#define OHFIFO_SIZE              (32)      //size of each OH fifo in bytes
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//#define LP_MICROCODE_WORDS     (70)      //maximum size of each micro-code block per latency path (for one direction) in 32-bit words
//Increased from 70 to 90 due to increase of length in the ADSL ReTx micro code at LP1
#define LP_MICROCODE_WORDS       (96)      //maximum size of each micro-code block per latency path (for one direction) in 32-bit words

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (END)

//Define the size of each memory block in bytes
//Note the total memmory available for the following four blocks should be (172032-32768-2096-8192) = 128976 bytes
#define ZEP_PRAM_BLOCK_SIZE               ((ZEP_REG_TX_PRAM_SIZE+ZEP_REG_RX_PRAM_SIZE+4)*2*4)      //=(250+4)*2*4 = 2032
                                             //note: +4 for extra gap, *2 for 2 LPs, *4 for words to byte conversion
#define ZEP_OHFIFO_BLOCK_SIZE             (OHFIFO_SIZE*16)       //=(16*32)=512, total of 16 fifos and each allocated 32 bytes
#if 1
#define ZEP_MICRO_CODE_BLOCK_SIZE         (LP_MICROCODE_WORDS*4*4) //=(96*4*4)=1536, 2 TX LPs, 2 RX LPs, the final *4 is for word to byte conversion
#else
#define ZEP_MICRO_CODE_BLOCK_SIZE   (((70*2) + (120 * 2))*4) //=(96*4*4)=1536, 2 TX LPs, 2 RX LPs, the final *4 is for word to byte conversion
#endif
#define ZEP_ILV_DILV_BLOCK_SIZE           (20*1024)

//XDSLRTFW-1634 (Start_End)
#define DSRETX_MIN_DTUs_REQOVERQTX        (3)   //Additional DTUs required for Qrx on top of Qtx size
//XDSLRTFW-1223 Qrx Full Fix (Start-End)
#define ILVB_WRPTR_TABLE_SIZE_LW          (3)

#if 0
    // some memory map info from the TARGET_HW build:

    RT 0x62004d jgZEP_RAM_TX_RX_UCODE_BASE_         : 0x0000F000
    RT 0x62008d jgZEP_RAM_TX_LP0_UCODE_ADDR_        : 0x0000F000
    RT 0x6200Cd jgZEP_RAM_TX_LP1_UCODE_ADDR_        : 0x0000F118
    RT 0x62010d jgZEP_RAM_RX_LP0_UCODE_ADDR_        : 0x0000F230
    RT 0x62014d jgZEP_RAM_RX_LP1_UCODE_ADDR_        : 0x0000F348
    RT 0x62018d jgZEP_PRAM_BASE_                    : 0x0000F600
    RT 0x6201Cd jgZEP_PRAM_BLOCK_SIZE_              : 0x000007F0
    RT 0x62020d jgZEP_REG_TX_PRAM_SIZE_             : 0x000001E8
    RT 0x62024d jgZEP_REG_RX_PRAM_SIZE_             : 0x00000200
    RT 0x62028d jgZEP_PRAM_TX_LP0_START_ADDR_       : 0x0004F60C
    RT 0x6202Cd jgZEP_PRAM_TX_LP1_START_ADDR_       : 0x0004F7F4
    RT 0x62030d jgZEP_PRAM_RX_LP0_START_ADDR_       : 0x0004F9EC
    RT 0x62034d jgZEP_PRAM_RX_LP1_START_ADDR_       : 0x0004FBEC
    RT 0x62038d jgZEP_RAM_OHFIFO_BASE_              : 0x0000FDF0
    RT 0x6203Cd jgZEP_RAM_ILV_DLIV_BASE_            : 0x00010000
    RT 0x62040d jgZEP_RAM_ILV_BASE_                 : 0x00014400
    RT 0x62044d jgZEP_RAM_DILV_BASE_                : 0x00010000
    RT 0x62048d jgZEP_PRAM_ZR_FIFO_BASE0_LP0_ADDR_  : 0x0004FA54
    RT 0x6204Cd jgZEP_ILV_RAM_TXDTB_LP0_BASE_       : 0x00000000
    RT 0x62050d jgZEP_ILV_RAM_RXDTB_LP0_BASE_       : 0x00000000
    RT 0x62054d jgZEP_ILV_LP0_BASE_                 : 0x00014400
    RT 0x62058d jgZEP_DILV_LP0_BASE_                : 0x00010000
    RT 0x6205Cd jgZEP_RAM_TX_LP0_OHFIFO0_OFFSET_    : 0x0000FDF0
    RT 0x62060d jgZEP_RAM_RX_LP0_OHFIFO0_OFFSET_    : 0x0000FEF0
#endif
//All the following three addresses are the offset from the beginning of IIBRAM in bytes

#ifdef TARGET_HW
   extern int32 __gla_ZepPramStart[];
   extern int32 __gla_ZepOhvdFifoStart[];
   extern int32 __gla_ZepTxRxUcodeStart[];
    extern int32 __gla_HwIlvDilvStart[];
    extern int32 __gla_ShowHwDilvStart[];
    extern int32 __gla_ShowHwIlvStart[];

#else
    // these are addresses obtained from TARGET_HW build
   #define __gla_ZepPramStart              0x4F600
   #define __gla_ZepOhvdFifoStart          0x4FDF0
   #define __gla_ZepTxRxUcodeStart         0x4F000
    #define __gla_ShowHwDilvStart          0x50000
    #define __gla_HwIlvDilvStart           __gla_ShowHwDilvStart
    #define __gla_ShowHwIlvStart           0x54400
#endif

#define ZEP_PRAM_BASE               ((int32)__gla_ZepPramStart - ZEP_RAM_IIBRAM_ADDR)
#define ZEP_RAM_OHFIFO_BASE         ((int32)__gla_ZepOhvdFifoStart  - ZEP_RAM_IIBRAM_ADDR)
#define ZEP_RAM_ILV_DLIV_BASE       ((int32)__gla_HwIlvDilvStart  - ZEP_RAM_IIBRAM_ADDR)
#define ZEP_RAM_DILV_BASE           ((int32)__gla_ShowHwDilvStart  - ZEP_RAM_IIBRAM_ADDR)
#define ZEP_RAM_ILV_BASE            ((int32)__gla_ShowHwIlvStart  - ZEP_RAM_IIBRAM_ADDR)
#define ZEP_RAM_TX_RX_UCODE_BASE    ((int32)__gla_ZepTxRxUcodeStart  - ZEP_RAM_IIBRAM_ADDR)

#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)
#define ZEP_ONE_PORT_SHOW_DATA_BASE   ((int32)gula_fifo3_dbg - ZEP_RAM_IIBRAM_ADDR)
#endif //#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)

//========= Configure DTB memory addresses (in 32-bit words) ==================================

#define ZEP_DTB_SIZE_WDS                     (ZEP_ILV_RAM_DTB_SIZE/4)
#define ZEP_DTB_SIZE_TX_WDS                  (ZEP_DTB_SIZE_WDS/2)      //TX DTB buffer size in 32-bit words
#define ZEP_DTB_SIZE_RX_WDS                  (ZEP_DTB_SIZE_WDS - ZEP_DTB_SIZE_TX_WDS)   ////RX DTB buffer size in 32-bit words

#define ZEP_ILV_RAM_TXDTB_OFFSET             (uint32)(0)                  //in 32-bit words
#define ZEP_ILV_RAM_RXDTB_OFFSET             (uint32)(ZEP_ILV_RAM_TXDTB_OFFSET + ZEP_DTB_SIZE_TX_WDS)   //in 32-bit words
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
#define ZEP_ILV_RAM_RETX_TXDTB_LP0_SIZE      (ZEP_DTB_SIZE_TX_WDS - ZEP_ILV_RAM_RETX_TXDTB_LP1_SIZE)
#define ZEP_ILV_RAM_RETX_TXDTB_LP1_SIZE      (1) //1 word to send 24 bits of RRC in US for ReTx
#define ZEP_ILV_RAM_RETX_TXDTB_LP0_BASE      (0) // Base of the DTB in 32-bit words
#define ZEP_ILV_RAM_RETX_TXDTB_LP1_BASE      (ZEP_ILV_RAM_RETX_TXDTB_LP0_BASE + ZEP_ILV_RAM_RETX_TXDTB_LP0_SIZE)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

#define ZEP_ILV_RAM_TXDTB_LP0_SIZE           (1000)      //max LDR = 1000*32*4000 = 128 Mbps
#define ZEP_ILV_RAM_TXDTB_LP1_SIZE           (ZEP_DTB_SIZE_TX_WDS - ZEP_ILV_RAM_TXDTB_LP0_SIZE) //max (LDR=2816/2-1000)*32*4000 ~= 52 Mbps

//XDSLRTFW-XDSLRTFW-1381 (Start)
//Dividing the total RX DTB space equally between LP0 and LP1.
//LP0 = LP1 = 1408/2 = 704 32 bit words = ((704 * 32)/2) * 4000 = ~45 Mbps.
//Note: (704 * 32)/2) => divide by 2 is being done as PMS-RX processing is delayed by one symbol compared to QT-RX
#define ZEP_ILV_RAM_RXDTB_LP0_SIZE           (ZEP_DTB_SIZE_RX_WDS/2)
#define ZEP_ILV_RAM_RXDTB_LP1_SIZE           (ZEP_DTB_SIZE_RX_WDS - ZEP_ILV_RAM_RXDTB_LP0_SIZE)
//XDSLRTFW-XDSLRTFW-1381 (Stop)

#define ZEP_ILV_RAM_TXDTB_LP0_BASE           (0) // Base of the DTB in 32-bit words
#define ZEP_ILV_RAM_TXDTB_LP1_BASE           (ZEP_ILV_RAM_TXDTB_LP0_BASE + ZEP_ILV_RAM_TXDTB_LP0_SIZE)
#define ZEP_ILV_RAM_RXDTB_LP0_BASE           (0) //Base is relative to Offset
#define ZEP_ILV_RAM_RXDTB_LP1_BASE           (ZEP_ILV_RAM_RXDTB_LP0_BASE + ZEP_ILV_RAM_RXDTB_LP0_SIZE)


//======= Configure the interleaver/deinterleaver memory address (in bytes) =================

//Allocated 7KB for Z_ILV memory section
#define ZEP_ILV_BLOCK_SIZE                   (7*1024) //XDSLRTFW-3717 (Start_End)
#define ZEP_DILV_BLOCK_SIZE                  (29*1024) //XDSLRTFW-1223 Qrx Full Fix (Start-End)

#define ZEP_ILV_LP0_BLOCK_SIZE               (ZEP_ILV_BLOCK_SIZE-2)      //mei fixme: LP0 used almost all now
#define ZEP_ILV_LP1_BLOCK_SIZE               (ZEP_ILV_BLOCK_SIZE-ZEP_ILV_LP0_BLOCK_SIZE)

#define ZEP_DILV_LP0_BLOCK_SIZE              (ZEP_DILV_BLOCK_SIZE-2)      //mei fixme: LP0 used almost all now
#define ZEP_DILV_LP1_BLOCK_SIZE              (ZEP_DILV_BLOCK_SIZE-ZEP_DILV_LP0_BLOCK_SIZE)

#define ZEP_ILV_LP0_BASE                     (ZEP_RAM_ILV_BASE)
#define ZEP_ILV_LP1_BASE                     (ZEP_ILV_LP0_BASE+ZEP_ILV_LP0_BLOCK_SIZE)

#define ZEP_DILV_LP0_BASE                    (ZEP_RAM_DILV_BASE)
#define ZEP_DILV_LP1_BASE                    (ZEP_DILV_LP0_BASE+ZEP_DILV_LP0_BLOCK_SIZE)

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
#define RETX_ZEP_ILV_LP0_BLOCK_SIZE          (ZEP_ILV_BLOCK_SIZE - 4) //7K - 4 bytes
#define RETX_ZEP_ILV_LP1_BLOCK_SIZE          (ZEP_ILV_BLOCK_SIZE - RETX_ZEP_ILV_LP0_BLOCK_SIZE)   //4 Bytes

#define RETX_ZEP_DILV_LP0_BLOCK_SIZE         (1024) //1K bytes
#define RETX_ZEP_DILV_LP1_BLOCK_SIZE         (ZEP_DILV_BLOCK_SIZE) - RETX_ZEP_DILV_LP0_BLOCK_SIZE //29K - 1Kbytes

#define RETX_ZEP_ILV_LP0_BASE                (ZEP_RAM_ILV_BASE)
#define RETX_ZEP_ILV_LP1_BASE                (RETX_ZEP_ILV_LP0_BASE + RETX_ZEP_ILV_LP0_BLOCK_SIZE)

#define RETX_ZEP_DILV_LP0_BASE               (ZEP_RAM_DILV_BASE)
#define RETX_ZEP_DILV_LP1_BASE               (RETX_ZEP_DILV_LP0_BASE + RETX_ZEP_DILV_LP0_BLOCK_SIZE)

#define DEFAULT_RETX_ZEP_DILV_LP1_BLOCK_SIZE (256*4)             // should be good enough for D=1

#define DTU_POINTERS_BASE_ADDR               (RETX_ZEP_DILV_LP1_BASE + DEFAULT_RETX_ZEP_DILV_LP1_BLOCK_SIZE)
#define DTU_POINTERS_LW_BASE_ADDR            (DTU_POINTERS_BASE_ADDR >> 2)

#define DTU_READ_POINTERS_SIZE               (16 * 4) //16 read pointer, each with 4 bytes
#define RETX_QUEUE_BASE_ADDR                 (DTU_POINTERS_BASE_ADDR + DTU_READ_POINTERS_SIZE)
#define RETX_QUEUE_SIZE                      (RETX_ZEP_DILV_LP1_BLOCK_SIZE - DEFAULT_RETX_ZEP_DILV_LP1_BLOCK_SIZE - DTU_READ_POINTERS_SIZE)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

//======= Configure the micro-code address (in bytes) =======================================
#if 1
#define ZEP_RAM_TX_LP0_UCODE_ADDR            (uint32)(ZEP_RAM_TX_RX_UCODE_BASE)
#define ZEP_RAM_TX_LP1_UCODE_ADDR            (uint32)(ZEP_RAM_TX_RX_UCODE_BASE + (LP_MICROCODE_WORDS*4))
#define ZEP_RAM_RX_LP0_UCODE_ADDR            (uint32)(ZEP_RAM_TX_RX_UCODE_BASE + (LP_MICROCODE_WORDS*4*2))
#define ZEP_RAM_RX_LP1_UCODE_ADDR            (uint32)(ZEP_RAM_TX_RX_UCODE_BASE + (LP_MICROCODE_WORDS*4*3))
#else
#define ZEP_RAM_TX_LP0_UCODE_ADDR            (uint32)(ZEP_RAM_TX_RX_UCODE_BASE)
#define ZEP_RAM_TX_LP1_UCODE_ADDR            (uint32)(ZEP_RAM_TX_LP0_UCODE_ADDR + (70*4))
#define ZEP_RAM_RX_LP0_UCODE_ADDR            (uint32)(ZEP_RAM_TX_LP1_UCODE_ADDR + (70*4))
#define ZEP_RAM_RX_LP1_UCODE_ADDR            (uint32)(ZEP_RAM_RX_LP0_UCODE_ADDR + (120*4))
#endif

//====== Configure OH FIFO addresses (in bytes)
//these sizes are in bytes.
#define ZEP_RAM_OHFIFO_SIZE_32               (uint32)(32)
#define ZEP_RAM_OHFIFO_SIZE_6                (uint32)(6)

#define   ZEP_RAM_TX_LP0_OHFIFO0_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*0)
#define   ZEP_RAM_TX_LP0_OHFIFO1_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*1)
#define   ZEP_RAM_TX_LP0_OHFIFO2_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*2)
#define   ZEP_RAM_TX_LP0_OHFIFO3_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*3)
#define   ZEP_RAM_TX_LP1_OHFIFO0_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*4)
#define   ZEP_RAM_TX_LP1_OHFIFO1_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*5)
#define   ZEP_RAM_TX_LP1_OHFIFO2_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*6)
#define   ZEP_RAM_TX_LP1_OHFIFO3_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*7)

#define   ZEP_RAM_RX_LP0_OHFIFO0_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*8)
#define   ZEP_RAM_RX_LP0_OHFIFO1_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*9)
#define   ZEP_RAM_RX_LP0_OHFIFO2_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*10)
#define   ZEP_RAM_RX_LP0_OHFIFO3_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*11)
#define   ZEP_RAM_RX_LP1_OHFIFO0_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*12)
#define   ZEP_RAM_RX_LP1_OHFIFO1_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*13)
#define   ZEP_RAM_RX_LP1_OHFIFO2_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*14)
#define   ZEP_RAM_RX_LP1_OHFIFO3_OFFSET      (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*15)

#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)
//Following FIFO3 configuration is for capturing the TX scrambler input and RX scrambler output data
#define ZEP_RAM_TX_OHFIFO3_DBG0_SIZE         (0*4)      //in byte, support the line rate of 64 mbps for US
#define ZEP_RAM_RX_OHFIFO3_DBG0_SIZE         (1024*4)      //in byte, support the line rate of 128 Mbps for DS
#define   ZEP_RAM_TX_OHFIFO3_DBG0_OFFSET     (ZEP_ONE_PORT_SHOW_DATA_BASE)
#define   ZEP_RAM_RX_OHFIFO3_DBG0_OFFSET     (ZEP_RAM_TX_OHFIFO3_DBG0_OFFSET + ZEP_RAM_TX_OHFIFO3_DBG0_SIZE)
#define ZEP_RAM_TX_OHFIFO3_DBG0_ADDR         (ZEP_RAM_IIBRAM_ADDR + ZEP_RAM_TX_OHFIFO3_DBG0_OFFSET)
#define ZEP_RAM_RX_OHFIFO3_DBG0_ADDR         (ZEP_RAM_IIBRAM_ADDR + ZEP_RAM_RX_OHFIFO3_DBG0_OFFSET)

//The following FIFOs are dummy FIFOs for storing "don't care" data
#define ZEP_RAM_TX_OHFIFO3_DBG1_SIZE         (8)      //in byte
#define ZEP_RAM_RX_OHFIFO3_DBG1_SIZE         (8)      //in byte
#define   ZEP_RAM_TX_OHFIFO3_DBG1_OFFSET     (uint32)(ZEP_RAM_RX_OHFIFO3_DBG0_OFFSET + ZEP_RAM_RX_OHFIFO3_DBG0_SIZE)
#define   ZEP_RAM_RX_OHFIFO3_DBG1_OFFSET     (uint32)(ZEP_RAM_TX_OHFIFO3_DBG1_OFFSET + ZEP_RAM_TX_OHFIFO3_DBG1_SIZE)

#endif //#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)

/******************************************************************************************************
:   Possible PRAM Arrangement
:
:         ***Tx PRAM Start***
:   0x0000   Num_Latency_Paths = 0 or 1
:   0x0004   ZEP_TX_CFG_LP0_PTR (= 0xC)
:   0x0008   ZEP_TX_CFG_LP1_PTR (= 0x0xxx)
;
:         ***Tx PRAM Start***
:   0x000C   ZEP_PRAM_ZT_R0_LP0_ADDR (First register in Tx PRAM LP0)
:         ...
:   0x0xxx   ZEP_PRAM_ZT_R0_LP1_ADDR (First register in Tx PRAM LP1)
:         ...
:
:         ***Rx PRAM Start***
:   0x0000   Num_Latency_Paths = 0 or 1
:   0x0004   ZEP_RX_CFG_LP0_PTR
:   0x0008   ZEP_RX_CFG_LP1_PTR
:   0x000C   ZEP_PRAM_ZR_R0_LP0_ADDR (First register in Rx PRAM LP0)
:         ...
:   0x0xxx   ZEP_PRAM_ZR_R0_LP1_ADDR (First register in Rx PRAM LP1)
:         ...
********************************************************************************************************/

//================ Configure PRAM Zephyr register block ===========================================
#define ZEP_PRAM_TX_START_ADDR                     (uint32)(ZEP_PRAM_BASE)
#define ZEP_PRAM_RX_START_ADDR                     (uint32)(ZEP_PRAM_TX_START_ADDR + (4*ZEP_REG_TX_PRAM_SIZE)*2 + 0xC + 4)
#define ZEP_TX_CFG_LP0_PTR                         (uint32)(ZEP_PRAM_TX_START_ADDR + 0xC) //0xc
#define ZEP_TX_CFG_LP1_PTR                         (uint32)(ZEP_TX_CFG_LP0_PTR + (ZEP_REG_TX_PRAM_SIZE*4)) //0xc + 0x1d4 = 0x1e0
#define ZEP_RX_CFG_LP0_PTR                         (uint32)(ZEP_PRAM_RX_START_ADDR + 0xC) //0x1e0 + 0x1d4 = 0x3b4; 0x3b4 + 0xc = 0x3c0
#define ZEP_RX_CFG_LP1_PTR                         (uint32)(ZEP_RX_CFG_LP0_PTR + (ZEP_REG_RX_PRAM_SIZE*4)) //0x3c0 + 0x1f0 = 0x5b0

#define ZEP_PRAM_TX_LP0_START_ADDR                 (uint32)(ZEP_RAM_IIBRAM_ADDR + ZEP_TX_CFG_LP0_PTR)
#define ZEP_PRAM_TX_LP1_START_ADDR                 (uint32)(ZEP_RAM_IIBRAM_ADDR + ZEP_TX_CFG_LP1_PTR)

#define ZEP_PRAM_RX_LP0_START_ADDR                 (uint32)(ZEP_RAM_IIBRAM_ADDR + ZEP_RX_CFG_LP0_PTR)
#define ZEP_PRAM_RX_LP1_START_ADDR                 (uint32)(ZEP_RAM_IIBRAM_ADDR + ZEP_RX_CFG_LP1_PTR)

// ----------- TX LP0 registers ----------------------

// Per LP Registers
#define ZEP_PRAM_ZT_R0_LP0_ADDR                    (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_R0_OFFSET)
#define ZEP_PRAM_ZT_R4_LP0_ADDR                    (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_R4_OFFSET)
#define ZEP_PRAM_ZT_R8_LP0_ADDR                    (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_R8_OFFSET)
#define ZEP_PRAM_ZT_R12_LP0_ADDR                   (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_R12_OFFSET)
#define ZEP_PRAM_ZT_CODEWORD_LP0_ADDR              (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CODEWORD_OFFSET)
#define ZEP_PRAM_ZT_VBC_SIZE_LP0_ADDR              (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_VBC_SIZE_OFFSET)
#define ZEP_PRAM_ZT_FRAMING_LP0_ADDR               (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FRAMING_OFFSET)
#define ZEP_PRAM_ZT_OHRATE_LP0_ADDR                (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_OHRATE_OFFSET)
#define ZEP_PRAM_ZT_FLAG_CTRL0_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FLAG_CTRL0_OFFSET)
#define ZEP_PRAM_ZT_FLAG_CTRL1_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FLAG_CTRL1_OFFSET)
#define ZEP_PRAM_ZT_CRC0_LP0_ADDR                  (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CRC0_OFFSET)
#define ZEP_PRAM_ZT_CRC_POLY0_LP0_ADDR             (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CRC_POLY0_OFFSET)
#define ZEP_PRAM_ZT_CRC_CTRL0_LP0_ADDR             (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CRC_CTRL0_OFFSET)
#define ZEP_PRAM_ZT_CRC1_LP0_ADDR                  (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CRC1_OFFSET)
#define ZEP_PRAM_ZT_CRC_POLY1_LP0_ADDR             (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CRC_POLY1_OFFSET)
#define ZEP_PRAM_ZT_CRC_CTRL1_LP0_ADDR             (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CRC_CTRL1_OFFSET)
#define ZEP_PRAM_ZT_SCR_LP0_ADDR                   (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_SCR_OFFSET)
#define ZEP_PRAM_ZT_SCR_POLY_LP0_ADDR              (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_SCR_POLY_OFFSET)
#define ZEP_PRAM_ZT_SCR_CTRL_LP0_ADDR              (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_SCR_CTRL_OFFSET)
#define ZEP_PRAM_ZT_SCR_STATE_LP0_ADDR             (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_SCR_STATE_OFFSET)
#define ZEP_PRAM_ZT_DTB_CTRL_LP0_ADDR              (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_DTB_CTRL_OFFSET)
#define ZEP_PRAM_ZT_DTB_PTRS_LP0_ADDR              (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_DTB_PTRS_OFFSET)
#define ZEP_PRAM_ZT_ILVB_WRAD_LP0_ADDR             (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILVB_WRAD_OFFSET)
#define ZEP_PRAM_ZT_ILVB_RDAD_LP0_ADDR             (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILVB_RDAD_OFFSET)
#define ZEP_PRAM_ZT_ILVB_WRPTR_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILVB_WRPTR_OFFSET)
#define ZEP_PRAM_ZT_ILVB_RDPTR_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILVB_RDPTR_OFFSET)
#define ZEP_PRAM_ZT_FIFO_BASE0_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_BASE0_OFFSET)
#define ZEP_PRAM_ZT_FIFO_PTRS0_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_PTRS0_OFFSET)
#define ZEP_PRAM_ZT_FIFO_CNST0_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_CNST0_OFFSET)
#define ZEP_PRAM_ZT_FIFO_BASE1_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_BASE1_OFFSET)
#define ZEP_PRAM_ZT_FIFO_PTRS1_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_PTRS1_OFFSET)
#define ZEP_PRAM_ZT_FIFO_CNST1_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_CNST1_OFFSET)
#define ZEP_PRAM_ZT_FIFO_BASE2_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_BASE2_OFFSET)
#define ZEP_PRAM_ZT_FIFO_PTRS2_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_PTRS2_OFFSET)
#define ZEP_PRAM_ZT_FIFO_CNST2_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_CNST2_OFFSET)
#define ZEP_PRAM_ZT_FIFO_BASE3_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_BASE3_OFFSET)
#define ZEP_PRAM_ZT_FIFO_PTRS3_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_PTRS3_OFFSET)
#define ZEP_PRAM_ZT_FIFO_CNST3_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_CNST3_OFFSET)
#define ZEP_PRAM_ZT_DEPTH_LP0_ADDR                 (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_DEPTH_OFFSET)
#define ZEP_PRAM_ZT_ILV_PARAMS0_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILV_PARAMS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_BASE0_LP0_ADDR             (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_BASE0_OFFSET)
#define ZEP_PRAM_ZT_ILV_SIZE0_LP0_ADDR             (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_SIZE0_OFFSET)
#define ZEP_PRAM_ZT_ILV_MAX_FULLNESS0_LP0_ADDR     (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_MAX_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_MIN_FULLNESS0_LP0_ADDR     (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_MIN_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_FULLNESS0_LP0_ADDR         (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_CNTRS0_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_CNTRS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_PMS_CNTRS0_LP0_ADDR        (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_PMS_CNTRS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_PMD_CNTRS0_LP0_ADDR        (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_PMD_CNTRS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_PARAMS1_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_PARAMS1_OFFSET)
#define ZEP_PRAM_ZT_ILV_BASE1_LP0_ADDR             (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_BASE1_OFFSET)
#define ZEP_PRAM_ZT_ILV_SIZE1_LP0_ADDR             (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_SIZE1_OFFSET)
#define ZEP_PRAM_ZT_ILV_MAX_FULLNESS1_LP0_ADDR     (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_MAX_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZT_ILV_MIN_FULLNESS1_LP0_ADDR     (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_MIN_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZT_ILV_FULLNESS1_LP0_ADDR         (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZT_ILV_CNTRS1_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_CNTRS1_OFFSET)
#define ZEP_PRAM_ZT_ILV_PMS_CNTRS1_LP0_ADDR        (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_PMS_CNTRS1_OFFSET)
#define ZEP_PRAM_ZT_ILV_PMD_CNTRS1_LP0_ADDR        (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_PMD_CNTRS1_OFFSET)
#define ZEP_PRAM_ZT_CHECKBYTE0_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_CHECKBYTE0_OFFSET)
#define ZEP_PRAM_ZT_CHECKBYTE1_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_CHECKBYTE1_OFFSET)
#define ZEP_PRAM_ZT_CHECKBYTE2_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_CHECKBYTE2_OFFSET)
#define ZEP_PRAM_ZT_CHECKBYTE3_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_CHECKBYTE3_OFFSET)
#define ZEP_PRAM_ZT_TCSRC_STATE_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_TCSRC_STATE_OFFSET)
#define ZEP_PRAM_ZT_UPROC_ENA_LP0_ADDR             (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC_ENA_OFFSET)
#define ZEP_PRAM_ZT_UPROC01_BASE_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC01_BASE_OFFSET)
#define ZEP_PRAM_ZT_UPROC23_BASE_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC23_BASE_OFFSET)
#define ZEP_PRAM_ZT_UPROC45_BASE_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC45_BASE_OFFSET)
#define ZEP_PRAM_ZT_UPROC67_BASE_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC67_BASE_OFFSET)
#define ZEP_PRAM_ZT_UPROC89_BASE_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC89_BASE_OFFSET)
#define ZEP_PRAM_ZT_UPROC_INT_LP0_ADDR             (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC_INT_OFFSET)
#define ZEP_PRAM_ZT_UPROC0_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC0_STATE0_OFFSET)

#define ZEP_PRAM_ZT_UPROC0_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC0_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC0_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC0_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC1_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC1_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC1_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC1_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC1_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC2_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC2_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC2_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC2_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC2_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC3_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC3_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC3_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC3_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC3_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC4_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC4_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC4_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC4_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC4_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC5_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC5_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC5_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC5_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC5_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC6_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC6_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC6_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC6_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC6_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC7_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC7_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC7_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC7_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC7_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC8_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC8_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC8_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC8_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC8_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC9_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC9_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC9_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC9_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC9_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC_STATE5_LP0_ADDR          (uint32)(ZEP_PRAM_ZT_UPROC9_STATE4_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_ALU_STATE_LP0_ADDR             (uint32)(ZEP_PRAM_ZT_UPROC_STATE5_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_ALU_CLI_REQ_LP0_ADDR           (uint32)(ZEP_PRAM_ZT_ALU_STATE_LP0_ADDR + 0x4)

#ifdef VRX518
#define ZEP_PRAM_ZT_UPROC5_BASE_LP0_35B_ADDR       (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC6_BASE_LP0_35B_ADDR       (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC7_BASE_LP0_35B_ADDR       (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP0_ADDR + 0xC)
#define ZEP_PRAM_ZT_UPROC8_BASE_LP0_35B_ADDR       (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC9_BASE_LP0_35B_ADDR       (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP0_ADDR + 0x14)
#endif
// ----------- RX LP0 registers ----------------------

// Per Lp Registers
#define ZEP_PRAM_ZR_R0_LP0_ADDR                    (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_R0_OFFSET)
#define ZEP_PRAM_ZR_R4_LP0_ADDR                    (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_R4_OFFSET)
#define ZEP_PRAM_ZR_R8_LP0_ADDR                    (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_R8_OFFSET)
#define ZEP_PRAM_ZR_R12_LP0_ADDR                   (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_R12_OFFSET)
#define ZEP_PRAM_ZR_CODEWORD_LP0_ADDR              (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CODEWORD_OFFSET)
#define ZEP_PRAM_ZR_VBC_SIZE_LP0_ADDR              (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_VBC_SIZE_OFFSET)
#define ZEP_PRAM_ZR_FRAMING_LP0_ADDR               (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FRAMING_OFFSET)
#define ZEP_PRAM_ZR_OHRATE_LP0_ADDR                (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_OHRATE_OFFSET)
#define ZEP_PRAM_ZR_FLAG_CTRL0_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FLAG_CTRL0_OFFSET)
#define ZEP_PRAM_ZR_FLAG_CTRL1_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FLAG_CTRL1_OFFSET)
#define ZEP_PRAM_ZR_CRC0_LP0_ADDR                  (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CRC0_OFFSET)
#define ZEP_PRAM_ZR_CRC_POLY0_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CRC_POLY0_OFFSET)
#define ZEP_PRAM_ZR_CRC_CTRL0_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CRC_CTRL0_OFFSET)
#define ZEP_PRAM_ZR_CRC1_LP0_ADDR                  (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CRC1_OFFSET)
#define ZEP_PRAM_ZR_CRC_POLY1_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CRC_POLY1_OFFSET)
#define ZEP_PRAM_ZR_CRC_CTRL1_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CRC_CTRL1_OFFSET)
#define ZEP_PRAM_ZR_SCR_LP0_ADDR                   (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_SCR_OFFSET)
#define ZEP_PRAM_ZR_SCR_POLY_LP0_ADDR              (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_SCR_POLY_OFFSET)
#define ZEP_PRAM_ZR_SCR_CTRL_LP0_ADDR              (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_SCR_CTRL_OFFSET)
#define ZEP_PRAM_ZR_SCR_STATE_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_SCR_STATE_OFFSET)
#define ZEP_PRAM_ZR_DTB_CTRL_LP0_ADDR              (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_DTB_CTRL_OFFSET)
#define ZEP_PRAM_ZR_DTB_PTRS_LP0_ADDR              (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_DTB_PTRS_OFFSET)
#define ZEP_PRAM_ZR_ILVB_WRAD_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILVB_WRAD_OFFSET)
#define ZEP_PRAM_ZR_ILVB_RDAD_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILVB_RDAD_OFFSET)
#define ZEP_PRAM_ZR_ILVB_WRPTR_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILVB_WRPTR_OFFSET)
#define ZEP_PRAM_ZR_ILVB_RDPTR_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILVB_RDPTR_OFFSET)
#define ZEP_PRAM_ZR_FIFO_BASE0_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_BASE0_OFFSET)
#define ZEP_PRAM_ZR_FIFO_PTRS0_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_PTRS0_OFFSET)
#define ZEP_PRAM_ZR_FIFO_CNST0_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_CNST0_OFFSET)
#define ZEP_PRAM_ZR_FIFO_BASE1_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_BASE1_OFFSET)
#define ZEP_PRAM_ZR_FIFO_PTRS1_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_PTRS1_OFFSET)
#define ZEP_PRAM_ZR_FIFO_CNST1_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_CNST1_OFFSET)
#define ZEP_PRAM_ZR_FIFO_BASE2_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_BASE2_OFFSET)
#define ZEP_PRAM_ZR_FIFO_PTRS2_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_PTRS2_OFFSET)
#define ZEP_PRAM_ZR_FIFO_CNST2_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_CNST2_OFFSET)
#define ZEP_PRAM_ZR_FIFO_BASE3_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_BASE3_OFFSET)
#define ZEP_PRAM_ZR_FIFO_PTRS3_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_PTRS3_OFFSET)
#define ZEP_PRAM_ZR_FIFO_CNST3_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_CNST3_OFFSET)
#define ZEP_PRAM_ZR_DEPTH_LP0_ADDR                 (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_DEPTH_OFFSET)
#define ZEP_PRAM_ZR_ILV_PARAMS0_LP0_ADDR           (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_PARAMS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_BASE0_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_BASE0_OFFSET)
#define ZEP_PRAM_ZR_ILV_SIZE0_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_SIZE0_OFFSET)
#define ZEP_PRAM_ZR_ILV_MAX_FULLNESS0_LP0_ADDR     (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_MAX_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_MIN_FULLNESS0_LP0_ADDR     (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_MIN_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_FULLNESS0_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_CNTRS0_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_CNTRS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_PMS_CNTRS0_LP0_ADDR        (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_PMS_CNTRS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_PMD_CNTRS0_LP0_ADDR        (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_PMD_CNTRS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_PARAMS1_LP0_ADDR           (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_PARAMS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_BASE1_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_BASE1_OFFSET)
#define ZEP_PRAM_ZR_ILV_SIZE1_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_SIZE1_OFFSET)
#define ZEP_PRAM_ZR_ILV_MAX_FULLNESS1_LP0_ADDR     (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_MAX_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_MIN_FULLNESS1_LP0_ADDR     (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_MIN_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_FULLNESS1_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_CNTRS1_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_CNTRS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_PMS_CNTRS1_LP0_ADDR        (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_PMS_CNTRS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_PMD_CNTRS1_LP0_ADDR        (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_PMD_CNTRS1_OFFSET)
#define ZEP_PRAM_ZIR_DL_REL0_LP0_ADDR              (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZIR_DL_REL0_OFFSET)
#define ZEP_PRAM_ZIR_NL_REL0_LP0_ADDR              (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZIR_NL_REL0_OFFSET)
#define ZEP_PRAM_ZIR_DMETRIC0_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZIR_DMETRIC0_OFFSET)
#define ZEP_PRAM_ZIR_DMETRIC_CTRL_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZIR_DMETRIC_CTRL_OFFSET)
#define ZEP_PRAM_ZIR_LPBITS_LP0_ADDR               (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZIR_LPBITS_OFFSET)
#define ZEP_PRAM_ZR_CW_COUNT_LP0_ADDR              (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CW_COUNT_OFFSET)
#define ZEP_PRAM_ZR_FEC_CNT_LP0_ADDR               (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FEC_CNT_OFFSET)
#define ZEP_PRAM_ZR_UNCORR_CW0_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UNCORR_CW0_OFFSET)
#define ZEP_PRAM_ZR_UNCORR_CW1_LP0_ADDR            (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UNCORR_CW1_OFFSET)
#define ZEP_PRAM_ZR_WB_SCORE_CTL_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_WB_SCORE_CTL_OFFSET)
#define ZEP_PRAM_ZR_WB_SCORE2_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_WB_SCORE2_OFFSET)
#define ZEP_PRAM_ZR_UPROC_ENA_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC_ENA_OFFSET)
#define ZEP_PRAM_ZR_UPROC01_BASE_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC01_BASE_OFFSET)
#define ZEP_PRAM_ZR_UPROC23_BASE_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC23_BASE_OFFSET)
#define ZEP_PRAM_ZR_UPROC45_BASE_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC45_BASE_OFFSET)
#define ZEP_PRAM_ZR_UPROC67_BASE_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC67_BASE_OFFSET)
#define ZEP_PRAM_ZR_UPROC89_BASE_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC89_BASE_OFFSET)
#define ZEP_PRAM_ZR_UPROC_INT_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC_INT_OFFSET)
#define ZEP_PRAM_ZR_UPROC0_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC0_STATE0_OFFSET)

#define ZEP_PRAM_ZR_UPROC0_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC0_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC0_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC0_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC1_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC1_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC1_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC1_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC1_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC2_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC2_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC2_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC2_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC2_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC3_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC3_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC3_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC3_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC3_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC4_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC4_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC4_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC4_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC4_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC5_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC5_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC5_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC5_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC5_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC6_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC6_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC6_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC6_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC6_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC7_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC7_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC7_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC7_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC7_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC8_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC8_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC8_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC8_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC8_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC9_STATE0_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC9_STATE1_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC9_STATE2_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC9_STATE3_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC9_STATE4_LP0_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC_STATE5_LP0_ADDR          (uint32)(ZEP_PRAM_ZR_UPROC9_STATE4_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_ALU_STATE_LP0_ADDR             (uint32)(ZEP_PRAM_ZR_UPROC_STATE5_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_ALU_CLI_REQ_LP0_ADDR           (uint32)(ZEP_PRAM_ZR_ALU_STATE_LP0_ADDR + 0x4)

#ifdef VRX518
#define ZEP_PRAM_ZR_UPROC5_BASE_LP0_35B_ADDR       (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC6_BASE_LP0_35B_ADDR       (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC7_BASE_LP0_35B_ADDR       (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP0_ADDR + 0xC)
#define ZEP_PRAM_ZR_UPROC8_BASE_LP0_35B_ADDR       (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC9_BASE_LP0_35B_ADDR       (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP0_ADDR + 0x14)
#endif
// ----------- TX LP1 registers ----------------------

// Per LP Registers
#define ZEP_PRAM_ZT_R0_LP1_ADDR                    (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_R0_OFFSET)
#define ZEP_PRAM_ZT_R4_LP1_ADDR                    (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_R4_OFFSET)
#define ZEP_PRAM_ZT_R8_LP1_ADDR                    (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_R8_OFFSET)
#define ZEP_PRAM_ZT_R12_LP1_ADDR                   (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_R12_OFFSET)
#define ZEP_PRAM_ZT_CODEWORD_LP1_ADDR              (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CODEWORD_OFFSET)
#define ZEP_PRAM_ZT_VBC_SIZE_LP1_ADDR              (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_VBC_SIZE_OFFSET)
#define ZEP_PRAM_ZT_FRAMING_LP1_ADDR               (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FRAMING_OFFSET)
#define ZEP_PRAM_ZT_OHRATE_LP1_ADDR                (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_OHRATE_OFFSET)
#define ZEP_PRAM_ZT_FLAG_CTRL0_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FLAG_CTRL0_OFFSET)
#define ZEP_PRAM_ZT_FLAG_CTRL1_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FLAG_CTRL1_OFFSET)
#define ZEP_PRAM_ZT_CRC0_LP1_ADDR                  (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CRC0_OFFSET)
#define ZEP_PRAM_ZT_CRC_POLY0_LP1_ADDR             (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CRC_POLY0_OFFSET)
#define ZEP_PRAM_ZT_CRC_CTRL0_LP1_ADDR             (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CRC_CTRL0_OFFSET)
#define ZEP_PRAM_ZT_CRC1_LP1_ADDR                  (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CRC1_OFFSET)
#define ZEP_PRAM_ZT_CRC_POLY1_LP1_ADDR             (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CRC_POLY1_OFFSET)
#define ZEP_PRAM_ZT_CRC_CTRL1_LP1_ADDR             (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CRC_CTRL1_OFFSET)
#define ZEP_PRAM_ZT_SCR_LP1_ADDR                   (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_SCR_OFFSET)
#define ZEP_PRAM_ZT_SCR_POLY_LP1_ADDR              (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_SCR_POLY_OFFSET)
#define ZEP_PRAM_ZT_SCR_CTRL_LP1_ADDR              (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_SCR_CTRL_OFFSET)
#define ZEP_PRAM_ZT_SCR_STATE_LP1_ADDR             (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_SCR_STATE_OFFSET)
#define ZEP_PRAM_ZT_DTB_CTRL_LP1_ADDR              (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_DTB_CTRL_OFFSET)
#define ZEP_PRAM_ZT_DTB_PTRS_LP1_ADDR              (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_DTB_PTRS_OFFSET)
#define ZEP_PRAM_ZT_ILVB_WRAD_LP1_ADDR             (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_ILVB_WRAD_OFFSET)
#define ZEP_PRAM_ZT_ILVB_RDAD_LP1_ADDR             (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_ILVB_RDAD_OFFSET)
#define ZEP_PRAM_ZT_ILVB_WRPTR_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_ILVB_WRPTR_OFFSET)
#define ZEP_PRAM_ZT_ILVB_RDPTR_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_ILVB_RDPTR_OFFSET)
#define ZEP_PRAM_ZT_FIFO_BASE0_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_BASE0_OFFSET)
#define ZEP_PRAM_ZT_FIFO_PTRS0_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_PTRS0_OFFSET)
#define ZEP_PRAM_ZT_FIFO_CNST0_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_CNST0_OFFSET)
#define ZEP_PRAM_ZT_FIFO_BASE1_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_BASE1_OFFSET)
#define ZEP_PRAM_ZT_FIFO_PTRS1_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_PTRS1_OFFSET)
#define ZEP_PRAM_ZT_FIFO_CNST1_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_CNST1_OFFSET)
#define ZEP_PRAM_ZT_FIFO_BASE2_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_BASE2_OFFSET)
#define ZEP_PRAM_ZT_FIFO_PTRS2_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_PTRS2_OFFSET)
#define ZEP_PRAM_ZT_FIFO_CNST2_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_CNST2_OFFSET)
#define ZEP_PRAM_ZT_FIFO_BASE3_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_BASE3_OFFSET)
#define ZEP_PRAM_ZT_FIFO_PTRS3_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_PTRS3_OFFSET)
#define ZEP_PRAM_ZT_FIFO_CNST3_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_CNST3_OFFSET)
#define ZEP_PRAM_ZT_DEPTH_LP1_ADDR                 (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_DEPTH_OFFSET)
#define ZEP_PRAM_ZT_ILV_PARAMS0_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_ILV_PARAMS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_BASE0_LP1_ADDR             (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_BASE0_OFFSET)
#define ZEP_PRAM_ZT_ILV_SIZE0_LP1_ADDR             (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_SIZE0_OFFSET)
#define ZEP_PRAM_ZT_ILV_MAX_FULLNESS0_LP1_ADDR     (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_MAX_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_MIN_FULLNESS0_LP1_ADDR     (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_MIN_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_FULLNESS0_LP1_ADDR         (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_CNTRS0_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_CNTRS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_PMS_CNTRS0_LP1_ADDR        (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_PMS_CNTRS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_PMD_CNTRS0_LP1_ADDR        (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_PMD_CNTRS0_OFFSET)
#define ZEP_PRAM_ZT_ILV_PARAMS1_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_PARAMS1_OFFSET)
#define ZEP_PRAM_ZT_ILV_BASE1_LP1_ADDR             (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_BASE1_OFFSET)
#define ZEP_PRAM_ZT_ILV_SIZE1_LP1_ADDR             (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_SIZE1_OFFSET)
#define ZEP_PRAM_ZT_ILV_MAX_FULLNESS1_LP1_ADDR     (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_MAX_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZT_ILV_MIN_FULLNESS1_LP1_ADDR     (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_MIN_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZT_ILV_FULLNESS1_LP1_ADDR         (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZT_ILV_CNTRS1_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_CNTRS1_OFFSET)
#define ZEP_PRAM_ZT_ILV_PMS_CNTRS1_LP1_ADDR        (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_PMS_CNTRS1_OFFSET)
#define ZEP_PRAM_ZT_ILV_PMD_CNTRS1_LP1_ADDR        (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_PMD_CNTRS1_OFFSET)
#define ZEP_PRAM_ZT_CHECKBYTE0_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_CHECKBYTE0_OFFSET)
#define ZEP_PRAM_ZT_CHECKBYTE1_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_CHECKBYTE1_OFFSET)
#define ZEP_PRAM_ZT_CHECKBYTE2_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_CHECKBYTE2_OFFSET)
#define ZEP_PRAM_ZT_CHECKBYTE3_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_CHECKBYTE3_OFFSET)
#define ZEP_PRAM_ZT_TCSRC_STATE_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_TCSRC_STATE_OFFSET)
#define ZEP_PRAM_ZT_UPROC_ENA_LP1_ADDR             (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC_ENA_OFFSET)
#define ZEP_PRAM_ZT_UPROC01_BASE_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC01_BASE_OFFSET)
#define ZEP_PRAM_ZT_UPROC23_BASE_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC23_BASE_OFFSET)
#define ZEP_PRAM_ZT_UPROC45_BASE_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC45_BASE_OFFSET)
#define ZEP_PRAM_ZT_UPROC67_BASE_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC67_BASE_OFFSET)
#define ZEP_PRAM_ZT_UPROC89_BASE_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC89_BASE_OFFSET)
#define ZEP_PRAM_ZT_UPROC_INT_LP1_ADDR             (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC_INT_OFFSET)
#define ZEP_PRAM_ZT_UPROC0_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC0_STATE0_OFFSET)

#define ZEP_PRAM_ZT_UPROC0_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC0_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC0_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC0_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC1_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC1_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC1_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC1_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC1_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC2_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC2_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC2_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC2_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC2_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC3_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC3_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC3_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC3_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC3_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC4_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC4_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC4_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC4_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC4_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC5_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC5_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC5_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC5_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC5_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC6_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC6_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC6_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC6_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC6_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC7_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC7_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC7_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC7_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC7_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC8_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC8_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC8_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC8_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC8_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC9_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC9_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC9_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC9_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC9_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC_STATE5_LP1_ADDR          (uint32)(ZEP_PRAM_ZT_UPROC9_STATE4_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_ALU_STATE_LP1_ADDR             (uint32)(ZEP_PRAM_ZT_UPROC_STATE5_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_ALU_CLI_REQ_LP1_ADDR           (uint32)(ZEP_PRAM_ZT_ALU_STATE_LP1_ADDR + 0x4)

#ifdef VRX518
#define ZEP_PRAM_ZT_UPROC5_BASE_LP1_35B_ADDR       (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC6_BASE_LP1_35B_ADDR       (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC7_BASE_LP1_35B_ADDR       (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP1_ADDR + 0xC)
#define ZEP_PRAM_ZT_UPROC8_BASE_LP1_35B_ADDR       (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC9_BASE_LP1_35B_ADDR       (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP1_ADDR + 0x14)
#endif
// ----------- RX LP1 registers ----------------------

// Per Lp Registers
#define ZEP_PRAM_ZR_R0_LP1_ADDR                    (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_R0_OFFSET)
#define ZEP_PRAM_ZR_R4_LP1_ADDR                    (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_R4_OFFSET)
#define ZEP_PRAM_ZR_R8_LP1_ADDR                    (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_R8_OFFSET)
#define ZEP_PRAM_ZR_R12_LP1_ADDR                   (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_R12_OFFSET)
#define ZEP_PRAM_ZR_CODEWORD_LP1_ADDR              (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CODEWORD_OFFSET)
#define ZEP_PRAM_ZR_VBC_SIZE_LP1_ADDR              (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_VBC_SIZE_OFFSET)
#define ZEP_PRAM_ZR_FRAMING_LP1_ADDR               (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FRAMING_OFFSET)
#define ZEP_PRAM_ZR_OHRATE_LP1_ADDR                (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_OHRATE_OFFSET)
#define ZEP_PRAM_ZR_FLAG_CTRL0_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FLAG_CTRL0_OFFSET)
#define ZEP_PRAM_ZR_FLAG_CTRL1_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FLAG_CTRL1_OFFSET)
#define ZEP_PRAM_ZR_CRC0_LP1_ADDR                  (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CRC0_OFFSET)
#define ZEP_PRAM_ZR_CRC_POLY0_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CRC_POLY0_OFFSET)
#define ZEP_PRAM_ZR_CRC_CTRL0_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CRC_CTRL0_OFFSET)
#define ZEP_PRAM_ZR_CRC1_LP1_ADDR                  (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CRC1_OFFSET)
#define ZEP_PRAM_ZR_CRC_POLY1_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CRC_POLY1_OFFSET)
#define ZEP_PRAM_ZR_CRC_CTRL1_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CRC_CTRL1_OFFSET)
#define ZEP_PRAM_ZR_SCR_LP1_ADDR                   (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_SCR_OFFSET)
#define ZEP_PRAM_ZR_SCR_POLY_LP1_ADDR              (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_SCR_POLY_OFFSET)
#define ZEP_PRAM_ZR_SCR_CTRL_LP1_ADDR              (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_SCR_CTRL_OFFSET)
#define ZEP_PRAM_ZR_SCR_STATE_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_SCR_STATE_OFFSET)
#define ZEP_PRAM_ZR_DTB_CTRL_LP1_ADDR              (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_DTB_CTRL_OFFSET)
#define ZEP_PRAM_ZR_DTB_PTRS_LP1_ADDR              (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_DTB_PTRS_OFFSET)
#define ZEP_PRAM_ZR_ILVB_WRAD_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILVB_WRAD_OFFSET)
#define ZEP_PRAM_ZR_ILVB_RDAD_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILVB_RDAD_OFFSET)
#define ZEP_PRAM_ZR_ILVB_WRPTR_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILVB_WRPTR_OFFSET)
#define ZEP_PRAM_ZR_ILVB_RDPTR_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILVB_RDPTR_OFFSET)
#define ZEP_PRAM_ZR_FIFO_BASE0_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_BASE0_OFFSET)
#define ZEP_PRAM_ZR_FIFO_PTRS0_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_PTRS0_OFFSET)
#define ZEP_PRAM_ZR_FIFO_CNST0_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_CNST0_OFFSET)
#define ZEP_PRAM_ZR_FIFO_BASE1_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_BASE1_OFFSET)
#define ZEP_PRAM_ZR_FIFO_PTRS1_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_PTRS1_OFFSET)
#define ZEP_PRAM_ZR_FIFO_CNST1_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_CNST1_OFFSET)
#define ZEP_PRAM_ZR_FIFO_BASE2_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_BASE2_OFFSET)
#define ZEP_PRAM_ZR_FIFO_PTRS2_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_PTRS2_OFFSET)
#define ZEP_PRAM_ZR_FIFO_CNST2_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_CNST2_OFFSET)
#define ZEP_PRAM_ZR_FIFO_BASE3_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_BASE3_OFFSET)
#define ZEP_PRAM_ZR_FIFO_PTRS3_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_PTRS3_OFFSET)
#define ZEP_PRAM_ZR_FIFO_CNST3_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_CNST3_OFFSET)
#define ZEP_PRAM_ZR_DEPTH_LP1_ADDR                 (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_DEPTH_OFFSET)
#define ZEP_PRAM_ZR_ILV_PARAMS0_LP1_ADDR           (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_PARAMS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_BASE0_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_BASE0_OFFSET)
#define ZEP_PRAM_ZR_ILV_SIZE0_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_SIZE0_OFFSET)
#define ZEP_PRAM_ZR_ILV_MAX_FULLNESS0_LP1_ADDR     (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_MAX_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_MIN_FULLNESS0_LP1_ADDR     (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_MIN_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_FULLNESS0_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_CNTRS0_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_CNTRS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_PMS_CNTRS0_LP1_ADDR        (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_PMS_CNTRS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_PMD_CNTRS0_LP1_ADDR        (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_PMD_CNTRS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_PARAMS1_LP1_ADDR           (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_PARAMS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_BASE1_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_BASE1_OFFSET)
#define ZEP_PRAM_ZR_ILV_SIZE1_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_SIZE1_OFFSET)
#define ZEP_PRAM_ZR_ILV_MAX_FULLNESS1_LP1_ADDR     (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_MAX_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_MIN_FULLNESS1_LP1_ADDR     (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_MIN_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_FULLNESS1_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_CNTRS1_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_CNTRS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_PMS_CNTRS1_LP1_ADDR        (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_PMS_CNTRS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_PMD_CNTRS1_LP1_ADDR        (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_PMD_CNTRS1_OFFSET)
#define ZEP_PRAM_ZIR_DL_REL0_LP1_ADDR              (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZIR_DL_REL0_OFFSET)
#define ZEP_PRAM_ZIR_NL_REL0_LP1_ADDR              (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZIR_NL_REL0_OFFSET)
#define ZEP_PRAM_ZIR_DMETRIC0_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZIR_DMETRIC0_OFFSET)
#define ZEP_PRAM_ZIR_DMETRIC_CTRL_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZIR_DMETRIC_CTRL_OFFSET)
#define ZEP_PRAM_ZIR_LPBITS_LP1_ADDR               (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZIR_LPBITS_OFFSET)
#define ZEP_PRAM_ZR_CW_COUNT_LP1_ADDR              (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CW_COUNT_OFFSET)
#define ZEP_PRAM_ZR_FEC_CNT_LP1_ADDR               (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FEC_CNT_OFFSET)
#define ZEP_PRAM_ZR_UNCORR_CW0_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UNCORR_CW0_OFFSET)
#define ZEP_PRAM_ZR_UNCORR_CW1_LP1_ADDR            (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UNCORR_CW1_OFFSET)
#define ZEP_PRAM_ZR_WB_SCORE_CTL_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_WB_SCORE_CTL_OFFSET)
#define ZEP_PRAM_ZR_WB_SCORE2_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_WB_SCORE2_OFFSET)
#define ZEP_PRAM_ZR_UPROC_ENA_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC_ENA_OFFSET)
#define ZEP_PRAM_ZR_UPROC01_BASE_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC01_BASE_OFFSET)
#define ZEP_PRAM_ZR_UPROC23_BASE_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC23_BASE_OFFSET)
#define ZEP_PRAM_ZR_UPROC45_BASE_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC45_BASE_OFFSET)
#define ZEP_PRAM_ZR_UPROC67_BASE_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC67_BASE_OFFSET)
#define ZEP_PRAM_ZR_UPROC89_BASE_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC89_BASE_OFFSET)
#define ZEP_PRAM_ZR_UPROC_INT_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC_INT_OFFSET)
#define ZEP_PRAM_ZR_UPROC0_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC0_STATE0_OFFSET)

#define ZEP_PRAM_ZR_UPROC0_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC0_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC0_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC0_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC1_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC1_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC1_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC1_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC1_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC2_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC2_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC2_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC2_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC2_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC3_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC3_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC3_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC3_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC3_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC4_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC4_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC4_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC4_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC4_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC5_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC5_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC5_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC5_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC5_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC6_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC6_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC6_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC6_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC6_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC7_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC7_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC7_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC7_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC7_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC8_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC8_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC8_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC8_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC8_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC9_STATE0_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC9_STATE1_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC9_STATE2_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC9_STATE3_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC9_STATE4_LP1_ADDR         (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC_STATE5_LP1_ADDR          (uint32)(ZEP_PRAM_ZR_UPROC9_STATE4_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_ALU_STATE_LP1_ADDR             (uint32)(ZEP_PRAM_ZR_UPROC_STATE5_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_ALU_CLI_REQ_LP1_ADDR           (uint32)(ZEP_PRAM_ZR_ALU_STATE_LP1_ADDR + 0x4)

#ifdef VRX518
#define ZEP_PRAM_ZR_UPROC5_BASE_LP1_35B_ADDR       (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC6_BASE_LP1_35B_ADDR       (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC7_BASE_LP1_35B_ADDR       (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP1_ADDR + 0xC)
#define ZEP_PRAM_ZR_UPROC8_BASE_LP1_35B_ADDR       (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC9_BASE_LP1_35B_ADDR       (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP1_ADDR + 0x14)
#endif
#endif //_ZEP_MEMMAP_CNFG_H    Do not add anything below this line.
