/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   interrupt_control.c
 *
 *    contains functions that control the enabling/disabling of interrupts.
 *
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "cri_iof.h"
//=========================================================
// Global variables
//=========================================================

//=========================================================
// Static variables
//=========================================================

//=========================================================
// Functions
//=========================================================

/***************************************************************************************
;  Subroutine Name: MoveToFrameStartInt
;
;  Description:
;                       Time critical task to enable frame start interrupt and
;                       disable frame done interrupt
;
;  Prototype:
;     void MoveToFrameStartInt
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;
;   Substates:
;
;**********************************************************************************************/

void MoveToFrameStartInt(void)
{
#ifndef FD_ACCUM_FOR_PGA
   //This is the "last" frame running RxProcessTones(). Next frame FFT will not
   //be bufferswap started but register started.

    gt_TaskArray[RX_TSC_INT].TimeCriticalTask = NULL;
    gt_TaskArray[RX_FRAME_START].TimeCriticalTask = RxProcessTime;

    //Enable frame start in additon to tsc interrupt
    ModifyRxInterruptReg(1, CRI_MASK_RX_FTB_FRAME);

    //Disable QT recieve path
    WriteCoreReg(IRI_QT_REG_RX_ENABLE_ADDR, 0);

    // Program FFT start mode to FFT disabled, disabling the QT as well
    WriteCoreReg(CRI_RX_FFT_CTL_ADDR, (uint32)REGISTER_START_RX_FFT_SEL);
#endif

}

/***************************************************************************************
;  Subroutine Name: MoveToFdqDoneInt
;
;  Description:
;                       Time critical task to enable frame start interrupt and
;                       disable frame done interrupt
;
;  Prototype:
;     void MoveToFdqDoneInt
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;
;   Substates:
;
;**********************************************************************************************/
void MoveToFdqDoneInt(void)
{
#ifndef FD_ACCUM_FOR_PGA
    //This is the "last" frame running RxProcessTime(). Next frame FFT will
    //resume bufferswap started.
    //Enable QT recieve path
    WriteCoreReg(IRI_QT_REG_RX_ENABLE_ADDR, 0x1);

    //Here we may need to let FFT_STALL_DONE timer-based, such that QT can
    //started regardless of the availability of the Buffer
    //For cocomo, this is unnecessary; Hw build needs the calibrate the rx_time count.

    // WriteCoreReg(CRI_RX_FFT_STALL_CTL, FFT_DONE_TIMER_BASED|FFT_DONE_CNT);

    /* Run RxForeGround after RxProcessTones() */
    gt_TaskArray[RX_FRAME_START].TimeCriticalTask = NULL;
    gt_TaskArray[RX_TSC_INT].TimeCriticalTask = RxProcessTones;

   // We should wait for  FFT being triggered for the current frame before we switch FFT back to bufferswap started.
    // Otherwise, the FFT buffer index will be wrong after we switch back to the frequency domain processing
      // ResetManualFFT() will switch FFT mode back to bufferswap "immediately"
    // such that there wont be any FFT triggered.
   // ResetManualFFT();
#endif
   gft_RxFdqDoneIntOnly = TRUE;

}

void DisableFDQDoneNTC_DisableGetRxTones(void)
{
#ifndef FD_ACCUM_FOR_PGA
    gt_TaskArray[RX_TSC_INT].NonTimeCriticalTask = NULL;
    gt_TaskArray[RX_FRAME_START].NonTimeCriticalTask = RxForeGround;
   gft_DisableGetRxTones = TRUE;
#endif
}

void EnableFDQDoneNTC_EnableGetRxTones(void)
{
#ifndef FD_ACCUM_FOR_PGA
    /* Disable RX_FRAME_START */
   ModifyRxInterruptReg(0, CRI_MASK_RX_FTB_FRAME);

    /* Run RxForeGround after RxProcessTones() */
    gt_TaskArray[RX_FRAME_START].NonTimeCriticalTask = NULL;
    gt_TaskArray[RX_TSC_INT].NonTimeCriticalTask = RxForeGround;
    gft_DisableGetRxTones = FALSE;
#endif
}

/***************************************************************************************
;  Subroutine Name: EnableFFTDoneInt
;
;  Description:
;     Loading function to enable FFT complete interrupt.
;
;  Prototype:
;     void EnableFFTDoneInt(void)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;
;   Substates:
;
;**********************************************************************************************/

#ifndef TARGET_HW
void EnableFFTDoneInt(void)
{
   EnableRxInterrupt(RX_FFT_DONE);
}
#endif



#ifndef TARGET_HW
void DisableFDQDoneInterrupt()
{
   DisableRxInterrupt(RX_FDQ_DONE);
}
#endif

#ifndef TARGET_HW
void EnableFrameStartInterrupt()
{
   EnableRxInterrupt(RX_FRAME_START);
}

void DisableFrameStartInterrupt()
{
   DisableRxInterrupt(RX_FRAME_START);
}
#endif

#if defined(ADSL_62) && defined(TARGET_HW)
void ClearADSLInterrupts()
{
   // clear interrupt status registers.
   WriteCoreReg(CRI_STATUS0_ADDR, (uint32)0xFFFFFFFF);
   WriteCoreReg(CRI_STATUS1_ADDR, (uint32)0xFFFFFFFF);
}
#endif

