/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   iri_BitswapLoad.c
 *
 *   Iridia CPE interface layer functions to load the BAT and gain tables associated
 * with a bitswap.
 *
 *
 *----------------------------------------------------------------------------
 */

//#include "iridia.h"
//#include "alphaeus_const.h"

#include "const.h"
#include "gdata.h"
#include "error.h"
#include "aoc.h"
#include "datapumpsetup_tx.h"
#include "datapumpsetup_rx.h"
#include "LL_Iof.h"
#include "memrymap.h"
#include "string.h"
#include "IRI_Iof.h"
#include "states.h"
#include "const.h"
#include "cmv.h"
#include "IRI_IOf_tables.h"
//=========================================================
// Global variables
//=========================================================

//=========================================================
// Static variables
//=========================================================

//=========================================================
// Functions
//=========================================================

/****************************************************************************
; Name: LoadTxBitSwap
;
; Prototype:
;  void LoadTxBitSwap(void)
;
; Description:
;  This function loads into Iridia the entries of the Tx BAT and Tx combined
;  gains table that were modified as a result of a Tx bit swap. The Tx tone
;   reordering table is also loaded in its enterity.
;
; Arguments:
;  None.
;
; Return Value:
;  N/A
;
; Globals:
;  gt_TxBitSwapInfo
;  guca_TxBat
;  gsa_TxFineGains
;  gsa_TxToneOrder
*****************************************************************************/
void LoadTxBitSwap(void)
{
   if (guc_TxQtInactiveTblSeg == TX_INACTIVE_SEG0)
      guc_TxQtInactiveTblSeg = TX_INACTIVE_SEG1;
   else if (guc_TxQtInactiveTblSeg == TX_INACTIVE_SEG1)
        guc_TxQtInactiveTblSeg = TX_INACTIVE_SEG0;

   /* Write  table to Iridia core */
   LoadTxBitAllocationTable();
   LoadTxExtendedGainTable();
   LoadTxGainScaleTable();
   LoadTxToneReorderTable();

   /* Load QTP*/
    ConfigIridiaQtpTxPath();
}


/****************************************************************************
; Name: LoadRxBitSwap
;
; Prototype:
;  void LoadRxBitSwap(void)
;
; Description:
;  This function loads new BAT/EGT/GS/TOT into Iridia
;
; Arguments:
;  None.
;
; Return Value:
;  N/A
;
; Globals:
;  gt_RxBitSwapInfo
;  gsa_RxBat
;  gsa_RxFineGains
;  gsa_RxToneOrder
*****************************************************************************/
void LoadRxBitSwap(void)
{
   if (guc_RxQtActiveTblSeg == RX_INACTIVE_SEG0)
      guc_RxQtInactiveTblSeg = RX_INACTIVE_SEG1;
   else if (guc_RxQtActiveTblSeg == RX_INACTIVE_SEG1)
        guc_RxQtInactiveTblSeg = RX_INACTIVE_SEG0;

   /* Write  table to Iridia core */
   LoadRxBitAllocationTable();
   LoadRxExtendedGainTable();
   LoadRxGainScaleTable();
   LoadRxToneReorderTable();

   /* Load QTP*/
    ConfigIridiaQtpRxPath();
   guc_RxQtActiveTblSeg = guc_RxQtInactiveTblSeg;
}
