/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   iri_InsertCP.c
 *
 *   Iridia CPE interface layer functions used to insert the cyclic prefix
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "trail.h"

//=========================================================
// Global variables
//=========================================================

//=========================================================
// Static variables
//=========================================================

//=========================================================
// Functions
//=========================================================

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : InsertRxCP
 *
 *  Description:    Time Critical Function to Insert Rx Cyclic Prefix
 *
 *  Prototype:  void InsertRxCP(void)
 *
 *
 *  Input Arguments:none
 *
 *
 *  Output Arguments: None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void InsertRxCP(void)
{
   uint32 ul_data;

    //Register: 0x30c66c
   //Bits 0:13  : CP_SIZE  Bits 14:25 : CS_SIZE
   //Bit 26     : CP_EN    Bit 27     : CS_EN
   //Bit 28     : WIN_EN   Bit 29     : Sync
   //Bit 30     : RES      Bit 31     : Unused
   //set Rx extension register
   ul_data = ((uint32)gs_RxCPLength & 0x00003FFF)  // Rx CP length
         | (uint32)MASK_BIT26;               // Rx CP strobe enable
   if (gft_useRxWin != FALSE)
   {
      ul_data |= WIN_EN;         // Rx Window strobe enable
   }
    //set inactive register
   WriteCoreReg((uint32)V_RX_EXTEN_ADDR, ul_data);

#ifdef PROFILE_TASKS
   gft_RxCPInserted = TRUE;
#endif
}



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name :
 *
 *  Description:    InsertTxCP
 *
 *  Prototype:  void InsertTxCP(void)
 *
 *
 *  Input Arguments: None.
 *
 *
 *  Output Arguments: None.
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:  gs_TxCPLength
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void InsertTxCP(void)
{
   uint32 ul_data;

   //Bits 0:13  : CP_SIZE  Bits 14:25 : CS_SIZE
   //Bit 26     : CP_EN    Bit 27     : CS_EN
   //Bit 28     : WIN_EN   Bit 29     : Tx_WIN_coeff_mode
   //Bit 30:31  : unused
   //set Tx extension register

   ul_data = ((uint32)gs_TxCPLength_Oversample & 0x00003FFF) // Tx CP length
         | (uint32)MASK_BIT26; // Tx CP strobe enable
    //set inactive register, active regiter to be updated at buffer
   WriteCoreReg((uint32)V_TX_EXTEN_ADDR, ul_data);
}
