/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: IRI_dec_adap.c
;
;  Additional HW Engine functions
;
*****************************************************************************/
//*******************************************************************
// IRI_dec_adap.c
//
// History
//
//
// 12/01/2012 Kannan : Don't send out of band tones if we are sending the images.
//                     Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
// 11/06/2012 Raghu : Out of band excitation noise enabled for Annex M and Annex J
//                    even though imageas are generated in the TX.
//
// 31/07/2012 Ram: FW implementation for 'Out of band transmission' is reverted
//                 back to the initial method used for POTS build.
//                 Grep for: Fix_US_ALL_ALL_USE_POTS_METHOD_FOR_OOB_TX_IN_ANX_A
// 25/06/2013 Kannan: Added debug code to debug the DEC struck issue.
//                 Grep for "BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest"
//*****************************************************************************

#include "typedef.h"
//#include "DSLEngin.h"
#include "LL_IOf.h"
//#include "iridia.h"
#include "IRI_IOf.h"
#include "STR_IOf.h"
#include "STR_Ini.h"
#include "ZPH_IOf.h"
#include "ALP_IOf.h"
//#include "rt_state.h"
#include "afe.h"
#include "dec_adap.h"
#include "cmv.h"
#include "fifo.h"
#include "memrymap.h"
#include "gdata.h"
#include "dec_adap_Data.h"


extern uint32 gul_qttx_active_reg_sav;
extern FlagT guc_DECRxCaptureFlag;
extern void ConfigIridiaQtpTxPath(void);
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
extern uint32 gula_dbg_DecSetting[20];
#endif //#ifdef DEBUG_DEC_ADAPT

extern uint8  guc_RxDecCaptureState;
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)

/***************************************************************************************
;  Subroutine Name: LoadDECAdaptationTxOffset
;
;  Description:
;     This function loads the Iridia Tx frame strobe offset. This strobe
;     is used to trigger the capture of Rx data for DEC adaptation during
;     showtime.
;
;  Prototype:
;     void LoadDECAdaptationTxOffset(void)
;
;  Input Arguments:
;     N/A
;
;  Output Arguments:
;     N/A
;
;  Return Value:
;     N/A
;**********************************************************************************************/
C_SCOPE void LoadDECAdaptationTxOffset(void)
{
   //configure NUMBER of Esamples and Isamples
   WriteCoreReg((uint32)V_DEC_CAPTURE_ADDR, (DEC_RX_DATA_CAPTURE_ESAMPLES<<28)|(gs_DECTxDataCaptureLength<<1));

   //configure error signal capture strobe
     WriteCoreReg((uint32)V_FSADDR_ER_ADDR, (uint32)gs_DECAdaptationTxOffset);

   //configure error signal capture strobe
   WriteCoreReg((uint32)V_FSADDR_IN_ADDR, (uint32)gs_DECAdaptationInputCaptureOffset);
}

/***************************************************************************************
;  Subroutine Name: ActivateDECAdaptationRxCapture
;
;  Description:
;     This function programs Strymon and Iridia to execute a DEC summing
;     junction data capture during the next frame.
;
;  Prototype:
;     void ActivateDECAdaptationRxCapture(void)
;
;  Input Arguments:
;     N/A
;
;  Output Arguments:
;     N/A
;
;  Return Value:
;     N/A
;**********************************************************************************************/
C_SCOPE void ActivateDECAdaptationRxCapture(void)
{
   /* Set capture mode */
   ResetCoreReg((uint32)V_ADAPT_CTRL_ADDR, (uint32)(MASK_BIT1|MASK_BIT2));

   /* Enable DEC training state machine */
   SetCoreReg((uint32)V_ADAPT_CTRL_ADDR, MASK_BIT0);
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
   gula_dbg_DecSetting[1] += 1;
#endif //#ifdef DEBUG_DEC_ADAPT
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)
}

/***************************************************************************************
;  Subroutine Name: SetRxSyncFrame
;
;  Description:

;     This function sets the sync frame indicator for dec capture.
;
;  Prototype:
;     void SupressDECAdaptationRxCapture(void)
;
;  Input Arguments:
;     N/A
;
;  Output Arguments:
;     N/A
;
;  Return Value:
;     N/A
;**********************************************************************************************/
C_SCOPE void SetRxSyncFrame(void)
{
   /* Indicate next frame as a sync frame. */
    SetCoreReg((uint32)V_RX_EXTEN_ADDR, MASK_BIT29);
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
    gula_dbg_DecSetting[2] += 1;
#endif //#ifdef DEBUG_DEC_ADAPT
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)
}

/***************************************************************************************
;  Subroutine Name: SupressDECAdaptationRxCapture
;
;  Description:

;     This function resets the sync frame indicator for dec capture.
;
;  Prototype:
;     void SupressDECAdaptationRxCapture(void)
;
;  Input Arguments:
;     N/A
;
;  Output Arguments:
;     N/A
;
;  Return Value:
;     N/A
;**********************************************************************************************/

C_SCOPE void SupressDECAdaptationRxCapture(void)
{

   guc_DECRxCaptureFlag = ACTIVE;

   //Resets Sync Frame Indicator
   ResetCoreReg((uint32)V_RX_EXTEN_ADDR, MASK_BIT29);
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
   gula_dbg_DecSetting[3] += 1;
#endif //#ifdef DEBUG_DEC_ADAPT
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)
}
/***************************************************************************************
;  Subroutine Name: GetDECAdaptationRxData
;
;  Description:
;     This function transfers the results of a DEC capture cycle
;     to the task layer, and resets the DEC capture state machine.
;     Both the Rx capture offset and the sequence of sixteen samples
;     captured at the output of the DEC summing junction are copied
;     to task layer variables.
;
;  Prototype:
;     void GetDECAdaptationRxData(void)
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;**********************************************************************************************/


C_SCOPE void GetDECAdaptationRxData(void)
{

    uint32 ul_data;

   // Check if a capture cycle has been completed.
   ReadCoreReg((uint32)V_DEC_CAPTURE_ADDR, &ul_data);


   if(((ul_data >> 11) & 0x3) == 0x3)
   {

      // Record capture offset in RX samples.
      gs_DECAdaptationRxOffset = (int16)((ul_data >> 13) & 0x3FFF);

      // Save captured ESAMPLE of DEC summing junction.
      ReadCoreBuf32(V_DEC_ADAPT_ADDR , gsa_DECAdaptationRxData, (DEC_RX_DATA_CAPTURE_LEN>>1));
      //XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start_End)
      // Signal capture cycle has been completed.
      guc_DECRxCaptureFlag = DONE;

      // Signal capture cycle has been completed.
      guc_DECTxCaptureFlag = ACTIVE;
      // Also copy Tx data
      ReadCoreBuf32(V_DEC_ADAPT_ADDR +DEC_RX_DATA_CAPTURE_LEN*2,
         &gpsa_DECAdaptationTxData[0], ((gs_DECTxDataCaptureLength+1)>>1));

//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
      gula_dbg_DecSetting[4] += 1;
#endif //#ifdef DEBUG_DEC_ADAPT
      guc_RxDecCaptureState = 0;
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)

   }


}

#ifdef ISDN
/***************************************************************************************
;  Subroutine Name: add_oob_inband
;
;  Description:
;     This function programs adds oob energy to active table.
;
;  Prototype:
;     void add_oob_inband(int16 oob_gain, int left_idx, int right_idx)
;
;  Input Arguments:
;     oob_gain, left_idx, right_idx
;
;  Output Arguments:
;     N/A
;
;  Return Value:
;     N/A
;**********************************************************************************************/
#if 0
C_SCOPE void add_oob_inband(int16 oob_gain, int left_idx, int right_idx)
{
   int i;
   uint32 ul_ABGTaddr, ul_data;

   if(left_idx < 0)
      left_idx = 0;
   if(right_idx > TX_NUM_TONES-1)
      right_idx = TX_NUM_TONES-1;

   for(i=left_idx; i<=right_idx; i++)
   {
      ul_ABGTaddr =IRI_QT_RAM_ACTIVE_BGTN_ADDR-4;
      do
      {
         ul_ABGTaddr += 4;
         ReadCoreReg((uint32)ul_ABGTaddr, &ul_data);
      }
      //while((ul_data&0xfff) != i);
      while((ul_data&0x1fff) != i); //Tone extraction
      //ul_data &= ~0x7fff0000;
      ul_data &= ~0xfffe0000; //Masking Gain or you can use ul_data &= 0x0001FFFF
      //ul_data |= oob_gain<<16;
      ul_data |= oob_gain<<17; //Updating Gain
      WriteCoreReg((uint32)ul_ABGTaddr, ul_data);
   }
}
#else
C_SCOPE void add_oob_inband(int16 oob_gain, int left_idx, int right_idx)
{

#if 1
   return;
#else
   int i;
   uint32 ul_ABGTaddr, ul_data;
   uint32 ul_EGTaddr;

   if(left_idx < 0)
      left_idx = 0;

   if(right_idx > TX_NUM_TONES-1)
      right_idx = TX_NUM_TONES-1;

   /*
   -------------------------------------------------------------------
   QT Doc-> section 5.4-> Table 30. Tx ABGTN DSP view for 35b mode
      Bits 0 to 11 :  Not used
      Bits 12:15   :  BAT_n
      Bits 16:30   :  Gain_n                <<====
      Bit  31       : Nssi

    Table 37. Tx/Rx AEGT DSP view for 35b mode
      Bit 0:1   :  2-bit shiftn
      Bit 2     :  Blkoi_n
      Bit 3:15  :  Tone_n                   <<====
   -------------------------------------------------------------------
   */
   for(i=left_idx; i<=right_idx; i++)
   {
      ul_ABGTaddr =IRI_QT_RAM_ACTIVE_BGTN_ADDR-4;
      ul_EGTaddr = IRI_QT_RAM_TX_ACTIVE_EGT_ADDR-2;
      do
      {
         ul_ABGTaddr += 4; //32-bit
         ul_EGTaddr  += 2; //16-bit
         ReadCoreReg((uint32)ul_EGTaddr, &ul_data); //Tone index
         ul_data = ul_data >> 3;
      }
      while((ul_data&0x1fff) != i);

      ReadCoreReg((uint32)ul_ABGTaddr, &ul_data);
      ul_data &= ~0x7fff0000;
      ul_data |= oob_gain<<16;
      WriteCoreReg((uint32)ul_ABGTaddr, ul_data);
   }
#endif
}
#endif
#endif
/***************************************************************************************
;  Subroutine Name: EnableOutBandSignalInsertion
;
;  Description:
;     This function programs Iridia to start sending the outband signal.
;
;  Prototype:
;     void EnableOutBandSignalInsertion(void)
;
;  Input Arguments:
;     N/A
;
;  Output Arguments:
;     N/A
;
;  Return Value:
;     N/A
;**********************************************************************************************/
C_SCOPE void EnableOutBandSignalInsertion(void)
{
//Changes from R3.5 (Start)
   int i;
    uint32 ul_addr;
#ifdef ISDN
   int j, s_toneAt;
#endif
#ifndef ISDN
   //uint32 ul_addr;
   uint32 ul_ABGTaddr, ul_data;
   int16 s_InNumTones, s_OutNumTones;
   uint16 *pus_AEGTN;

   //Fix_US_ALL_ALL_USE_POTS_METHOD_FOR_OOB_TX_IN_ANX_A (Start)
//#if 0
   // Using the 'original POTS' method of implementation for ANX-A/L/I
   if (gl_SelectedMode & (ANNEX_A | ANNEX_L | ANNEX_I))
   {
      //Only insert OOB for ADSL2/2+
      //We set Nsc =256 in IT_CONFIG register in ADSL2/2+
      //No oversample is applied.
      //PERF_US_T1413_T1&CNXT_64ptIFFT (START)
      //In T1413 mode We set NSC Tx to 32 in IT_CONFIG register and
      //selected option (02 << 11) in IRI_QT_REG_TX_MISC_ADDR to create mirrored
      //complex conjugate images till Tx IFFT size.
      //Tx IFFT size is configured to 256 tones, hence oversampling is applied till
      //256 tones, for 32 tones 4 images will be created to mimic the
      // training equivalent as we do in the FW at statestc.c
      if ((!gft_TxImages) && (!gft_IFFT64_T1413_TxImages)) //PERF_US_T1413_T1&CNXT_64ptIFFT (END)
      {
         if (gus_NumOutBandTones_right > 0)
         {
            // get current address of gain table
            ul_ABGTaddr =IRI_QT_RAM_ACTIVE_BGTN_ADDR;

            s_InNumTones  = gs_TxMedleyLastCh;
            s_OutNumTones = gus_NumOutBandTones_right;

            // Actual number of tones is 1 more than last medley channel
            ul_ABGTaddr += ((s_InNumTones+1) << 2) ;

         //pointing to the 16 bit EGT buffer
            pus_AEGTN = (uint16 *) (IRI_QT_RAM_TX_ACTIVE_EGT_ADDR + ((s_InNumTones+1) << 1));

            /*
         -------------------------------------------------------------------
         QT Doc-> section 5.4-> Table 30. Tx ABGTN DSP view for 35b mode
            Bits 0 to 11 :  Not used
            Bits 12:15  :  BAT_n
            Bits 16:30  :  Gain_n            <<====
            Bit   31    : Nssi

         Table 37. Tx/Rx AEGT DSP view for 35b mode
            Bit 0:1  :  2-bit shiftn
            Bit 2    :  Blkoi_n
            Bit 3:15  : Tone_n               <<====
            Note: BGT registers are 32 bit where as EGT is 16 bit
         -------------------------------------------------------------------
         */
            ul_data = gs_TxOutBandGain<<16;
            for (i= s_InNumTones +1; i< s_InNumTones + s_OutNumTones +1; i++ )
            {
               // write gain in the BGT buffer
               //Check from winhost: dump BGT table for 100 bins: mrd 0x350000 100 d i temp1.txt
               WriteCoreReg((uint32)ul_ABGTaddr, ul_data);
               ul_ABGTaddr +=4;
            //write tone number in the EGT buffer
               //Check from winhost: dump EGT table for 100 bins: mr 0x360000 100 d i temp2.txt
            *pus_AEGTN++ = i<<3;
            }

            //setup QT_REG_TX_ACTIVE
            ReadCoreReg((uint32)IRI_QT_REG_TX_ACTIVE_ADDR, &ul_data);
            gul_qttx_active_reg_sav =  ul_data;
            ul_data &= 0x1FFF;
            ul_data |= ((s_InNumTones + s_OutNumTones)<<16);
            WriteCoreReg((uint32)IRI_QT_REG_TX_ACTIVE_ADDR, ul_data);

         }
      }
   }
   else
   {
      // Using the 'original ISDN' method of implemenation for ANX-B/J/M
//#else
      // XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (START)
      // handle out-of-band energy
       // This piece of initialization code can be moved to showtime init.
       if (gl_SelectedMode & ANNEX_JM)
       {
         gus_NumOutBandTones_left = 0;
          gus_NumOutBandTones_right = gs_RxFirstChannel  - gs_TxMedleyLastCh-1;
       }

       if ((gus_NumOutBandTones_left) || (gus_NumOutBandTones_right))
       {

         for(i=1; i<=gus_NumOutBandTones_right; i++)
         {
            gsa_TxCombinedGains[gs_TxMedleyLastCh +i] = gs_TxOutBandGain;
         }
         for(i=1; i<=gus_NumOutBandTones_left; i++)
         {
            gsa_TxCombinedGains[gs_TxFirstChannel-i ] = gs_TxOutBandGain;
         }

          // write GST
         ul_addr = GetPingPongTableAddress(TX_GST, guc_TxQtInactiveTblSeg);
         WriteCoreBuf32(ul_addr, (int16*)gsa_TxCombinedGains, (uint16)(gs_TxNumTones >> 1));

         ConfigIridiaQtpTxPath();
       }
      // XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (END)
   }
//#endif //#ifndef ISDN
   //Fix_US_ALL_ALL_USE_POTS_METHOD_FOR_OOB_TX_IN_ANX_A (End)


#else

   i =   gs_TxMedleyFirstCh - gus_NumOutBandTones_left;
   j = gs_TxMedleyFirstCh - 1;

    //add_oob_inband(gs_TxOutBandGain, i, j);
    //Calling the add_oob_inband with BGT/EGT 518 specific modifications
    //causing CRCs (some times burst of CRCs).
    //with out 518 specific code same as VR9 causing the LOF.
    //So active tables are updated similar to above POTS (refer else part) case
    //through inactive tables.
    for(s_toneAt = i; s_toneAt <= j; s_toneAt++)
   {
      gsa_TxCombinedGains[s_toneAt] = gs_TxOutBandGain;
   }

   i = gs_TxMedleyLastCh + 1;
   j = gs_TxMedleyLastCh + gus_NumOutBandTones_right;
   //add_oob_inband(gs_TxOutBandGain, i, j);
    for(s_toneAt = i; s_toneAt <= j; s_toneAt++)
   {
      gsa_TxCombinedGains[s_toneAt] = gs_TxOutBandGain;
   }

   // write GST
   ul_addr = GetPingPongTableAddress(TX_GST, guc_TxQtInactiveTblSeg);
   WriteCoreBuf32(ul_addr, (int16*)gsa_TxCombinedGains, (uint16)(gs_TxNumTones >> 1));

   ConfigIridiaQtpTxPath();
#endif
//Changes from R3.5 (End)
}

/***************************************************************************************
;  Subroutine Name: DisableOutBandSignalInsertion
;
;  Description:
;     This function programs Iridia to stop sending the outband signal.
;
;  Prototype:
;     void DisableOutBandSignalInsertion(void)
;
;  Input Arguments:
;     N/A
;
;  Output Arguments:
;     N/A
;
;  Return Value:
;     N/A
;**********************************************************************************************/
C_SCOPE void DisableOutBandSignalInsertion(void)
{
//Changes from R3.5 (Start)
   int i;
    uint32 ul_addr;
//Changes from R3.5 (End)
#ifndef ISDN
   //uint32 ul_addr;
   uint32 ul_ABGTaddr, ul_data;
   int16 s_InNumTones, s_OutNumTones;
   uint16 *pus_AEGTN;
#endif

#ifdef ISDN
   int j, s_toneAt;
#endif

   //Fix_US_ALL_ALL_USE_POTS_METHOD_FOR_OOB_TX_IN_ANX_A (Start)
//Changes from R3.5 (Start)
//#if 0
#ifndef ISDN
//Changes from R3.5 (End)
   // Using the 'original POTS' method of implementation for ANX-A/L/I
   if (gl_SelectedMode & (ANNEX_A | ANNEX_L | ANNEX_I))
   {
      //PERF_US_T1413_T1&CNXT_64ptIFFT (START - END)
      if ((!gft_TxImages) && (!gft_IFFT64_T1413_TxImages))
      {
         if (gus_NumOutBandTones_right > 0)
         {
            // get current address of gain table
            ul_ABGTaddr =IRI_QT_RAM_ACTIVE_BGTN_ADDR;

            s_InNumTones  = gs_TxMedleyLastCh;
            s_OutNumTones = gus_NumOutBandTones_right;

            // Actual number of tones is 1 more than last medley channel
            ul_ABGTaddr += ((s_InNumTones+1) << 2) ;
         pus_AEGTN = (uint16 *) (IRI_QT_RAM_TX_ACTIVE_EGT_ADDR + ((s_InNumTones+1) << 1));

            for (i= s_InNumTones +1; i< s_InNumTones + s_OutNumTones +1; i++ )
            {
               // out of band tones
               ul_data =  0;
               WriteCoreReg((uint32)ul_ABGTaddr, ul_data);
               ul_ABGTaddr +=4;
               //write EGT buffer[tone number] = 0
               //Check from winhost: dump EGT table for 100 bins: mr 0x360000 100 d i temp2.txt
            *pus_AEGTN++ = 0;
            }

            //setup QT_REG_TX_ACTIVE
            WriteCoreReg((uint32)IRI_QT_REG_TX_ACTIVE_ADDR, gul_qttx_active_reg_sav);
         }
      }
   }
   else
   {
      // Using the 'original ISDN' method of implemenation for ANX-B/J/M
//#else

      // handle out-of-band energy
      if (gl_SelectedMode & ANNEX_JM)
      {
         gus_NumOutBandTones_left = 0;
         gus_NumOutBandTones_right = gs_RxFirstChannel  - gs_TxMedleyLastCh-1;
      }

      if ((gus_NumOutBandTones_left) || (gus_NumOutBandTones_right))
      {
         for(i=1; i<=gus_NumOutBandTones_right; i++)
         {
            gsa_TxCombinedGains[gs_TxMedleyLastCh +i] = 0;
         }
         for(i=1; i<=gus_NumOutBandTones_left; i++)
         {
            gsa_TxCombinedGains[gs_TxFirstChannel-i] = 0;
         }

         // write GST
         ul_addr = GetPingPongTableAddress(TX_GST, guc_TxQtInactiveTblSeg);

         WriteCoreBuf32(ul_addr, (int16*)gsa_TxCombinedGains, (uint16)(gs_TxNumTones >> 1));
         ConfigIridiaQtpTxPath();
      }
   }
//#endif
   //Fix_US_ALL_ALL_USE_POTS_METHOD_FOR_OOB_TX_IN_ANX_A (End)
//Changes from R3.5 (Start)
#else
   i =   gs_TxMedleyFirstCh - gus_NumOutBandTones_left;
   j = gs_TxMedleyFirstCh - 1;
   //add_oob_inband(0, i, j);
    //Calling the add_oob_inband with BGT/EGT 518 specific modifications
    //causing CRCs (some times burst of CRCs).
    //with out 518 specific code same as VR9 causing the LOF.
    //So active tables are updated similar to above POTS (refer else part) case
    //through inactive tables.
    for(s_toneAt = i; s_toneAt <= j; s_toneAt++)
   {
      gsa_TxCombinedGains[s_toneAt] = 0;
   }


   i = gs_TxMedleyLastCh + 1;
   j = gs_TxMedleyLastCh + gus_NumOutBandTones_right;
   //add_oob_inband(0, i, j);
    for(s_toneAt = i; s_toneAt <= j; s_toneAt++)
   {
      gsa_TxCombinedGains[s_toneAt] = 0;
   }

   // write GST
   ul_addr = GetPingPongTableAddress(TX_GST, guc_TxQtInactiveTblSeg);
   WriteCoreBuf32(ul_addr, (int16*)gsa_TxCombinedGains, (uint16)(gs_TxNumTones >> 1));

   ConfigIridiaQtpTxPath();
#endif
//Changes from R3.5 (End)
}



