/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf30.C
 *
 *   Iridia CPE core interface layer.
 *
 *
 *----------------------------------------------------------------------------
 */
// ******************************************************************
// iri_iof1.c
//
// History
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
// ******************************************************************
#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "IRI_Iof.h"
#include "bitload_const.h"
#include "pll.h"

/*****************************************************************************
;  Prototype:
;     void LoadFDQ(void)
;
;  Input Arguments: None
;  Output Arguments: None
;
;  Time Critical function to load the FDQ coefficients and their shifts from the values
;  computed during training to the values used in the actual FDQ
;
;  Global Variables:
;     Inputs:
;        gs_RxFirstChannel
;        gs_RxLastChannel
;        gsa_pre_FDQ_coef - FDQ coefficients computed during training
;        gsa_pre_FDQ_exp - shifts values for FDQ coefficients computed during training
;
;
;     Outputs:
;        gsa_FDQ_coef - FDQ coefficients used in the actual FDQ
;
;****************************************************************************/

void LoadFDQ(void)
{

    int16 i, j, s_length;


   i = gs_RxFirstChannel;
   j = gs_RxLastChannel;
   s_length = j - i + 1;

    // write SFDQ mantissa
   WriteCoreBuf32((uint32)(IRI_QT_RAM_FDQ_MANT_ADDR + 4*i),  &(gsa_pre_FDQ_coef[2*i]), s_length);
    // write SFDQ exponent
   WriteCoreBuf8((uint32)(IRI_QT_RAM_FDQ_EXP_ADDR + 4*i),    &(guca_pre_FDQ_exp[i]), s_length);


   gft_fdqState = FDQ_ENABLED;

}
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
#ifdef HW_SNR_FDQ
void ReadFDQ1(void)
{
    int16 i, j, s_length;

    i = gs_RxFirstChannel;
    j = 255;
    s_length = j - i + 1;

    // read FDQ mantissa
    ReadCoreBuf32((uint32)(IRI_QT_RAM_FDQ_MANT_ADDR + 4*i),  &(gsa_pre_FDQ_coef[2*i]), s_length);
    // read FDQ exponent
    ReadCoreBuf8((uint32)(IRI_QT_RAM_FDQ_EXP_ADDR + 4*i), (int8 *)(void *)&guca_pre_FDQ_exp[i], s_length);
}
void ReadFDQ2(void)
{
    int16 i, j, s_length;

    i = 256;
    j = 511;
    s_length = j - i + 1;

    // read FDQ mantissa
    ReadCoreBuf32((uint32)(IRI_QT_RAM_FDQ_MANT_ADDR + 4*i),  &(gsa_pre_FDQ_coef[2*i]), s_length);
    // read FDQ exponent
    ReadCoreBuf8((uint32)(IRI_QT_RAM_FDQ_EXP_ADDR + 4*i), (int8 *)(void *)&guca_pre_FDQ_exp[i], s_length);
}
#endif
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

