/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf.C
 *
 *   Iridia CPE core interface layer.
 *
 *
 *----------------------------------------------------------------------------
 */
// ******************************************************************
// IRI_IOf_ddSnrFdqUtils.C
//
// History
//
// 15/11/2011 ChihWen/Bhadra: There is a special requirement that CPE should sync up in 2km loop with -90 dBm/Hz AWGN (normally DS rate is 600 Kbps),
//                and should be able to reach max capped rate of 6 Mbps by upshift SRA when noise power is decreased to -140 dBm/Hz AWGN.
//            With this special requirement, we need to load more bits not only on already loaded tones, but also on monitored tones,
//                in order to reach the max capped rate. A problem behind this requirement is that CNXT CO does not send signal on unloaded tones.
//                So the workaround to fulfill the requirement for all CO are as below.
//                1. For all CO, changing the threshold for setting monitored tones from 4 dB to 6 dB (SNR_THRESH_LOAD_MIN_BITS).
//                2. For all CO, not limiting number of monitored tones to 20 if SRA is enabled on CO site.
//                3. For all CO, making OLR (SRA and bitswap) only occurring on loaded/monitored tones.
//                4. For CNXT CO, no updating FDQ cofficients on unloaded tones.
//                5. For CNXT CO, measuring noise on monitored tones to get an estimation of SNR.
//                6. For CNXT CO, SNR on monitored tones are capped to 2-bits required SNR, in order to load two bits and get better SNR measurement.
//
//                7. When DS rate capped low, it took bitloading too long time to
//               find gs_deltaLp_max and failed the training. This is the root cause
//               of no-link with 3.5M capped profiles.
//               The solution is to use a larger searching step to find a valid
//               gs_deltaLp_max faster.
//
//                8. For CNXT CO, decreasing the Tx buffer size for overhead message by 2 if the tone number in the last segment of SRA message was 14.
//                   This was because CRC/link drop was always seen when there was 14 tones in the last segment of SRA message.
//
//            Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones
//
// ******************************************************************

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "bitload_const.h"

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    get_rx_gainscale_shift
 *
 * Prototype:
 *    void get_rx_gainscale_shift(int8 *puca_bat, int16 s_num_channels, int16 *psa_RxGainScaleShifts);
 *
 * Input Arguments:
 *    puca_bat
 *    s_num_channels
 *
 * Output Arguments:
 *    psa_RxGainScaleShifts
 *
 *  Abstract:
 *
 * Compute rx gain scale shifts
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *      None
 *------------------------------------------------------------------------
 */

void get_rx_gainscale_shift(int8 *puca_bat, int16 s_num_channels, int16 *psa_RxGainScaleShifts)
{
   int16 i, s_shift;

/* Iridia ROM Rx Gain Scale Exponents -- Do not have access to these in h/w */
   int16 sa_combDecGainExponent[16] = {
         0,DECGAINEXP1,DECGAINEXP2,DECGAINEXP3,DECGAINEXP4,
         DECGAINEXP5,DECGAINEXP6,DECGAINEXP7,DECGAINEXP8,
         DECGAINEXP9, DECGAINEXP10, DECGAINEXP11, DECGAINEXP12,
         DECGAINEXP13, DECGAINEXP14, DECGAINEXP15
   };

   for(i = 0; i < s_num_channels; i++)
   {
      // Get precision i.e. number of rightshifts to get fdq output estimate in required format (Q3.13)
      s_shift = FRAC_BITS_DESCALED_XY_TCM + FRAC_BITS_DEC_COMBGAIN_MANTISSA - FRAC_BITS_DESCALE_INPUT;
      // Derive gain exponent (need to derive becos gain exponent is stored in ROM).
      s_shift += sa_combDecGainExponent[(int16)(*puca_bat++)];

      *psa_RxGainScaleShifts++ = s_shift;
      /* Duplicate shift value so as to use assembly vector multiply routines */
      *psa_RxGainScaleShifts++ = s_shift;
   }
}

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    do_rx_consdec
 *
 * Prototype:
 *    void do_rx_consdec(int16 *psa_qam_output, int16 *psa_fdq_output, int16 s_first_channel, int16 s_last_channel);
 *
 * Input Arguments:
 *    psa_qam_output
 *    psa_fdq_output
 *    s_first_channel
 *    s_last_channel
 *
 * Output Arguments:
 *    psa_qam_output
 *
 *  Abstract:
 *
 *    Do constellation decode of 0 and 1 bit tones
 *    Background:
 *       -Hardware does not do constellation decode of a unloaded tone
 *       -Hardware does not write back the constellation decode o/p of all 1 bit tones
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *      None
 *------------------------------------------------------------------------
 */

#define PLUS_ONE     (1<<FRAC_BITS_DESCALED_XY_TCM)
#define MINUS_ONE    ((-1)<<FRAC_BITS_DESCALED_XY_TCM)

void do_rx_consdec(int16 *psa_qam_output, int16 *psa_fdq_output, int16 s_first_channel, int16 s_last_channel)
{
   int16 i, s_X, s_Y, s_X_Clipped = 0, s_Y_Clipped = 0;
   int16 s_gi, *psa_RxFineGains;
   int8  uc_bi, *puca_bat;

   puca_bat = (int8 *)(void *)&guca_RxBat[s_first_channel];
   psa_RxFineGains = &gsa_RxFineGains[s_first_channel];
   for(i = 0; i < (s_last_channel - s_first_channel + 1); i++)
   {
      uc_bi = *puca_bat++;
      s_gi  = *psa_RxFineGains++;

      if(uc_bi == 0 || uc_bi == 1)
      {
         s_X = *psa_fdq_output;
         s_Y = *(psa_fdq_output+1);

         if (s_gi == NEG_INFINITY_DB)  // gi=0, tone not transmitted
         {  //Reference signal is 0
            s_X_Clipped = s_Y_Clipped = 0;
         }
         else if(uc_bi == 0)           // bi=0, gi>0 monitored tone
         {  //Do elementary 2 bit QAM (no TCM) constellation decode
            s_X_Clipped = (int16)((s_X >= 0)? PLUS_ONE: MINUS_ONE);
            s_Y_Clipped = (int16)((s_Y >= 0)? PLUS_ONE: MINUS_ONE);
            //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (START)
            // CNXT chipset based DSLAMs does n't send any signal on monitor tones.
            #ifndef ISDN
            if ((gs_CurrentCoChipset == GSI_CO_CHIPSET) && (gl_SelectedMode & (MODE_ADSL2)))
            {
               s_X_Clipped = 0;
               s_Y_Clipped = 0;
            }
            #endif
            //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (END)
         }
         else if(uc_bi == 1)  // bi=1, 1 bit tone
         {  //Do elementary 1 bit QAM (no TCM) constellation decode
            s_X_Clipped = s_Y_Clipped = (int16)((s_X >= -s_Y)? PLUS_ONE: MINUS_ONE);
         }

         *psa_qam_output = s_X_Clipped;
         *(psa_qam_output+1) = s_Y_Clipped;
      }

      psa_qam_output+=2;
      psa_fdq_output+=2;
   }
}

#undef PLUS_ONE
#undef MINUS_ONE
