/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   iri_timer.c
 *
 *   Iridia CPE interface layer functions to setup and use the Iridia
 * timer registers.
 *
 *
 *
 *----------------------------------------------------------------------------
 */

// **************************************************************************
//  iri_timer.c
//
// History
//
// 22/03/2013 Ram: Timer data is '20 bits' wide in VR9. Refer to document
//                 'ClkRstInt-CRI_xDSL_CPE_bonded.pdf' for more details
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
// ***************************************************************************

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"

//=========================================================
// Global variables
//=========================================================

//=========================================================
// Static variables
//=========================================================

//=========================================================
// Functions
//=========================================================

// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
/****************************************************************************
; Name: ReadTxTimer
;
; Prototype:
;  uint32 ReadTxTimer(void)
;
; Description:
;  reads and returns the current timer value.
;
; Arguments:
;  None.
;
;  Return Value:
;  N/A
*****************************************************************************/
uint32 ReadTxTimer(void)
{
   uint32 ul_data;

   ReadCoreReg(CRI_TX_TIMER_ADDR, &ul_data);

   return (ul_data & 0xFFFFF);
}

/****************************************************************************
; Name: ReadRxTimer
;
; Prototype:
;  uint32 ReadRxTimer(void)
;
; Description:
;  reads and returns the current timer value.
;
; Arguments:
;  None.
;
;  Return Value:
;  N/A
*****************************************************************************/
uint32 ReadRxTimer(void)
{
   uint32 ul_data;

   ReadCoreReg(CRI_RX_TIMER_ADDR, &ul_data);

   return (ul_data & 0xFFFFF);
}
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)


/****************************************************************************
; Name: StartTxTimer
;
; Prototype:
;  void StartTxTimer(uint16 timerdelay)
;
; Description:
;  Reset and start Iridia's Tx timer
;
; Arguments:
;  timerdelay - value from which to start decrementing.
;
;  Return Value:
;  N/A
*****************************************************************************/
//void StartTxTimer(uint16 timerdelay)
//{
// WriteCoreReg(IRI_REG_IT_TIMER_ADDR, 0x4);   /* reset the timer  */
// WriteCoreReg(IRI_REG_IT_TIMER_ADDR, 0);
//
// WriteCoreReg(IRI_REG_IT_DELAY_ADDR, (uint16) timerdelay);
//
// WriteCoreReg(IRI_REG_IT_TIMER_ADDR, 0x2);   /* start the timer  */
//}

/****************************************************************************
; Name: StartRxTimer
;
; Prototype:
;  void StartRxTimer(uint16 timerdelay)
;
; Description:
;  Reset and start Iridia's Rx timer
;
; Arguments:
;  timerdelay - value from which to start decrementing.
;
;  Return Value:
;  N/A
*****************************************************************************/
//void StartRxTimer(uint16 timerdelay)
//{
// WriteCoreReg(IRI_REG_IR_TIMER_ADDR, 0x4);   /* reset the timer  */
// WriteCoreReg(IRI_REG_IR_TIMER_ADDR, 0);
//
// WriteCoreReg(IRI_REG_IR_DELAY_ADDR, (uint16) timerdelay);
//
// WriteCoreReg(IRI_REG_IR_TIMER_ADDR, 0x2);   /* start the timer  */
//}

