/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   ZPH_IOf1_BIS.C
 *
 *   Functions to Interface to zephyr core, before entering showtime
 *
 *
 *
 *----------------------------------------------------------------------------
 */

// **************************************************************************
//  rx_ovhd_bis.h
//
// History
//
// 30/08/2012 Ram: Add fix to resolove US Bitswap issue (CO was losing Showtime
//                 SYNC after CPE applies US bit swap) during ReTx mode.
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 20/02/2013 Mahesh:  Removed Ananta's bitswap enhancement changes for L2 & SRA
//
// 22/03/2013 Ram: Call ReverbSegueDetectorSetup() in 'Data symbol 1'
//                 (during L0 to L2 transition) to avoid Mips Peaking.
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
//
// 09/09/2014 ChihWen: Avoid MIPs peaking in L2 entry and exit by moving calculation of FDQ coefficients to background tasks.
//            Grep for XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit
//
// 24/11/2017 Sriram Shastry:VRX518 US CRCs and FECs in Tests of 1TR112 ADSL2+ Anx J.
//       Disable OOB handling if US Bitswap is ongoing .DEC update logic gets into conflict with OLR as both algorithms
//       copy gsa_TxCombinedGains to the inactive gain table / active table.
//       Grep for XDSLRTFW-3479
// ***************************************************************************

#include <stdio.h>
#include "gdata.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "gdata_bis.h"
#include "const_bis.h"
#include "fifo.h"
#include "showinit.h"
#include "cmv.h"
#include "tone_ord.h"
#include "tone_reord_load.h"
#include "fdqmult.h"
#include "tx_ovrhd_bis.h"
#include "datapumpsetup_tx.h"
#include "datapumpsetup_rx.h"
#include "IRI_Iof.h"
#include "IRI_IOf_tables.h"

extern uint32 gul_qtp_rx_ctrl_L0;
extern void SetUpTxTonesRegister(uint16 us_MinToneIndex, uint16 us_MaxToneIndex);
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
#ifdef HW_SNR_FDQ
#include "pll.h"
#define MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION       (370)
extern int16 gsa_pilot_FDQ_coef[2];
extern uint8 guc_pilot_FDQ_exp;
extern void ReadFDQ1(void);
extern void ReadFDQ2(void);
extern void reconfig_fft_fdq_for_l2pcb(void);
extern void reconfig_next_fdq_for_l2pcb(void);
uint8 guc_ReconfigNextFdqCoefForL2Pcb = 0;
#endif
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
/*****************************************************************************
;  Subroutine Name: OLR_TxLoadTables(void)
;
;  This subroutine loads the BAT, GAIN amd TRB tables for OLR reconfiguration
;
;  Prototype:
;     void OLR_TxLoadTables(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;****************************************************************************/
void OLR_TxLoadTables(void)
{
//For vinax hercules, this is done at OLR_TxDataPumpSetup; No function required.

   if (guc_TxQtInactiveTblSeg == TX_INACTIVE_SEG0)
      guc_TxQtInactiveTblSeg = TX_INACTIVE_SEG1;
   else if (guc_TxQtInactiveTblSeg == TX_INACTIVE_SEG1)
      guc_TxQtInactiveTblSeg = TX_INACTIVE_SEG0;

   //RECONFIG_BiGi
   // XDSLRTFW-3479(Start)
   gft_BlockOOBSignal_BecauseOf_OngoingUSOLR = FALSE; // clear the  flag
   // XDSLRTFW-3479(End)
   LoadTxBitAllocationTable();
   LoadTxGainScaleTable();
   LoadTxToneReorderTable();
   LoadTxExtendedGainTable();
}


/*****************************************************************************
;  Subroutine Name: OLRPM_RxLoadTables(void)
;
;  This subroutine loads the BAT, GAIN amd TRB tables for OLR reconfiguration
;
;  Prototype:
;     void OLRPM_RxLoadTables(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;****************************************************************************/
void OLRPM_RxLoadTables(void)
{

   TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoInput;
   TxOvhdMsgInfoRequest_t* pt_OlrPm_TxOvhdMsgInfoInput;
   int32 l_priority, l_NextOLRPMState, l_ret;

   if (guc_RxQtActiveTblSeg == RX_INACTIVE_SEG0)
      guc_RxQtInactiveTblSeg = RX_INACTIVE_SEG1;
   else if (guc_RxQtActiveTblSeg == RX_INACTIVE_SEG1)
        guc_RxQtInactiveTblSeg = RX_INACTIVE_SEG0;

   if(gt_RxOLRPMVars.s_rxOLRPMEvent & LOAD_BAT)
   {
      /* Write BAT table to Iridia core */
      LoadRxBitAllocationTable();
      LoadRxExtendedGainTable();
      gt_RxOLRPMVars.s_rxOLRPMEvent &= ~LOAD_BAT;
   }
   else if(gt_RxOLRPMVars.s_rxOLRPMEvent & LOAD_GAIN)
   {
      /* Load Gain Scales to Iridia core */
      //XDSLRTFW-1727
                if(gt_RxOLRPMVars.uc_rxOLRPMState == L2_LOAD_TABLES)
                {
                   LoadRxGainScaleL2Table();
                }
                else
      LoadRxGainScaleTable();
      gt_RxOLRPMVars.s_rxOLRPMEvent &= ~LOAD_GAIN;
   }
   else if(gt_RxOLRPMVars.s_rxOLRPMEvent & LOAD_TRB)
   {
      /* Load Tone Reordering Table to Iridia core */
      LoadRxToneReorderTable();
      if ((( gl_SelectedMode & (MODE_ADSL2)  )) && gft_TcmFlag_bis_DS){
         if (guc_RxToneOrderLoadState == RXTONEORDERLOAD_BKGD_DONE){
            guc_RxToneOrderLoadState = RXTONEORDERLOAD_WAITING;
            gt_RxOLRPMVars.s_rxOLRPMEvent &= ~LOAD_TRB;
         }
      }
      else
         gt_RxOLRPMVars.s_rxOLRPMEvent &= ~LOAD_TRB;
   }
        //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
        //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
        #ifdef HW_SNR_FDQ
   else if (gt_RxOLRPMVars.s_rxOLRPMEvent & READ_FDQ1)
   {
      //AddFunctionToFifo(gp_RxLoadingFunctionFifo,ReadFDQ1);
      ReadFDQ1();
      gt_RxOLRPMVars.s_rxOLRPMEvent &= ~READ_FDQ1;
      return;
   }
   else if (gt_RxOLRPMVars.s_rxOLRPMEvent & READ_FDQ2)
   {
      //AddFunctionToFifo(gp_RxLoadingFunctionFifo,ReadFDQ2);
      ReadFDQ2();
      gt_RxOLRPMVars.s_rxOLRPMEvent &= ~READ_FDQ2;
      return;
   }
   else if (gt_RxOLRPMVars.s_rxOLRPMEvent & CAL_FDQ_COEF)
   {
      //Over-write FDQ coefficients of pilot tone before re-calculation for FDQ coefficients of all tones in L2 entry.
           gsa_pre_FDQ_coef[gs_PilotToneIdx*2] = gsa_pilot_FDQ_coef[0];
           gsa_pre_FDQ_coef[gs_PilotToneIdx*2+1] = gsa_pilot_FDQ_coef[1];
           guca_pre_FDQ_exp[gs_PilotToneIdx] = guc_pilot_FDQ_exp;

           //Move re-calculation for FDQ coefficients of all tones from TC tasks to here to avoid MIPs peaking.
           AddFunctionToBkgdFifo((PtrToBkgdFunc)reconfig_fft_fdq_for_l2pcb);
         if (gs_RxLastChannel > MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION)
         {
            guc_ReconfigNextFdqCoefForL2Pcb = 1;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)reconfig_next_fdq_for_l2pcb);
         }

      gt_RxOLRPMVars.s_rxOLRPMEvent &= ~CAL_FDQ_COEF;
      return;
   }
        #endif
        //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
        //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

   //Check if we are done loading tables, if not do not update olrpm state yet and return
        //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
        //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
        #ifdef HW_SNR_FDQ
        if( (gt_RxOLRPMVars.s_rxOLRPMEvent & (LOAD_BAT|LOAD_GAIN|LOAD_TRB|READ_FDQ1|READ_FDQ2|CAL_FDQ_COEF)) ||
            (guc_ReconfigNextFdqCoefForL2Pcb != 0) )
           return;
        #else
   if(gt_RxOLRPMVars.s_rxOLRPMEvent & (LOAD_BAT|LOAD_GAIN|LOAD_TRB)) return;
   #endif
        //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
        //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

   if(gt_RxOLRPMVars.uc_rxOLRPMState == L2_LOAD_TABLES)
   {
      l_NextOLRPMState = L2_RECV_SYNC_INDICATOR;
      if (( gl_SelectedMode & (MODE_G992_5)  ))
      {
         t_TxOvhdMsgInfoInput.uc_message_type = PLUS_L2_GRANT;
      }
      else
      {
         t_TxOvhdMsgInfoInput.uc_message_type = L2_GRANT;
      }

      t_TxOvhdMsgInfoInput.uc_message_designator = POWER_MGMT_CMD_DESIG;
      t_TxOvhdMsgInfoInput.uc_Source = RESPONSE_SOURCE;
      t_TxOvhdMsgInfoInput.ft_InvertedSyncSymbol_expected = TRUE;
      t_TxOvhdMsgInfoInput.uc_Segmented = TRUE;
      pt_OlrPm_TxOvhdMsgInfoInput = &t_TxOvhdMsgInfoInput;
      l_priority = 1;
   }
   else
   {
      l_NextOLRPMState = OLR_RECV_SYNC_INDICATOR;
      pt_OlrPm_TxOvhdMsgInfoInput = &gt_OlrPm_TxOvhdMsgInfoInput;
      l_priority = 0;
   }


   // If queue request was unsuccessful, remain in same state and try again next frame.
   l_ret = TxHdlcSendRequest(l_priority, (*pt_OlrPm_TxOvhdMsgInfoInput));
   if (l_ret ==HDLC_QUEUE_ADDED)
      gt_RxOLRPMVars.uc_rxOLRPMState = (uint8)l_NextOLRPMState;
}


/*****************************************************************************
;  Subroutine Name: OLR_TxDataPumpSetup(void)
;
;  This subroutine reconfigures the Iridia, Zephyr, Alphaeus data Tx path
;
;  Prototype:
;     void OLR_TxDataPumpSetup(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;****************************************************************************/
void OLR_TxDataPumpSetup(void)
{
   uint32 ul_data;
   FlagT ft_TcmFlag;
   int16 s_Tx_NumLogical_Tones,s_Tx_Num0bits_Tones,s_Tx_NumGT1bits_Tones;

   //RECONFIG_Lp
   {
      /*****  IT_LP0_BITS *****/
      ul_data = (uint32)gt_tx_config.s_Lp[LP0_DATA_PATH];
      WriteCoreReg((uint32)IRI_QT_REG_TX_LP0_BITS_ADDR, ul_data);

      /*****  IT_LP1_BITS *****/
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
      if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
      {
         ul_data = DS_RRC_BITS;  //add 24 bits of LpRRC
      }
      else
      {
         ul_data = (uint32)(gt_tx_config.s_Lp[LP1_DATA_PATH]);
      }
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
      WriteCoreReg (IRI_QT_REG_TX_LP1_BITS_ADDR, ul_data);
   }


      // IT_TCM_CTRL
   ul_data = (uint32)((gus_Tx_Tcm_Num1bits/2) & 0x0FFF) << 13;
   if (gft_ModemType == G_DMT_BIS)
      ft_TcmFlag = gft_TcmFlag_bis_US;
   else
      ft_TcmFlag = gft_TcmFlag;
   if (ft_TcmFlag == TRUE)
      ul_data |= MASK_BIT25;

    ul_data |= gs_TxNumTones -1;
   WriteCoreReg((uint32)IRI_QT_REG_TX_TCM_CTRL_ADDR, ul_data);


   // IT_ACT_ADDR
   //hardware restriction in the transmit path that when the BAT has an odd number of 1-bit tone pairs.

   //calculate the number of tones with bi=0 and with bi>0
    s_Tx_NumLogical_Tones = gs_TxNumTones;
    s_Tx_Num0bits_Tones =  s_Tx_NumLogical_Tones - gs_TxNumLoadedTones;
    s_Tx_NumGT1bits_Tones = gs_TxNumLoadedTones - gus_Tx_Tcm_Num1bits;

   if ((ft_TcmFlag == TRUE)&&((s_Tx_Num0bits_Tones - gft_Tx_Tcm_X0_YGT1) & 0x1))
      SetUpTxTonesRegister(1, (uint16)(gs_TxNumTones -1));
   else
      SetUpTxTonesRegister(0, (uint16)(gs_TxNumTones -1));

   //copy the inactive table to the active table
   ConfigIridiaQtpTxPath();

   /* Done with OLR reconfiguration, Update State */
   gt_TxOLRVars.uc_txOLRState = OLR_BKGND_PROC_STATE;
   /* Reconfiguration done, update OLR variables in background task */
   AddFunctionToBkgdFifo((PtrToBkgdFunc)OLR_BgBackupTxConfig);

}

void switch_bigi_banks(void)
{
    //The active and inactive tables point to the same segment
   guc_RxQtActiveTblSeg = guc_RxQtInactiveTblSeg;
   ConfigIridiaQtpRxPath();
}

void reconfig_Lp_Bits(void)
{
   uint16 us_data;
   uint32 ul_prev_LP0;

   ReadCoreReg(IRI_QT_REG_RX_LP0_BITS_ADDR, &ul_prev_LP0);
   /*****  IR_LP0_BITS *****/
   us_data = (uint16)(gt_rx_config.s_Lp[LP0_DATA_PATH]);
   WriteCoreReg(IRI_QT_REG_RX_LP0_BITS_ADDR,(uint32)us_data);

   /*****  IR_LP1_BITS *****/
   us_data = (uint16)(gt_rx_config.s_Lp[LP1_DATA_PATH]);
   WriteCoreReg (IRI_QT_REG_RX_LP1_BITS_ADDR,(uint32)us_data);

   //reconfig_Lp_Bits always happens before CaptureRxBitsInFifo. Therefore
   //the value of LP used in CaptureRxBitsInFifo does not correspond to the
   //actual number of bits output by the previous qt run.
   //gs_RxBitsInFifo +=((uint16)ul_prev_LP0 - gt_rx_config.s_Lp[LP0_DATA_PATH]);
   //gs_RxBitsInFifo = gs_RxBitsInFifo & 0x7;

}

/*****************************************************************************
;  Subroutine Name: OLRPM_RxIridiaReconfigDataPumpSetup(void)
;
;  This subroutine reconfigures the Iridia FFT/FDQ/ConstDec Rx path
;
;  Prototype:
;     void OLRPM_RxIridiaReconfigDataPumpSetup(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;****************************************************************************/
void OLRPM_RxIridiaReconfigDataPumpSetup(void)
{

   uint16 us_Rx_1Bit_Index;

   if(gt_RxOLRPMVars.s_rxOLRPMEvent & RECONFIG_PCB)
   {
      /* load FFT scalebacks*/
      OLRPM_RxFftReconfigDataPumpSetup();

      /* load FDQ */
      LoadFDQ();

         //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
         #ifdef HW_SNR_FDQ
                gsa_pilot_FDQ_coef[0] = gsa_pre_FDQ_coef[gs_PilotToneIdx*2];
                gsa_pilot_FDQ_coef[1] = gsa_pre_FDQ_coef[gs_PilotToneIdx*2+1];
                guc_pilot_FDQ_exp = guca_pre_FDQ_exp[gs_PilotToneIdx];
         #endif
         //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

      gt_RxOLRPMVars.s_rxOLRPMEvent &= ~RECONFIG_PCB;
      return;
   }
   if(gt_RxOLRPMVars.s_rxOLRPMEvent & RECONFIG_BiGi)
   {
      /************ IR_TONES ************/
      //Save previous ir_tones register value -- needed during L2 to L0 transition
      ReadRxTonesRegister(&gt_RxOLRPMVars.us_rxL0IrMinToneRegVal, &gt_RxOLRPMVars.us_rxL0IrMaxToneRegVal);
      SetUpRxTonesRegister(gus_Rx_MinToneIndx, gus_Rx_MaxToneIndx);

      /*********IR_TCM_CTRL ************/
      //Save previous ir_tcm_ctrl register value -- needed during L2 to L0 transition
      ReadRxTcmControlRegister(&(gt_RxOLRPMVars.us_rxL0Tcm_Num1bits_Val), &(gt_RxOLRPMVars.us_rxL0Tcm_1Bit_Index_Val));

      us_Rx_1Bit_Index = gs_RxNumTones - gus_Rx_Tcm_Num1bits;
      Configure_TCM_Bits(gus_Rx_Tcm_Num1bits, us_Rx_1Bit_Index);

      switch_bigi_banks();

      gt_RxOLRPMVars.s_rxOLRPMEvent &= ~RECONFIG_BiGi;
   }
   if(gt_RxOLRPMVars.s_rxOLRPMEvent & RECONFIG_Lp)
   {
      reconfig_Lp_Bits();

      /* Use Lp Event to distinguish between L0 to L2 and L2 Trim */
      if(   gt_RxOLRPMVars.uc_rxOLRPMState == L2_RECONFIGURE)
      {
         /* update l2 processing state */
         gt_RxOLRPMVars.uc_l2ProcState = PM_L2_STATE;

// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
         STATArray[STAT_PowerMode] = STAT_PM_L2;
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
      }

      gt_RxOLRPMVars.s_rxOLRPMEvent &= ~RECONFIG_Lp;
   }

   if(   gt_RxOLRPMVars.uc_rxOLRPMState == L2_RECONFIGURE)
   {

      /* Done with L0 to L2/L2 Trim, Update State */

      // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
      // During L2, Call ReverbSegueDetectorSetup() during 'Data symbol 1'
      // (i.e. one symbol before going to L2) to avoid Mips Peaking.
      gt_RxOLRPMVars.uc_rxOLRPMState = L2_SETUP_REVSEQ_DETECTOR;
      //gt_RxOLRPMVars.uc_rxOLRPMState = L2_STEADY_STATE;
      // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

      gs_OlrReq = 0;

      /* L0 to L2/L2 Trim, do post-processing */
      AddFunctionToBkgdFifo((PtrToBkgdFunc)PM_BgRxL0ToL2Config);
   }
}

/*****************************************************************************
;  Subroutine Name: OLRPM_RxAZIReconfigDataPumpSetup(void)
;
;  This subroutine reconfigures the Iridia, Zephyr, Alphaeus data Rx path
;
;  Prototype:
;     void OLRPM_RxAZIReconfigDataPumpSetup(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;****************************************************************************/
void OLRPM_RxAZIReconfigDataPumpSetup(void)
{

   if(gt_RxOLRPMVars.s_rxOLRPMEvent & RECONFIG_Bpn)
   {
#ifndef HERCULES_ADSL_CPE
      /*****  ZEP_REG_ZR_BC0_ADDR *****/
      if(STATArray[STAT_ACTIVEBCLP_DS] & BC0_ACTIVE) {
         us_data = 1;                        /* Enable Receive on AS0 */
         if(gt_RxShowTimeVars.t_BCParms[0].sa_BC_LPath == LP1_DATA_PATH) {
            us_data |= (1 << 1);                /* Latency path 1 */
         }
      } else {
         us_data = 0;
      }
      WriteCoreReg (ZEP_REG_ZR_BC0_ADDR, us_data);

      /*****  ZEP_REG_ZR_BC1_ADDR *****/
      if(STATArray[STAT_ACTIVEBCLP_DS] & BC1_ACTIVE) {
         us_data = 1;                        /* Enable Receive on LS0 */
         if(gt_RxShowTimeVars.t_BCParms[1].sa_BC_LPath == LP1_DATA_PATH) {
            us_data |= (1 << 1);                /* Latency path 1 */
         }
      } else {
         us_data = 0;
      }
      WriteCoreReg (ZEP_REG_ZR_BC1_ADDR, us_data);

      /*****  ZEP_REG_ZR_FB0_END_ADDR *****/
      if(gt_RxShowTimeVars.t_BCParms[0].sa_BC_Bytes) {
         us_data = gt_RxShowTimeVars.t_BCParms[0].sa_BC_Bytes - 1;
         if (gt_rx_config.s_Tp[gt_RxShowTimeVars.t_BCParms[0].sa_BC_LPath] > 1) {
            us_data += 1;
         }
      }
      WriteCoreReg (ZEP_REG_ZR_FB0_END_ADDR, us_data);
      /*****  AR_FB_END0_ADDR *****/
      WriteCoreReg (AR_FB_END_ADDR(0), us_data);

      /*****  ZEP_REG_ZR_FB1_START_ADDR *****/
      if(us_data) us_data++;
      WriteCoreReg (ZEP_REG_ZR_FB1_START_ADDR, us_data);
      /*****  AR_FB_START1_ADDR *****/
      WriteCoreReg (AR_FB_START_ADDR(1), us_data);

      /*****  ZEP_REG_ZR_FB1_END_ADDR *****/
      if(gt_RxShowTimeVars.t_BCParms[1].sa_BC_Bytes) {
         us_data += (gt_RxShowTimeVars.t_BCParms[1].sa_BC_Bytes - 1);
         if( gt_rx_config.s_Tp[gt_RxShowTimeVars.t_BCParms[1].sa_BC_LPath] > 1) {
            us_data += 1;
         }
      }
      WriteCoreReg (ZEP_REG_ZR_FB1_END_ADDR, us_data);
      /*****  AR_FB_END1_ADDR *****/
      WriteCoreReg (AR_FB_END_ADDR(1), us_data);

      /*****  ZEP_REG_ZR_CODEWORD_ADDR *****/
      us_data = (uint16)((gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_CodewordSize << 8) |
                     (gt_RxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_CodewordSize));
      WriteCoreReg (ZEP_REG_ZR_CODEWORD_ADDR, us_data);

      /*****  ZEP_REG_ZR_CW_DIV_MF_ADDR *****/
      us_data = (uint16)(( gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_MuxFrameSize << 8) |
                        gt_RxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_MuxFrameSize );
      WriteCoreReg (ZEP_REG_ZR_CW_DIV_MF_ADDR, us_data);

      ReadCoreReg (ZEP_REG_ZR_DBASE0_ADDR, &us_data);
      us_data += (uint16)(gt_rx_config.s_Dp[LP0_DATA_PATH] *
                     gt_RxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_CodewordSize_Odd);
      /*****  ZEP_REG_ZR_DLIMIT0_ADDR *****/
      WriteCoreReg (ZEP_REG_ZR_DLIMIT0_ADDR, us_data);
      /*****  IR_LP0_LIMIT *****/
      WriteCoreReg (IRI_REG_IR_LP0_LIMIT_ADDR, us_data);

      ReadCoreReg (ZEP_REG_ZR_DBASE1_ADDR, &us_data);
      us_data += (uint16)(gt_rx_config.s_Dp[LP1_DATA_PATH] *
                     gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_CodewordSize_Odd);
      /*****  ZEP_REG_ZR_DLIMIT1_ADDR *****/
      WriteCoreReg (ZEP_REG_ZR_DLIMIT1_ADDR, us_data);
      /*****  IR_LP1_LIMIT *****/
      WriteCoreReg (IRI_REG_IR_LP1_LIMIT_ADDR, us_data);

      /*****  IR_LP0_XCNT *****/
      ReadCoreReg (IRI_REG_IR_LP0_XCNT_ADDR, &us_data);
      us_data &= 0x7FFF;   /* Clear the msb */
      us_data |= ((gt_RxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_CodewordSize & 0x1) << 15);
      WriteCoreReg (IRI_REG_IR_LP0_XCNT_ADDR, us_data);

      /*****  IR_LP1_XCNT *****/
      ReadCoreReg (IRI_REG_IR_LP1_XCNT_ADDR, &us_data);
      us_data &= 0x7FFF;   /* Clear the msb */
      us_data |= ((gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_CodewordSize & 0x1) << 15);
      WriteCoreReg (IRI_REG_IR_LP1_XCNT_ADDR, us_data);
#endif // HERCULES_ADSL_CPE
      gt_RxOLRPMVars.s_rxOLRPMEvent &= ~RECONFIG_Bpn;
   }

   if(   gt_RxOLRPMVars.uc_rxOLRPMState == OLR_RECONFIGURE)
   {
      /* Done with OLR reconfiguration, Update State */
      gt_RxOLRPMVars.uc_rxOLRPMState = OLR_BKGND_PROC_STATE;
      /* Reconfiguration done, update and backup OLR/PM variables in background task, do post-processing */
      AddFunctionToBkgdFifo((PtrToBkgdFunc)OLR_BgBackupRxConfig);
   }

}

/*****************************************************************************
;  Subroutine Name: OLRPM_RxFftFdqReconfigDataPumpSetup(void)
;
;  This subroutine reconfigures the Iridia FFT Rx path
;
;  Prototype:
;     void OLRPM_RxFftFdqReconfigDataPumpSetup(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;****************************************************************************/
void OLRPM_RxFftReconfigDataPumpSetup(void)
{
   /* Update FFT Scalebacks */
   WriteCoreReg(IRI_FT_REG_RX_SCALE_ADDR, gt_RxOLRPMVars.t_L2PowerCutBack.s_FftScalebackMask);
}

/*****************************************************************************
;  Subroutine Name: void PML2ToL0_RestoreRxL0Config(void)
;
;  This subroutine reconfigures the Iridia data Rx path for L2 to L0 transition
;
;  Prototype:
;     void PML2ToL0_RestoreRxL0Config(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;****************************************************************************/
void PML2ToL0_RestoreRxL0Config(void)
{
   //////////////////////////////////
   // Switch BAT and Gain Tables
   //////////////////////////////////
    if (guc_RxQtInactiveTblSeg == RX_INACTIVE_SEG0)
        guc_RxQtInactiveTblSeg = RX_INACTIVE_SEG1;

   else if (guc_RxQtInactiveTblSeg == RX_INACTIVE_SEG1)
      guc_RxQtInactiveTblSeg = RX_INACTIVE_SEG0;

   //////////////////////////////////
   // Load Iridia IR_Tones control Register
   //////////////////////////////////
   SetUpRxTonesRegister(gt_RxOLRPMVars.us_rxL0IrMinToneRegVal, (uint16)gt_RxOLRPMVars.us_rxL0IrMaxToneRegVal);

   //////////////////////////////////
   // Load Iridia Tcm control Register
   //////////////////////////////////
   Configure_TCM_Bits(gt_RxOLRPMVars.us_rxL0Tcm_Num1bits_Val, gt_RxOLRPMVars.us_rxL0Tcm_1Bit_Index_Val);

   //////////////////////////////////
   // Load Iridia Lp Bits Register
   //////////////////////////////////
   reconfig_Lp_Bits();

   // Restore Rx rate buf wptr and Rx Bit fifo to saved values-- used to account for falsely decoding l2 exit seq as data
   RestoreQamOutputState();

   //switch_bigi_banks();
   //Fix bug of not properly configuring Rx active/inactive table (START)
   uint32 ul_temp;
   ul_temp = gul_qtp_rx_ctrl_L0;
   ul_temp &= ~(7<<2);
   ul_temp |= (guc_RxQtInactiveTblSeg<<2);
   //WriteCoreReg( IRI_QTP_REG_RXTC_CTRL_ADDR, gul_qtp_rx_ctrl_L0);
   WriteCoreReg( IRI_QTP_REG_RXTC_CTRL_ADDR, ul_temp);
   //Fix bug of not properly configuring Rx active/inactive table (END)

   //The active and inactive tables point to the same segment
   guc_RxQtActiveTblSeg = guc_RxQtInactiveTblSeg;
   CopyRxTable_InactiveToActive(gt_RxOLRPMVars.us_rxL0IrMinToneRegVal, gt_RxOLRPMVars.us_rxL0IrMaxToneRegVal);
   //restore state machine moved to ZPH_IOf_bis.c
}

/*****************************************************************************
;  Subroutine Name: OLRPM_RxReadTables(void)
;
;  Restore the s/w copy of BAT/Gains table from h/w
;
;  Prototype:
;     void OLRPM_RxReadTables(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;****************************************************************************/
void OLRPM_RxReadTables(void)
{
   uint32 ul_addr;

   /* Read bat table */
   if(gt_RxOLRPMVars.s_rxOLRPMEvent & READ_BAT)
   {
      /* Write BAT table to Iridia core */
      ul_addr = GetPingPongTableAddress(RX_BAT, guc_RxQtActiveTblSeg);

      ReadCoreBuf32(ul_addr, (int16*)(void *)gt_rx_config.psa_BAT, (uint16)(gs_RxNumTones >> 2));
      gt_RxOLRPMVars.s_rxOLRPMEvent &= ~READ_BAT;
   }
   /* Read combined gain table */
   else if(gt_RxOLRPMVars.s_rxOLRPMEvent & READ_GAIN)
   {
      /* Load Gain Scales to Iridia core */
      ul_addr = GetPingPongTableAddress(RX_GST, guc_RxQtActiveTblSeg);
      ReadCoreBuf32(ul_addr, gsa_RxCombinedGains, (uint16)(gs_RxNumTones >> 1));
      gt_RxOLRPMVars.s_rxOLRPMEvent &= ~READ_GAIN;
   }
        //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
        //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
        #ifdef HW_SNR_FDQ
        else if (gt_RxOLRPMVars.s_rxOLRPMEvent & READ_FDQ1)
        {
         ReadFDQ1();
         gt_RxOLRPMVars.s_rxOLRPMEvent &= ~READ_FDQ1;
        }
        else if (gt_RxOLRPMVars.s_rxOLRPMEvent & READ_FDQ2)
        {
         ReadFDQ2();
         gt_RxOLRPMVars.s_rxOLRPMEvent &= ~READ_FDQ2;
        }
        #endif
        //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
        //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
   else
   {
      /* Done with reconfiguration, Update Event and State */
      if(gt_RxOLRPMVars.uc_rxOLRPMState == L2_READ_TABLES)
      {
         gt_RxOLRPMVars.uc_rxOLRPMState = PM_BKGND_PROC_STATE;
      }
      else if(gt_RxOLRPMVars.uc_rxOLRPMState == OLR_READ_TABLES)
      {
         gt_RxOLRPMVars.uc_rxOLRPMState = OLR_BKGND_PROC_STATE;
      }
      /* Reconfiguration done, update OLR/PM variables in background task */
      AddFunctionToBkgdFifo((PtrToBkgdFunc)OLRPM_BgRestoreRxL0Config);
      return;
   }


}
