/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_Ini.C
 *
 *   Iridia Initialization functions
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"

/***************************************************************************************
;  Subroutine Name: void ReadRxTonesRegister(uint16 *pus_data)
;
;  Description:
;
;  Return Iridia IR_MIN_TONES and IR_MAX_TONES register
;
;  Prototype:
;     void ReadRxTonesRegister(uint16 *pus_minTone, uint16 *pus_maxTone)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;**********************************************************************************************/
void ReadRxTonesRegister(uint16 *pus_minTone, uint16 *pus_maxTone)
{

    uint32 ul_data;

   ReadCoreReg(IRI_QT_REG_RX_ACTIVE_ADDR, &ul_data);

   *pus_minTone = (uint16)ul_data & 0x01FFF;

   *pus_maxTone = (uint16)(ul_data >> 16) & 0x01FFF;
}

/***************************************************************************************
;  Subroutine Name: void ReadRxTcmControlRegister(uint16 *pus_Tcm_Num1bits, uint16 *pus_1Bit_Index)
;
;  Description:
;
;  Read Iridia IR_NUM_1BIT register and IR_1BIT_INDEX register
;
;  Prototype:
;     void ReadRxTcmControlRegister(uint16 *pus_Tcm_Num1bits, uint16 *pus_1Bit_Index)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;**********************************************************************************************/

void ReadRxTcmControlRegister(uint16 *pus_Tcm_Num1bits, uint16 *pus_1Bit_Index)
{
   uint32 ul_data;
   uint16 us_Num1BitPair;

   ReadCoreReg(IRI_QT_REG_RX_TCM_CTRL_ADDR, &ul_data);

   us_Num1BitPair = (uint16)(ul_data >> 13) & 0x0FFF;
   *pus_Tcm_Num1bits = us_Num1BitPair << 1;

   *pus_1Bit_Index = (uint16)ul_data & 0x01FFF;
}
