/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_Ini.C
 *
 *   Iridia Initialization functions
 *
 *
 *----------------------------------------------------------------------------
 */
//*******************************************************************
// reconfig_fft1.c
//
// History
//
// 20/09/2011 Anantha Ramu: Brought up Annex M feature
//                   Grep for XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//*****************************************************************************
#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "ec_init.h"


/****************************************************************************
; Name: Reconfig_TxIfftLength
;
; Prototype:
;  void Reconfig_TxIFftLength(void)
;
; Description:
;  This function is used in the HWE engine to set the tx ifft length
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
*****************************************************************************/

C_SCOPE void Reconfig_TxIfftLength(int16 s_FftLength)
{
   uint32 ul_data;

   //FT_TX_CTRL_A and FT_TX_CTRL register
   ReadCoreReg((uint32)IRI_FT_REG_TX_CTRL_A_ADDR, &ul_data);
   ul_data &= ~((uint32)FT_TX_CTRL_IFFT_TSIZE_MASK);
   if (s_FftLength == 1024)
      ul_data |= (uint32)(0x3<<3);
   else
      ul_data |= (uint32)(0x2<<3);
   WriteCoreReg((uint32)IRI_FT_REG_TX_CTRL_A_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_FT_REG_TX_CTRL_ADDR, ul_data);
   gt_vrx5dfe_dsl_config.ul_FT_REG_TX_CTRL = ul_data;

   //set IRI_FTB_IFFT_TSIZE_ADDR register
   if (s_FftLength == 1024)
      ul_data = (uint32)0x3333;  //FFT_TSIZE = 512
   else
      ul_data = (uint32)0x2222;   //FFT_TSIZE = 256
   WriteCoreReg((uint32)IRI_FTB_IFFT_TSIZE_ADDR, ul_data);
   gt_vrx5dfe_dsl_config.ul_FTB_IFFT_TSIZE = ul_data;

   // set QT IR_CONFIG register
   ReadCoreReg((uint32)IRI_QT_REG_TX_CNFG_ADDR, &ul_data);
   ul_data &= ~((uint32)IRI_QT_REG_TX_CNFG_MASK);
   if (s_FftLength == 1024)
      ul_data |= (uint32)(QT_I_CONFIG_I_NSC_512<<4);
   else
      ul_data |= (uint32)(QT_I_CONFIG_I_NSC_256<<4);
   WriteCoreReg((uint32)IRI_QT_REG_TX_CNFG_ADDR, ul_data);
   gt_vrx5dfe_dsl_config.ul_QT_REG_TX_CNFG = ul_data;

}
/***************************************************************************************
;  Subroutine Name: void SetUpTxIfftScaling(void)
;
;  Description:
;
;  Sets Iridia IT_SCALE register for additional scaling, if necessary
;
;  Prototype:
;     void SetUpTxIfftScaling(void)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;**********************************************************************************************/


C_SCOPE void SetUpTxIfftScaling(void)
{
   uint32 ul_data;

#ifdef ISDN
   // set IFFT scaleback
   ul_data =
      ((uint32)0x1 << 0) // PP_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      | ((uint32)0x2 << 2) // BP1_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      | ((uint32)0x2 << 4) // BP2_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      | ((uint32)0x1 << 6) // BP3_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      | ((uint32)0x0 << 8) // BP4_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      | ((uint32)0x0 << 10) // BP5_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      | ((uint32)0x0 << 12); // BP6_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
   gs_TxLog2FftScaling = 6;
#else
   // set IFFT scaleback
if (gs_RxFftLength==512)
{
   //XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M (Start)
   if (!(gl_SelectedMode == (MODE_G992_3 | ANNEX_M)))
   {
   // BIS, DMT
      ul_data =
         ((uint32)0x1 << 0) // PP_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x2 << 2) // BP1_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x2 << 4) // BP2_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x1 << 6) // BP3_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x1 << 8) // BP4_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x0 << 10) // BP5_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x0 << 12); // BP6_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      gs_TxLog2FftScaling =  7;
   }
   else
   {
      // XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (START)
      ul_data =
         ((uint32)0x1 << 0) // PP_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x2 << 2) // BP1_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x2 << 4) // BP2_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x1 << 6) // BP3_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x0 << 8) // BP4_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x0 << 10) // BP5_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x0 << 12); // BP6_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      gs_TxLog2FftScaling = 6;
      // XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (END)
   }
   //XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M (End)
}
else
{
   // PLUS
   //XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M (Start)
   if (!(gl_SelectedMode == (MODE_G992_5 | ANNEX_M)))
   {
         //XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M (End)
         //XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
         if (OPTNArray[OPTN_TXPathControl] & 0x01)    // if US performance fix: on
         {
            // PLUS
            ul_data =
                  ((uint32)0x2 << 0) // PP_SB:  0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
               | ((uint32)0x2 << 2) // BP1_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
               | ((uint32)0x2 << 4) // BP2_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
               | ((uint32)0x1 << 6) // BP3_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
               | ((uint32)0x0 << 8) // BP4_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
               | ((uint32)0x0 << 10) // BP5_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
               | ((uint32)0x0 << 12); // BP6_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
            gs_TxLog2FftScaling = 7;
         }
         else
         {
         //XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
         ul_data =
            ((uint32)0x1 << 0) // PP_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
            | ((uint32)0x1 << 2) // BP1_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
            | ((uint32)0x1 << 4) // BP2_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
            | ((uint32)0x1 << 6) // BP3_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
            | ((uint32)0x0 << 8) // BP4_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
            | ((uint32)0x0 << 10) // BP5_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
            | ((uint32)0x0 << 12); // BP6_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
            gs_TxLog2FftScaling = 4;
         }     //XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start_End)
   }
   else
   {
      ul_data =
         ((uint32)0x1 << 0) // PP_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x2 << 2) // BP1_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x2 << 4) // BP2_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x1 << 6) // BP3_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x1 << 8) // BP4_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x0 << 10) // BP5_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
         | ((uint32)0x0 << 12); // BP6_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      gs_TxLog2FftScaling = 7;
   }
   //XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M (End)

}

#endif
   // program the ft scale register only once at the end
   if ((gs_AnnexBMJPSDMaskIdx >= 1) &&(gft_XtraIfftCutback))
   {
         gs_TxLog2FftScaling++;
         ul_data |= ((uint32)0x1 << 1);      // add another stage of scaling for 64-pt emulation because of clipping in ifft
   }
   WriteCoreReg((uint32)IRI_FT_REG_TX_SCALE_ADDR, ul_data);
   gt_vrx5dfe_dsl_config.ul_TxIFFTScaling = ul_data;
}

/***************************************************************************************
;  Subroutine Name: void Reconfig_IRI_IFFT_Size(void)
;
;  Description:
;
;     enable Tx and Rx paths
;
;  Prototype:
;        void Reconfig_IRI_IFFT_Size(void)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;**********************************************************************************************/

C_SCOPE void Reconfig_IRI_IFFT_Size(void)
{
   /* configure fft length based on recently found value */
   Reconfig_TxIfftLength(gs_TxFftLength_Oversample);
   //extra ifft cutback
   SetUpTxIfftScaling();
}
