/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   timercov.c
 *
 *   Interface functions for timing recovery hardware.
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include <memrymap.h>
#include <LL_IOf.h>
#include "dsp_op.h"
#include "gdata.h"
#include "pll.h"

int32 gl_quan_err=0;

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: UpdateTimingRecoveryHW(int32 l_in);
 *
 *  Description: Updates the hardware register for timing recovery.
 *
 *------------------------------------------------------------------------
 *^^^
 */
void UpdateTimingRecoveryHW(int32 l_in)
{

    int32 l_in_quan;

   union
   {
      int32   s;
      uint32  u;
   } RegisterValue32;


#ifndef TARGET_HW
   // for cocomo testing it isn't working if we allow the SRC_FR to change.
   return;
#endif

   if(gft_EnableNoiseShaping) // could remove this line as there is no means to disable this anymore.
      l_in += gl_quan_err;

    // Quantize the input.
   //  Round(l_in,14) is inline for efficiency.
   // Note the register value is 4X compared to Danube to keep loop gain the same.
    l_in_quan   = l_in + ((int32)0x1 << (14-1)); // add rounding bit
    l_in_quan >>= 14;
    gl_quan_err = l_in - (l_in_quan << 14);

   // Write FreqOffset to HW Register.
   // Note SRC FR input needs to be negated compared to socrates/Danube hw.
   if (gs_UpdateTimingRecoveryHWEnable == 1){
      RegisterValue32.s = (int32) -l_in_quan + gl_initfreqoffset; // add the fixed frequency offset to take care of different Master clock frequency
      WriteCoreReg((uint32) V_SRCFR_ADDR, RegisterValue32.u);
   }


   /* reminder to consider this
   these limits are in vdsl and may be a good idea to include for adsl if the pll goes haywire.
   #ifdef TARGET_HW
   int32 gl_upperlimit = 0x4F000;
   int32 gl_lowerlimit = 0x47000;
   #else
   int32 gl_upperlimit = 0x7FFFF;
   int32 gl_lowerlimit = 0x00000;
   #endif
    if (l_in_quan > gl_upperlimit) l_in_quan = gl_upperlimit;  // make sure it's not too big or too small;
    if (l_in_quan < gl_lowerlimit) l_in_quan = gl_lowerlimit;  // otherwise PLL not able to pull in
   */


}

