/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   zph_FrameBuffer.c
 *
 *   Functions to Interface to zephyr Frame Buffer
 *
 *
 *
 *----------------------------------------------------------------------------
 */
#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "xgdata.h"
#include "byteflip.h"
#include "rx_ops.h"
#include "ghs.h"
#include "cmv.h"
#include "tx_aoc.h"

//#include "zephyr.h"
#include "memrymap.h"
#include "ALP_IOf.h"
#include "LL_IOf.h"
#include "IRI_Iof.h"
#include "mp.h"
#include "fifo.h"
#include "tx_m3oh.h"
#include "ib.h"
#include "tx_ib.h"
#include "tx_eoc.h"
#include "tx_ovrhd.h"
#include "bert.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name :  LoadTxFrameBuffer
 *
 *  Description: Load data into the TX frame buffer
 *
 *  Prototype: void LoadTxFrameBuffer(int16 s_bc, uint8 *puc_txbertbuffer,
 *                            int16 s_txbertbufferreadaddr, uint16 *ps_bytesloaded)
 *
 *  Input Arguments: ppuc_databuffer   -  Pointer to an array of pointers to data
 *
 *  Output Arguments:   None
 *
 *  Return: None
 *
 *  Global Variables Used: guca_fciTxBS
 *
 *------------------------------------------------------------------------
 *^^^
 */
void LoadTxFrameBuffer(int16 s_bc, uint8 *puc_txbertbuffer, int16 s_txbertbufferreadaddr, uint16 *ps_bytesloaded)
{
   // not supported in Hercules build
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name :  GetRxFrameBuffer
 *
 *  Description: Get data from the RX frame buffer
 *
 *  Prototype: void GetRxFrameBuffer(int16 s_bc, uint8 *puca_databuffer, int16 *ps_databufferindex)
 *
 *  Input Arguments: s_bc           - Bearer channel
 *                puca_databuffer      - Buffer to be written to
 *                ps_databufferindex   - Buffer Index
 *
 *  Output Arguments:   None
 *
 *  Return: None
 *
 *  Global Variables Used: guca_fciRxBSR
 *
 *------------------------------------------------------------------------
 *^^^
 */

void GetRxFrameBuffer(int16 s_bc, uint8 *puca_databuffer, int16 *ps_databufferindex)
{
   // not supported in Hercules build
}

/***************************************************************************************
;  Subroutine Name: GetBCTxFrameBufferStartAddr(int16 s_numBearerChannel,
;                                      uint16 *pus_fbxStartAddr)
;
;  Description:
;     This function gets the start address of the given bearer channel
;     data in the Tx frame buffer
;
;  Prototype:
;     void GetBCTxFrameBufferStartAddr(int16 s_numBearerChannel, uint16 *pus_fbxStartAddr)
;
;  Input Arguments:
;     s_numBearerChannel   -  specifies the bearer channel
;
;  Output Arguments:
;     pus_fbxStartAddr  -  specifies the start address of the given bearer channel
;                       in Tx frame buffer
;
;  Return Value:
;     none
;
;**********************************************************************************************/
void GetBCTxFrameBufferStartAddr(int16 s_numBearerChannel, uint16 *pus_fbxStartAddr)
{
   // not supported in Hercules build
}

/***************************************************************************************
;  Subroutine Name: GetBCRxFrameBufferStartAddr(int16 s_numBearerChannel,
;                                      uint16 *pus_fbxStartAddr)
;
;  Description:
;     This function gets the start address of the given bearer channel
;     data in the Rx frame buffer
;
;  Prototype:
;     void GetBCRxFrameBufferStartAddr(int16 s_numBearerChannel, uint16 *pus_fbxStartAddr)
;
;  Input Arguments:
;     s_numBearerChannel   -  specifies the bearer channel
;
;  Output Arguments:
;     pus_fbxStartAddr  -  specifies the start address of the given bearer channel
;                       in Rx frame buffer
;
;  Return Value:
;     none
;
;**********************************************************************************************/
void GetBCRxFrameBufferStartAddr(int16 s_numBearerChannel, uint16 *pus_fbxStartAddr)
{
   // not supported in Hercules build
}

