/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   zph_ini.c
 *
 *   Functions to Interface to
 *
 *
 *----------------------------------------------------------------------------
 */

//*-------------------------------------------------------------------------------//
// zph_ini.c
//
// History
//
//
// 25/03/2013 Kannan:
//          1. Reset Zephyr's PRAM & Zephy'r register locations
//             Grep for "XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues "
//
// 16/05/2013 Kannan:
//            Clearing of PRAM location are enough and clearing of
//            Zephyr registers are not required, since Zephyr will copy
//            the data from PRAM and store Zephyr register contents back
//            to the PRAM once the framing is done.
//            Hence initializing of PRAM registers are enough.
//            Grep for "XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException"
//
// 10/05/2013 Prashant:
//          1. Clearing of Zephyr register locations was causing the ShowtimeLink drop in AnnexB DMT.
//          As per Kannan this Clearing of Zephy'r register locations is not necessary, so removed it.
//             Grep for " XDSLRTFW-932: BugFix_DS_DMT_ALL_InitialSynchLoss "
//
//*-------------------------------------------------------------------------------//


#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"

void InitZephyr(void)
{
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)

   //Reset Zephyr's PRAM memory location for both Tx & Rx
   FillCoreBuf32(ZEP_PRAM_TX_LP0_START_ADDR, 0, ZEP_REG_TX_PRAM_SIZE);
   FillCoreBuf32(ZEP_PRAM_TX_LP1_START_ADDR, 0, ZEP_REG_TX_PRAM_SIZE);

   FillCoreBuf32(ZEP_PRAM_RX_LP0_START_ADDR, 0, ZEP_REG_RX_PRAM_SIZE);
   FillCoreBuf32(ZEP_PRAM_RX_LP1_START_ADDR, 0, ZEP_REG_RX_PRAM_SIZE);

   //XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (START)
   //Reseting of Zephyr registers are not required, since Zephyr will copy
   //the data from PRAM and store it back once the framing is done.
   //Hence initializing of PRAM registers are enough.

   // XDSLRTFW-932: BugFix_DS_DMT_ALL_InitialSynchLoss (START)
   // reset all Zephyr-FC TX registers
// FillCoreBuf32(ZEP_TX_START_ADDRESS, 0, ZEP_REG_NUM_TX_WORDS);

   // reset all Zephyr-FC RX registers
// FillCoreBuf32(ZEP_RX_START_ADDRESS, 0, ZEP_REG_NUM_RX_WORDS);
   // XDSLRTFW-932: BugFix_DS_DMT_ALL_InitialSynchLoss (END)
    //XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (END)

    //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
}

void InitBcr(void)
{
   // reset all TX registers
   FillCoreBuf32(BCR_TX_REG_BASE_ADDR, 0, BCR_TX_NUM_GREGS);

   // reset all RX registers
   FillCoreBuf32(BCR_RX_REG_BASE_ADDR, 0, BCR_RX_NUM_GREGS);
}
