/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*----------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Condfidential
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276-4000
*   FAX   (781) 276-4001
*
*   LinkStart.c
*
*
*----------------------------------------------------------------------------
*/
// ******************************************************************************
// LinkStart.c
//
// History
//
// 21/11/2011 Hanyu:  Ported MFD code to VR9. Added code to force G.dmt Annex A for NLNF measurement.
//                    This can be enabled by CMV bit-15 (default "0" means enabled)
//                    of INFO 121 0 in persistent memory
//                    and "cw test 7 0 0x0D" without SW API support
//                    or enabaled by cw cntl 0 0 0x09 with SW API support.
//                    Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// 02/12/2011 Balabath:Added new microstate STATs18D and 19D CMV DSL 16 is used inplace of INFO 121
//       for NLNF measurement.INFO 103 (6:11) are mapped to DSL 18 0 5 (Hybrid information)..
//            Additinally, DSL13 bit2 is used inplace of CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap
//
// 03/03/2011 Stefan/Vinjam: Use Annex-B filters in oISDN binary. Reconfigure them post-handshake again based on selected mode.
//          PSD violation in ADSL G.Hs if Annex-J mode is enabled - Jira XDSLRTFW-258
//          In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
//          in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
//          tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
//          PSDs because of the reconfiguration of the tx-path after G.Hs
//          As Annex-J activation tones are currently not used in any field deployment the activation
//          tones and G.Hs filter configurations are hard-coded to Annex-B.
//          this part of the code is called only in LinkStartForTest.c
//          Grep for XDSLRTFW-653 XDSLRTFW-258 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs
//
// 23/01/2013: Kannan: THIS FILE IS NOT BEING USED FOR VR9/VRX318
//             TARGET_HW COMPILATION, HENCE DO NOT ADD ANY CODE
//             RELATED TO VR9/VRX318 IN THIS FILE.
//
//  07/02/18: Stefan: XDSLRTFW-2417: INFINEON not used anymore in VR9 ADSL code
//            Re-enable required code under #ifdef INFINEON
//            - KPN specific ADSL Annex-B (oISDN) Tx-spectrum
//            - Nlp = 1
//            grep for XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
// ******************************************************************

#include "const.h"
#include "file_io.h"
#include "gdata.h"
#include <stdio.h>
#include <stdlib.h>
#include "modem_hw.h"
#include "InitBMf.h"
#include "trail.h"
#include "trailend.h"
#include "file_io3.h"
#include "ghs.h"
#include "string.h"
#include "mp.h"
#include "cmv.h"
#include "nmp.h"
#include "nmp_plfm.h"
#include "channel.h"
#include "bert.h"
#include "STR_IOf.h"
#include "ALP_IOf.h"
#include "stateini.h"
#include "ec_data.h"
#include "gdata_bis.h"
#include "sach.h"    // For Sachmo channel
#include "cnfg_eng.h"
#include "cnfg_task.h"
#include "iri_ini.h"
#include "DSLEngin.h"
#include "str_ini.h"
#include "statein1.h"
#include "hndshk_Data.h"
#include "afe.h"
#include "delay.h"
#include "ll_iof.h"
#include "memrymap.h"
#include "pll.h"
#include "codeswap.h"
#include "spectral_shape_bis.h"
#ifdef TARGET_HW
#include "socrates_memrymap.h"
#include "soc_codeswap.h"
#endif
#include "InitTDQfilter.h"

#ifdef VINAX_ADSL_AFE
#include "ifx_vdsl2_afe_memmap.h"
#include "afe_if_dd.h"
#endif

/*^^^
*-------------------------------------------------------------------
*
*  void ConfigEngineForLinkStart(void)
*
*  Description:
*
*
*-------------------------------------------------------------------
*^^^
*/
void ConfigEngineForLinkStart(void)
{
    int16 i, s_temp;


#ifdef ISDN
    int16 sa_Preferred_PSDMask_G9923x[NUM_G992_3_ANNEX_SUPPORTED] = {DEFAULT_G992_3B_PSDMASK, DEFAULT_G992_3J_PSDMASK, DEFAULT_G992_3M_PSDMASK};
    int16 sa_Preferred_PSDMask_G9925x[NUM_G992_5_ANNEX_SUPPORTED] = {DEFAULT_G992_5B_PSDMASK, DEFAULT_G992_5J_PSDMASK, DEFAULT_G992_5M_PSDMASK};
#else
    int16 sa_Preferred_PSDMask_G9923x[NUM_G992_3_ANNEX_SUPPORTED] = {DEFAULT_G992_3A_PSDMASK, DEFAULT_G992_3I_PSDMASK, DEFAULT_G992_3M_PSDMASK};
    int16 sa_Preferred_PSDMask_G9925x[NUM_G992_5_ANNEX_SUPPORTED] = {DEFAULT_G992_5A_PSDMASK, DEFAULT_G992_5I_PSDMASK, DEFAULT_G992_5M_PSDMASK};
#endif

    // A longer dec length of 400 taps combined with a sharper interp1 gives us improved
    // performance by limiting uncancelled linear echo.
    gs_DEC_ORDER = 400; /* swengine tests use 288 tap DEC, hence we need to reconfigure here */

#ifdef ISDN
    // XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
    if (gt_INFX_CMV.us_OperatorSpBits & CMV_TO_FORCE_KPN_TSSI_US_BIN_START)
    {
        // Overwrite default US TSSI with KPN-specific values.  Note that these
        // US tssi are the same for modes 3B and 5B.

        memcpy(guca_US_TssiIndex_G9923B, guca_US_TssiIndex_G9923B_KPN, sizeof(uint8) * NUM_US_TSSI_VALUES_INITIAL_CLR);
        memcpy(guca_US_TssiValue_G9923B, guca_US_TssiValue_G9923B_KPN, sizeof(uint8) * NUM_US_TSSI_VALUES_INITIAL_CLR);
        memcpy(gfta_US_SprtSet_G9923B, gfta_US_SprtSet_G9923B_KPN, sizeof(uint8));

        memcpy(guca_US_TssiIndex_G9925B, guca_US_TssiIndex_G9923B_KPN, sizeof(uint8) * NUM_US_TSSI_VALUES_INITIAL_CLR);
        memcpy(guca_US_TssiValue_G9925B, guca_US_TssiValue_G9923B_KPN, sizeof(uint8) * NUM_US_TSSI_VALUES_INITIAL_CLR);
        memcpy(gfta_US_SprtSet_G9925B, gfta_US_SprtSet_G9923B_KPN, sizeof(uint8));
    }
#endif

    /* =============================================================================== */
    /* Select DMT or BIS (or both?)    */
    /* =============================================================================== */

  //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
   // To force G.dmt Annex A if NLNF measurement is enabled.
   // This gives better performance for NLNF.
   // This can be enabled by CMV bit-2 of DSL 13 0
   // (default "0" means enabled)
   // and "cw test 7 0 0x7FD0" without SW API support
   // or enabaled by cw cntl 0 0 0x09 with SW API support.
   //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (start_end)
   if (((gt_ApiOptions.us_Opt_Offset0 & CMV_BIT2_TO_ENABLEE_NLNF_STARTUP)&&
      (TESTArray[TEST_RxSubState] == CMV_TEST70_RX_NLNF_TRIGGERED)) ||
      (CNTLArray[CNTL_ModemControl] == CNTL_ModemNLNF))
  {
      OPTNArray[OPTN_ModeControl] = (int16) OPTN_ConfigMode_G992_1_A;
  }
#endif //#ifndef ISDN
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)

    gul_ModeControl = ((uint32)OPTNArray[OPTN_ModeControl]&0xFFFF) |  (uint32)(OPTNArray[OPTN_ModeControl1]<<16);
    if (gul_ModeControl & STAT_ConfigMode_ADSL2_ALL) // Bis or plus bit is set
    {
        gft_ModemType = G_DMT_BIS;

        // We delay the initialization of some G.HS BisInfo Tx members here
        // because those info are controlled via CMV. Therefore we have
        // to wait until all the CMVs have been processed
        /* Initialize Bis (ADSL2) Information in TxInfo */
        for (i = 0; i < NUM_G992_3_ANNEX_SUPPORTED; i++)
        {
            gs_Preferred_PSDMask_G9923x[i] = sa_Preferred_PSDMask_G9923x[i];
            InitGlobalVariables2_BisInfoTx(gpt_TxInfo->pta_G9923xInfo[i], i);
            InitGlobalVariables2_BisInfoRx(gpt_RxInfo->pta_G9923xInfo[i], i);
        }
        for (i = 0; i < NUM_G992_5_ANNEX_SUPPORTED; i++)
        {
            gs_Preferred_PSDMask_G9925x[i] = sa_Preferred_PSDMask_G9925x[i];
            InitGlobalVariables2_BisPlusInfoTx(gpt_TxInfo->pta_G9925xInfo[i], i);
            InitGlobalVariables2_BisPlusInfoRx(gpt_RxInfo->pta_G9925xInfo[i], i);
        }

        if((OPTNArray[OPTN_AlgControl] & OPTN_MedleyControlMask) != 0) // MedleyTdqOff, MultiTdq, MultiSync or MedleyFdq is on
        gt_RMsgs1_bis.uc_CA_MEDLEYds = guc_R_C_MEDLEY_LENGTH_DIV_512;    // Regular length
        else
        gt_RMsgs1_bis.uc_CA_MEDLEYds = guc_R_C_MEDLEY_LENGTH_DIV_512_DEBUG; // short length

        if ((gul_ModeControl & STAT_ConfigMode_G992_5_ALL) != 0)
        {
            if ((OPTNArray[OPTN_StateMachineCtrl] & OPTN_G992_5_14thOrderPRBS_Enable) )
            gt_RMsgFmt_bis.uc_MedleyPRBSus = 1;          /* use 14th order medley sequence */
            else
            gt_RMsgFmt_bis.uc_MedleyPRBSus = 0;          /* default use dmt medley sequence */
        }

    }
    else{
        gft_ModemType = G_DMT;
    }

    /* =============================================================================== */
    /* Set STAT CMV to indicate that TDQ runs at 1.1MHz if necessary */
    /* =============================================================================== */
    if (OPTNArray[OPTN_AlgControl] & OPTN_Run_TDQ_at_1104)
    {
        STATArray[STAT_Misc] |= STAT_TDQ_at_1104;
    }

    /* =============================================================================== */
    /* Update Tx FFT length and registers for a chosen IFFT size*/
    /* =============================================================================== */
#ifdef IFFT128
    /* IFFT size is always 128 in HWEngine 3.0 (Socrates Plus chip) since we use emulated 64 pt IFFT if required */
    gs_TxFftLength = 128;
    gs_TxCPLength = (int16) (gs_TxFftLength>>4);

    /* Compute log2(gs_TxFftLength)-1 = log2(gs_TxFftLength/2) */
    gs_TxLog2FftLength1 = 0;
    s_temp = (gs_TxFftLength >> 1);
    while((s_temp&1) == 0)
    {
        gs_TxLog2FftLength1++;
        s_temp >>= 1;
    }
#endif

    /****************************************************************************/
    /* We cannot truly multimode yet. Hence we set some firmware settings based */
    /* on specific modes that OPTNArray[OPTN_ModeControl] supports            */
    /****************************************************************************/
#ifdef ISDN /* Annex B/J/M */
    /* Digital and Analog filters to be used */

   /* Reconfig strymon s/w filter coefs for Annex B/M/J operation */
   /* Use the most Annex-B filters in oISDN binary                 */
   /* Reconfigure them post-handshake again based on selected mode */

   //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (Start)
   // PSD violation in ADSL G.Hs if Annex-J mode is enabled - Jira XDSLRTFW-258
   // In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
   // in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
   // tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
   // PSDs because of the reconfiguration of the tx-path after G.Hs
   // As Annex-J activation tones are currently not used in any field deployment the activation
   // tones and G.Hs filter configurations are hard-coded to Annex-B.
   // this part of the code is called only in LinkStartForTest.c
   Reconfig_STR_FW(ANNEX_B);
   //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (End)

    /* Reconfig AFE filters for Annex B/M/J operation */
    /* Specifically, AFE High pass filters */
    /* No reconfiguration required post-handshake given multi-mode between B/J/M */
    Reconfig_AFE();
#else /* Annex A/I/M */
#ifndef DANUBE
    /* Reconfigure the default POTS TX HPF filter with an alternative one, if desired.*/
    if (TESTArray[TEST_Control2] & TEST_AltPOTSTxHPF)
    {
        Reconfig_POTS_TxHPF();
    }
    /* Reconfigure the default Interp1 TX LPF filters with alternative ones, if desired.*/
    if (gft_AltInterp1TxLPF != FALSE)
    {
        Reconfig_Interp1_TxLPF();
    }
#endif
    /* Load appropriate filters for sleep mode based on preferred mode and mask. */
  //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
   if ((CNTLArray[CNTL_ModemControl] & CNTL_ModemSleep) ||
       (CNTLArray[CNTL_ModemControl] == CNTL_ModemNLNF))
#else
  if (CNTLArray[CNTL_ModemControl] & CNTL_ModemSleep)
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
    {
        /* Use 512 point FFT in DMT, Lite, and Annex A/L Bis modes; use 1024 point FFT in all other modes. */
        if ((gul_ModeControl & (~(STAT_ConfigMode_G992_1_ALL | STAT_ConfigMode_G992_2_ALL | STAT_ConfigMode_G992_3_A | STAT_ConfigMode_G992_3_L))) == 0)
        {
            OPTNArray[OPTN_StateMachineCtrl] &= (~OPTN_FFT1024_Enable);
        }
        /* Reconfigure filters and AFE for Annex M. */
        if (gul_ModeControl & STAT_ConfigMode_AnnexM_ALL)
        {
            Reconfig_STR_FW(ANNEX_M);
            Reconfig_AFE();
        }
        /* Reconfigure filters for Annex L mask 2. */
        else if ((gul_ModeControl & STAT_ConfigMode_AnnexL_ALL) && ((OPTNArray[OPTN_AnnexControl] & OPTN_G992_3_AnnexA_PreferredModeMask) == OPTN_G992_3_AnnexA_PreferredModeL2))
        {
            STATArray[STAT_Misc] |= STAT_AnnexL_US_Mask2_PSD;
            Reconfig_STR_FW(ANNEX_L);
        }
    }
    /* Reconfig AFE filters for Annex A/I/M operation */
    /* Specifically, AFE High pass filters  now happens  */
    /*  post-handshake for multi-mode between A/I && M */

#endif


    /* =============================================================================== */
    /* Update Rx FFT length for 1024 point IFFT */
    /* =============================================================================== */

    if ((OPTNArray[OPTN_StateMachineCtrl] & OPTN_FFT1024_Enable))
    {
        /* Update f/w variables to correspond to using 1024 pt FFT */
        gs_RxFftLength = 1024;
        gs_RxNumTones = 512;
        gs_numAecLMSIterations = 12;   /* we run out of MIPS here with 1024 samples/frame with default value of 16 */
        /* Empirically, 12 iterations seems to be fine with 1024 samples/frame on Socrates+ */
#ifdef TARGET_HW
        gs_presync_stepsize = 2;
#endif

        // gs_RxFftLength would have changed.
        gs_RxCPLength = gs_RxFftLength >> 4;
        gs_RxSamplesPerFrame = gs_RxFftLength;
        /* Compute log2(gs_RxFftLength)-1 = log2(gs_FftLength/2) */
        gs_RxLog2FftLength1 = 0;
        s_temp = (gs_RxFftLength >> 1);
        while((s_temp&1) == 0)
        {
            gs_RxLog2FftLength1++;
            s_temp >>= 1;
        }
        /* Compute log2rxnumsamples */
        s_temp = gs_RxSamplesPerFrame;
        gs_Log2RxSamplesPerFrame = 0;
        while((s_temp&1) == 0)
        {
            gs_Log2RxSamplesPerFrame++;
            s_temp >>= 1;
        }

        // gs_RxNumTones would have changed.
        gs_RxLastChannel = gs_RxNumTones-1;
        gus_Rx_MaxToneIndx = gs_RxNumTones-1;
        DisableFDQ();   // Reload UnityFdq
    }

    /* =============================================================================== */
    /* Update DEC Upsampling factor based on Rx FFT and Tx IFFT Lengths */
    /* =============================================================================== */
    for(gs_DECUpsamplingFactor=1, s_temp=gs_TxFftLength; s_temp<gs_RxSamplesPerFrame; s_temp<<=1)
    gs_DECUpsamplingFactor <<= 1;

    /* =============================================================================== */
    /* Update Iridia based on Rx FFT and Tx IFFT Lengths                      */
    /* =============================================================================== */
    Reconfig_IRI();

#ifndef ADSL_62
    /* =============================================================================== */
    /* Update Strymons SMODE Register based on Rx FFT and Tx IFFT Lengths           */
    /* =============================================================================== */
    Reconfig_STR_SMODE();
#else
    /* ==================================================================================== */
    /* update Strymons sample rate (input rate of each block) due to fft/ifft length change */
    /* =====================================================================================*/
    Reconfig_DFE_SampleRate();
#endif

    /* =============================================================================== */
    /* Update Strymons Filters based on above reconfigs (SMODE registers/DEC Length)   */
    /* =============================================================================== */
    Reconfig_DFE_Rx();
    Reconfig_DFE_Tx();



#ifdef VINAX_ADSL_AFE
    // This code sets the external line driver based on TEST 30.
    // At power up it is currently set to Internal.
    if (TESTArray[30] & 1)
    WriteVDSLAfe(IFX_VDSL2_AFE_DIGITAL_REG_15_ADDR, 0x09C6);   // External LD - Acton/Boxborough
    else
    WriteVDSLAfe(IFX_VDSL2_AFE_DIGITAL_REG_15_ADDR, 0x09E1); // Internal LD - Bedford Config

#endif

    /* =============================================================================== */
    /* Load TX Sine Gain */
    /* =============================================================================== */
    gus_TxSineGain = gus_TxGain_NoCutBack;
    LoadTxSineGain();

    /* =============================================================================== */
    /* Take Strymon out of reset. */
    /* =============================================================================== */
    Strymon_ClearResetState();

    /* =============================================================================== */
    /* If Alphaeus is enabled, we may want to put it in transparent mode */
    /* =============================================================================== */

    if ((TESTArray[TEST_Control] & TEST_AlphaeusControl) != 0
            && (TESTArray[TEST_Control] & TEST_AlphaeusTPEnable) != 0)
    {
        EnableAAI_TPMODE();
    }

#ifndef HERCULES_ADSL_CPE
    Reconfig_AAI();
#endif

    // Set default values to fft buffer control OPTN
    // TEMPORARY-- Until we get rid of this altogether
    OPTNArray[OPTN_FFTBufferControl] =  OPTN_ShowtimeScenario3 | OPTN_TrainScenario1 ;

    SetInitialTDQ();

    LoadTDQ();

    if (OPTNArray[OPTN_StateMachineCtrl] &OPTN_ForceExplicitRate)
    CNTLArray[0] |= CNTL_ExpilictRate;

#ifdef PCM_INTERFACE_SUPPORT
    if (CNTLArray[CNTL_ME_HDLC] & CNTL_ME_Start_PCM)
    gsa_CodeSwapNextSection[CSPAGE_BIS_SHOWBG2] = CSPAGE_BIS_SHWBG3B;
#endif


}
#undef ANNEX_J_TXGAIN
#undef ANNEX_M_TXGAIN

/*^^^
*-------------------------------------------------------------------
*
*  void LinkStart(void)
*
*  Description:
*
*     This function uses the CMV's to configure the modem when
*  CNTL is used to start a link and G.HS IS the initial state
*  (i.e. during the normal modem mode of operation).
*
*
*-------------------------------------------------------------------
*^^^
*/
#ifdef VINAX_ADSL_AFE
extern void EnableAfeDataProcessing(void);
#endif

void LinkStart(void)
{

    ConfigEngineForLinkStart();
    ConfigTaskLayerForLinkStart();

#ifndef TARGET_HW
    if ((gul_ModeControl & STAT_ConfigMode_G992_5_ALL) != 0)
    gs_AtoD_PutPtr = (3*(1024+64))/2;
    else
    gs_AtoD_PutPtr = (3*(512+32))/2;
#endif

    /*==============================================================*/
    /* Update STAT   */
    /*==============================================================*/

    STATArray[STAT_MacroState] = STAT_ReadyState;



#ifdef VINAX_ADSL_AFE
    // Following function resides in afeio_VNX.c file.  If exact same Argo AI register access is used for other
    // HWE5.x-matched AFE's, then same function can be reused (better moved to a more generic-named file).
    EnableAfeDataProcessing();
#endif

#ifdef AMAZON_SE
    // controls whether we need the workaround for the adma or not. (00 = A11 = adma is broken => gft_FixAdma = False = 0 )
    gft_Fixadma = (FlagT) (gt_INFX_CMV.s_versionControl & 0x3);
#endif
}

