/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   init_eng.c
*
*  Functions for configuring engine.
*
*-------------------------------------------------------------------------
*/
#include "gdata.h"
#include "gdata_bis.h"
#include "bert.h"
#include "ZPH_Ini.h"
#include "cmv.h"
#include "preshow.h"
#include "memsetbf.h"
#include "fifo.h"
#include "modem.h"

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void ConfigBERT(void)
*
*   Description:
*
*     If enabled via CMV, then initialize the SW BERT.
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void ConfigBERT(void)
{
   int16 i;

   /* =============================================================================== */
   /* Perform initialization based on the initial state */
   /* =============================================================================== */

#ifndef DISABLE_BERT
   if ((TESTArray[TEST_Control] & TEST_ConnControl) && (gs_do_bert))
   {
      for (i = 0; i < NUM_DS_BEARER_CHANNELS; i++)
      {
         Init_Rx_Bert(&gta_RxBertStat[i] , 0);
         gta_RxBertStat[i].s_num_bytes = (gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].sa_B_alloc[i] +
            gt_RxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].sa_B_alloc[i]);
      }
      for (i = 0; i < NUM_US_BEARER_CHANNELS; i++){
         Init_Tx_Bert(&gta_TxBertStat[i], 0, 1000);
      }

   }
#endif

}

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void ConfigEngineForInitialState(void)
*
*   Description:
*  Configure those parameters of the HW Engine that depend on the test type/
*  initial state (i.e. training, showtime, etc.).  This function is NOT
*  called when the modem begins in G.HS (as it would during normal operation).
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void ConfigEngineForInitialState(void)
{
   int16 i;
   int16 la_ZeroBuf[4096];

   /* =============================================================================== */
   /* Perform initialization based on the initial state */
   /* =============================================================================== */

   if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState)
   {
      /* Initialize Iridia and Zephyr */
      for(guc_TxDataPumpState = TRAINING_WAITING; guc_TxDataPumpState != TRAINING_DONE;)
      {
         TxDataPumpSetUp();
      }
      if(gft_TcmFlag_bis_DS)  //If ADSL2 and Trellis On
      {
      /* Rx Data Pump Setup calls a background function which inturn waits forever until a TC task is completed */
      /* Ugly Hack to have showtime only tests working given that we cannot simulate the above here */
      /* split the datapumpsetup to have bkgrnd function processed here instead of being added to the fifo */
         for(guc_RxDataPumpState = TRAINING_WAITING; guc_RxToneOrderLoadState != RXTONEORDERLOAD_BKGD_IN_PROGRESS;)
         {
            RxDataPumpSetUp();
         }
         RunModem();
         for(;guc_RxDataPumpState != TRAINING_DONE;)
         {
            RxDataPumpSetUp();
         }
      }
      else
      {
         for(guc_RxDataPumpState = TRAINING_WAITING; guc_RxDataPumpState != TRAINING_DONE;)
         {
            RxDataPumpSetUp();
         }
      }

      /* Initialize Zephyr */
      InitZephyr();

      /* In the absence of Alphaeus, to convey to the DSP of byte stuffing */
      for(i = 0; i < NUM_BEARER_CHANNELS; i++)
      {
         if (gt_tx_config.s_Tp[gt_TxShowTimeVars.t_BCParms[i].sa_BC_LPath] > 1)
            guca_fciTxBS[i]=1;
         else
            guca_fciTxBS[i]=0;
      }

      // For showtime test we need to load the task-layer FDQ that was initialized
      // in ConfigTaskLayerForInitialState().  These coefficients have the required
      // scaling (not unity) for the showtime-only test.
      // LoadFDQ() is set as a loading function, queued after another loading function
      // DisableFDQ() which is set in function SetLinkModeDependentVariables().
      // When the first interrupt arrives, DisableFDQ() will be executed first and then
      // LoadFDQ will be executed. This way, it is guaranteed that the FDQ coefficients
      // required for a showtime-only test are loaded.
      AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQ);

      // Load AEC, DEC and TDQ for showtime tests (needed if Strymon is ON).
      LoadAEC();
      gsa_RxBuffer8X_0 = gpsa_CommonMemoryBlock0;
      gla_RxAccumBuf = (int32 *) gsa_RxBuffer8X_0;
      gft_ReorderDEC = TRUE;
      MemSetBuffer((int16 *) la_ZeroBuf, 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));
      ReorderDEC((int16 *) la_ZeroBuf);
      LoadDEC();
      LoadTDQ();

      /* initialization Time Critical Task for Showtime  */
      //gt_TaskArray[TX_FRAME_START].TimeCriticalTask=RShowtimeTxTC;
      //gt_TaskArray[RX_FDQ_DONE].TimeCriticalTask = RShowtimeRxTC;
      gt_TaskArray[TX_FRAME_START].TimeCriticalTask=RPreShowtimeTxTC;
      gt_TaskArray[RX_FDQ_DONE].TimeCriticalTask = RPreShowtimeRxTC;
      gt_TaskArray[RX_QAM_DONE].TimeCriticalTask = RPreShowtimeRxTC;


      /* Reset TX and RX input and output buffer size */
      InsertTxCP();
      InsertRxCP();
   }

   else if (TESTArray[TEST_InitState] == TEST_RetrainInitState)
   {
      ;
   }

   UpdateTxParameters();   // Force Iridia to update Tx parameters, including frame size, CP length.
   UpdateRxParameters();   // Force Iridia to update Rx parameters, including CP length.
}

