/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   file_io3.c
*
*  Functions for handling file I/O processing.
*
*-------------------------------------------------------------------------
*/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "common.h"
#include "gdata.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ghs.h"
#include "hs_tx.h"
#include "hs_rx.h"
#include "hs_mesg.h"
#include "hs_resp.h"
#include "hs_misc.h"
#include "ifft_fix.h"
#include "qam_enc.h"
#include "xgdata.h"
#include "exchdata.h"
#include "trail.h"
#include "channel.h"
#include "tdq_init.h"
#include "compiler.h"
#include "modem_hw.h"
#include "file_io.h"
#include "file_io3.h"
#include "pll.h"
#include "byteflip.h"
#include "bert.h"
#include "mp.h"
#include "cmv.h"
#include "rx_eoc.h"
#include "alphaeus.h"
#include "alphaeus_const.h"
#include "zephyr.h"
#include "dsp_op.h"
#include "modem_hw.h"
#include "sach.h"
#include "data_alloc.h"
#include "dli.h"
extern processDLI_t fnProcessDLI;

/* =============================================== */
/* global variable declarations */
/* =============================================== */

int16 gs_downSampleCnt = 16;


#ifdef LEAVE_TRAIL
FILE *trail_fid;
#endif /*  LEAVE_TRAIL */

#ifdef PRINT_INTERMEDIATE_RESULTS
FILE *fp_fconfig_tx, *fp_fframe_tx, *fp_fcrc_tx, *fp_fscram_tx, *fp_frs_tx, *fp_filv_tx, *fp_fqam_tx, *fp_fifft_tx,
     *fp_fconfig_rx, *fp_fframe_rx, *fp_fcrc_rx, *fp_fscram_rx, *fp_frs_rx, *fp_filv_rx, *fp_fqam_rx, *fp_fifft_rx;



#endif /*  PRINT_INTERMEDIATE_RESULTS */

uint8 guca_TX_LS0_Inbuf[MAX_LSX_PAYLOAD_BYTES + 1]; /*  Input data from Bearer Channel LS0 */
                                                    /*  +1 to account for robbed data bytes */

uint8 guca_RX_AS0_Outbuf[MAX_AS0_PAYLOAD_BYTES + 2]; /*  Input data from Bearer Channel AS0 */
                                                    /*  +2 to account for robbed data bytes */

uint8 guca_TX_LS1_Inbuf[MAX_LSX_PAYLOAD_BYTES + 1]; /*  Input data from Bearer Channel LS1 */
                                                    /*  +1 to account for robbed data bytes */
uint8 guca_TX_LS2_Inbuf[MAX_LSX_PAYLOAD_BYTES + 1]; /*  Input data from Bearer Channel LS2 */
                                                    /*  +1 to account for robbed data bytes */
uint8 guca_RX_AS1_Outbuf[MAX_AS1_PAYLOAD_BYTES + 2]; /*  Input data from Bearer Channel AS1 */
                                                    /*  +2 to account for robbed data bytes */
uint8 guca_RX_AS2_Outbuf[MAX_AS2_PAYLOAD_BYTES + 2]; /*  Input data from Bearer Channel AS2 */
                                                    /*  +2 to account for robbed data bytes */
uint8 guca_RX_AS3_Outbuf[MAX_AS3_PAYLOAD_BYTES + 2]; /*  Input data from Bearer Channel AS3 */
                                                    /*  +2 to account for robbed data bytes */
uint8 guca_RX_LS0_Outbuf[MAX_LSX_PAYLOAD_BYTES + 1];    /*  Output data from Bearer Channel LS0 */
                                                        /*  +1 to account for robbed data bytes */
uint8 guca_RX_LS1_Outbuf[MAX_LSX_PAYLOAD_BYTES + 1];    /*  Output data from Bearer Channel LS1 */
                                                        /*  +1 to account for robbed data bytes */
uint8 guca_RX_LS2_Outbuf[MAX_LSX_PAYLOAD_BYTES + 1];    /*  Output data from Bearer Channel LS2 */
                                                        /*  +1 to account for robbed data bytes */

uint8 *gpucaa_TXChannel_InBufs[NUM_US_BEARER_CHANNELS] = /* Array of pointers in Input data buffers */
{
    guca_TX_LS0_Inbuf,

    guca_TX_LS1_Inbuf,
    guca_TX_LS2_Inbuf

};

uint8 *gpucaa_RXChannel_OutBufs[NUM_DS_BEARER_CHANNELS] = /* Array of pointers in output data buffers */
{
    guca_RX_AS0_Outbuf,

    guca_RX_AS1_Outbuf,
    guca_RX_AS2_Outbuf,
    guca_RX_AS3_Outbuf,
    guca_RX_LS0_Outbuf,
    guca_RX_LS1_Outbuf,
    guca_RX_LS2_Outbuf

};

int16 gsa_sync_priority[NUM_US_BEARER_CHANNELS] = {     /*  list of bearer channels, sorted  */
                                                        /*  by their sync control priority */
    US_LS0_BEARER_CHANNEL,

    US_LS1_BEARER_CHANNEL,
    US_LS2_BEARER_CHANNEL

};

/* =============================================== */
/* static variable declarations */
/* =============================================== */
#ifdef FILE_IO


FILE *TxInFilePtrs[NUM_US_BEARER_CHANNELS]  = {NULL, NULL, NULL};
FILE *RxOutFilePtrs[NUM_DS_BEARER_CHANNELS] = {NULL, NULL, NULL, NULL, NULL, NULL, NULL};


FILE *Tx_infid=NULL;
FILE *Tx_outfid=NULL;
FILE *Tx_echo_outfid = NULL; //ECHO output file
FILE *Rx_infid=NULL;
FILE *Rx_outfid=NULL;
#endif


int16 gs_EndOfRxInputData = 0;
int8 gca_InitialState[50];
int16 gs_TxDownSampleCnt;

/* Tx_outfid_filename holds a pointer to the Tx_outfid file    */
/* used to hold the transmit time domain data.              */
/* this pointer is used to open (append) and close the         */
/* output file to allow C model connectivity via the file.     */

char *gpc_Tx_outfid_filename;

/* gs_ReadType determines how the receive time domain data is accessed. */
/* The type of access may vary based on the method used to connect C Models   */

/* gs_ReadType determines how the receive time domain data is accessed. */
/* The type of access may vary based on the method used to connect C Models   */

#ifdef READ_TYPE_1
int16 gs_ReadType = 1;
#else
int16 gs_ReadType = 0;
#endif

int16 gs_TxSample;         /* Tx output sample */
int16 gs_EchoSample;    /* Echo-pass filtered Tx output sample */
int16 gs_AecChannelOut;       /* output of AEC channel */

/*****************************************************************************
;  Prototype: int16 OpenFiles(void);
;
;  Description:
;     This subroutine gets TX input and RX input data for current symbol period
;
;  Arguments:
;
;  Return:
;     SUCCEED -- open files succeed
;     FAIL  -- open files fails
;
;  Global Variables:
;     Tx_infid -- (O) TX input file pointer
;     Rx_infid -- (O) RX input file pointer
;     Tx_outfid   -- (O) TX output file pointer
;     Rx_outfid   -- (O) RX output file pointer
;****************************************************************************/
int16 OpenFiles(void)
{
   int16 result, i, j;

   if (gs_TxInputFile)
   {
      // These files not used in BERT mode
      if ((Tx_infid = fopen(SetInputDir(Tx_Infile_Name), "r")) == NULL)
      {
         fprintf(stdout, "Cannot open Tx input file %s\n", SetInputDir(Tx_Infile_Name));
         return((int16)FAIL);
      }

      if (OpenTX_Files() == FAIL)
      {
         return((int16)FAIL);
      }

   }


   if (gs_TxOutputFile)
   {
      if ((Tx_outfid = fopen(Tx_Outfile_Name, "wb")) == NULL) {
         fprintf(stdout, "Cannot open Tx output file %s\n", Tx_Outfile_Name);
         return((int16)FAIL);
      }

      if ((Tx_echo_outfid = fopen("tx_echo.bin", "wb")) == NULL) {
         fprintf(stdout, "Cannot open Tx Echo data output file tx_echo.bin\n");
         return((int16)FAIL);
      }

      /* get global pointer to the Tx_outfid file  */
      gpc_Tx_outfid_filename = Tx_Outfile_Name;

      if(gs_ReadType == 1)
      {
         j=0;
         for (i=0; i<200; i++){
            fwrite(&j, sizeof(int16), 1, Tx_outfid);
            fwrite(&j, sizeof(int16), 1, Tx_echo_outfid);
         }
         fclose(Tx_outfid);
         fclose(Tx_echo_outfid);
      }

   }

   if (gs_RxInputFile)
   {
      if ((Rx_infid = fopen(SetInputDir(Rx_Infile_Name), "rb")) == NULL) {
         fprintf(stdout, "Cannot open Rx input file %s\n", SetInputDir(Rx_Infile_Name));
         return((int16)FAIL);
      }
   }

   if (gs_RxOutputFile)
   {
      if ((Rx_outfid = fopen(SetInputDir(Rx_Outfile_Name), "r")) == NULL) {
         fprintf(stdout, "Cannot open Rx output file %s\n", SetInputDir(Rx_Outfile_Name));
         return((int16)FAIL);
      }

      if (OpenRX_Files() == FAIL)
      {
         return((int16)FAIL);
      }
   }

#ifdef LEAVE_TRAIL
   if( (result = OpenTrailFile()) == (int16)FAIL)
      return((int16)FAIL);

#endif /*  LEAVE_TRAIL */

#ifdef PRINT_INTERMEDIATE_RESULTS
   fp_fconfig_tx = fopen("fconfig.tx", "w");
   if (fp_fconfig_tx == NULL) {
      fprintf(stdout,"\nFile fconfig.tx cannot be opened.\n");
      return((int16)FAIL);
   }

   fp_fframe_tx = fopen("fframe.tx", "w");
   if (fp_fframe_tx == NULL) {
      fprintf(stdout,"\nFile fframe.tx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_fcrc_tx = fopen("fcrc.tx", "w");
   if (fp_fcrc_tx == NULL) {
      fprintf(stdout,"\nFile fcrc.tx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_fscram_tx = fopen("fscram.tx", "w");
   if (fp_fscram_tx == NULL) {
      fprintf(stdout,"\nFile fscram.tx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_frs_tx = fopen("frs.tx", "w");
   if (fp_frs_tx == NULL) {
      fprintf(stdout,"\nFile frs.tx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_filv_tx = fopen("filv.tx", "w");
   if (fp_filv_tx == NULL) {
      fprintf(stdout,"\nFile filv.tx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_fqam_tx = fopen("fqam.tx", "w");
   if (fp_fqam_tx == NULL) {
      fprintf(stdout,"\nFile fqam.tx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_fifft_tx = fopen("fifft.tx", "w");
   if (fp_fifft_tx == NULL) {
      fprintf(stdout,"\nFile fifft.tx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_fconfig_rx = fopen("fconfig.rx", "w");
   if (fp_fconfig_rx == NULL) {
      fprintf(stdout,"\nFile fconfig.rx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_filv_rx = fopen("filv.rx", "w");
   if (fp_filv_rx == NULL) {
      fprintf(stdout,"\nFile filv.rx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_frs_rx = fopen("frs.rx", "w");
   if (fp_frs_rx == NULL) {
      fprintf(stdout,"\nFile frs.rx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_fscram_rx = fopen("fscram.rx", "w");
   if (fp_fscram_rx == NULL) {
      fprintf(stdout,"\nFile fscram.rx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_fcrc_rx = fopen("fcrc.rx", "w");
   if (fp_fcrc_rx == NULL) {
      fprintf(stdout,"\nFile fcrc.rx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_fframe_rx = fopen("fframe.rx", "w");
   if (fp_fframe_rx == NULL) {
      fprintf(stdout,"\nFile fframe.rx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_fifft_rx = fopen("fifft.rx", "w");
   if (fp_fifft_rx == NULL) {
      fprintf(stdout,"\nFile fifft.rx cannot be opened.\n");
      return((int16)FAIL);
   }
   fp_fqam_rx = fopen("fqam.rx", "w");
   if (fp_fqam_rx == NULL) {
      fprintf(stdout,"\nFile fqam.rx cannot be opened.\n");
      return((int16)FAIL);
   }

#endif /*  PRINT_INTERMEDIATE_RESULTS */


   return((int16)SUCCEED);
}

/*****************************************************************************
;  Prototype: int16 CloseFiles(void);
;
;  Description:
;     This subroutine closes all input and output files.
;
;  Arguments:
;     none
;
;  Return:
;     SUCCEED
;
;  Global Variables:
;     Tx_infid -- (I) TX input file pointer
;     Rx_infid -- (I) RX input file pointer
;     Tx_outfid   -- (I) TX output file pointer
;     Rx_outfid   -- (I) RX output file pointer
;
;****************************************************************************/
int16 CloseFiles(void)
{

    int16 i;

   /*  Close Files for user data */
    for (i = 0; i < NUM_US_BEARER_CHANNELS; i++)
    {
        if (TxInFilePtrs[i])
         fclose(TxInFilePtrs[i]);
    }
    for (i = 0; i < NUM_DS_BEARER_CHANNELS; i++)
    {
        if (RxOutFilePtrs[i])
         fclose(RxOutFilePtrs[i]);
    }

   if(Tx_infid)
      fclose(Tx_infid);
   if(Tx_outfid)
      fclose(Tx_outfid);
   if(Tx_echo_outfid)
      fclose(Tx_echo_outfid);
   if(Rx_infid)
      fclose(Rx_infid);
   if(Rx_outfid)
      fclose(Rx_outfid);

#ifdef PRINT_INTERMEDIATE_RESULTS
   fclose(fp_fframe_tx);
   fclose(fp_fcrc_tx);
   fclose(fp_fscram_tx);
   fclose(fp_frs_tx);
   fclose(fp_filv_tx);
   fclose(fp_fqam_tx);
   fclose(fp_fifft_tx);
   fclose(fp_fconfig_tx);
   fclose(fp_fconfig_rx);
   fclose(fp_filv_rx);
   fclose(fp_frs_rx);
   fclose(fp_fscram_rx);
   fclose(fp_fcrc_rx);
   fclose(fp_fframe_rx);
   fclose(fp_fqam_rx);
   fclose(fp_fifft_rx);



#endif /*  PRINT_INTERMEDIATE_RESULTS */

   return((int16)SUCCEED);
}

/*****************************************************************************
;  Prototype: int16 ReadAnInputSample(int16 *sample)
;
;  This subroutine gets RX input sample for Iridia
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;     SECCEED -- read succeed
;     FAIL  -- read fails (not enough data)
;
;  Global Variables:
;     Rx_infid    -- (I) RX input file pointer
;     gs_Tx_OutBuf_Size -- (I) no. of samples in current TX symbol
;     gs_Log2DS2US_RateRatio -- (I) DS to RS sampling rate ratio
;     gs_InitialState   -- (I) ID for initial state to start with
;     gs_AtoD_GetPtr    -- (I) Get pointer of AtoD buffer
;     gs_AtoD_PutPtr    -- (I/O) Put pointer of AtoD buffer
;     gsa_RxAtoDBuf[]   -- (O) RX input buffer
;****************************************************************************/
/* need one sample at a time */

#define HWENGINE_REQUIRED_SAMPLE_CNT    1

int32 gl_PreShowtimeRxSampleCount=0;
int32 gl_ShowtimeTestDLISampleDelay=0;

int16 ReadAnInputSample(int16 *ps_sample)
{
   int16 s_count=0;
    int16 s_read, s_FramesToWaitBeforeReadingSamples;

   // If running showtime test, need to ignore read requests for
   // first R_PRE_SHOWTIME_LEN frames of Rx data corresponding to pre-showtime state
   // We do not read from file, which is assumed to contain only valid
   // showtime data

   if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState) {

      s_FramesToWaitBeforeReadingSamples = R_PRE_SHOWTIME_LEN;

      if ((TESTArray[TEST_Control] & TEST_ConnControl) &&
         ((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) != 0) &&
         ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0))
         // For Sachmo connectivity, skip over first two (invalid) frames, so that first frame
         // sent to Sachmo channel will be data for first Tx showtime frame.
         s_FramesToWaitBeforeReadingSamples += 2;

      if (gl_PreShowtimeRxSampleCount < s_FramesToWaitBeforeReadingSamples*(gs_RxFftLength+gs_RxCPLength)){
         gl_PreShowtimeRxSampleCount++;
         if (TESTArray[TEST_Control] & TEST_UpsampleControl)
         gl_PreShowtimeRxSampleCount++; /* add another since input file is at
         half the sample rate */
            *ps_sample = 0;      // Return any value. Shouldn't matter.
         return (SUCCEED);
      }


//================================================================================
// Start: Section needed for DLI connectivity (not needed for Sachmo connectivity)
//================================================================================
      // If running showtime test with DLI connectivity, initially need to delay another 2
      // frames before reading from DLI in order to avoid buffer underflow condition.

      if ((TESTArray[TEST_Control] & TEST_ConnControl) &&
         ((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0))
      {  // For DLI or Sample-based connectivity:

         if (gl_ShowtimeTestDLISampleDelay < 2*(gs_RxFftLength+gs_RxCPLength))

         {
            gl_ShowtimeTestDLISampleDelay++;
            if (TESTArray[TEST_Control] & TEST_UpsampleControl)
            gl_ShowtimeTestDLISampleDelay++; /* add another since input file is at
            half the sample rate */
            *ps_sample = 0;               // Return zero.
            return (SUCCEED);
         }
      }
   }
//================================================================================
// End: Section needed for DLI connectivity (not needed for Sachmo connectivity)
//================================================================================

   if(TESTArray[TEST_Control] & TEST_ConnControl)
   {
      // Read from the channel.

      if((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0)
      {  // For DLI or Sample-based connectivity

         s_read = gs_AtoD_PutPtr - gs_AtoD_GetPtr;
         if(s_read < 0)
            s_read += RX_ADCBUF_SIZE;
         if(s_read < HWENGINE_REQUIRED_SAMPLE_CNT)
            return((FlagT)FALSE);

         *ps_sample = gsa_RxAtoDBuf[gs_AtoD_GetPtr++];
         if(gs_AtoD_GetPtr == RX_ADCBUF_SIZE)
            gs_AtoD_GetPtr = 0;
         return (SUCCEED);
      }

      else
      {  // For Sachmo-based connectivity.
         // Read 1 sample.
         int16 s_SamplesRead, s_retcode;

         s_retcode = (int16) SACHMO_ReadDownstreamSamples(ps_sample, 1, &s_SamplesRead);

         if (s_SamplesRead < 1) {
            // This should only occur when the channel has been terminated.
            return (FAIL);
         }
         return (SUCCEED);
      }
   }

   else
   {  // Read from a file.

      if (gs_ReadType == 0){
         s_count = fread(ps_sample, sizeof(int16), 1, Rx_infid);

         if (s_count < 1){
            return(FAIL);
         }
         else{
            return(SUCCEED);
         }
      }
      else{
         while ((s_count = fread(ps_sample, sizeof(int16), 1, Rx_infid)) != 1);
         return (SUCCEED);
      }
   }
}

/*****************************************************************************
;  Prototype: int16 WriteAnOutputSample(int16 sample)
;
;  This subroutine writes an output sample from Iridia into a file
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;     SECCEED -- read succeed
;     FAIL  -- read fails (not enough data)
;
;  Global Variables:
;
;****************************************************************************/
//#define DEBUG_TX_PATH /* if turned on Tx output at low and high sampling rate
                  /* recorded into arrays. */
#ifdef DEBUG_TX_PATH
int16 gsa_STR_TxOut[1088]; /* Strymon output at 4.4MHz */
#endif

int32 gl_PreShowtimeTxSampleCount=0;

int16 WriteAnOutputSample(int16 sample)
{
   int16 s_FramesToWaitInPreshowtime;
   int32 l_SamplesToWaitInPreshowtime;
   int16 DliRxBuffer[256];

   if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState)
   {
      s_FramesToWaitInPreshowtime = R_PRE_SHOWTIME_LEN;

      if ((TESTArray[TEST_Control] & TEST_ConnControl) &&
         ((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) != 0) &&
         ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0))
      {
         // For Sachmo-based showtime connectivity, wait 2 additional frames before sending samples
         // to channel.  These first two frames have all zero samples (why?).  The real showtime
         // data seems to start with the 3rd frame.  (Is this the case for tests starting at g.hs or
         // train, too? - TNT)
         s_FramesToWaitInPreshowtime += 2;
      }

      if (gs_bypass_strymon == 1)
         l_SamplesToWaitInPreshowtime = s_FramesToWaitInPreshowtime * (gs_TxFftLength+gs_TxCPLength);
      else
         // This line looks wrong.  Probably untested since preshowtime not used with Strymon on.
         l_SamplesToWaitInPreshowtime = 2 * s_FramesToWaitInPreshowtime * (gs_RxFftLength+gs_RxCPLength);

      if (gl_PreShowtimeTxSampleCount < (int32)l_SamplesToWaitInPreshowtime)
      {
         gl_PreShowtimeTxSampleCount++;
         return (SUCCEED);    // Don't write to file or channel - still in preshowtime. Just return.
      }
   }

   if ((TESTArray[TEST_Control] & TEST_EchoControl) != 0)
   {
      /*  echo is on ==> AEC and hybrid summing junctions are implemented */
      gs_TxSample = sample;
      EchoSim(&gs_TxSample, &gs_EchoSample); /* generate an echo sample */
      if (gs_AecDacSampleValid){
         /* send AEC DAC output through AEC channel */
         AecChannel(&gs_AecDacSample, &gs_AecChannelOut);
         /* saturate result to 16 bits */
         /* if AEC taps are downloaded, gs_EchoSample is small */
         gs_EchoSample = sature16(gs_AecChannelOut + (int32)gs_EchoSample);
         /* clear valid AEC DAC sample valid flag */
         gs_AecDacSampleValid=0;
      }

   }

#ifdef DEBUG_TX_PATH
   gsa_STR_TxOut[gs_TmpTxOutBufIndex*gs_downSampleCnt+gs_TxDownSampleCnt] = sample;
#endif
   gs_TxDownSampleCnt++;
   if (gs_TxDownSampleCnt == gs_downSampleCnt){

      if((TESTArray[TEST_Control] & TEST_ConnControl))
      {
         if ((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0)
         {
            /* DLI or Sample-based DLI connectivity. Copy samples into this buffer to be
            xferred later on, right initialized to 0 */
            gsa_TmpTxOutBuf[gs_TmpTxOutBufIndex++] = sample;

            if((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) != 0) // Sample-based DLI connectivity
               if(gs_TmpTxOutBufIndex == 4)
               {
                  if(fnProcessDLI(gsa_TmpTxOutBuf, 4, DliRxBuffer) != 0)
                     gs_EndOfRxInputData = 1;

                  if(gs_AtoD_PutPtr < RX_ADCBUF_SIZE - (gs_RxFftLength >> 4))
                  {
                     memcpy(&gsa_RxAtoDBuf[gs_AtoD_PutPtr], DliRxBuffer, (gs_RxFftLength >> 4)*sizeof(int16));
                     gs_AtoD_PutPtr += (gs_RxFftLength >> 4);
                  }
                  else
                  {
                     memcpy(&gsa_RxAtoDBuf[gs_AtoD_PutPtr], DliRxBuffer, (RX_ADCBUF_SIZE - gs_AtoD_PutPtr)*sizeof(int16));
                     memcpy(&gsa_RxAtoDBuf[0], &DliRxBuffer[RX_ADCBUF_SIZE - gs_AtoD_PutPtr], ((gs_RxFftLength >> 4) - (RX_ADCBUF_SIZE - gs_AtoD_PutPtr))*sizeof(int16));
                     gs_AtoD_PutPtr = ((gs_RxFftLength >> 4) - (RX_ADCBUF_SIZE - gs_AtoD_PutPtr));
                  }

                  gs_TmpTxOutBufIndex = 0;
               }
         }
         else
         {  // Sachmo-based connectivity.
            // If the channel is terminated, no samples will be written.
            int16 s_retcode;
         s_retcode = (int16) SACHMO_WriteUpstreamSamples(&sample, 1);

         }
      }

      else
      {  // Write to a file.
         fwrite(&sample, sizeof(int16), 1, Tx_outfid);
         if ((TESTArray[TEST_Control] & TEST_EchoControl) != 0)
            fwrite(&gs_EchoSample, sizeof(int16), 1, Tx_echo_outfid);
#ifdef DEBUG_TX_PATH
         gsa_TmpTxOutBuf[gs_TmpTxOutBufIndex++] = sample;
#endif
      }
   gs_TxDownSampleCnt = 0;
   }

   return(SUCCEED);
}


/*****************************************************************************
;  Prototype: int16 GetRxInputSample (int16 *ps_RxInput)
;
;  This subroutine of Rx input data from a file into a buffer
;   gets more data when buffer is empty.
;
;  Input Arguments:
;
;  Output Arguments: ps_RxInput -- pointer to current Rx sample
;
;  Return: gs_EndOfRxInputData
;
;  Global Variables: gs_EchoSample   adds echo to Rx input sample
;
;****************************************************************************/

int16 GetRxInputSample(int16 *ps_RxInput)
{
   static int16 sample, s_count, i, s_read;
   static int16 s_NumSamples, s_IdxFirstBadSample,
   sa_InBuf[RX_FFT_LENGTH], sa_OutBuf[MAX_UPSAMPLING_FACTOR*RX_NUM_TONES];

   int16 s_Buf_Size;

   // If running showtime test, need to ignore read requests for
   // first 10 frames of Rx data corresponding to pre-showtime state
   // We do not read from file, which is assumed to contain only valid
   // showtime data
   if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState) {
      if (gl_PreShowtimeRxSampleCount < 2*10*(gs_RxFftLength+gs_RxCPLength)){
         gl_PreShowtimeRxSampleCount++;
         *ps_RxInput = 0;     // Return zero.
         if ((TESTArray[TEST_Control] & TEST_EchoControl) != 0)
            *ps_RxInput = sature16(*ps_RxInput +(int32)gs_EchoSample);
         return (0);
      }
   }

   if(TESTArray[TEST_Control] & TEST_ConnControl)
   {
      if (TESTArray[TEST_Control] & TEST_UpsampleControl)
      {
         s_Buf_Size = (gs_RxFftLength>>1);
      }
      else
      {
         s_Buf_Size = gs_RxFftLength;
      }
   }
   else
   {
      s_Buf_Size = 64;
   }

   if(s_NumSamples == 0) {

      if (gs_ReadType == 0){
      /* Read more samples from Rx input file. */

         if((TESTArray[TEST_Control] & TEST_ConnControl) == 0)
         {
            if((Rx_infid != NULL) && !feof(Rx_infid))
               s_NumSamples = (int16) fread(sa_InBuf, sizeof(int16), s_Buf_Size, Rx_infid);
         }
         else
         {
            /* First check if there is s_Buf_Size samples to get. */
            /* If there is not, do not copy data */
            s_read = gs_AtoD_PutPtr - gs_AtoD_GetPtr;
            if(s_read < 0)
               s_read += RX_ADCBUF_SIZE;
            if(s_read < s_Buf_Size)
               return((FlagT)FALSE);

            s_read = RX_ADCBUF_SIZE - gs_AtoD_GetPtr;
            if(s_read >= s_Buf_Size) {
               memcpy(sa_InBuf, &gsa_RxAtoDBuf[gs_AtoD_GetPtr], s_Buf_Size * sizeof(int16));
               gs_AtoD_GetPtr += s_Buf_Size;
            }
            else {
               memcpy(sa_InBuf, &gsa_RxAtoDBuf[gs_AtoD_GetPtr], s_read * sizeof(int16));
               memcpy(&sa_InBuf[s_read], gsa_RxAtoDBuf, (s_Buf_Size - s_read) * sizeof(int16));
               gs_AtoD_GetPtr = (s_Buf_Size - s_read);
            }

            s_NumSamples = s_Buf_Size;
            if(gs_AtoD_GetPtr == RX_ADCBUF_SIZE)
               gs_AtoD_GetPtr = 0;
         }

      }
      else{
         for (i=0; i<s_Buf_Size; i++){
            while ((s_count = fread(&sample, sizeof(int16), 1, Rx_infid))!= 1);
            sa_InBuf[i] = sample;
            s_NumSamples++;
         }
      }   /* gs_ReadType == 1, file io based connectivity */

      s_IdxFirstBadSample = (GetInterp()->us_UpsamplingFactor)*s_NumSamples;

      /* Pad input buffer with zeros. */
      for(i=s_NumSamples; i<s_Buf_Size; i++, s_NumSamples++)
         sa_InBuf[s_NumSamples] = 0;

      /* Simulate channel. */
      Channel(sa_InBuf, s_Buf_Size, sa_OutBuf);

      /* Number of samples in sa_OutBuf[]. */
      s_NumSamples = s_Buf_Size*(GetInterp()->us_UpsamplingFactor);
   }

   *ps_RxInput = sa_OutBuf[s_Buf_Size*(GetInterp()->us_UpsamplingFactor)-s_NumSamples];

   if ((TESTArray[TEST_Control] & TEST_EchoControl) != 0)
      *ps_RxInput = sature16(*ps_RxInput +(int32)gs_EchoSample); /* Add echo */

    ApplyPga(ps_RxInput);

   if(s_Buf_Size*(GetInterp()->us_UpsamplingFactor)-s_NumSamples == s_IdxFirstBadSample)
      gs_EndOfRxInputData = 1;
   s_NumSamples--;

   return(gs_EndOfRxInputData);
}
#undef BUF_SIZE


/**************************************************
 * Prototype:void InitAtoDBufPointers()
 *
 *************************************************/
void InitAtoDBufPointers(void)
{
   /* Set the ADC buffer pointers*/
   gs_AtoD_GetPtr = 0;

   /* If SHOWTIME is tested without going through initialization */
   /* we need to set pointer differently to ensure superframe is proper aligned */

    if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState)
    {

      gs_AtoD_PutPtr = gs_AtoD_GetPtr + (int16)(RX_INIT_BUF_DELAY*(gs_RxFftLength+gs_RxCPLength));


         /* set delay before valid tx samples are available */
         gs_TxOutSymbolCount = 0;
    }

}

/*****************************************************************************
;  Prototype: int16 MPHandler_STRY(char *setting)
;
;     This function configures the modem in reaction to a STRY(MON BYPASS) MP
;   command.
;
;  Input Arguments:
;
;        char *setting   -- Currently one of ON/OFF
;
;  Output Arguments:
;
;  Return:
;           Should return FAIL if an unsupported mode is selected.
;
;  Global Variables:
;****************************************************************************/

int16 MPHandler_STRY(void)
{
   int16 us_stat = (int16)SUCCEED;


      gs_bypass_strymon = 1;
      gs_downSampleCnt = 1;

   return(us_stat);
}

/*****************************************************************************
;  Prototype: int16 MPHandler_BERT(char *setting)
;
;     This function configures the modem in reaction to a BERT MP
;   command.
;
;  Input Arguments:
;
;        char *setting   -- Currently one of ON/OFF
;
;  Output Arguments:
;
;  Return:
;           Should return FAIL if an unsupported mode is selected.
;
;  Global Variables:
;****************************************************************************/

int16 MPHandler_BERT(void)
{
   int16 us_stat = (int16)SUCCEED;
   int16 i;

   gs_do_bert = 1;

   for (i = 0; i < NUM_DS_BEARER_CHANNELS; i++)
   {
      Init_Rx_Bert(&gta_RxBertStat[i] , 0);
      gta_RxBertStat[i].s_num_bytes = (gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].sa_B_alloc[i] +
         gt_RxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].sa_B_alloc[i]);
   }
   for (i = 0; i < NUM_US_BEARER_CHANNELS; i++)
      Init_Tx_Bert(&gta_TxBertStat[i], 0, 1000);


   return(us_stat);
}

/*****************************************************************************
;  Prototype: int16 MPHandler_BERT_SF(void)
;
;     This function configures the modem in reaction to a BERT_SF MP
;   command.
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;  Return:
;           Should return FAIL if an unsupported mode is selected.
;
;  Global Variables:
;****************************************************************************/

int16 MPHandler_BERT_SF(void)
{
   int16 us_stat = (int16)SUCCEED;

   gs_bert_sf_cnt = TESTArray[TEST_BertSFCnt];

   return(us_stat);
}




/*****************************************************************************
;  Prototype: int16 ReadTxInputFile(void)
;
;  This subroutine gets TX input data for current symbol period
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;     SECCEED -- read succeed
;     FAIL  -- read fails (not enough data)
;
;  Global Variables:
;     Tx_infid    -- (I) TX input file pointer
;     gl_TxSymbolCount -- (I) TX symbol count
;     gt_TxBertStat  -- (I/O) TX BERT state
;****************************************************************************/
// These flag variables were added to eliminate multiple "out-of-data" messages.
FlagT ft_InitPrintFlags=1;
FlagT fta_OutOfDataMsgPrinted[NUM_US_BEARER_CHANNELS];

int16 ReadTxInputFile(void)
{
   //==========================================================
   // Note that this function is not called during sync frames.
   //==========================================================
   int16 i, s_bytes_read;
    int16 s_bytes_avail;

   s_bytes_avail = 0;

    /* ==================================================================== */
    /*  Test for end of BERT processing */
    /* ==================================================================== */

   if (gs_bert_sf_cnt > 0)
   {
        if (gl_TxSymbolCount > (gs_bert_sf_cnt*69))
        {
            fprintf(stdout, "all BERT TX frames generated\n");
            return((int16)FAIL);
        }
   }

   /* ==================================================================== */
   /* Read TX input data */
   /* ==================================================================== */

    {

#ifdef GDMT_DS_NUM_TONES
        /*  Check if any synchronization control action is required */
        if (gft_FrameMode == FULL_ASYNC)
        {
            Update_Sync_Action_Counters();
            Check_Sync_Action(gft_FastSyncAvailable_Flag, &gt_TxShowTimeVars.t_FrameParms[FAST_DATA_PATH]);
            Check_Sync_Action(gft_InlvSyncAvailable_Flag, &gt_TxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH]);
        }
#endif /* GDMT_DS_NUM_TONES */

        /* ========================================================= */
        /*  For each bearer channel, see if there is any data to read */
        /* ========================================================= */
        for (i = 0; i  < NUM_US_BEARER_CHANNELS; i++)
        {
            s_bytes_read = 0;
         s_bytes_read = gt_TxShowTimeVars.t_FrameParms[FAST_DATA_PATH].sa_B_out[i];
            if (s_bytes_read == 0)
            {
                s_bytes_read = gt_TxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].sa_B_out[i];
            }
            if (s_bytes_read != 0)
            {

            if (gs_do_bert == 0)
            {
               /*  check that input file is open */
               if (TxInFilePtrs[i] == NULL)
               {
                  fprintf(stdout, "US Bearer Channel %d not active\n", i);
                  return((int16)FAIL);
               }

               /*  read data  */
               s_bytes_avail = (int16)fread(gpucaa_TXChannel_InBufs[i], sizeof(uint8), s_bytes_read, TxInFilePtrs[i]);

               /*  if run out of data then stop */
               if (s_bytes_avail < s_bytes_read)
               {
                  if (ft_InitPrintFlags)
                     fta_OutOfDataMsgPrinted[i]=0;

                  if (!fta_OutOfDataMsgPrinted[i]){
                     fprintf(stdout, "Out of input data for US Bearer Channel %d - Inserting all zero bytes\n", i);
                     fta_OutOfDataMsgPrinted[i] = 1;
                  }

                  // If EOF reached, fill returned buffer with zeroes.
                  memset(gpucaa_TXChannel_InBufs[i] + s_bytes_avail, 0, s_bytes_read - s_bytes_avail);
               }
            } /* end gs_do_bert == 0   */
            }
        }
      ft_InitPrintFlags = 0;
   }

   /* ======================================================================== */
   /* Load Zephyr TxFrameBuffer with bearer data.                       */
    /* This is done by Alphaeus if present.                                       */
   /*                                                       */
   /* ======================================================================== */
   {
      uint16 us_fbxStartAddr, j;
      uint8 *puca_channel_data, *puca_TxFrameBuffer;

      puca_TxFrameBuffer = Get_TxFrameBuffer();
      for (j = 0; j < NUM_BEARER_CHANNELS; j++)
      {
         if(   gt_TxShowTimeVars.t_BCParms[j].sa_BC_BytesOut)
         {
            /* Get the corresponding LSx channel data buffer */
            puca_channel_data = gpucaa_TXChannel_InBufs[gt_TxShowTimeVars.t_BCParms[j].sa_BC_LSX];

            /* Get start address of the BC in Tx frame buffer */
            GetBCTxFrameBufferStartAddr(j, &us_fbxStartAddr);

            for (i = 0; i < gt_TxShowTimeVars.t_BCParms[j].sa_BC_BytesOut; i++)
            {
               puca_TxFrameBuffer[us_fbxStartAddr+i] = puca_channel_data[i];
            }
         #ifdef DO_BYTE_FLIP
            /*  Flip bits in each byte to emulate the case where  */
            /*  MSB enters V-C interface first */
            ByteFlip(&puca_TxFrameBuffer[us_fbxStartAddr], gt_TxShowTimeVars.t_BCParms[j].sa_BC_BytesOut);
         #endif /*  DO_BYTE_FLIP */
         }
      }
   }
   return ((int16)SUCCEED);
}






/*****************************************************************************
;  Prototype: int16 OpenTX_Files()
;
;  This subroutine reads the TX configuration, determining which bearer
;   channels are active and associating the indicated TX input data file
;   with that bearer channel;
;
;  Input Arguments:
;       None
;
;  Output Arguments:
;       None
;
;   Return:
;       FAIL -- any errors were encounterd during configuration
;       PASS -- no errors encountered
;
;  Global Variables:
;
;
;****************************************************************************/
int16 OpenTX_Files()
{

    int8 ca_channel[50];
    int8 ca_filename[50];
    int16 s_channel;

    while(fscanf(Tx_infid,"%s", ca_channel) != EOF)
    {

        if ( !( strcmp(ca_channel, "LS0") ) )
         s_channel = US_LS0_BEARER_CHANNEL;
        else if ( !( strcmp(ca_channel, "LS1") ) )
         s_channel = US_LS1_BEARER_CHANNEL;
        else if ( !( strcmp(ca_channel, "LS2") ) )
         s_channel = US_LS2_BEARER_CHANNEL;
        else
        {
            fprintf(stdout, "Illegal bearer channel in TX configuration file, choose from:\nLS0 LS1 LS2\n");
         return((int16)FAIL);
        }


        fscanf(Tx_infid, "%s", ca_filename);

        if ( (TxInFilePtrs[s_channel] = fopen(SetInputDir(ca_filename), "rb")) == NULL)
        {
         fprintf(stdout, "Cannot open Tx input file %s\n", SetInputDir(ca_filename));
         return((int16)FAIL);
      }
    }

    return((int16)SUCCEED);

}

/*****************************************************************************
;  Prototype: int16 OpenRX_Files()
;
;  This subroutine reads the RX configuration, determining which bearer
;   channels are active and associating the indicated RX output data file
;   with that bearer channel;
;
;  Input Arguments:
;       None
;
;  Output Arguments:
;       None
;
;   Return:
;       FAIL -- any errors were encounterd during configuration
;       PASS -- no errors encountered
;
;  Global Variables:
;
;
;****************************************************************************/
int16 OpenRX_Files()
{

    int8 ca_channel[50];
    int8 ca_filename[50];
    int16 s_channel;

    while(fscanf(Rx_outfid,"%s", ca_channel) != EOF)
    {
        if ( !( strcmp(ca_channel, "AS0") ) )
         s_channel = DS_AS0_BEARER_CHANNEL;
        else if ( !( strcmp(ca_channel, "AS1") ) )
         s_channel = DS_AS1_BEARER_CHANNEL;
        else if ( !( strcmp(ca_channel, "AS2") ) )
         s_channel = DS_AS2_BEARER_CHANNEL;
        else if ( !( strcmp(ca_channel, "AS3") ) )
         s_channel = DS_AS3_BEARER_CHANNEL;
      else if ( !( strcmp(ca_channel, "LS0") ) )
         s_channel = DS_LS0_BEARER_CHANNEL;
        else if ( !( strcmp(ca_channel, "LS1") ) )
         s_channel = DS_LS1_BEARER_CHANNEL;
        else if ( !( strcmp(ca_channel, "LS2") ) )
         s_channel = DS_LS2_BEARER_CHANNEL;
        else
        {
            fprintf(stdout, "Illegal bearer channel in RX configuration file, choose from:\nAS0 AS1 AS2 AS3 LS0 LS1 LS2\n");
         return((int16)FAIL);
        }

        fscanf(Rx_outfid, "%s", ca_filename);

        if ( (RxOutFilePtrs[s_channel] = fopen(ca_filename, "wb")) == NULL)
        {
         fprintf(stdout, "Cannot open Rx output file %s\n", ca_filename);
         return((int16)FAIL);
      }
    }

    return((int16)SUCCEED);
}

#ifdef GDMT_DS_NUM_TONES

/*****************************************************************************
;  Prototype: int16 Update_Sync_Action_Counters()
;
;  This subroutine is used for testing the robbing/stuffing functions of the
;   modem.
;
;   Sync action reqests are simulated in the following manner:
;   Each bearer channel maintains a counter, gsa_SyncActionCount[i] (i is the
;   bearer channel number) which counts down to 0.  At this point a sync action
;   request is generated by incrementing gsa_SyncActionReq[i], and the counter
;   is reset to its initial value.  This initial value is stored in
;   gs_FramesPerSyncAction[i].
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;       gsa_FramesPerSyncAction[]   (I) Data frames required to generate one
;                                       sync action request
;       gsa_SyncActionCount[]       (I/O) Data frames remaining until the next
;                                         sync action request is generated
;       gsa_SyncActionReq[]         (I/O) Number of sync action requests that
;                                         are pending;
;
;****************************************************************************/
void Update_Sync_Action_Counters()
{
    int16 i;

    /* ==================================================================== */
    /*  Update sync action counters */
    /* ==================================================================== */
    for (i = 0; i < NUM_US_BEARER_CHANNELS; i++)
    {
        if (gsa_FramesPerSyncAction[i] != 0)
        {
            gsa_SyncActionCount[i]--;
            if (gsa_SyncActionCount[i] == 0)
            {
                gsa_SyncActionReq[i]++;
                gsa_SyncActionCount[i] = gsa_FramesPerSyncAction[i];
            }
        }
    }
}

/*****************************************************************************
;  Prototype: void Check_Sync_Action(FlagT ft_SyncAvailable_Flag,
;                                     US_FrameParms_t *pt_PathParms)
;
;  This subroutine checks to see if sync control action is allowed for this
;   frame, and if so then grants sync action to the highest priority channel
;   that is requesting sync action.
;
;  Input Arguments:
;       ft_SyncAvailable_Flag - used to test if sync action is allowed during
;                               this frame
;
;       pt_PathParms - pointer to path parameter structure
;
;  Output Arguments:
;       pt_PathParms - pointer to path parameter structure
;
;  Global Variables:
;       gsa_SyncActionReq[]         (I/O) Number of sync action requests that
;                                         are pending;
;
;****************************************************************************/
void Check_Sync_Action(FlagT ft_SyncAvailable_Flag, US_FrameParms_t *pt_PathParms)
{
    FlagT ft_LEX_sync;
    int16 s_sync_index;
    int16 i, s_numBearerChannel;

    /* ==================================================================== */
    /*  set bytes to transmit during this frame */
    /* ==================================================================== */
    for (i = 0; i < NUM_US_BEARER_CHANNELS; i++)
    {
        pt_PathParms->sa_B_out[i] = pt_PathParms->sa_B_alloc[i];
      for(s_numBearerChannel = 0; s_numBearerChannel < NUM_BEARER_CHANNELS; s_numBearerChannel++)
      {
         if( (gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LSX == i) &&
            (gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LPath == pt_PathParms->s_PathType) ) {
            gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_BytesOut = pt_PathParms->sa_B_out[i];
            break;
         }
      }
    }

    /* ==================================================================== */
    /* If sync action is permitted on this latency path during this frame  */
    /* then perform on requesting bearer channel with highest sync action  */
    /* priority,  otherwise perfrom no sync action */
    /* ==================================================================== */
    if (ft_SyncAvailable_Flag != SYNC_ALLOWED)
    {
        return;
    }

    /* perform sync action on requesting bearer channel with */
    /* highest sync action priority */
    ft_LEX_sync = 0;

    for (i = 0; i < NUM_US_BEARER_CHANNELS; i++)
    {
        s_sync_index = gsa_sync_priority[i];
        if (gsa_SyncActionReq[s_sync_index] == 0)
        {
            /*  no sync action is being requested by this bearer channel, */
            /*  continue with the next bearer channel */
            continue;
        }

        if (pt_PathParms->sa_B_alloc[s_sync_index] != 0)
        {
         /* channel being examined is an LSX channel, grant LEX */
         /* sync action only if not already been granted to another channel */
         if (ft_LEX_sync == 0)
         {
            ft_LEX_sync = 1;    /*  grant sync action to this channel */
            if (gsa_SyncActionType[s_sync_index] == STUFF)
               pt_PathParms->sa_B_out[s_sync_index]--;
            else
               pt_PathParms->sa_B_out[s_sync_index]++;
         /*  decrement request counter since sync action has been granted */
            gsa_SyncActionReq[s_sync_index]--;
         }
      }
      else if ((s_sync_index == US_LS0_BEARER_CHANNEL) &&
                (pt_PathParms->Ft_C_Chan_Enabled == TRUE))
      {
         /*  perform sync action for 'C' channel */
         if (ft_LEX_sync == 0)
         {
            ft_LEX_sync = 1;    /*  grant sync action to LS0 channel carrying 'C' channel */
            pt_PathParms->sa_B_out[s_sync_index] = 1;
            gsa_SyncActionReq[s_sync_index]--;
         }
      }
      for(s_numBearerChannel = 0; s_numBearerChannel < NUM_BEARER_CHANNELS; s_numBearerChannel++)
      {
         if( (gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LSX == s_sync_index) &&
            (gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_LPath == pt_PathParms->s_PathType) ) {
            gt_TxShowTimeVars.t_BCParms[s_numBearerChannel].sa_BC_BytesOut = pt_PathParms->sa_B_out[s_sync_index];
            break;
         }
      }
    }

}
#endif /* GDMT_DS_NUM_TONES */

/*****************************************************************************
;  Prototype: void Rx_Byte_StuffRob(uint8 uc_fciRxBSR, DS_BCParms_t *pt_BCParms)
;
;  This subroutine does byte stuffing and robbing
;
;  Input Arguments:
;       puc_fciRxBSR - specifies the value of byte stuff and rob signal from zephyr
;
;  Output Arguments:
;       pt_BCParms - pointer to BC parameter structure
;
;  Global Variables:
;
;****************************************************************************/
void Rx_Byte_StuffRob(uint8 uc_fciRxBSR, DS_BCParms_t *pt_BCParms)
{
   pt_BCParms->sa_BC_BytesIn = pt_BCParms->sa_BC_Bytes;

   if(gt_rx_config.s_FramingMode == FULL_ASYNC) /* g.dmt framing mode 0 */
   {
      switch(uc_fciRxBSR) {
      case 0:
         pt_BCParms->sa_BC_BytesIn += 2;
         break;
      case 1:
         pt_BCParms->sa_BC_BytesIn++;
         break;
      case 3:
         pt_BCParms->sa_BC_BytesIn--;
         break;
      }
   }
}

/*****************************************************************************
;  Prototype: int16 WriteOutputFiles(void)
;
;  This subroutine outputs RX data for current symbol period.
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;     SUCCEED
;
;  Global Variables:
;     RxOutFilePtrs[]      -- (I) Array of RX output file pointers
;       gs_TxOutSymbolCount -- (I/O) <= 0, pre-processing of TX data is not
;                                          complete, do not write TX samples
;****************************************************************************/
/* This variable is in the software engine */

int16 WriteOutputFiles(void)
{
    int16 i, j, s_LSxASx, s_bytes_in;
   uint16 us_fbxStartAddr;
    uint8 *puca_channel_data, *puca_RxFrameBuffer;

   /*  Due to one symbol buffer delay and any pre-processing of interleaved path data,  */
    /*  there is a delay before the first symbol is output if testing showtime alone */

   if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState)
    {

      if(gs_TxOutSymbolCount <= 0)
        {
         gs_TxOutSymbolCount++;
         goto _RxOut;
      }
   }

_RxOut:

   /* ========================================================================= */
   /* Write RX output data */
   /* ========================================================================= */
   puca_RxFrameBuffer = Get_RxFrameBuffer();
    for (i = 0; i < NUM_BEARER_CHANNELS; i++)
    {
      /* Get the effective number of bytes to be read from frame buffer */
      Rx_Byte_StuffRob(guca_fciRxBSR[i], &gt_RxShowTimeVars.t_BCParms[i]);
      s_bytes_in = gt_RxShowTimeVars.t_BCParms[i].sa_BC_BytesIn;

        if(s_bytes_in != 0)
        {
         /* Get start address of the BC in Rx frame buffer */
         GetBCRxFrameBufferStartAddr(i, &us_fbxStartAddr);

         /* Get the mapping for the bearer channel to the corresponding LSx/ASx channel */
         s_LSxASx = gt_RxShowTimeVars.t_BCParms[i].sa_BC_LSXASX;

         /* Get the corresponding LSx/ASx channel data buffer */
         puca_channel_data = gpucaa_RXChannel_OutBufs[s_LSxASx];

         /*  copy data from mux frame buffer */
         for (j = 0; j < s_bytes_in; j++)
         {
            puca_channel_data[j] = puca_RxFrameBuffer[us_fbxStartAddr+j];
         }

      #ifdef DO_BYTE_FLIP
         /*  Flip bits in each byte to emulate the case where  */
         /*  MSB enters V-C interface first     */
         ByteFlip(puca_channel_data, s_bytes_in);
      #endif /* DO_BYTE_FLIP */

         if (RxOutFilePtrs[s_LSxASx] == NULL)
         {
            if (AttachMPDLL() == FAIL)
            {
               gs_MpWinhostControl = 0;
               fprintf(stdout, "DS Bearer Channel %d not active\n", s_LSxASx);
            }
            continue;
         }
         fwrite(gpucaa_RXChannel_OutBufs[s_LSxASx], sizeof(uint8), s_bytes_in, RxOutFilePtrs[s_LSxASx]);
        }
   }
    return((int16)SUCCEED);
}

/*****************************************************************************
;  Prototype: void SaveRxCells(void)
;
;  This subroutine copies incoming ATM cells from Alphaeus' Rx cell buffer
;  to a file.
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
void SaveRxCells(void)
{
   uint16 us_CellPgFull, us_Clear = 0;
   uint8 i, j, uc_CellPgIdx, *puca_data;

   /* find active bearer channels */
   /* If exists, 'C' channel is assigned first */
   for(i=gus_numRxC_Channel, j=0; i<NUM_BEARER_CHANNELS; i++, j++) {

      for(; (j<NUM_DS_BEARER_CHANNELS) && (RxOutFilePtrs[j] == NULL); j++);
      if(j<NUM_DS_BEARER_CHANNELS){

         SetRxBC(i);
         uc_CellPgIdx = Read_RXPAGE();
         us_CellPgFull = Read_RX_PGFULL();

         while(us_CellPgFull & (1 << uc_CellPgIdx)) {
            // In DSP intercept mode, page RXPAGE is set ready for DSP access,
            if (Read_RXIFMODE(i) ==  DSP_INTERCEPT_MODE )
               SetRxPgReadyDSP(i, (uint16)(1 << uc_CellPgIdx));

            puca_data = (Get_RxCellPage(uc_CellPgIdx))->cell.uca_bytes;

            fwrite(puca_data, sizeof(uint8), ATM_CELL_SIZE, RxOutFilePtrs[j]);
            us_Clear |= (uint16) (1 << uc_CellPgIdx);
            us_CellPgFull &= ~us_Clear;
            uc_CellPgIdx++;
            if(uc_CellPgIdx == Read_RXCB_NPAGES(i))
               uc_CellPgIdx = 0;

            Write_RXCLEAR(i);
         }
      }
   }
}

/*****************************************************************************
;  Prototype: void LoadTxCells(void)
;
;  This subroutine copies outgoing ATM cells from a file to Alphaeus'
;  Tx cell buffer.
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;****************************************************************************/
void LoadTxCells(void)
{
   uint16 us_CellPgFull;
   uint8 i,j, uc_CellPgIdx, *puca_data;
   int16 s_bytes_avail;

   /* find active bearer channels */
   /* If exists, 'C' channel is assigned first */
   for(i=gus_numTxC_Channel, j=0; i<NUM_BEARER_CHANNELS; i++, j++) {

      for(; (j<NUM_US_BEARER_CHANNELS) && (TxInFilePtrs[j] == NULL); j++);
      if(j<NUM_US_BEARER_CHANNELS){

         SetTxBC(i);
         uc_CellPgIdx = Read_TXPAGE();
         us_CellPgFull = Read_TX_PGFULL();

         if(!(us_CellPgFull & (1 << uc_CellPgIdx))) {
            puca_data = (Get_TxCellPage(uc_CellPgIdx))->cell.uca_bytes;

            s_bytes_avail = (int16) fread(puca_data, sizeof(uint8), ATM_CELL_SIZE, TxInFilePtrs[j]);

            /*  if run out of data then stop */
            if (s_bytes_avail < ATM_CELL_SIZE)
               // If EOF reached, fill returned buffer with zeroes.
               memset( puca_data + s_bytes_avail, 0, ATM_CELL_SIZE - s_bytes_avail);

            Write_TXSEND(i);

            // In DSP intercept mode, DSP access page and modifies contents,
            // and reset TxPgReadyDSP to 0 (not ready for DSP access).
            if (Read_TXIFMODE(i) ==  DSP_INTERCEPT_MODE )
               ResetTxPgReadyDSP(i, (uint16)(1 << uc_CellPgIdx));
         }
      }
   }
}

/*****************************************************************************
;  Prototype: int16 WriteStrymonTxOutput(int16 s_Output)
;
;
;  Input Arguments: s_Output : Output of Interp3 filter in Strymon
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;  Dummy function, can be used to write strymon TX output to a file.
;****************************************************************************/

int16 WriteStrymonTxOutput(int16 s_Output)
{
   return(0);
}

/*****************************************************************************
;  Prototype: int16 WriteStrymonAECOutput(int16 s_Output)
;
;
;  Input Arguments: s_Output : Output of  Interp4 filter in Strymon
;
;  Output Arguments:
;
;  Return:
;
;  Global Variables:
;
;   Dummy function, can be used to write strymon AEC output to a file.
;****************************************************************************/

int16 WriteStrymonAECOutput(int16 s_Output)
{
   return(0);
}


