/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   modem_hw.C
 *
 *   Exec for Bit true models
 *
 *----------------------------------------------------------------------------
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "const.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "compiler.h"
#include "mtkernel.h"
#include "xgdata.h"
#include "ghs.h"
#include "pll.h"
#include "states.h"
#include "tx_ops.h"
#include "file_io3.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "fifo.h"
#include "file_io.h"
#include "bert.h"
#include "mp.h"
#include "cmv.h"
#include "stateini.h"

#include "cri.h"
#include "cri_cocomo_interface.h"
//#include "electra.h"
#include "strymon_cpe.h"
#include "strymon_cpe_typedef.h"
#include "iridia.h"
#include "Zephyr.h"
#include "alphaeus.h"
#include "alphaeus_typedef.h"
#include "dsp_op.h"
#include "file_io3.h"
#include "statein1.h"
#include "tx_ovrhd_bis.h"
#include "rx_ovrhd_bis.h"
#include "data_alloc.h"
#include "dli.h"
extern processDLI_t fnProcessDLI;

#define FFT_LEN_1024 1024

// Local functions

static void OutputIridiaTxSample(void);
static void InputIridiaRxSample(void);

/************************************************/
/* BM Input/Output structures             */
/************************************************/

CRI_Input_t gt_Cri_Input;
CRI_Output_t gt_Cri_Output;

StrymonCPE_Input_t gt_StrymonCPE_Input;
StrymonCPE_Output_t gt_StrymonCPE_Output = {(int16) 0, (int16) 0, (int16) 0,
(int16) 0, (int16) 0, (int16) 0,
(int16) 0, (int16) 0};

Iridia_Input_t gt_Iridia_Input;
Iridia_Output_t gt_Iridia_Output = {(uint8) 0, (uint8) 0, (uint8) 0,
(uint8) 0, (uint8) 0, (uint8) 0,
(uint8) 0, (uint8) 0, (uint8) 0,
(uint8) 0, (uint8) 0, (uint8) 0,
(uint8) 0, (uint8) 0, (uint8) 0,
(uint8) 0, (uint8) 0, (uint8) 0};

Zephyr_Input_t gt_Zephyr_Input;
Zephyr_Output_t gt_Zephyr_Output = {(uint8) 0, (uint8) 0, (uint8) 0,
(uint8) 0, (uint8) 0, (uint8) 0,
(uint8) 0, (uint8) 0, (uint8) 0,
(uint8) 0};

Alphaeus_Input_t gt_Alphaeus_Input;
Alphaeus_Output_t gt_Alphaeus_Output = {(uint8) 0, (uint8) 0, (uint8) 0,
(uint8) 0, (uint8) 0, (uint8) 0,
(uint8) 0};

//Electra_Input_t gt_Electra_Input;
//Electra_Output_t gt_Electra_Output;


/************************************************/
/*                                  */
/************************************************/


//#define DEBUG_TX      /* Debugs showtime Tx path */

int16 gs_AecDacSample;
int16 gs_AecDacSampleValid;   /* AEC DAC sample valid flag */

int16 gs_bypass_strymon = 0;

int16 gs_IridiaUpClockPeriod = 512;


#define STRYMON_CLOCK_PERIOD  (16)


   #define IRIDIA_DN_CLOCK_PERIOD_4416MHZ  (32)                  /* 4.416 MHz */
   #define IRIDIA_DN_CLOCK_PERIOD_2208MHZ  (64)          /* 2.208 MHz */


int16 gs_Interrupt_Detected=0;

int32 gl_RxFrameCnt, gl_TxFrameCnt;
int16 gs_rxFrameInt, gs_txFrameInt;
int16 gs_TmpRxInBufIndex;
int16 gs_TmpTxOutBufIndex;

int16 gsa_TmpRxInBuf[1300];

#ifndef IFFT128

      int16 gsa_TmpTxOutBuf[150];

#else
int16 gsa_TmpTxOutBuf[150];
#endif
int16 gs_upIndex;
int16 gs_sampleCnt;


   int16 gs_skipSampleCnt= 32;


int16 gs_RxSampleIndexLatch;
int16 gs_FirstTimeCounter;

int16 gsa_TxDtoABuf[TX_OUTBUF_FRAME_SIZE];            /*  output from TX filter (D/A input) */
int16 gsa_RxAtoDBuf[RX_ADCBUF_SIZE];               /*  input ADC buffer */

int16 gs_AtoD_PutPtr;            /* ADC buffer put pointer */
int16 gs_AtoD_GetPtr;                           /* ADC buffer get pointer */

void DownSampler(int16 *psa_inbuf, int16 *psa_outbuf, int16 s_length, int16 s_factor);

FlagT ft_GetTxFrame, ft_WriteRxFrame;
uint16 us_ZephyrReg_ZR_DMISC;
FlagT ZephyrRequiresTxDataFrame(void);




// !!debug

uint32 gl_TotalRxSampleCount = 0;



#include <conio.h>


/*-------------------------------------------------------------------
*
*  int Pause(void)
*
*  Description: For debugging purposes.  Stops the DSL cores (necessary) and allows
*  external debug reads and writes to be performed, dummy here
*
*-------------------------------------------------------------------
*^^^
*/
void Pause(int16 s_Marker)
{
}

/*****************************************************************************
;  Prototype: int16 InitModem_PreHandshake(void)
;
;  This subroutine initialize the modem variables based on the initial state
;  to start the modem.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return:
;     SUCCEED              - Initialization is done successfully
;     FAIL                 - Initialization fails
;
;****************************************************************************/

int16 InitModem_PreHandshake(void)
{
   KernelInit();

   InitGlobalVariables();     // These initializations have no dependence on CMV settings.

   InitModemTasks_PreHandshake();

   InitEngine();  // Rename this InitEngine_PreHandshake() ?
   Enable_MTEtoDFE_TxRx();

   return((int16)SUCCEED);
}

/*****************************************************************************
;  Prototype:  int16 DetectInterrupts(void)
;
;  This function detects interrupts generated by the ADSL cores.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return:
;     0     no interrupts detected
;     1     interrupt detected
;
;  Global Variables:
;     gs_InterruptMask
;     gt_Iridia_Output
;     guc_PREV_IR_RT_DONE
;     guc_PREV_IR_RFRAME
;     guc_PREV_IR_FDQ_DONE
;     guc_PREV_IR_RDT_DONE
;     guc_PREV_IR_TFRAME
;     guc_PREV_IR_TT_DONE
;
;****************************************************************************/
int16 DetectInterrupts(void)
{

   int16 s_CriAMask0;
   int16 s_CriAMask1;
   int16 s_CriMask2;

   int16 s_CriStatus0;
   int16 s_CriStatus1;
   int16 s_CriStatus2;

   /************************************************/
   /* Read CRI to get interrupt status and masks   */
   /************************************************/

   ReadCoreReg(CRI_AMASK0_ADDR, &s_CriAMask0);
   ReadCoreReg(CRI_AMASK1_ADDR, &s_CriAMask1);
   ReadCoreReg(CRI_MASK2_ADDR, &s_CriMask2);

   ReadCoreReg(CRI_STATUS0_ADDR, &s_CriStatus0);
   ReadCoreReg(CRI_STATUS1_ADDR, &s_CriStatus1);
   ReadCoreReg(CRI_STATUS2_ADDR, &s_CriStatus2);

   s_CriStatus0 = s_CriStatus0 & s_CriAMask0;
   s_CriStatus1 = s_CriStatus1 & s_CriAMask1;
   s_CriStatus2 = s_CriStatus2 & s_CriMask2;

   gs_InterruptMask = 0;

   /************************************************/
   /* MTE (Iridia) Rx Interrupts */
   /************************************************/

   /* Rx frame start interrupt. */
   if ( ((s_CriStatus0 & (1<<CRI_MTE_RFRAME_DONE)) != 0) ){

      gs_InterruptMask |= (int16) (1 << RX_FRAME_START);
      gs_rxFrameInt=1;

      /* clear interrupt */
      WriteCoreReg(CRI_STATUS0_ADDR,(uint16)(1 << CRI_MTE_RFRAME_DONE));
   }

   /* QAM done interrupt. */
   /* Note-- Process QAM done interrupt before FDQ done interrupt for showtime */
   /* L2 exit sequence detection assumes QAM done is processed before FDQ done */
   /* Also note-- unlike socrates for cocomo the actual ordering of detecting */
   /* interrupts here  dosent matter. We detect all recieved interrupts; the  */
   /* processing order is determined by MasterIntHandler                */
   if ( ((s_CriStatus0 & (1<<CRI_MTE_RCD_DONE)) != 0) ){

      gs_InterruptMask |= (int16) (1 << RX_QAM_DONE);
      gs_rxFrameInt=1;

      /* clear interrupt */
      WriteCoreReg(CRI_STATUS0_ADDR,(uint16)(1 << CRI_MTE_RCD_DONE));
   }

   /* FDQ done interrupt. */
   if ( ((s_CriStatus0 & (1<<CRI_MTE_FDQ_DONE)) != 0) ){

      gs_InterruptMask |= (int16) (1 << RX_FDQ_DONE);
      gs_rxFrameInt=1;

      /* clear interrupt */
      WriteCoreReg(CRI_STATUS0_ADDR,(uint16)(1 << CRI_MTE_FDQ_DONE));
   }

   /* FFT done interrupt. */
   if ( ((s_CriStatus0 & (1<<CRI_MTE_FFT_DONE)) != 0) ){

      gs_InterruptMask |= (int16) (1 << RX_FFT_DONE);
      gs_rxFrameInt=1;

      /* clear interrupt */
      WriteCoreReg(CRI_STATUS0_ADDR,(uint16)(1 << CRI_MTE_FFT_DONE));
   }

   /************************************************/
   /* MTE (Iridia) Tx Interrupts */
   /************************************************/

   /* Tx frame start interrupt. */
   if ( ((s_CriStatus1 & (1<<CRI_MTE_TFRAME_DONE)) != 0) ){

      gs_InterruptMask |= (int16) (1 << TX_FRAME_START);
      gs_txFrameInt=1;

      /* clear interrupt */
      WriteCoreReg(CRI_STATUS1_ADDR,(uint16)(1 << CRI_MTE_TFRAME_DONE));
   }

   /* Tx Data Xfer done interrupt.*/
   if ( ((s_CriStatus1 & (1<<CRI_MTE_TDT_DONE)) != 0) ){

      gs_InterruptMask |= (int16) (1 << TX_TDT_DONE);

      /* clear interrupt */
      WriteCoreReg(CRI_STATUS1_ADDR,(uint16)(1 << CRI_MTE_TDT_DONE));
   }

   /* IFFT done interrupt.*/
   if ( ((s_CriStatus1 & (1<<CRI_MTE_IFFT_DONE)) != 0) ){

      gs_InterruptMask |= (int16) (1 << TX_IFFT_DONE);
      gs_txFrameInt=1;

      /* clear interrupt */
      WriteCoreReg(CRI_STATUS1_ADDR,(uint16)(1 << CRI_MTE_IFFT_DONE));
   }

   /************************************************/
   /* AAI (Alphaeus) Rx Interrupts  */
   /************************************************/

   /* AAI Rx done interrupt. */
   if ( ((s_CriStatus0 & (1<<CRI_AAI_RX_DONE)) != 0) ){

      gs_InterruptMask |= (int16) (1 << RX_AAI_DONE);
      gs_rxFrameInt=1;

      /* clear interrupt */
      WriteCoreReg(CRI_STATUS0_ADDR,(uint16)(1 << CRI_AAI_RX_DONE));
   }



   return((int16) (gs_InterruptMask != 0));
}

/*****************************************************************************
;  Prototype:  void Setup_CriInputs(void)
;
;  This function sets up the inputs to the CRI clock
;  function.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return: none
;
;  Global Variables: gt_StrymonCPE_Input, gt_Iridia_Output
;
;****************************************************************************/
void Setup_CriInputs(void)
{

   // Clocks and Resets
   gt_Cri_Input.uc_dspRstn=(uint8)1;
   gt_Cri_Input.uc_dspClk=(uint8)0;

   if (guc_Iridia_Revision_Number >= IRIDIA_31) // need to read iridia revision number as there is no cri revision number.
   {
      gt_Cri_Input.uc_pll_freq_sel = (uint8)0;
   }
   else
   {
      // these two lines do not exist for 3.1 cri bm.
      gt_Cri_Input.uc_afeFreqSel=(uint8)0;
      gt_Cri_Input.uc_pllMult[4]=(uint8)0;
   }

   // Alphaeus Interface
   gt_Cri_Input.uc_aaiRxDone=gt_Alphaeus_Output.uc_aai_rx_done;
   gt_Cri_Input.uc_aaiTxDone=gt_Alphaeus_Output.uc_aai_tx_done;
   gt_Cri_Input.uc_aaiRxClkGate=(uint8)0;
   gt_Cri_Input.uc_aaiTxClkGate=(uint8)0;

   // Zephyr Interface
   gt_Cri_Input.uc_fciRxDone=gt_Zephyr_Output.uc_FCI_RX_DONE;
   gt_Cri_Input.uc_fciTxDone=gt_Zephyr_Output.uc_FCI_TX_DONE;
   gt_Cri_Input.uc_fciRxClkGate=(uint8)0;
   gt_Cri_Input.uc_fciTxClkGate=(uint8)0;

   // Iridia Interface
   gt_Cri_Input.uc_mteTPE=gt_Iridia_Output.uc_IR_TPE;
   gt_Cri_Input.uc_mteTFrame=gt_Iridia_Output.uc_IR_TFRAME;
   gt_Cri_Input.uc_mteIfftDone=gt_Iridia_Output.uc_IR_COMPLEX_IFFT_DONE;
   gt_Cri_Input.uc_mtePreDone=gt_Iridia_Output.uc_IR_PRE_IFFT_DONE;
   gt_Cri_Input.uc_mteTCeDone=gt_Iridia_Output.uc_IR_TCE_DONE;
   gt_Cri_Input.uc_mteTDtDone=gt_Iridia_Output.uc_IR_TDT_DONE;
   gt_Cri_Input.uc_mteTTDone=gt_Iridia_Output.uc_IR_TT_DONE;

   gt_Cri_Input.uc_mteRPE=gt_Iridia_Output.uc_IR_RPE;
   gt_Cri_Input.uc_mteRTDone=gt_Iridia_Output.uc_IR_RT_DONE;
   gt_Cri_Input.uc_mteRFrame=gt_Iridia_Output.uc_IR_RFRAME;
   gt_Cri_Input.uc_mteFftDone=gt_Iridia_Output.uc_IR_COMPLEX_FFT_DONE;
   gt_Cri_Input.uc_mtePstDone=gt_Iridia_Output.uc_IR_POST_FFT_DONE;
   gt_Cri_Input.uc_mteFdqDone=gt_Iridia_Output.uc_IR_FDQ_DONE;
#ifndef HWENGINE_30
   gt_Cri_Input.uc_mteRGsDone=gt_Iridia_Output.uc_IR_RGS_DONE;
#endif
   gt_Cri_Input.uc_mteRCdDone=gt_Iridia_Output.uc_IR_RCD_DONE;
   gt_Cri_Input.uc_mteRDtDone=gt_Iridia_Output.uc_IR_RDT_DONE;
   gt_Cri_Input.uc_mteRxClkGate=(uint8)0;
   gt_Cri_Input.uc_mteTxClkGate=(uint8)0;
   gt_Cri_Input.uc_mteRxLp0Error=gt_Iridia_Output.uc_IR_RXLP0_ERROR;
   gt_Cri_Input.uc_mteRxLp1Error=gt_Iridia_Output.uc_IR_RXLP1_ERROR;
   gt_Cri_Input.uc_mteTxLp0Error=gt_Iridia_Output.uc_IR_TXLP0_ERROR;
   gt_Cri_Input.uc_mteTxLp1Error=gt_Iridia_Output.uc_IR_TXLP1_ERROR;
   gt_Cri_Input.uc_mteRxBATError=gt_Iridia_Output.uc_IR_RXBAT_ERROR;
   gt_Cri_Input.uc_mteTxBATError=gt_Iridia_Output.uc_IR_TXBAT_ERROR;

   // Strymon Interface
   gt_Cri_Input.uc_fdfAecDone=(uint8)gt_StrymonCPE_Output.s_AECDONE;
   gt_Cri_Input.uc_fdfDecDone=(uint8)gt_StrymonCPE_Output.s_DECDONE;
   gt_Cri_Input.uc_fdfAfeBusy=(uint8)0;
   gt_Cri_Input.uc_fdfClkGate=(uint8)0;

   // Electra Interface
   gt_Cri_Input.uc_stmFrsInt=(uint8)0;
   gt_Cri_Input.uc_stmOvErrInt=(uint8)0;
   gt_Cri_Input.uc_stmRxDone=(uint8)0;//gt_Electra_Output.uc_stm_rx_done;
   gt_Cri_Input.uc_stmTxDone=(uint8)0;//gt_Electra_Output.uc_stm_tx_done;
   gt_Cri_Input.uc_stmClkGate=(uint8)0;

}
/*****************************************************************************
;  Prototype:  void Setup_StrymonCPEInputs(void)
;
;  This function sets up the inputs to the Strymon CPE clock
;  function.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return: none
;
;  Global Variables: gt_StrymonCPE_Input, gt_Iridia_Output
;
;****************************************************************************/
void Setup_StrymonCPEInputs(void)
{
   // Tx offset frame strobe for DEC updates.
   gt_StrymonCPE_Input.s_ITOFS = (int16) gt_Iridia_Output.uc_ITOFS;

   // Rx sync frame strobe for DEC updates.
   gt_StrymonCPE_Input.s_IRSFS = (int16) gt_Iridia_Output.uc_IRSFS;

   if (guc_Strymon_Revision_Number >= (uint8)STRYMON_32)
   {
      // Rx frame strobe for copying SR_VARGAIN (shadow) register contents to SR_AVARGAIN (active)
      gt_StrymonCPE_Input.s_IRFS = (int16) gt_Iridia_Output.uc_IRFS;

      // Rx frame strobe used to initiate capture of CP data for Rx windowing
      gt_StrymonCPE_Input.s_IRFS_RXWIN_CAPT = (int16) gt_Iridia_Output.uc_IRFS_RXWIN_CAPT;

      // Rx window strobe used to apply Rx windowing
      gt_StrymonCPE_Input.s_IRWS = (int16) gt_Iridia_Output.uc_IRWS;
   }


}

/*****************************************************************************
;  Prototype:  void Setup_ZephyrInputs(void)
;
;  This function sets up the inputs to the Zephyr CPE clock
;  function.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return: none
;
;  Global Variables: gt_Zephyr_Input, gt_Iridia_Output
;
;****************************************************************************/
void Setup_ZephyrInputs(void)
{
   gt_Zephyr_Input.uc_GO_FCI_RX = gt_Iridia_Output.uc_GO_FCI_RX;
   /* temporary - tie this to alphaeus go_stm_tx for now, since we are not integrating electra */
   gt_Zephyr_Input.uc_GO_FCI_TX = gt_Alphaeus_Output.uc_go_stm_tx;//gt_Electra_Output.uc_go_fci_tx;
}

/*****************************************************************************
;  Prototype:  void Setup_IridiaInputs(void)
;
;  This function sets up the inputs to the Iridia CPE clock
;  function.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return: none
;
;  Global Variables: gt_Zephyr_Output, gt_Iridia_Input
;
;****************************************************************************/
void Setup_IridiaInputs(void)
{
   gt_Iridia_Input.uc_GO_MTE_TX = gt_Zephyr_Output.uc_GO_MTE_TX;
}

/*****************************************************************************
;  Prototype:  void Setup_AlphaeusInputs(void)
;
;  This function sets up the inputs to the Alphaeus clock
;  function.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return: none
;
;  Global Variables: gt_Alphaeus_Input, gt_Iridia_Output, gt_Zephyr_Output
;
;****************************************************************************/
void Setup_AlphaeusInputs(void)
{
   gt_Alphaeus_Input.uc_go_aai_tx = gt_Iridia_Output.uc_GO_AAI_TX;
   /* temporary - tie this to zephyr go_stm_rx for now, since we are not integrating electra */
   gt_Alphaeus_Input.uc_go_aai_rx = gt_Zephyr_Output.uc_GO_STM_RX; //gt_Electra_Output.uc_go_aai_rx;

   // Set Alphaeus input Stuff and rob control signals to Zephyr output.
   gt_Alphaeus_Input.uca_fci_rx_bsr[0][0] = (gt_Zephyr_Output.uc_FCI_RX_BSR_BC0 & 0x01);
   gt_Alphaeus_Input.uca_fci_rx_bsr[0][1] = (gt_Zephyr_Output.uc_FCI_RX_BSR_BC0 & 0x02) >> 1;
   gt_Alphaeus_Input.uca_fci_rx_bsr[1][0] = (gt_Zephyr_Output.uc_FCI_RX_BSR_BC1 & 0x01);
   gt_Alphaeus_Input.uca_fci_rx_bsr[1][1] = (gt_Zephyr_Output.uc_FCI_RX_BSR_BC1 & 0x02) >> 1;
   gt_Alphaeus_Input.uca_fci_tx_bs[0] = gt_Zephyr_Output.uc_FCI_TX_BS_BC0;
   gt_Alphaeus_Input.uca_fci_tx_bs[1] = gt_Zephyr_Output.uc_FCI_TX_BS_BC1;
}

/*****************************************************************************
;  Prototype:  int16 RunCores(void)
;
;  This function runs the ADSL cores until an interrupt is generated.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return:
;     SUCCEED           - continue
;     FAIL           - stop/exit
;
;  Global Variables:
;     gt_StrymonCPE_Input
;     gt_StrymonCPE_Output
;     gt_Iridia_Input
;     gt_Iridia_Output
;     gt_Zephyr_Input
;     gt_Zephyr_Output
;     gt_AlphaeusDSPSignals
;     gt_AlphaeusFIFOSignals
;
;****************************************************************************/

int16 gs_Up_Sample_Clock=0, gs_Dn_Sample_Clock=0, gs_Strymon_Clock=0;

int16 gs_RxSampleIndex=0;
int16 gs_TxSampleIndex = 0;
static int16 s_ZeroSample=0;

#ifdef DEBUG_TX
FILE *fpout;
int16 gs_open_txfile=1;
#endif

int16 RunCores(void)
{


    int16 s_DataSample;

    int16 s_ReturnVal;
    static uint16 us_frame_index  = 0;

   uint16 us_zepstatus ;
   int16 s_IRIDIA_DN_CLOCK_PERIOD;

   /* init s_DataSample to avoid warning in bypass mode  */
   s_DataSample=0;

#ifdef DEBUG_TX
   if (gs_open_txfile == 1){
      gs_open_txfile = 0;
      fpout = fopen("ifftout","w");
   }
#endif

   if(gs_RxFftLength == FFT_LEN_1024)
      s_IRIDIA_DN_CLOCK_PERIOD = IRIDIA_DN_CLOCK_PERIOD_4416MHZ;
   else
      s_IRIDIA_DN_CLOCK_PERIOD = IRIDIA_DN_CLOCK_PERIOD_2208MHZ;

    if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState)
    {
      gft_TxDataPump_On = TRUE;
        gs_skipSampleCnt = 0;
    }
    else
    {
      if(gs_RxFftLength == FFT_LEN_1024)
         gs_skipSampleCnt = 64;
      else
         gs_skipSampleCnt = 32;
    }

   //==================================
   // Start of Master Clock loop
   //==================================

   while(!gs_Interrupt_Detected && !gs_EndOfRxInputData) {

      /************************************************/
      /* CLOCK CRI                           */
      /************************************************/

      CRI_Clock(&gt_Cri_Input, &gt_Cri_Output);

      /****************************************/
      /* CLOCK STRYMON (if not bypassed)     */
      /****************************************/

      if (gs_bypass_strymon == 0)
      {
         if (gt_Cri_Output.uc_fdfClk == 1){

            gs_Strymon_Clock++;
            gs_Dn_Sample_Clock++;
            gs_Up_Sample_Clock++;

            if(gs_Strymon_Clock == STRYMON_CLOCK_PERIOD) {

               gs_Strymon_Clock = 0;

               /* Clock Strymon. */
               StrymonCPE_8832kHzClock(&gt_StrymonCPE_Input, &gt_StrymonCPE_Output);

               /* Write to AEC output file. */
               if(gt_StrymonCPE_Output.s_AECOutputValid){
                  gs_AecDacSample = gt_StrymonCPE_Output.s_AECOutput;
                  gs_AecDacSampleValid = 1;
               }
               else
                  gs_AecDacSampleValid = 0;

               /* Write to Tx output file. */
               if(gt_StrymonCPE_Output.s_TxOutputValid)
                  WriteAnOutputSample(gt_StrymonCPE_Output.s_TxOutput);

               /* Write to Iridia's FFT buffer. */
               if(gt_StrymonCPE_Output.s_RxOutputValid){
                  IRI_Rx_WriteInputDataSample(gt_StrymonCPE_Output.s_RxOutput);
               }

            }
         }
      }
      else
      {
         gs_Strymon_Clock++;
         gs_Dn_Sample_Clock++;
         gs_Up_Sample_Clock++;
      }



      /************************************************/
      /* CLOCK IRIDIA                           */
      /************************************************/

      /****************************************************************************/
      /* TFRAME and RFRAME strobe to Iridia for generation of  TxSymbolUpdate and   */
      /* RxSymbolUpdate signal has a width of   one DSP clock cycle and not one     */
      /* Iridia clock cycle. This is achieved by making the TFRAME and RFRAME    */
      /* strobes low (0) in IRI_ClockSampledRegisters function which is called   */
      /* every DSP clock cycle.                                      */
      /* CAVEAT: This implies that IRI_ClockSampledRegisters should be called    */
      /* after CRI_Clock has been called. Calling IRI_ClockSampledRegisters after   */
      /* IRI_Clock() and before CRI_Clock() would result in CRI never receiving  */
      /* the TFRAME and RFRAME strobes                               */
      /****************************************************************************/
      gt_Iridia_Input.uc_CRI_RXSYM_UPDATE = gt_Cri_Output.uc_criRxSymUpdate;
      gt_Iridia_Input.uc_CRI_TXSYM_UPDATE = gt_Cri_Output.uc_criTxSymUpdate;
      IRI_ClockSampledRegisters(&gt_Iridia_Input, &gt_Iridia_Output);

      if (gt_Cri_Output.uc_mteRxClk == 1){

         IRI_Clock(&gt_Iridia_Input, &gt_Iridia_Output);

         // Currently all interrupts are from Iridia.
         if(gt_Cri_Output.uc_acAggrInt) {
            gs_Interrupt_Detected = DetectInterrupts();
         }
      }

      /************************************************/
      /* CLOCK ZEPHYR                           */
      /************************************************/

      if (gt_Cri_Output.uc_fciRxClk == 1){

         //=====================
         // Clock Zephyr
         //=====================

         if ( (TESTArray[TEST_Control] & TEST_AlphaeusControl) == 0){
            // Check whether Zephyr needs Tx data, and if so read a frame from
            // an input file.

            if (gt_Zephyr_Input.uc_GO_FCI_TX == 1) {        // If GO signal

               ft_GetTxFrame = ZephyrRequiresTxDataFrame();

               if (ft_GetTxFrame == 1) {  // If Zephyr Tx framer enabled.
                  if(ReadTxInputFile() == FAIL) // Read next frame of Tx data from file.
                     return(FAIL);
               }
            }

            /* New BERT code */

            /* Check whether all BERT TX frames have been generated */

            if ((TESTArray[TEST_Control] & TEST_BertControl) != 0)
            {
               ReadCoreReg(ZEP_REG_ZT_LINE_ADDR, &us_zepstatus);
               if ((us_zepstatus & 0x0018) == 0x0018)
                  if (((TESTArray[TEST_Control] & TEST_BertSFControl) != 0) &&
                     (gl_TxSymbolCount > (gs_bert_sf_cnt*69)))
                  {
                     fprintf(stdout, "all BERT TX frames generated\n");
                     return(FAIL);
                  }
            }
         }


         ZEP_Clock(&gt_Zephyr_Input, &gt_Zephyr_Output);


         if ( (TESTArray[TEST_Control] & TEST_AlphaeusControl) == 0){
            /* If Zephyr Rx processing done, write the Zephyr Rx output to a file */
            if (gt_Zephyr_Output.uc_FCI_RX_DONE == 1)
            {
               /* determine if it is a sync frame by reading the Zephyr core. We cannot use the global */
               /* variable gs_MuxFrameCntRxFastPath to check for sync frame as this variable does not */
               /* get updated in time for sync frame. So, the counter stays at value 67 for two zephyr Rx processing cycles */
               /* The reason is as follows: During the sync frame, when iridia RX is set in the register mode */
               /* we also set the sync frame start bit in IR_MODE register, which causes the GO_FCI_RX signal */
               /* to be generated at the Rx Frame Strobe which comes before Iridia's FDQ_DONE interrupt. So */
               /* we enter this function twice before updating the counter gs_MuxFrameCntRxFastPath to 68. */
               /* We do not want to print the contents of RxFrameBuffer during sync frame (i.e) when gs_MuxFrameCntRxFastPath==67 */
               /* AND we enter this function the second time. Instead of checking this, we read the ZR_DMISC register */
               /* to determine if it is a sync frame */

               uint16 us_data;
               FlagT ft_AlphaeusRxEnabled;

               ReadCoreReg(A_CFG_ADDR, &us_data);
               ft_AlphaeusRxEnabled = (uint8)((us_data & (1<<13)) >> 13);

               /* In the absence of Alphaeus, to convey to the DSP of byte stuffing/robbing */
               guca_fciRxBSR[0] = gt_Zephyr_Output.uc_FCI_RX_BSR_BC0;
               guca_fciRxBSR[1] = gt_Zephyr_Output.uc_FCI_RX_BSR_BC1;

               if (ft_AlphaeusRxEnabled == 1)
                  WriteOutputFiles();
            }
            if (gt_Zephyr_Output.uc_FCI_TX_DONE == 1)
            {
               /* In the absence of Alphaeus, to convey to the DSP of byte stuffing */
               guca_fciTxBS[0] = gt_Zephyr_Output.uc_FCI_TX_BS_BC0;
               guca_fciTxBS[1] = gt_Zephyr_Output.uc_FCI_TX_BS_BC1;
            }
         }
      }  /* END if (gt_Cri_Output.uc_fciRxClk == 1) */


      /************************************************/
      /* CLOCK ALPHAEUS                      */
      /************************************************/

      if (gt_Cri_Output.uc_aaiRxClk == 1){

         //=====================
         // Clock Alphaeus
         //=====================

         if ( (TESTArray[TEST_Control] & TEST_AlphaeusControl) != 0){
            /* Write data to Tx cell buffer. */
            if(!(gt_Alphaeus_Output.uc_aai_tx_on))
               LoadTxCells();

            /* Exit if all the TX frames have been transmited */
            if (((TESTArray[TEST_Control] & TEST_BertSFControl) != 0) &&
               (gl_TxSymbolCount > (gs_bert_sf_cnt*69)))
            {
                  fprintf(stdout, "all TX frames have been transmited\n");
                  return(FAIL);
            }
         }
         /* Clock Alphaeus. */
         Alphaeus_Clock(&gt_Alphaeus_Input, &gt_Alphaeus_Output);

         if ( (TESTArray[TEST_Control] & TEST_AlphaeusControl) != 0){
            /* Read data from Rx cell buffer. */
            if(gt_Alphaeus_Output.uc_aai_rx_done)
               SaveRxCells();
         }

      } /* END if (gt_Cri_Output.uc_aaiRxClk == 1) */


      /********************************/
      /* if strymon is being bypassed  */
      /********************************/

      if (gs_bypass_strymon == 1)
      {

         // For Sachmo, check for Tx samples to be written before
         // checking for Rx samples to be read in order to meet the
         // channel's causality requirement.
         // Existing code had checked for Rx samples first.  There
         // may be no functional difference in checking for one before
         // the other, but until this is confirmed we handle the Sachmo
         // connectivity case separately and leave the file I/O and
         // DLI-connectivity cases unchanged. (T.Tsakiris).

         if ((TESTArray[TEST_Control] & TEST_ConnControl) &&
            ((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) != 0) &&
            ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0))
         {  // Sachmo-based connectivity

            if (gs_Up_Sample_Clock == gs_IridiaUpClockPeriod)
               OutputIridiaTxSample();

            if (gs_Dn_Sample_Clock == s_IRIDIA_DN_CLOCK_PERIOD)
               InputIridiaRxSample();
         }

         else { // DLI or Sample-based DLI connectivity

            if (gs_Dn_Sample_Clock == s_IRIDIA_DN_CLOCK_PERIOD)
               InputIridiaRxSample();

            if (gs_Up_Sample_Clock == gs_IridiaUpClockPeriod)
               OutputIridiaTxSample();
         }

      } /* if(gs_bypass_strymon == 1) */

      /********************************/
      /* end strymon bypass section */
      /********************************/

      //================================================
      // Set up inputs to cores for next clock cycle.
      // Order of these should not matter.
      //================================================

      // CRI inputs
      Setup_CriInputs();

      // Strymon inputs
      Setup_StrymonCPEInputs();

      // Iridia inputs
      Setup_IridiaInputs();

      // Zephyr inputs
      Setup_ZephyrInputs();

      // Alphaeus inputs
      Setup_AlphaeusInputs();

    } /* end while(!gs_Interrupt_Detected && !gs_EndOfRxInputData) */


   //==================================
   // End of Master Clock loop
   //==================================

   if (gs_rxFrameInt == 1){
      gs_RxSampleIndexLatch = gs_RxSampleIndex;
      gs_RxSampleIndex = 0;
        gs_rxFrameInt = 0;
      gl_RxFrameCnt++;
      gs_TmpRxInBufIndex = 0;

   }
   if (gs_txFrameInt == 1){

#ifdef DEBUG_TX
      gs_open_txfile = 1;
      fclose(fpout);
#endif

      //================================================================================
      // Start: Section needed for DLI connectivity (not needed for Sachmo connectivity)
      //================================================================================

      if ((TESTArray[TEST_Control] & TEST_ConnControl) &&
         ((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0) &&
         ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0))
         // For DLI connectivity only:
      {
         /* copy the samples into shared memory */
            if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState)
            {

            if (!(OPTNArray[OPTN_ModeControl] & (OPTN_ConfigMode_G992_1_B | OPTN_ConfigMode_G992_3_B)))
            {

               if ((gs_TxFftLength == 128))
               {
               /* Down sample by 2 (Downsampler in SWE has a gain of 2) */
               DownSampler(gsa_TmpTxOutBuf,gsa_TmpTxOutBuf,gs_TmpTxOutBufIndex, 2);
               gs_TmpTxOutBufIndex >>= 1;
               }

               if(gl_TxFrameCnt >= R_PRE_SHOWTIME_LEN)
               {
               if(!DliHandler(gsa_TmpTxOutBuf, gs_TmpTxOutBufIndex, gs_Tx_OutBuf_Size, &gft_ResetDmaPtr))
                  return(FAIL);
               }
            }
            else
            {
            if(gl_TxFrameCnt >= R_PRE_SHOWTIME_LEN)
               {
               if(!DliHandler(gsa_TmpTxOutBuf, gs_TmpTxOutBufIndex, gs_Tx_OutBuf_Size, &gft_ResetDmaPtr))
                  return(FAIL);
               }
            }
         }
            else
            {
            if(!DliHandler(gsa_TmpTxOutBuf, gs_TmpTxOutBufIndex, gs_Tx_OutBuf_Size, &gft_ResetDmaPtr))
               return(FAIL);
            }
         /* Tx_OutBuf_Size has to track the no of samples output by Iridia
         (gs_TmpTxOutBufIndex). The variable gs_FirstTimeCounter is to allow
         Iridia signals to get latched first few frames so the gs_TmpTxOutBufIndex has the
         right no. Right now gs_FirstTimeCounter is initialized to 4 */
         if (gs_FirstTimeCounter == 0){
            gs_Tx_OutBuf_Size = gs_TmpTxOutBufIndex;
         }
         else
         {
            gs_FirstTimeCounter--;
         }
      }
      //================================================================================
      // End: Section needed for DLI connectivity (not needed for Sachmo connectivity)
      //================================================================================

      if(((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) != 0) ||
         ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0))   // if not Sample-based DLI
         gs_TmpTxOutBufIndex = 0;
      gs_upIndex = 0;
      gs_txFrameInt = 0;
      gl_TxFrameCnt++;
   }
   gs_Interrupt_Detected = 0;    // Reset interrupt indicator.

   if(gs_EndOfRxInputData)
      s_ReturnVal = FAIL;
   else
      s_ReturnVal = SUCCEED;
   return (s_ReturnVal);
}


static void OutputIridiaTxSample(void)
{
   int16 s_DataSample;
   int16 DliRxBuffer[256];

            gs_Up_Sample_Clock = 0;

            IRI_Tx_GetOutputDataSample(&s_DataSample);
            gs_TxSampleIndex++; //!!! crashes at 8388
            if (gs_TxSampleIndex == 8384)
               gs_TxSampleIndex += gs_Up_Sample_Clock;
            /* mod 100 is because the Tx buffer size is 100 */
            /*gsa_TmpTxOutBuf[(gs_TmpTxOutBufIndex++)%100] = s_DataSample;*/
            gsa_TmpTxOutBuf[gs_TmpTxOutBufIndex++] = s_DataSample;

            if((TESTArray[TEST_Control] & TEST_ConnControl) &&
               ((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0) &&
               ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) != 0))
            {  // Sample-based DLI connectivity
               if((gs_TxFftLength == 128) && (gs_TmpTxOutBufIndex == 8) ||
                  (gs_TxFftLength == 64) && (gs_TmpTxOutBufIndex == 4))
               {
                  if(gs_TxFftLength == 128)
                     DownSampler(gsa_TmpTxOutBuf, gsa_TmpTxOutBuf, gs_TmpTxOutBufIndex, 2);

                  if(fnProcessDLI(gsa_TmpTxOutBuf, 4, DliRxBuffer) != 0)
                     gs_EndOfRxInputData = 1;

                  if(gs_AtoD_PutPtr < RX_ADCBUF_SIZE - (gs_RxFftLength >> 4))
                  {
                     memcpy(&gsa_RxAtoDBuf[gs_AtoD_PutPtr], DliRxBuffer, (gs_RxFftLength >> 4)*sizeof(int16));
                     gs_AtoD_PutPtr += (gs_RxFftLength >> 4);
                  }
                  else
                  {
                     memcpy(&gsa_RxAtoDBuf[gs_AtoD_PutPtr], DliRxBuffer, (RX_ADCBUF_SIZE - gs_AtoD_PutPtr)*sizeof(int16));
                     memcpy(&gsa_RxAtoDBuf[0], &DliRxBuffer[RX_ADCBUF_SIZE - gs_AtoD_PutPtr], ((gs_RxFftLength >> 4) - (RX_ADCBUF_SIZE - gs_AtoD_PutPtr))*sizeof(int16));
                     gs_AtoD_PutPtr = ((gs_RxFftLength >> 4) - (RX_ADCBUF_SIZE - gs_AtoD_PutPtr));
                  }

                  gs_TmpTxOutBufIndex = 0;
               }
            }

            if ( !(TESTArray[TEST_Control] & TEST_ConnControl) ||
               ((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) != 0)   )
            {
               /* if it is DLI or Sample-based DLI mode, then the TmpTxOutBuf is used to copy into
               dli shared memory */
               WriteAnOutputSample((int16) (s_DataSample));
            }
#ifdef DEBUG_TX
            fprintf(fpout,"%d\n",s_DataSample);
#endif
            gs_upIndex++;

}


static void InputIridiaRxSample(void)
{
   int16 s_DataSample;

            gs_Dn_Sample_Clock = 0;

            if (s_ZeroSample == 0){
               if (gs_sampleCnt < gs_skipSampleCnt){
                  gs_sampleCnt++;
                  s_DataSample = 0;
               }
               else{
                  if ( ReadAnInputSample(&s_DataSample) == FAIL){
                     // Ran out of Rx input data. Set flag to end simulation
                     // but finish processing for this clock cycle.
                     gs_EndOfRxInputData = 1;
                  }
               }

               IRI_Rx_WriteInputDataSample(s_DataSample);

               gs_RxSampleIndex++;
               gl_TotalRxSampleCount++;      // Useful for debugging.

               gsa_TmpRxInBuf[(gs_TmpRxInBufIndex++)%gs_RxFftLength] = s_DataSample;

               if (TESTArray[TEST_Control] & TEST_UpsampleControl){
                  s_ZeroSample = 1; /* insert 0 samples */
               }
            }
            else{
               IRI_Rx_WriteInputDataSample(0);  /* write one more sample for lite */
               s_ZeroSample = 0;
            }
}






/*****************************************************************************
;  Prototype:  int16 RunModem(void)
;
;  This subroutine is called to service interrupts (time-critical and
;  non-time-critical tasks) and to run background tasks. The state
;  machine is run as a non-time-critical task. Background tasks are
;  initiated by the state machine.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return:
;     SUCCEED           - continue
;     FAIL           - stop/exit
;
;  Global Variables:
;     gs_RxState        - (I) current RX state
;     gs_RxDoneState    - (I) RX done state
;     gs_RxStopState    - (I) TX stop state
;     gs_RxNextState    - (I) RX next state
;     gs_TxState        - (I) current TX state
;     gs_TxDoneState    - (I) TX done state
;     gs_TxStopState    - (I) TX stop state
;     gs_RxNextState    - (I) TX next state
;
;****************************************************************************/
int16 RunModem(void)
{
   void (*BGTask)(void);

   /* ================================================================================ */
   /* Service interrupts and run state machine.                            */
   /* ================================================================================ */
   MasterIntHandler();

   /* =============================================================================== */
   /*  if processing is done, break */
   /* =============================================================================== */
   if ((gs_TxState == gs_TxDoneState) && (gs_RxState == gs_RxDoneState)) {
      fprintf(stderr, "processing halted (RX and TX done state)\n");
      return((int16)FAIL);
   }

   /* =============================================================================== */
   /*  check for any failures  */
   /* (Warning: this check should be commented out if it is desired to */
   /* make the program truely stops at stop state) */
   /* =============================================================================== */
   if ( (gs_RxNextState == gs_RxStopState) || (gs_TxNextState == gs_TxStopState) ) {
      fprintf(stderr, "processing halted (RX or TX stop state)\n");
      return((int16)FAIL);
   }

   /* =============================================================================== */
   /*  BackgroundTask processing */
   /* =============================================================================== */

   /* If there are pending Background processes, run them here */
   while(RemoveFunctionFromBkgdFifo(gp_BGTaskFifo , &BGTask))
      (BGTask)();

   if(gft_ModemType == G_DMT_BIS)
   {
      /* Process the overhead byte to be transmitted here */
      if (gs_TxState == 47)
         TxHDLCProcessor();

      /* Process the received overhead byte here */
      if (gs_RxState == 94)
         RxHDLCProcessor();
   }

   return((int16)SUCCEED);

}


#define FASTPATH 0
#define INTLVPATH 1
FlagT ZephyrRequiresTxDataFrame(void)
{
   uint16 us_data;
   uint8 uc_TxFastEnabled, uc_TxIntlvEnabled;
   FlagT ft_FrameNeeded;

   ReadCoreReg(ZEP_REG_ZT_LINE_ADDR, &us_data);
   uc_TxFastEnabled = ((us_data & (1 << 12)) != 0); //(uint8)(us_data & (1<<12));
   uc_TxIntlvEnabled = ((us_data & (1 << 11)) != 0); //(uint8)(us_data & (1<<11));

   if ( (uc_TxFastEnabled != 0) || (uc_TxIntlvEnabled != 0) )
      ft_FrameNeeded = 1;
   else
      ft_FrameNeeded = 0;

   return(ft_FrameNeeded);
}

#undef FASTPATH
#undef INTLVPATH


/****************************************************************************
 ;
 ; Subroutine Name : void DownSampler()
 ;
 ; Abstract:  This function downsamples the input by s_factor.
 ;
 ;  Note: Downsampling can be done in place
 ;
  *****************************************************************************/
void DownSampler(int16 *psa_inbuf, int16 *psa_outbuf, int16 s_length, int16 s_factor)
{
   int16 i;

   for (i=0;i<(s_length/s_factor);i++)
      psa_outbuf[i] = psa_inbuf[i*s_factor];
}

#undef FFT_LEN_1024
