/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   modem_hw.C
 *
 *   Exec for Bit true models
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "mtkernel.h"
#include "LL_IOf.h"
#include "cri_memmap.h"

extern int16 gs_rxFrameInt, gs_txFrameInt;

/*****************************************************************************/
/* The following TCB_INDEX_xxx definitions specify the index         */
/* to index the Task Control Block (TCB) table.                   */
/*****************************************************************************/

#define NUMBER_OF_INTERRUPTS  18

/* TX interrupt mask constants */
#define TCB_INDEX_TX_FC_DONE               0
#define TCB_INDEX_TX_QT_DONE               1
#define TCB_INDEX_TX_QTP_DONE              2
#define TCB_INDEX_TX_FT_IFFT_DONE          3
#define TCB_INDEX_TX_FTB_FRAME_DONE        4
#define TCB_INDEX_TX_CRI_TIMER             5
#define TCB_INDEX_TX_TSC_INT               6
#define TCB_INDEX_TX_QT_TXBAT_ERROR        7

/* RX interrupt mask constants */
#define TCB_INDEX_RX_FTB_FRAME_DONE        8
#define TCB_INDEX_RX_FT_FFT_DONE           9
#define TCB_INDEX_RX_QTP_DONE              10
#define TCB_INDEX_RX_QT_DONE               11
#define TCB_INDEX_RX_FC_DONE               12
#define TCB_INDEX_RX_CRI_TIMER             13
#define TCB_INDEX_RX_TSC_INT               14
#define TCB_INDEX_RX_FC_NTR                15
#define TCB_INDEX_RX_QT_RXBAT_ERROR        16
#define TCB_INDEX_RX_FDF_DEC_DONE          17


/*****************************************************************************
;  Prototype:  int16 DetectInterrupts(void)
;
;  This function detects interrupts generated by the HW cores.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return:
;     0     no interrupts detected
;     1     interrupt detected
;
;  Global Variables:
;     gs_InterruptMask
;     gt_Iridia_Output
;
;****************************************************************************/
int16 DetectInterrupts(void)
{
   int32 l_CriStatus0;

    /************************************************/
   /* Read CRI to get interrupt status          */
   /************************************************/

   ReadCoreReg(CRI_STATUS0_ADDR, &l_CriStatus0);

   gs_InterruptMask = 0;

    /* detect interrupt */
   //Since we only enabled one interrupt, i.e., TSC_RX_INT,
   //we will only look for this interrupt and ignore all the others
   if(l_CriStatus0 & CRI_MASK_RX_TSC_INT)
   {
      //By doing this, we can share some code with soc/herc5.0 build
      gs_InterruptMask = (1<<RX_TSC_INT);

      //Clear this interrupt
      SetCoreReg(CRI_STATUS0_ADDR, CRI_MASK_RX_TSC_INT);
   }

#ifndef TARGET_HW
    //TX_FTB_FRAME and RX_FTB_FRAME are for cocomo test only
    //TSC_RX_INT is the only one that starts TX/RX TC TASK
    else if (l_CriStatus0 & CRI_MASK_TX_FTB_FRAME)
    {

        gs_InterruptMask = (1<< TX_FRAME_START);
        //tx frame boundary  for cocomo
        gs_txFrameInt =1;

        //Clear this interrupt
      SetCoreReg(CRI_STATUS0_ADDR, CRI_MASK_TX_FTB_FRAME);
    }
#endif

    else if (l_CriStatus0 & CRI_MASK_RX_FTB_FRAME)
    {

        gs_InterruptMask = (1<<RX_FRAME_START);
        //Clear this interrupt
      SetCoreReg(CRI_STATUS0_ADDR, CRI_MASK_RX_FTB_FRAME);
    }

   return((int16) (gs_InterruptMask != 0) || (gs_txFrameInt !=0) );
}
