/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf_FFT.C
 *
 *   Iridia CPE Data Transfer Layer.
 *
 *
 *----------------------------------------------------------------------------
 */
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "IRI_Iof.h"

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    LoadTxOutBuffer
 *
 * Prototype:
 *    LoadTxOutBuffer (int16 *ps_data, int s_ndata);
 *
 *  Abstract:
 *    LoadTxOutBuffer() -
 *
  *      Copies s_numtones data from ps_data to Tx IFFT buffer via Txactive buffer
 *
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *      gs_TxNumTones, gsa_TxToneBuf,
 *    gs_Tx_OutBuf_Size, gs_TxCPLength
 *------------------------------------------------------------------------
 */

#if 1
void LoadTxOutBuffer(int16 *ps_data, int16 s_ndata)
{

   uint32 uloffsetBytes;
    uint32* pusa_dci_toneBGT;
   uint16 *pus_AEGTN;
    uint16 us_min_dci, us_max_dci;
   uint16 us_real, us_imag, us_startTone;
    uint32 ul_data;
    uint16 s_numtones;
   int16 i;

    s_numtones = s_ndata>>1;
   us_startTone = 0;
    /*-------------------------------------------------------------------------
                 Non 35B mode                35B mode
                                 ----------------------------------------------
                           Tx_BGT                  Tx_EGT
    ---------------------------------------------------------------------------
   Start tone  DW0: Bits 0:11                   W0: Bits 3:15
   End tone DW0: Bits 16:27  DW0:Bits 15:27
   ---------------------------------------------------------------------------
   Tone0 Real  DW1: Bits 0:15    DW1:real[13:15]@12:14  W1:real[0:12]@3:15
   Tone0 Imag  DW1: Bits 16:31  DW1: Bits 15:30
   ---------------------------------------------------------------------------
   Tone1 Real  DW2: Bits 0:15    DW2:real[13:15]@12:14  W2:real[0:12]@3:15
   Tone1 Imag  DW2: Bits 16:31  DW2: Bits 15:30
   ---------------------------------------------------------------------------
   Tone2 Real  DW3: Bits 0:15   DW3:real[13:15]@12:14  W3:real[0:12]@3:15
   Tone2 Imag  DW3: Bits 16:31  DW3: Bits 15:30
    -------------------------------------------------------------------------*/
    uloffsetBytes = IRI_QT_RAM_TX_ACTIVE_EGT_SIZE>>1;  //in bytes
    pusa_dci_toneBGT = (uint32*)(void *)(&ghpuca_TxBat_Active[uloffsetBytes]);

    //calculate first location and data block offset
    //DCI uses the 2nd half of the tx active table
    //ul_dci_first_location = IRI_QT_RAM_TX_ACTIVE_BGTN_ADDR + (IRI_QT_RAM_TX_ACTIVE_EGT_SIZE >>3);
    //ul_dci_data_offset = ul_dci_first_location + 4;

    pusa_dci_toneBGT[0] = s_numtones << 15;
    pusa_dci_toneBGT++;

   pus_AEGTN = (uint16 *) (IRI_QT_RAM_TX_ACTIVE_EGT_ADDR + (uloffsetBytes>>1));
   pus_AEGTN[0] = us_startTone <<3; //start tone @bit3 to 15, here start tone is at 0
    pus_AEGTN++;

#if 1
   for (i=0; i<s_numtones; i++)
   {
      us_real = *ps_data++;
      us_imag = *ps_data++;
      *pusa_dci_toneBGT++ = (uint32)((us_imag << 15) | ((us_real & 0xE000) >> 1));
      *pus_AEGTN++ = (us_real & 0x1FFF) << 3;
   }
#else
   for (i=0; i<s_numtones; i++)
   {
      us_real = ps_data[0];
      us_imag = ps_data[1];

       pusa_dci_toneBGT[i] = (uint32)((us_imag << 15) | ((us_real & 0xE000) >> 1));
      ps_data += 2;
      pus_AEGTN[i] = (us_real & 0x1FFF) << 3;
   }
#endif
    //set the min and max addresses for DCI control registers and enable direct copy to IFFT
    //IRI_QT_REG_TX_DCI_CTRL
    us_min_dci = (IRI_QT_RAM_TX_ACTIVE_EGT_SIZE>>3);
    us_max_dci = us_min_dci + s_numtones;
   ul_data = ((uint32)(us_max_dci<<14) | (us_min_dci <<1) | (1<<0) );
   WriteCoreReg(IRI_QT_REG_TX_DCI_CTRL_ADDR, ul_data );
}
#else
void LoadTxOutBuffer(int16 *ps_data, int16 s_ndata)
{

    uint16* pusa_dci_toneindex;
    uint16* pusa_dci_tonevalue;
    uint16 us_min_dci, us_max_dci;
    uint32 ul_data;
    uint16 s_numtones;

    s_numtones = s_ndata/2;

    pusa_dci_toneindex = (uint16*)(void *)(&ghpuca_TxBat_Active[IRI_QT_RAM_TX_ACTIVE_EGT_SIZE/2]);
    pusa_dci_tonevalue = &(pusa_dci_toneindex[2]);

    //calculate first location and data block offset
    //DCI uses the 2nd half of the tx active table
    //ul_dci_first_location = IRI_QT_RAM_TX_ACTIVE_BGTN_ADDR + (IRI_QT_RAM_TX_ACTIVE_EGT_SIZE >>3);
    //ul_dci_data_offset = ul_dci_first_location + 4;

   // The first location will be the start and end tone of the band to be written
    pusa_dci_toneindex[0] = 0 ;
    pusa_dci_toneindex[1] = s_numtones;

   // The next (n-m+1) locations will be the real and imaginary values (in Q3.13 format) to write
   memcpy((uint8*)(void *)pusa_dci_tonevalue, (uint8*)(void *)ps_data, s_numtones*4);


    //set the min and max addresses for DCI control registers and enable direct copy to IFFT
    //IRI_QT_REG_TX_DCI_CTRL
    us_min_dci = (IRI_QT_RAM_TX_ACTIVE_EGT_SIZE>>3);
    us_max_dci = us_min_dci + s_numtones;
   ul_data = ((uint32)(us_max_dci<<14) | (us_min_dci <<1) | (1<<0) );
   WriteCoreReg(IRI_QT_REG_TX_DCI_CTRL_ADDR, ul_data );
}

#endif

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    GetTxOutBuffer
 *
 * Prototype:
 *    GetTxOutBuffer (int16 *ps_data, int ndata);
 *
 *  Abstract:
 *    GetTxOutBuffer() -
 *
  *      Copies "ndata" 16-bit data from Tx buffer to ps_data.
 *
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *      gs_TxFftLength, gsa_TxToneBuf,
 *    gs_Tx_OutBuf_Size, gs_TxCPLength
 *------------------------------------------------------------------------
 */
void GetTxOutBuffer(int16 *ps_data, int16 s_ndata)
{
//HW6.2 does not support reading out of ifft buffer
#ifdef VR9_FIXME
    int16 s_HalfSize;
   uint32 pul_IfftInputBuf, pul_IfftOutputBuf;

   s_HalfSize = s_ndata/2;
   WhichIFFTBuffers(&pul_IfftInputBuf, &pul_IfftOutputBuf);

   // Both time domain and freq domain signals are copied in the same way
   ReadCoreBuf32((uint16)pul_IfftInputBuf, ps_data, s_HalfSize);
#endif
}
/***************************************************************************************
;  Subroutine Name: GetIfftBufAddr
;
;  Description:
;     This function retrieves one of the IFFT buffer addresses for the following buffer:
;  TX_QT_BUF, TX_FT_BUF and TX_FDF.
;
;  Prototype:
;     void GetIfftBufAddr(uint32 *pul_addr, FlagT gft_WhichBuf)
;
;  Input Arguments:
;     pul_addr  -- pointer to the returned buffer address
;       gft_WhichBuf -- specify one of the IFFT buffers: TX_QT_BUF, TX_FT_BUF or TX_FDF
;
;  Output Arguments:
;
;  Return Value:
;     none
;
;  Global Variables:
;     none
;
;**********************************************************************************************/



   //Get the status bits





