/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf_FFT.C
 *
 *   Iridia CPE Data Transfer Layer.
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "IRI_Iof.h"


/***************************************************************************************
;  Subroutine Name: GetRxData
;
;  Description:
;     This routine copies the FFT buffer output from Iridia
;
;  Prototype:
;     void GetRxData(int16 *psa_buffer, int16 s_logicalBuffer, int16 s_offset, int16 s_numTones)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;
;   Substates:
;             None
;
;**********************************************************************************************/


C_SCOPE void GetRxData(int16 *psa_buffer, int16 s_logicalBuffer, int16 s_offset, int16 s_numTones)
{

    uint32 ul_addr;

   if (s_logicalBuffer == DD_GSRCD_LOGICAL_BUFFER) // RTV0 is configured to store Decision output
      ul_addr = (uint32)IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR;
   else // RTV1 is configured to store FDQ output
      ul_addr = (uint32)IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR + 512*4;

   ul_addr += (uint32)s_offset*4;

#ifdef TARGET_HW
   {
   uint32 ul_StartAddress,ul_EndOffset;
   mComputeHerculesOffsetAddress(ul_StartAddress, ul_addr);
   ul_EndOffset = (uint32)((s_numTones<< 2) - 2); // Each tone is a 4 byte addr increment= 2(Real/Imag)*2(word size)
   SetUpDMATransfer(ul_StartAddress, (ul_StartAddress + ul_EndOffset), (uint32) psa_buffer);
   }
#else
   {
   ReadCoreBuf32(ul_addr, psa_buffer, (uint16)s_numTones);
   }
#endif

}

