/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf_FFT_train.C
 *
 *   Iridia CPE Data Transfer Layer.
 *
 *
 *----------------------------------------------------------------------------
 */
// ******************************************************************
// IRI_IOf_FFT_train.c
//
// History
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
//
//
// 12/10/2015 Vinay: Added two more field to DSL 3 ( DSL 3 2 for real part and DSL 3 3 for imaginary part) to accomadate
//                   the mapping of pilot tone constellation for the pilot tone.
//            Grep: XDSLRTFW-214
// ******************************************************************
#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "IRI_Iof.h"
#include "mul.h"

//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
#ifdef HW_SNR_FDQ
extern int16 gsa_pilot_FDQ_coef[2];
extern uint8 guc_pilot_FDQ_exp;
#endif
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

/***************************************************************************************
;       Subroutine Name: GetRxTones
;
;       Description:
;               This routine copies the FFT buffer output from Iridia
;
;       Prototype:
;               void GetRxTones(int16 *psa_OutBuf, int16 s_FirstTone, int16 s_NumTones)
;
;       Input Arguments:
;
;       Output Arguments:
;               none
;
;       Return Value:
;               none
;
;       Global Variables:
;               gsa_RxToneBuf[] (O)      - DMT tones output from FDQ
;
;   Substates:
;             None
;
;**********************************************************************************************/
void GetRxTones(int16 *psa_OutBuf, int16 s_FirstTone, int16 s_NumTones)
{

        /* ===========================================================================  */
        /* if gft_CopyRxBuffer is FALSE, then do not load gsa_RxToneBuf                                 */
        /* ===========================================================================  */
        if (gft_CopyRxBuffer == FALSE)
        {
                return;
        }
        /* ===========================================================================  */
        /* if gft_CopyRxBuffer is TRUE, then load gsa_RxToneBuf with freq domain data   */
        /* ===========================================================================  */
    ReadCoreBuf32(IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR + (s_FirstTone<<2), psa_OutBuf, (uint16)s_NumTones );

}

#ifndef FD_ACCUM_FOR_FRAMEALIGN
/***************************************************************************************
;       Subroutine Name: GetRxTime
;
;       Description:
;               This routine copies the time domain signal from FFT buffer.
;
;       Prototype:
;               void GetRxTime(int16 *ps_data, int16 ndata)
;
;       Input Arguments:
;               ndata - Number of samples to read from the FFT buffer
;
;       Output Arguments:
;               ps_data - Pointer to a buffer in which to store the time-domain samples
;
;       Return Value:
;               none
;
;       Global Variables:
;
;   Substates:
;
;**********************************************************************************************/

void GetRxTime(int16 *ps_data, int16 s_ndata)
{

        /* ===========================================================================  */
        /* if gft_CopyRxBuffer is FALSE, then do not load gsa_RxToneBuf                                 */
        /* ===========================================================================  */
        if (gft_CopyRxBuffer == FALSE)
        {
                return;
        }
        /* ===========================================================================  */
        /* if gft_CopyRxBuffer is TRUE, then load gsa_RxToneBuf with time domain data   */
        /* ===========================================================================  */
    // read from fft output buffer which contains frequency domain data
     ReadFftBuffer(ps_data, 0, gs_RxFftLength/2, 1);
}
#endif

#ifdef USE_ENGINE_FOR_BG_FFTS
/***************************************************************************************
;       Subroutine Name: LoadFFTInput
;
;       Description:
;               This loading function copies a time domain signal to be transformed from the task layer to
;               Iridia's FFT buffer.
;
;       Prototype:
;               void LoadFFTInput(void)
;
;       Input Arguments:
;               None.
;
;       Output Arguments:
;               None.
;
;       Return Value:
;               none
;
;       Global Variables:
;       gs_EngineFFTSize - Specifies size of FFT. Equal to either 128 or 256.
;               gpsa_EngineFFTInput - Pointer to time-domain real-valued buffer of size 2*gs_FastFFTSize.
;
;   Substates:
;
;**********************************************************************************************/
#ifdef TARGET_HW
void LoadEngineFFTInput(void)
{
        uint32 ul_FftInputBuf;
        uint32 ul_FftOutputBuf;
        uint32 ul_StartAddress;
        int16 s_NumInputSamples ;

        if (gs_EngineFFTSize == 512) {  // Plus needs to load 4*num_tones
                s_NumInputSamples = 4*gs_EngineFFTSize ;
        }
        else {
                s_NumInputSamples = 2*gs_EngineFFTSize ;
        }

        WhichFFTBuffers(&ul_FftInputBuf, &ul_FftOutputBuf);
        mComputeHerculesOffsetAddress(ul_StartAddress, ul_FftInputBuf);

        SetUpDMATransfer((uint32) gpsa_EngineFFTInput,
                                        (uint32) &gpsa_EngineFFTInput[s_NumInputSamples-1],
                                        ul_StartAddress);
}
#else
void LoadEngineFFTInput(void)
{
        uint32 ul_FftInputBuf;  /* points to IRI_RAM_RX_FFT_A0 or IRI_RAM_RX_FFT_B0 */
        uint32 ul_FftOutputBuf; /* points to IRI_RAM_RX_FFT_A1 or IRI_RAM_RX_FFT_B1 */

        /* ===========================================================================  */
        /* if gft_CopyRxBuffer is TRUE, then load gsa_RxToneBuf with time domain data   */
        /* ===========================================================================  */

        WhichFFTBuffers(&ul_FftInputBuf, &ul_FftOutputBuf);

        if(gs_EngineFFTSize == 128) {
                WriteCoreBuf32LowHigh(ul_FftInputBuf, gpsa_EngineFFTInput, (int16)(2*gs_EngineFFTSize), 0);
                FillCoreBuf32LowHigh(ul_FftInputBuf, 0, gs_EngineFFTSize, 1);
        }
        else {  // Assumed that gs_EngineFFTSize == 256
                WriteCoreBuf32(ul_FftInputBuf, gpsa_EngineFFTInput, gs_EngineFFTSize);
        }
}
#endif

/***************************************************************************************
;       Subroutine Name: GetEngineFFTResult
;
;       Description:
;               This time-critical task copies the contents of the current FFT buffer to the
;               output buffer specified for the Fast FFT.  It is similar to GetRxTones() but is
;               especially for use in reading the results of the Fast FFT.
;
;       Prototype:
;               void GetEngineFFTResult(void)
;
;       Input Arguments:
;               None.
;
;       Output Arguments:
;               None.
;
;       Return Value:
;               none
;
;       Global Variables:
;       gs_EngineFFTSize - Specifies size of FFT. Equal to either 128 or 256.
;               gpsa_EngineFFTOutput - Pointer to buffer of size 2*gs_EngineFFTSize words.
;
;   Substates:
;
;**********************************************************************************************/
#ifdef TARGET_HW
void GetEngineFFTResult(void)
{
        uint32 ul_FftInputBuf;
        uint32 ul_FftOutputBuf;
        uint32 ul_StartAddress, ul_NumberOfBytes;

        WhichFFTBuffers(&ul_FftInputBuf, &ul_FftOutputBuf);
        mComputeHerculesOffsetAddress(ul_StartAddress, ul_FftOutputBuf);

        ul_NumberOfBytes = (2*gs_EngineFFTSize - 1) << 1;

        SetUpDMATransfer((uint32) ul_StartAddress,
                                        (uint32) (ul_StartAddress + ul_NumberOfBytes),
                                        (uint32) gpsa_EngineFFTOutput);
}
#else
void GetEngineFFTResult(void)
{
        uint32 ul_FftInputBuf;  /* points to IRI_RAM_RX_FFT_A0 or IRI_RAM_RX_FFT_B0 */
        uint32 ul_FftOutputBuf; /* points to IRI_RAM_RX_FFT_A1 or IRI_RAM_RX_FFT_B1 */
        int16 s_HalfSize;

        s_HalfSize = gs_EngineFFTSize;
        WhichFFTBuffers(&ul_FftInputBuf, &ul_FftOutputBuf);

        ReadCoreBuf32(ul_FftOutputBuf, gpsa_EngineFFTOutput, (uint16)s_HalfSize);
}
#endif  // TARGET_HW
#endif  // USE_ENGINE...


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : CopyTone
 *
 *  Description:  tone data is copied form RTV output
 *
 *  Prototype:  void CopyTone(int16 *ps_PilotToneBuf, int16 s_toneIndex)
 *
 *
 *  Input Arguments: None.
 *              s_toneIndex     :       Tone Index
 *
 *  Output Arguments:
 *      ps_PilotToneBuf:  two element array to store the pilot tone
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void CopyTone(int16 *buf, int16 s_toneIndex)
{
        uint32 ul_addr;
        // read from buffer which contains frequency domain data
        ul_addr = IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR + s_toneIndex *4;
        ReadCoreBuf32(ul_addr, (int16 *)(void *)&buf[0], (uint16)1);
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : CopyPilotTone
 *
 *  Description:
 *              (1). read real and ima part of pilot tone from IRI-QT register
 *      (2). run FW fdq on the pilot tone
 *  Prototype:  void CopyPilotTone(int16 *ps_PilotToneBuf, int16 s_toneIndex)
 *
 *
 *  Input Arguments: None.
 *              s_toneIndex     :       Tone Index
 *
 *  Output Arguments:
 *      ps_PilotToneBuf:  two element array to store the pilot tone
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void CopyPilotTone(int16 *psa_buffer, int16 s_toneIndex)
{


    uint32 ul_fft_pilot;
        int32 l_Acc_real=0, l_Acc_imag=0, l_temp;
        int16 s_pilot_real, s_pilot_imag;
        uint8 uc_pre_FDQ_exp;
        int16 sa_pre_FDQ_coef[2];

        //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
        #ifdef HW_SNR_FDQ
   WriteCoreReg(IRI_QT_REG_RX_PTINDEX_ADDR, (uint32)((s_toneIndex & 0x1FFF) | MASK_BIT13));
   #endif
        //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

        //IR_PILOT contains FFT data for Rx pilot
        ReadCoreReg(IRI_QT_REG_RX_PILOT_ADDR, &ul_fft_pilot);
        s_pilot_real = (int16)(ul_fft_pilot & 0xFFFF);
        s_pilot_imag = (int16)(ul_fft_pilot>>16) & 0xFFFF;

#ifdef PILOT_CAPTURE_518
    if (gul_518Pilot_Cnt > 9998)
    {
       gul_518Pilot_Cnt = 0;
    }
    gsa_518Pilot[gul_518Pilot_Cnt++] = s_pilot_real;
    gsa_518Pilot[gul_518Pilot_Cnt++] = s_pilot_imag;
#endif


        // XDSLRTFW-2419 (Start)
        gt_DS_StPilotDescriptorTable.usa_PilotTone_Constellation[0] = s_pilot_real;    // DSL 3 2
        gt_DS_StPilotDescriptorTable.usa_PilotTone_Constellation[1] = s_pilot_imag;    // DSL 3 3
        // XDSLRTFW-2419 (End)

        // read FDQ mantissa for pilot tone
        ReadCoreBuf32((uint32)(IRI_QT_RAM_FDQ_MANT_ADDR+4*s_toneIndex), sa_pre_FDQ_coef, 1);
  // read FDQ exponent for pilot tone
  ReadCoreBuf8((uint32)(IRI_QT_RAM_FDQ_EXP_ADDR + 4*s_toneIndex),(int8 *)(void *) &uc_pre_FDQ_exp, 1);

   //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
   #ifdef HW_SNR_FDQ
   if (gs_RxState == R_C_SHOWTIME_RX)
   {
      sa_pre_FDQ_coef[0] = gsa_pilot_FDQ_coef[0];
      sa_pre_FDQ_coef[1] = gsa_pilot_FDQ_coef[1];
      uc_pre_FDQ_exp = guc_pilot_FDQ_exp;
   }
   #endif
   //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

        // compute real part [pilot_re*fdq_re - pilot_im*fdq_im]
        MULS16(l_Acc_real, s_pilot_real, sa_pre_FDQ_coef[0]);
        MULS16(l_temp, s_pilot_imag, sa_pre_FDQ_coef[1]);
        l_Acc_real -= l_temp;

        // compute imag part [pilot_im*fdq_re + pilot_re*fdq_im]
        MULS16(l_Acc_imag, s_pilot_imag, sa_pre_FDQ_coef[0]);
        MULS16(l_temp, s_pilot_real, sa_pre_FDQ_coef[1]);
        l_Acc_imag += l_temp;

        //Convert result to Q(WORDLENGTH_SFDQ_OUT-FRAC_BITS_SFDQ_OUT).(FRAC_BITS_SFDQ_OUT) precision
        l_Acc_real = l_Acc_real >>(15 - uc_pre_FDQ_exp); //15=FRAC_BITS_SFDQ_INPUT+FRAC_BITS_SFDQ_MANT - FRAC_BITS_SFDQ_OUT
        l_Acc_imag = l_Acc_imag >>(15 - uc_pre_FDQ_exp);

        psa_buffer[0] = (int16)l_Acc_real;
  psa_buffer[1] = (int16)l_Acc_imag;

#if 0
        //use rtv1 to store fdq output, read the pilot tone from rtv1 to direct PLL
        ul_addr = (uint32)IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR + 512*4;
        ul_addr += (uint32)s_toneIndex*4;
        ReadCoreBuf32(ul_addr, psa_buffer, 1);
#endif

}


#ifdef HW_SNR_FDQ
/*
*-------------------------------------------------------------------------------
*
*       Prototype: void ResetNoisePowerBuffer(void)
*
*       This clears the RTV accumulator buffer
*
*       Input Arguments:
*
*       Output Arguments:
*
*       Returns:
*
*       Global Variables:
*
*-------------------------------------------------------------------------------
*/
// For Noise Power
void ResetNoisePowerBuffer(void)
{

        FillCoreBuf32((uint32)(IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR), (int32)0, (uint16)gs_RxNumTones);
        FillCoreBuf32((uint32)(IRI_QT_RAM_RX_NOISE_ACCMR_MSW_ADDR), (int32)0, (uint16)gs_RxNumTones);
}


/***************************************************************************************
;       Subroutine Name: ReadAccumulatedNoise
;
;       Description:
;               This routine reads the low and high words of the Accumulated Noise Power per tone.
;
;       Prototype:
;               void GetRxTones(void)
;
;       Input Arguments:
;
;       Output Arguments:
;               none
;
;       Return Value:
;               none
;
;       Global Variables:
;               gs_RtvSelect (I)                - FFT_OUTPUT: RTV0, SFDQ_OUTPUT: RTV1
;               gpsa_RxToneBuf (O)              - output from FDQ
;
;   Substates:
;             None
;
;**********************************************************************************************/

void ReadAccumulatedNoise(void)
{
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
#ifdef HW_SNR_FDQ
#else
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
        int32 *pla_addr;
        uint32 ul_LSW ,  ul_MSW, ul_LSW_temp,ul_MSW_temp;
        int i;
        pla_addr = gla_RxAccumBuf;

        ul_LSW  = IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR;
        ul_MSW  = IRI_QT_RAM_RX_NOISE_ACCMR_MSW_ADDR;

        for (i=0 ; i < gs_RxNumTones ; i++ )
        {
         ReadCoreReg(ul_LSW, &ul_LSW_temp);

         //Store LSW as 16 bits
         *pla_addr = (ul_LSW_temp  & 0xFFFF);

         pla_addr++;
         ul_LSW+=4;

         ReadCoreReg(ul_MSW, &ul_MSW_temp);
         // Store MSW as rest of the bits. This is required for correct working of RoundNoiseAccum()
         // as it exists currently
         *pla_addr = (int32) ( (ul_MSW_temp << 16) | (ul_LSW_temp >>16));

         pla_addr++;
         ul_MSW+=4;
        }
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START_END)
#endif
}

#endif //HW_SNR_FDQ


#ifdef HW_REIM_ACCUM

/*********************************************************************************************
;       Subroutine Name: ReadAccumulatedReIm
;
;       Description:
;               This routine reads accumulated Real Part and Imaginary Part of a signal
;
;       Prototype:
;               void GetReadAccumulatedReIm(void)
;
;       Input Arguments:
;
;       Output Arguments:
;               none
;
;       Return Value:
;               none
;
;       Global Variables:
;               gs_RtvSelect (I)                - FFT_OUTPUT: RTV0, SFDQ_OUTPUT: RTV1
;               gpsa_RxToneBuf (O)              - output from FDQ
;
;   Substates:
;             None
;
;**********************************************************************************************/

void ReadAccumulatedReIm(void)
{
        int32 *pla_addr;
        uint32 ul_LSW ,  ul_MSW;
        int i;
    uint32 ul_lsw_temp, ul_msw_temp;
        int32 l_data;

        pla_addr = gla_RxAccumBuf;

        ul_LSW  = IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR;
        ul_MSW  = IRI_QT_RAM_RX_NOISE_ACCMR_MSW_ADDR;

        for (i=0 ; i < gs_RxNumTones ; i++ )
        {
                ReadCoreReg(ul_LSW, &ul_lsw_temp);
                ul_LSW+=4;

                ReadCoreReg(ul_MSW, &ul_msw_temp);
                ul_MSW+=4;

        l_data = ul_lsw_temp &0xFFFFFF;
                if (l_data &0x800000)  l_data |= 0xFF000000;
                pla_addr[2*i] += l_data;

                l_data = (ul_msw_temp & 0xFFFF)<<8 | (ul_lsw_temp>>24);
                if (l_data &0x800000)  l_data |= 0xFF000000;
                pla_addr[2*i+1] += l_data;
        }

        ResetNoisePowerBuffer();
}
#endif //HW_REIM_ACCUM

