/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: LL_IOf.c
;
;  Low-level core interface layer.
;
*****************************************************************************/

#include "common.h"
#include "ll_iof.h"
#include "str_cocomo_interface.h"
#if 0
#include "afeif_cocomo_interface.h"
#endif
#include "zep_cocomo_interface.h"
#include "ft_cocomo_interface.h"
#include "qt_cocomo_interface.h"
#include "qtp_cocomo_interface.h"
#include "ftb_cocomo_interface.h"
#include "cri_cocomo_interface.h"
#include "ele_cocomo_interface.h"
#include "alp_cocomo_interface.h"

#ifndef ZEPHYR_62
#include "zep_ilv_cocomo_interface.h"
#endif

extern uint8 guc_ch_id;

/****************************************************************************
; Name: SetCoreReg
;
; Prototype:
;  void SetCoreReg(uint32 ul_addr, uint32 ul_mask)
;
; Description:
;  Function for setting bits in a register in the BMs
;
; Arguments:
;  ul_addr     (I)      physical address of register
;  ul_mask     (I)      bits set to 1 cause the corresponding
;                 bits in the register to be set to 1
;
;  Return Value:
;  N/A
*****************************************************************************/
void SetCoreReg(uint32 ul_addr, uint32 ul_mask)
{
   uint32 tmp;

   ReadCoreReg(ul_addr, &tmp);
   tmp |= ul_mask;
   WriteCoreReg(ul_addr, tmp);

}

/****************************************************************************
; Name: ResetCoreReg
;
; Prototype:
;  void ResetCoreReg(uint32 ul_addr, uint32 ul_mask)
;
; Description:
;  Function for resetting bits in a register in the BMs
;
; Arguments:
;  ul_addr     (I)      physical address of register
;  ul_mask     (I)      bits set to 1 cause the corresponding
;                 bits in the register to be set to 0
;
;  Return Value:
;  N/A
*****************************************************************************/
void ResetCoreReg(uint32 ul_addr, uint32 ul_mask)
{
   uint32 tmp;

   ReadCoreReg(ul_addr, &tmp);
   tmp &= ~ul_mask;
   WriteCoreReg(ul_addr, tmp);
}

/****************************************************************************
; Name: ReadCoreBuf32
;
; Prototype:
;  void ReadCoreBuf32(uint32 ul_addr, int16 *psa_words)
;
; Description:
;  Function for 32-bit read of ADSL core buffer
;
; Arguments:
;  ul_addr     (I)      physical address at which to start reading
;  psa_words   (O)      array containing data read from the buffer
;
;  Return Value:
;  N/A
*****************************************************************************/
void ReadCoreBuf32(uint32 ul_addr, int16 *psa_words, uint16 us_num)
{
   uint8 uc_Error;
   uint16 us_idx;
   uint32 ul_SrcAddr;
   uint16 us_DestOffset;
   uint32 ul_data;


   /* Zephyr */
   ul_SrcAddr = ul_addr;
   us_DestOffset = 0;
   uc_Error = 0;

   for(us_idx=0; us_idx<us_num; us_idx++){

      if(!ELE_ReadWord(ul_SrcAddr, &ul_data, LONGWORD_EN)) {
         *(psa_words+us_DestOffset) = (int16) ((ul_data) & 0x0000FFFF);
         us_DestOffset++;

         *(psa_words+us_DestOffset) = (int16) (((ul_data) & 0xFFFF0000) >> 16);
         us_DestOffset++;

         ul_SrcAddr++;
         continue;
      }

      if(!Str_ReadWord(guc_ch_id, ul_SrcAddr, &ul_data, STR_LONGWORD_EN)) {
         *(psa_words+us_DestOffset) = (int16) ((ul_data) & 0x0000FFFF);
         us_DestOffset++;

         *(psa_words+us_DestOffset) = (int16) (((ul_data) & 0xFFFF0000) >> 16);
         us_DestOffset++;

         ul_SrcAddr+=4;
         continue;
      }

      if (!ZEP_ReadWord(ul_SrcAddr, &ul_data, LONGWORD_EN,guc_ch_id)) {
         *(psa_words+us_DestOffset) = (int16) ((ul_data) & 0x0000FFFF);
         us_DestOffset++;

         *(psa_words+us_DestOffset) = (int16) (((ul_data) & 0xFFFF0000) >> 16);
         us_DestOffset++;

         ul_SrcAddr+=4;
         continue;
      }
#ifndef ZEPHYR_62
      if(!ZEP_ILV_ReadWord(ul_SrcAddr, &ul_data, (uint8)LONGWORD_EN,guc_ch_id)) {
         *(psa_words+us_DestOffset) = (int16) ((ul_data) & 0x0000FFFF);
         us_DestOffset++;

         *(psa_words+us_DestOffset) = (int16) (((ul_data) & 0xFFFF0000) >> 16);
         us_DestOffset++;

         ul_SrcAddr+=4;
         continue;
      }
#endif
      if (!IRI_FT_ReadWord(ul_SrcAddr, &ul_data, LONGWORD_EN,guc_ch_id)) {
         *(psa_words+us_DestOffset) = (int16) ((ul_data) & 0x0000FFFF);
         us_DestOffset++;

         *(psa_words+us_DestOffset) = (int16) (((ul_data) & 0xFFFF0000) >> 16);
         us_DestOffset++;

         ul_SrcAddr+=4;
         continue;
      }


      if (!IRI_FTB_ReadWord(ul_SrcAddr, &ul_data, LONGWORD_EN,guc_ch_id)) {
         *(psa_words+us_DestOffset) = (int16) ((ul_data) & 0x0000FFFF);
         us_DestOffset++;

         *(psa_words+us_DestOffset) = (int16) (((ul_data) & 0xFFFF0000) >> 16);
         us_DestOffset++;

         ul_SrcAddr+=4;
         continue;
      }

      if (!IRI_QT_ReadWord(ul_SrcAddr, &ul_data, LONGWORD_EN,guc_ch_id)) {
         *(psa_words+us_DestOffset) = (int16) ((ul_data) & 0x0000FFFF);
         us_DestOffset++;

         *(psa_words+us_DestOffset) = (int16) (((ul_data) & 0xFFFF0000) >> 16);
         us_DestOffset++;

         ul_SrcAddr+=4;
         continue;
      }

      if (!IRI_QTP_ReadWord(ul_SrcAddr, &ul_data, LONGWORD_EN,guc_ch_id)) {
         *(psa_words+us_DestOffset) = (int16) ((ul_data) & 0x0000FFFF);
         us_DestOffset++;

         *(psa_words+us_DestOffset) = (int16) (((ul_data) & 0xFFFF0000) >> 16);
         us_DestOffset++;

         ul_SrcAddr+=4;
         continue;
      }

      if(!CRI_ReadWord(guc_ch_id, ul_SrcAddr, &ul_data, LONGWORD_EN))
      {
         *(psa_words+us_DestOffset) = (int16) ((ul_data) & 0x0000FFFF);
         us_DestOffset++;

         *(psa_words+us_DestOffset) = (int16) (((ul_data) & 0xFFFF0000) >> 16);
         us_DestOffset++;

         ul_SrcAddr+=4;
         continue;
      }

      if(!ALP_ReadWord(ul_SrcAddr, &ul_data, LONGWORD_EN)) {
         *(psa_words+us_DestOffset) = (int16) ((ul_data) & 0x0000FFFF);
         us_DestOffset++;

         *(psa_words+us_DestOffset) = (int16) (((ul_data) & 0xFFFF0000) >> 16);
         us_DestOffset++;

         ul_SrcAddr++;
         continue;
      }
   }
}

/****************************************************************************
; Name: WriteCoreBuf32
;
; Prototype:
;  void WriteCoreBuf32(uint32 ul_addr, int16 *psa_words, uint16 us_num)
;
; Description:
;  Function for writing 32-bit words to a 32-bit buffer in the ADSL cores.
;
; Arguments:
;  ul_addr     (I)      physical address at which to start writing
;  psa_words   (I)      array containing data to be written to the buffer
;  us_num      (I)      number of 32-bit words to write to the buffer
;
;
;  Return Value:
;  N/A
*****************************************************************************/
void WriteCoreBuf32(uint32 ul_addr, int16 *psa_words, uint16 us_num)
{
   uint8 uc_Error;
   uint16 us_idx;
   uint16 us_SrcOffset;
   uint32 ul_DestAddr;
   uint32 ul_data1;
   uint32 ul_data2;


   /* Zephyr */
   ul_DestAddr = ul_addr;
   us_SrcOffset = 0;
   uc_Error = 0;

   for(us_idx=0; us_idx<us_num; us_idx++){

      /* read ls 16-bits */
      ul_data1= (uint32)(*(psa_words+us_SrcOffset));
      ul_data1 = ul_data1 & 0x0000FFFF;
      us_SrcOffset++;

      /* read mw 16-bits */
      ul_data2 = (uint32)(*(psa_words+us_SrcOffset));
      ul_data2 = (ul_data2<<16) & 0xFFFF0000;
      us_SrcOffset++;

      /* combine into a 32-bit word */
      ul_data1 = ul_data1 | ul_data2;

      /* write data to hardware */

      if(!ELE_WriteWord(ul_DestAddr, ul_data1, LONGWORD_EN)) {
         ul_DestAddr++;
            continue;
      }

        if(!Str_WriteWord(guc_ch_id, ul_DestAddr, ul_data1, STR_LONGWORD_EN)) {
         ul_DestAddr+=4;
            continue;
      }

      if(!ZEP_WriteWord( ul_DestAddr, ul_data1, LONGWORD_EN,guc_ch_id)) {
         ul_DestAddr+=4;
            continue;
      }
#ifndef ZEPHYR_62
      if(!ZEP_ILV_WriteWord(ul_DestAddr, ul_data1, (uint8)LONGWORD_EN,guc_ch_id)) {
         ul_DestAddr+=4;
            continue;
      }
#endif
      if(!IRI_FT_WriteWord(ul_DestAddr, ul_data1, LONGWORD_EN,guc_ch_id)) {
         ul_DestAddr+=4;
            continue;
      }

      if(!IRI_FTB_WriteWord(ul_DestAddr, ul_data1, LONGWORD_EN,guc_ch_id)) {
         ul_DestAddr+=4;
            continue;
      }

      if(!IRI_QT_WriteWord(ul_DestAddr, ul_data1, LONGWORD_EN,guc_ch_id)) {
         ul_DestAddr+=4;
            continue;
      }

      if(!IRI_QTP_WriteWord(ul_DestAddr, ul_data1, LONGWORD_EN,guc_ch_id)) {
         ul_DestAddr+=4;
            continue;
      }

      if(!CRI_WriteWord(guc_ch_id, ul_DestAddr, ul_data1, LONGWORD_EN))
      {
         ul_DestAddr+=4;
            continue;
      }

      if(!ALP_WriteWord(ul_DestAddr, ul_data1, LONGWORD_EN)) {
         ul_DestAddr++;
            continue;
      }

   }

}

/****************************************************************************
; Name: WriteCoreBuf32NoDMA
;
; Prototype:
;  void WriteCoreBuf32NoDMA(uint32 ul_addr, int16 *psa_words, uint16 us_num)
;
; Description:
;  Function for writing 32-bit words to a 32-bit buffer in the ADSL cores.
;
; Arguments:
;  ul_addr     (I)      physical address at which to start writing
;  psa_words   (I)      array containing data to be written to the buffer
;  us_num      (I)      number of 32-bit words to write to the buffer
;
;
;  Return Value:
;  N/A
*****************************************************************************/
void WriteCoreBuf32NoDMA(uint32 ul_addr, int16 *psa_words, uint16 us_num)
{
   // On cocomo, this is same as WriteCoreBuf32
   // Wrapper function needed to distinguish between DMA and NonDMA transfers
   // to 32 bit buffers on Socrates
   WriteCoreBuf32(ul_addr, psa_words, us_num);
}

/****************************************************************************
; Name: ReadCoreBuf32NoDMA
;
; Prototype:
;  void ReadCoreBuf32(uint32 ul_addr, int16 *psa_words)
;
; Description:
;  Function for 32-bit read of ADSL core buffer
;
; Arguments:
;  ul_addr     (I)      physical address at which to start reading
;  psa_words   (O)      array containing data read from the buffer
;
;  Return Value:
;  N/A
*****************************************************************************/
void ReadCoreBuf32NoDMA(uint32 ul_addr, int16 *psa_words, uint16 us_num)
{
   // On cocomo, this is same as WriteCoreBuf32
   // Wrapper function needed to distinguish between DMA and NonDMA transfers
   // to 32 bit buffers on Socrates
   ReadCoreBuf32(ul_addr, psa_words, us_num);
}



/****************************************************************************
; Name: FillCoreBuf32
;
; Prototype:
;  void FillCoreBuf32(uint32 ul_addr, int32 s_value, uint16 us_num)
;
; Description:
;
; Arguments:
;  ul_addr     (I)      physical address at which to start writing
;  s_value     (I)      data to be filled in to the buffer
;  us_num      (I)      number of 16-bit words to write to the buffer
;
;
;  Return Value:
;  N/A
*****************************************************************************/
void FillCoreBuf32(uint32 ul_addr, int32 s_value, uint16 us_num)
{
   int16 i;

   for (i=0;i<us_num;i++) {

      if(!ZEP_WriteWord(ul_addr, s_value, LONGWORD_EN, guc_ch_id)) {
         ul_addr+=4;
         continue;
      }
#ifndef ZEPHYR_62
      if(!ZEP_ILV_WriteWord(ul_addr, s_value, (uint8)LONGWORD_EN, guc_ch_id)) {
         ul_addr+=4;
         continue;
      }
#endif
      if(!ALP_WriteWord(ul_addr, s_value, LONGWORD_EN)) {
         ul_addr++;
         continue;
      }

      if(!ELE_WriteWord(ul_addr, s_value, LONGWORD_EN)) {
         ul_addr++;
         continue;
      }

        if(!Str_WriteWord(guc_ch_id, ul_addr, s_value, LONGWORD_EN)) {
         ul_addr+=4;
         continue;
      }

      if(!IRI_FT_WriteWord(ul_addr, s_value, LONGWORD_EN,guc_ch_id)) {
         ul_addr +=4;
         continue;
      }

      if(!IRI_FTB_WriteWord(ul_addr, s_value, LONGWORD_EN,guc_ch_id)) {
         ul_addr +=4;
         continue;
      }

      if(!IRI_QT_WriteWord(ul_addr, s_value, LONGWORD_EN,guc_ch_id)) {
         ul_addr+=4;
         continue;
      }


      if(!IRI_QTP_WriteWord(ul_addr, s_value, LONGWORD_EN,guc_ch_id)) {
         ul_addr+=4;
         continue;
      }

      if(!CRI_WriteWord(guc_ch_id, ul_addr, s_value, LONGWORD_EN))
      {
         ul_addr+=4;
         continue;
      }

   } //for (i=0;i<us_num;i++) {

}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ReadCoreBuf8(uint32 ul_addr, int8 *pca_word, uint16 us_num)
*
*  This function reads a 32-bit word from a core memory.
*
*  Input Arguments:
*     ul_addr: start address
*     *pca_word: pointer to 8-bit data array to be read from the buffer
*     us_num: # of data to read
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ReadCoreBuf8(uint32 ul_addr, int8 *pca_word, uint16 us_num)
{
   int16 i;
   uint32 ul_data;

   for (i=0;i<us_num;i++) {
      ReadCoreReg(ul_addr, &ul_data);
      pca_word[i] = (int8)ul_data;
      ul_addr += 4;
   }
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void WriteCoreBuf8(uint32 ul_addr, int8 *pca_word, uint16 us_num)
*
*  This function writes a 32-bit word to a core memory.
*
*  Input Arguments:
*     ul_addr: start address
*     *pca_word: pointer to 8-bit data array to be written to the buffer
*     us_num: # of data to write
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void WriteCoreBuf8(uint32 ul_addr, uint8 *pca_word, uint16 us_num)
{
   int16 i;
   uint32 ul_data;

   for (i=0;i<us_num;i++) {
      ul_data = (uint32)pca_word[i];
      WriteCoreReg(ul_addr, ul_data);
      ul_addr += 4;
   }
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ReadCoreReg(uint32 ul_address, uint32 *pul_word)
*
*  This function reads a 32-bit word from a core register.
*
*  Input Arguments:
*     ul_address     physical address of core
*
*  Output Arguments:
*     *pul_word      32-bit data read from the core
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ReadCoreReg(uint32 ul_address, uint32 *pul_word)
{
   if(!ELE_ReadWord(ul_address, pul_word, LONGWORD_EN))
      return;

    if(!Str_ReadWord(guc_ch_id, ul_address, pul_word, STR_LONGWORD_EN))
      return;
#if 0
   if(!Afeif_ReadWord(ul_address, pul_word, AI_LONGWORD_EN))
      return;
#endif
   if(!ZEP_ReadWord(ul_address, pul_word, (uint8)LONGWORD_EN,guc_ch_id)) {
      return;
   }
#ifndef ZEPHYR_62
   if(!ZEP_ILV_ReadWord(ul_address, pul_word, (uint8)LONGWORD_EN,guc_ch_id)) {
      return;
   }
#endif
   if(!IRI_FT_ReadWord(ul_address, pul_word, LONGWORD_EN,guc_ch_id)) {
      return;
   }

   if(!IRI_FTB_ReadWord(ul_address, pul_word, LONGWORD_EN,guc_ch_id)) {
      return;
   }
   if(!IRI_QT_ReadWord(ul_address, pul_word, LONGWORD_EN,guc_ch_id)) {
      return;
   }

   if(!IRI_QTP_ReadWord(ul_address, pul_word, LONGWORD_EN,guc_ch_id)) {
      return;
   }

   if(!CRI_ReadWord(guc_ch_id, ul_address, pul_word, LONGWORD_EN))
   {
      return;
   }

}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void WriteCoreReg(uint32 ul_address, uint32 ul_word)
*
*  This function writes a 32-bit word to a core register.
*
*  Input Arguments:
*     ul_address     physical address of core
*     ul_word        32-bit data written to the core
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
void WriteCoreReg(uint32 ul_address, uint32 ul_word)
{
   if(!ELE_WriteWord(ul_address, ul_word, LONGWORD_EN))
      return;

    if(!Str_WriteWord(guc_ch_id, ul_address, ul_word, STR_LONGWORD_EN))
      return;
#if 0
   if(!Afeif_WriteWord(ul_address, ul_word, AI_LONGWORD_EN))
      return;
#endif
   if(!ZEP_WriteWord(ul_address, ul_word, LONGWORD_EN,guc_ch_id))
      return;
#ifndef ZEPHYR_62
   if(!ZEP_ILV_WriteWord(ul_address, ul_word, (uint8)LONGWORD_EN,guc_ch_id))
      return;
#endif
   if(!IRI_FT_WriteWord(ul_address, ul_word, LONGWORD_EN,guc_ch_id))
      return;

   if(!IRI_FTB_WriteWord(ul_address, ul_word, LONGWORD_EN,guc_ch_id))
      return;

   if(!IRI_QT_WriteWord(ul_address, ul_word, LONGWORD_EN,guc_ch_id))
      return;

   if(!IRI_QTP_WriteWord(ul_address, ul_word, LONGWORD_EN,guc_ch_id))
      return;

   if(!CRI_WriteWord(guc_ch_id, ul_address, ul_word, LONGWORD_EN))
   {
      return;
   }

    if(!ALP_WriteWord(ul_address, ul_word, LONGWORD_EN))
      return;
}


/*
*-------------------------------------------------------------------------------
*
*  Prototype: uint8* Get_TxFrameBufferPointer(void)
*
*  This function gets the Tx Frame buffer pointer
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*     ptx_FrameBuffer      pointer to the pointer of the frame buffer
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
uint8* Get_TxFrameBufferPointer(void)
{
   //Mei fixme ???

// uint8 *ptx_FrameBuffer;
// BCR_GetTxFrameBuffer(&ptx_FrameBuffer);
///   return (ptx_FrameBuffer);
   return(0);
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: uint8* Get_RxFrameBufferPointer(void)
*
*  This function gets the Rx Frame buffer pointer
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*     prx_FrameBuffer      pointer to the pointer of the rx frame buffer
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
uint8* Get_RxFrameBufferPointer(void)
{
   //Mei fixme
// uint8 *prx_FrameBuffer;
// BCR_GetRxFrameBuffer(&prx_FrameBuffer);
// return (prx_FrameBuffer);
   return(0);
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: uint8* Get_RxCellBufferPointer(void)
*
*  This function gets the Rx cell buffer
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*     prx_CellBuffer    pointer to the pointer of the rx cell buffer
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
uint8* Get_RxCellBufferPointer(void)
{
   uint8 *prx_CellBuffer;
   ALP_GetRxCellBuffer(&prx_CellBuffer);
   return (prx_CellBuffer);
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: uint8* Get_TxCellBufferPointer(void)
*
*  This function gets the Tx cell buffer
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*     ptx_CellBuffer    pointer to the pointer of the tx cell buffer
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
uint8* Get_TxCellBufferPointer(void)
{
   uint8 *ptx_CellBuffer;
   ALP_GetTxCellBuffer(&ptx_CellBuffer);
   return (ptx_CellBuffer);
}

/**********************************************************************
*  Subroutine Name: GetActiveBGTNTableAddress()
*
*  This function returns the base address of the Iridia-QT
*  Tone Reordering Table.
*
*  Prototype:
*     uint32* GetActiveBGTNTableAddress(int32 s_Path,uint8 uc_port)
*
*  Input Arguments:
*     uc_port -- indicate which port (0,1,2,3) to use
*
*  Output Arguments:
*
*  Return Value:
*     pus_Addr -- Base address of the Tone Reordering Table
*
**********************************************************************/
uint32* GetActiveBGTNTableAddress(int32 s_Path,uint8 uc_port)
{
   uint32 *pus_Addr;
   IRI_QT_GetActiveBGTNTableAddress(&pus_Addr, s_Path,uc_port);
   return (pus_Addr);
}


/**********************************************************************
*  Subroutine Name: GetActiveEGTTableAddress()
*
*  This function returns the base address of the Iridia-QT
*  Tone Reordering Table.
*
*  Prototype:
*     uint8* GetActiveEGTTableAddress(uint8 uc_port)
*
*  Input Arguments:
*     uc_port -- indicate which port (0,1,2,3) to use
*
*  Output Arguments:
*
*  Return Value:
*     pus_Addr -- Base address of the Tone Reordering Table
*
**********************************************************************/
uint8* GetActiveEGTTableAddress(uint8 uc_port)
{
   uint8 *puc_Addr;
   IRI_QT_GetActiveEGTTableAddress(&puc_Addr, uc_port);
   return (puc_Addr);
}


/**********************************************************************
*  Subroutine Name: GetSFDQExponentTableAddress()
*
*  This function returns the base address of the Iridia-QT
*  Tone Reordering Table.
*
*  Prototype:
*     uint16* IRI_QT_GetSFDQExponentTableAddress(uint8 uc_port)
*
*  Input Arguments:
*     uc_port -- indicate which port (0,1,2,3) to use
*
*  Output Arguments:
*
*  Return Value:
*     pus_Addr -- Base address of the Tone Reordering Table
*
**********************************************************************/
uint8* GetSFDQExponentTableAddress(uint8 uc_port)
{
   uint8 *pus_Addr;
   IRI_QT_GetSFDQExponentTableAddress(&pus_Addr, uc_port);
   return (pus_Addr);
}

/**********************************************************************
*  Subroutine Name: GetToneReorderingTableAddress()
*
*  This function returns the base address of the Iridia-QT
*  Tone Reordering Table.
*
*  Prototype:
*     uint16* GetToneReorderingTableAddress(int16 s_SetNumber)
*
*  Input Arguments:
*     uc_port -- indicate which port (0,1,2,3) to use
*
*  Output Arguments:
*
*  Return Value:
*     pus_Addr -- Base address of the Tone Reordering Table
*
**********************************************************************/
uint16* GetToneReorderingTableAddress(uint8 uc_port)
{
   uint16 *pus_Addr;
   IRI_QTP_GetToneReorderingTableAddress(&pus_Addr, uc_port);
   return (pus_Addr);
}

/**********************************************************************
*  Subroutine Name: GetGainScaleTableAddress()
*
*  This function returns the base address of the Iridia-QT
*  Gain Scale Table.
*
*  Prototype:
*     uint16* GetGainScaleTableAddress(int16 s_SetNumber)
*
*  Input Arguments:
*     s_SetNumber -- indicate which memory set (0 or 1) to use
*
*  Output Arguments:
*
*  Return Value:
*     pus_Addr -- Base address of the Gain Scale Table
*
**********************************************************************/
uint16* GetGainScaleTableAddress(uint8 uc_port)
{
   uint16 *pus_Addr;
   IRI_QTP_GetGainScaleTableAddress(&pus_Addr, uc_port);
   return (pus_Addr);
}

/**********************************************************************
*  Subroutine Name: GetRxConstellationGainsTableAddress()
*
*  This function returns the base address of the Iridia-QT
*  Rx Constellation Gain Scale Table.
*
*  Prototype:
*     uint32* GetRxConstellationGainsTableAddress(void)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Return Value:
*     pul_Addr -- Base address of the Gain Scale Table
*
**********************************************************************/
uint32* GetRxConstellationGainsTableAddress(void)
{
// uint32 *pul_BaseAddr;
// IRI_QT_GetRxConstellationGainsTableAddress(&pul_BaseAddr);
   return (0);
}

/**********************************************************************
*  Subroutine Name: GetBitAllocationTableAddress()
*
*  This function returns the base address of the Iridia-QT
*  Bit Allocation Table.
*
*  Prototype:
*     uint8* GetBitAllocationTableAddress(uint8 uc_port)
*
*  Input Arguments:
*     uc_port -- indicates port id
*  Output Arguments:
*
*  Return Value:
*     puc_Addr -- Base address of the Bit Allocation Table
*
**********************************************************************/
uint8* GetBitAllocationTableAddress(uint8 uc_port)
{
   uint8 *puc_Addr;
   IRI_QTP_GetBitAllocationTableAddress(&puc_Addr, uc_port);
   return (puc_Addr);
}

/**********************************************************************
*  Subroutine Name: GetExtendedGainTableAddress()
*
*  This function returns the base address of the Iridia-QT
*  Extended Gain Table.
*
*  Prototype:
*     uint8* GetExtendedGainTableAddress(int16 s_SetNumber)
*
*  Input Arguments:
*     s_SetNumber -- indicate which memory set (0 or 1) to use
*
*  Output Arguments:
*
*  Return Value:
*     puc_Addr -- Base address of the Extended Gain Table
*
**********************************************************************/
uint8* GetExtendedGainTableAddress(uint8 uc_port)
{
   uint8 *puc_Addr;
   IRI_QTP_GetExtendedGainTableAddress(&puc_Addr, uc_port);
   return (puc_Addr);
}


/**********************************************************************
*  Subroutine Name: GetSFDQMantissaTableAddress()
*
*  This function returns the base address of the Iridia-QT
*  SFDQ Mantissa Table.
*
*  Prototype:
*     int16* GetSFDQMantissaTableAddress(void)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Return Value:
*     ps_BaseAddr -- Base address of the SFDQ Mantissa Table
*
**********************************************************************/
int16* GetSFDQMantissaTableAddress(uint8 uc_port)
{
   int16 *ps_BaseAddr;
   IRI_QT_GetSFDQMantissaTableAddress(&ps_BaseAddr,uc_port);
   return (ps_BaseAddr);
}

/**********************************************************************
*  Subroutine Name: GetMFDQFFMantissaTableAddress()
*
*  This function returns the base address of the Iridia-QT
*  MFDQ feedforward coefficient Mantissa Table.
*
*  Prototype:
*     int16* GetMFDQFFMantissaTableAddress(void)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Return Value:
*     ps_BaseAddr -- Base address of the MFDQ FeedForward Mantissa Table
*
**********************************************************************/
int16* GetMFDQFFMantissaTableAddress(uint8 uc_port)
{
   int16 *ps_BaseAddr;
   IRI_QT_GetMFDQFFMantissaTableAddress(&ps_BaseAddr,uc_port);
   return (ps_BaseAddr);
}

/**********************************************************************
*  Subroutine Name: GetMFDQFBMantissaTableAddress()
*
*  This function returns the base address of the Iridia-QT
*  MFDQ feedback coefficient Mantissa Table.
*
*  Prototype:
*     int16* GetMFDQFBMantissaTableAddress(void)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Return Value:
*     ps_BaseAddr -- Base address of the MFDQ FeedBack Mantissa Table
*
**********************************************************************/
int16* GetMFDQFBMantissaTableAddress(uint8 uc_port)
{
   int16 *ps_BaseAddr;
   IRI_QT_GetMFDQFBMantissaTableAddress(&ps_BaseAddr,uc_port);
   return (ps_BaseAddr);
}

/**********************************************************************
*  Subroutine Name: GetMFDQFBExponentTableAddress()
*
*  This function returns the base address of the Iridia-QT
*  MFDQ feedback exponent Table.
*
*  Prototype:
*     uint32* GetMFDQFBExponentTableAddress(void)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Return Value:
*     pul_BaseAddr -- Base address of the MFDQ FeedBack Exponent Table
*
**********************************************************************/
uint32* GetMFDQFBExponentTableAddress(uint8 uc_port)
{
   uint32 *pul_BaseAddr;
   IRI_QT_GetMFDQFBExponentTableAddress(&pul_BaseAddr,uc_port);
   return (pul_BaseAddr);
}

/**********************************************************************
*  Subroutine Name: IRI_QT_GetMFDQFBToneTableAddress()
*
*  This function returns the base address of the Iridia-QT
*  MFDQ feedback tone Table.
*
*  Prototype:
*     uint32* GetMFDQFBToneTableAddress(void)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Return Value:
*     pul_BaseAddr -- Base address of the MFDQ FeedBack Tone Table
*
**********************************************************************/
uint32* GetMFDQFBToneTableAddress(uint8 uc_port)
{
   uint32 *pul_BaseAddr;
   IRI_QT_GetMFDQFBToneTableAddress(&pul_BaseAddr,uc_port);
   return (pul_BaseAddr);
}


