/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   LinkStart.c
 *
 *
 *----------------------------------------------------------------------------
 */
// ******************************************************************
// LinkStart.c
//
// History
// 23/08/2011 Kannan: DS Performance improvement in DEC training.
//    Increased the DEC length from 400 to 480 to reduce the
//      uncancelled echo.
//      Grep for XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining
//
// 21/11/2011 Hanyu:  Ported MFD code to VR9. Added code to force G.dmt Annex A for NLNF measurement.
//                    This can be enabled by CMV bit-15 (default "0" means enabled)
//                    of INFO 121 0 in persistent memory
//                    and "cw test 7 0 0x0D" without SW API support
//                    or enabaled by cw cntl 0 0 0x09 with SW API support.
//                    Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// 02/12/2011 Balabath:Added new microstate STATs18D and 19D CMV DSL 16 is used inplace of INFO 121
//       for NLNF measurement.INFO 103 (6:11) are mapped to DSL 18 0 5 (Hybrid information)..
//            Additinally, DSL13 bit2 is used inplace of CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap
//
// 26/11/2012 Kannan: Included header file for compilation
//        Grep for XDSLRTFW-541: Platform_VR9_VRX318
//
// 03/03/2011 Stefan/Vinjam: Use Annex-B filters in oISDN binary. Reconfigure them post-handshake again based on selected mode.
//          PSD violation in ADSL G.Hs if Annex-J mode is enabled - Jira XDSLRTFW-258
//          In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
//          in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
//          tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
//          PSDs because of the reconfiguration of the tx-path after G.Hs
//          As Annex-J activation tones are currently not used in any field deployment the activation
//          tones and G.Hs filter configurations are hard-coded to Annex-B.
//          this part of the code is called only in LinkStartForTest.c
//          Grep for XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs
//
// 26/03/2013 Anantha Ramu: The DEC order restored back to 400 for Annex B
//            Grep for XDSLRTFW-761:PERF_ALL_ALL_AnxB_DEC_order_reduction
//
// 16/05/2013 Naveen: Configure link start with Annex J setting before GHS
//            This will configure the Tx IIR filter to Annex J (Mask 5-9) filter
//            Grep for XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs
//
// 02/May/2013 Ram: Added variable/marker for persistent memory. Persistent memory will be cleared if the marker is corrupted/modified.
//                  Grep for XDSLRTFW-241: FIX_ALL_ALL_ALL_Clear_Persistent_Memory
//
// 09/02/2018  Abu Rahman
//             XDSLRTFW-3708:Control of GPIO14 to indicate dying gasp for ADSL
//
//             In case of Dying Gasp set VRX518 GPIO pin 14 from high to low.
//             This feature is CMV controlled
//             CMV CNFG 58 Bit 8 (LSB = Bit0) = 1 Enable this feature
//             CMV CNFG 58 Bit 8 (LSB = Bit0) = 0 Disable this feature (default configuration)
//             Preferable configuration method for Enabling this feature: "dmms 3A48 0 1 0100 0100" at "wait for link activation" state
//
//             To control GPIO 14 first below mentioned registers need to be programmed
//             Register GPIO PAD PORTMUXC14(VRX518 address 0x24038) = 0
//             Register GPIO_FUNC DIRSET_0(VRX518 address 0x20048) bit14 value = 1
//             Register GPIO_FUNC OUTSET_0(VRX518 address 0x20040) bit14 value = 1
//
//             After detecting Dying Gasp
//             Register GPIO_FUNC OUTCLR_0(VRX518 address 0x20044) bit14 value = 1 will set
//             GPIO pin 14 voltage level low.
//             Check Jira for more information about register spec
//
//             Note: BAR registers can access only up to 64k from it's base address so that special care needed
//             to be taken while using BAR register to access data.
//
//             Grep pattern:  XDSLRTFW-3708
//
//  07/02/18: Stefan: XDSLRTFW-2417: INFINEON not used anymore in VR9 ADSL code
//            Re-enable required code under #ifdef INFINEON
//            - KPN specific ADSL Annex-B (oISDN) Tx-spectrum
//            - Nlp = 1
//            grep for XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
//
// 03/12/2018 Abu Rahman
//            XDSLRTFW-4039: Disable Autonomous State Event Messaging in ADSL mode
//            Autonomous State Event messaging was introduced with XDSLRTFW-3548(ADSL) & XDSLRTFW-3513 (VDSL) jiras. This functionality
//            required special message handling capability in SW which was introduced in UGW 8.1.1. It looks like concept were not adequate
//            to meet all the corner cases. This new feature often leads instabilities ( ie No TC Sync reporting in VDSL
//            mode, link drop in ADSL mode etc.) Due to these consequences the feature is decided to be disabled in FW
//            by default. If API tries to enable this feature then FW reports an exception (i.e E_CODE_MODEM_FSM_EVENT_NOT_ALLOWED_CONFIGURATION)
//
//            To enable or disable Autonomous state events handling in FW "test 46 0"  bit mask 0x0800 cmv is used
//            Enable Autonomous Message Handling : test 46 0  bit mask 0x0800 value 1 (dmms 2E44 0 1 0800 0800)
//            Disable Autonomous Message Handling : test 46 0  bit mask 0x0800 value 0 (dmms 2E44 0 1 0800 0000) default configuration.
//            Grep pattern:  XDSLRTFW-4039
// ************************************************************************************************************
// ******************************************************************

#include "const.h"
#include "file_io.h"
#include "gdata.h"
#include <stdio.h>
#include <stdlib.h>
#include "modem_hw.h"
#include "InitBMf.h"
#include "trail.h"
#include "trailend.h"
#include "file_io3.h"
#include "ghs.h"
#include "string.h"
#include "mp.h"
#include "cmv.h"
#include "nmp.h"
#include "nmp_plfm.h"
#include "channel.h"
#include "bert.h"
#include "STR_IOf.h"
#include "ALP_IOf.h"
#include "stateini.h"
#include "ec_data.h"
#include "gdata_bis.h"
#include "sach.h"    // For Sachmo channel
#include "cnfg_eng.h"
#include "cnfg_task.h"
#include "iri_ini.h"
#include "DSLEngin.h"
#include "str_ini.h"
#include "statein1.h"
#include "hndshk_Data.h"
#include "afe.h"
#include "delay.h"
#include "ll_iof.h"
#include "memrymap.h"
#include "pll.h"
#include "InitTDQfilter.h"
#include "cri_iof.h"

#include "nlnf.h"  //XDSLRTFW-541: Platform_VR9_VRX318 (START_END)

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"
#include "dsp_regs_62.h"
#include "codeswap.h"

extern void EnableStrymon(void);

// XDSLRTFW-4039: Disable Autonomous State Event Messaging in ADSL mode (Start)
/*
*-------------------------------------------------------------------
*
*   Prototype: void CheckModemMonitor0Config(void)
*
*   Description:
*
*   This function set exception code if API tries to enable Autonomous State Event Messaging
*
*   Note:
*   In General Autonomous State Event Polling mode is forbidden. For test purpose this mode
*   can be enabled via cmv test 46 bit mask 0x0800
*
*   Arguments:
*      none
*
*   Global Variables:
*     gt_HercADSL_MONIMap_EventConfigure[]: Autonomous message event reporter controller variable.
*-------------------------------------------------------------------
*/
void CheckModemMonitor0Config(void)
{
   uint32 ul_ErrorCode = 0;

   // non zero value of gusa_MONI_ModemStat[] means Autonomous message is configured which is not a valid configuration
   if ((gt_HercADSL_MONIMap_EventConfigure.s_Offset0 != 0) || (gt_HercADSL_MONIMap_EventConfigure.s_Offset1 != 0))
   {
      // Test 46 bit mask 0x0800 is FW internal bit to enable Autonomous message for test purpose. If this bit is not enabled then
      // go for exception if API enables the Autonomous message
      if((TESTArray[TEST_Control4] & TEST_Control4_Autonomous_State_Event_Msg_Bit11_Mask) != TEST_Control4_Autonomous_State_Event_Msg_Bit11_Mask)
      {
         ul_ErrorCode = E_CODE_MODEM_FSM_EVENT_NOT_ALLOWED_CONFIGURATION;

      }
      else // if the Autonomous message is enabled by FW
      {
         // According to VRX51x_xDSL_Firmware_UM_PR_Rev3.1.2_Int.pdf document restriction applied in bit field 4,5,and 9 of Modem_Monitor 0 CMV variable
         // Bit field 9 (STEADY_STATE_TC_SYNC_FIRSTTIME) and bit filed 4 (STEADY_STATE_TC_NOSYNC) shall be mutually exclusive
         // Bit field 9 (STEADY_STATE_TC_SYNC_FIRSTTIME) and bit filed 5 (STEADY_STATE_TC_SYNC) shall be mutually exclusive
         if ((gt_HercADSL_MONIMap_EventConfigure.s_Offset0 & MONI_FIRST_SHOWTIME_TC_SYNC) == MONI_FIRST_SHOWTIME_TC_SYNC)
         {
            if (((gt_HercADSL_MONIMap_EventConfigure.s_Offset0 & MONI_SHOWTIME_TC_NOSYNC) == MONI_SHOWTIME_TC_NOSYNC) || ((gt_HercADSL_MONIMap_EventConfigure.s_Offset0 & MONI_SHOWTIME_TC_SYNC) == MONI_SHOWTIME_TC_SYNC))
            {
               ul_ErrorCode = E_CODE_MODEM_FSM_EVENT_CONFIGURATION_ERROR;
            }
         }
      }
   }

   if(ul_ErrorCode != 0 )
   {
      EnterFailStates(ul_ErrorCode);
   }
}
// XDSLRTFW-4039: Disable Autonomous State Event Messaging in ADSL mode (End)



 //XDSLRTFW-3708 Control of GPIO14 to indicate dying gasp for ADSL (Start)
 /*******************************************************************************
 *
 *   Prototype: void InitVRX518Regs_for_Gpio14(void)
 *
 *   This function initializes variables used for controlling VRX518 GPIO14 pin
 *
 *   To initialize VRX518 GPIO14 pin below mentioned VRX518 registers need be programmed
 *   Register GPIO PAD PORTMUXC14(VRX518 address 0x24038) = 0
 *   Register GPIO_FUNC DIRSET_0(VRX518 address 0x20048) bit14 value = 1
 *   Register GPIO_FUNC OUTSET_0(VRX518 address 0x20040) bit14 value = 1
 *
 *   With present implementation all these registers are accessible via BAR18 register since BAR18 is
 *   pointing to CHIPID_EFUSE register(0x18000) register space.
 *
 *   Note: BAR registers can access only up to 64k from it's base address so that special care
 *   needed to be taken while using BAR register to access data.
 *
 *   Input Arguments: none
 *
 *   Output Arguments: none
 *
 *   Returns: none
 *
 *   Global Variables: none
 *
 *
 *******************************************************************************/


 void InitVRX518Regs_for_Gpio14(void)
 {
    FlagT ft_AddressInRange = TRUE;

    uint32 ul_data;
    volatile uint32 ul_RegAddress;

    int32 l_GPIO_PAD_PORTMUXC14_AddressOffset;
    int32 l_GPIO_FUNC_DIRSET_0_AddressOffset;
    int32 l_GPIO_FUNC_OUTSET_0_AddressOffset;
    int32 l_GPIO_FUNC_OUTCLR_0_AddressOffset;

    uint32 ul_AddressPointedByBAR18;


    // VRX518 CHIPID_EFUSE (relative) base address which is stored in first 20 bits of DSP_XMEM_BAR18
    // address location. 12 MS bits are used for PCIe_BaseAddress
    // all the address access via BAR18 register must be located within 64K byte address range from it's base address

    ul_AddressPointedByBAR18 = (*((volatile uint32 *)DSP_XMEM_BAR18)) & 0xFFFFF;

    l_GPIO_PAD_PORTMUXC14_AddressOffset = VRX518_GPIO_PAD_PORTMUXC14_ADDRESS - ul_AddressPointedByBAR18;
    l_GPIO_FUNC_DIRSET_0_AddressOffset = VRX518_GPIO_FUNC_DIRSET_0_ADDRESS - ul_AddressPointedByBAR18;
    l_GPIO_FUNC_OUTSET_0_AddressOffset = VRX518_GPIO_FUNC_OUTSET_0_ADDRESS - ul_AddressPointedByBAR18;
    l_GPIO_FUNC_OUTCLR_0_AddressOffset = VRX518_GPIO_FUNC_OUTCLR_0_ADDRESS - ul_AddressPointedByBAR18;

    // BAR register can access only 64k address space from it's base address
    if ((l_GPIO_PAD_PORTMUXC14_AddressOffset < 0) || (l_GPIO_PAD_PORTMUXC14_AddressOffset > 65535))
    {
       ft_AddressInRange = FALSE;
    }

    if ((l_GPIO_FUNC_DIRSET_0_AddressOffset < 0) || (l_GPIO_FUNC_DIRSET_0_AddressOffset > 65535))
    {
       ft_AddressInRange = FALSE;
    }

    if ((l_GPIO_FUNC_OUTSET_0_AddressOffset < 0) || (l_GPIO_FUNC_OUTSET_0_AddressOffset > 65535))
    {
       ft_AddressInRange = FALSE;
    }
    if ((l_GPIO_FUNC_OUTCLR_0_AddressOffset < 0) || (l_GPIO_FUNC_OUTCLR_0_AddressOffset > 65535))
    {
       ft_AddressInRange = FALSE;
    }



    if (ft_AddressInRange)
    {
       // note: all the memory locations below are located outside ARC memory region. According to coding guideline
       // these memory locations must be accessed via DMA! Since this function is called before the link start
       // and there are no code swap happening during this time, we can access theses location via direct access.
       // !! These memory accesses are exception!!

       // Initialize GPIO PAD register for GPIO 14
       //set register PORTMUXC14 value to 0
       ul_RegAddress = (uint32)(&__StartOfSramBAR18) + (uint32)l_GPIO_PAD_PORTMUXC14_AddressOffset;
       ul_data = 0;
       *(volatile uint32 *)ul_RegAddress = ul_data;

       // Initialize GPIO_FUNC register for GPIO 14
       // set register DIRSET_0 bit 14 value to 1(b)
       ul_RegAddress = (uint32)(&__StartOfSramBAR18) + (uint32)l_GPIO_FUNC_DIRSET_0_AddressOffset;
       ul_data = *(volatile uint32 *)ul_RegAddress;
       ul_data |= 0x4000;  // set bit 14 to 1
       *(volatile uint32 *)ul_RegAddress = ul_data;

       // set register OUTSET_0 bit 14 value to 1(b)
       ul_RegAddress = (uint32)(&__StartOfSramBAR18) + (uint32)l_GPIO_FUNC_OUTSET_0_AddressOffset;
       ul_data = *(uint32 *)ul_RegAddress;
       ul_data |= 0x4000; // set bit 14 to 1
       *(volatile uint32 *)ul_RegAddress = ul_data;
    }
    else
    {
       EnterFailStates(E_CODE_BAD_MEM_ACCESS);
    }
 }
 //XDSLRTFW-3708 Control of GPIO14 to indicate dying gasp for ADSL (End)



/*^^^
*-------------------------------------------------------------------
*
*  void ConfigEngineForLinkStart(void)
*
*  Description:
*
*
*-------------------------------------------------------------------
*^^^
*/

void ConfigEngineForLinkStart(void)
{
   int16 i, s_temp;

#ifdef ISDN
   int16 sa_Preferred_PSDMask_G9923x[NUM_G992_3_ANNEX_SUPPORTED] = {DEFAULT_G992_3B_PSDMASK, DEFAULT_G992_3J_PSDMASK, DEFAULT_G992_3M_PSDMASK};
   int16 sa_Preferred_PSDMask_G9925x[NUM_G992_5_ANNEX_SUPPORTED] = {DEFAULT_G992_5B_PSDMASK, DEFAULT_G992_5J_PSDMASK, DEFAULT_G992_5M_PSDMASK};
#else
   int16 sa_Preferred_PSDMask_G9923x[NUM_G992_3_ANNEX_SUPPORTED] = {DEFAULT_G992_3A_PSDMASK, DEFAULT_G992_3I_PSDMASK, DEFAULT_G992_3M_PSDMASK};
   int16 sa_Preferred_PSDMask_G9925x[NUM_G992_5_ANNEX_SUPPORTED] = {DEFAULT_G992_5A_PSDMASK, DEFAULT_G992_5I_PSDMASK, DEFAULT_G992_5M_PSDMASK};
#endif
   // A longer dec length of 400 taps combined with a sharper interp1 gives us improved
   // performance by limiting uncancelled linear echo.
   //gs_DEC_ORDER = 400;   /* swengine tests use 288 tap DEC, hence we need to reconfigure here */
   //XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining (START - END)
   // Increased DEC length from 400 to 480, it helps to reduce the
   //residual echo, i.e uncancelled linear echo. Observed improvement in the
   //Reverb Echo SNR & Medley SNR.
//XDSLRTFW-761:PERF_ALL_ALL_AnxB_DEC_order_reduction (Start)
#ifndef ISDN
   gs_DEC_ORDER = 480;
#else
   gs_DEC_ORDER = 400;
#endif
//XDSLRTFW-761:PERF_ALL_ALL_AnxB_DEC_order_reduction (End)

#ifdef ISDN
    // XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
    if (gt_INFX_CMV.us_OperatorSpBits & CMV_TO_FORCE_KPN_TSSI_US_BIN_START)
    {
        // Overwrite default US TSSI with KPN-specific values.  Note that these
        // US tssi are the same for modes 3B and 5B.

        memcpy(guca_US_TssiIndex_G9923B, guca_US_TssiIndex_G9923B_KPN, sizeof(uint8) * NUM_US_TSSI_VALUES_INITIAL_CLR);
        memcpy(guca_US_TssiValue_G9923B, guca_US_TssiValue_G9923B_KPN, sizeof(uint8) * NUM_US_TSSI_VALUES_INITIAL_CLR);
        memcpy(gfta_US_SprtSet_G9923B, gfta_US_SprtSet_G9923B_KPN, sizeof(uint8));

        memcpy(guca_US_TssiIndex_G9925B, guca_US_TssiIndex_G9923B_KPN, sizeof(uint8) * NUM_US_TSSI_VALUES_INITIAL_CLR);
        memcpy(guca_US_TssiValue_G9925B, guca_US_TssiValue_G9923B_KPN, sizeof(uint8) * NUM_US_TSSI_VALUES_INITIAL_CLR);
        memcpy(gfta_US_SprtSet_G9925B, gfta_US_SprtSet_G9923B_KPN, sizeof(uint8));
    }
#endif

   //XDSLRTFW-2442 OSC_AmplitudeControl (Start)
   if(gt_ApiOptions.us_Opt_Offset0 & CMV_TO_ENABLE_XO_LOW_OSC_DRIVE)
   {
      ProgramOSCDriveLevel(0x0000);
      //XO_CTL_AFE_SET(0x0000); // if "low" oscillator drive level
      gl_initfreqoffset = gl_initfreqoffset + (int32)((gs_lowOscOffset_ppm) * (-16));
   }
   else
   {
      ProgramOSCDriveLevel(0x0400);
      //XO_CTL_AFE_SET(0x0400); // if "high" oscillator drive level
      gs_lowOscOffset_ppm = 0;
   }
   //XDSLRTFW-2442 OSC_AmplitudeControl (end)
   //XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [Start]
   gl_initfreqoffset = gl_initfreqoffset + (int32)((gs_InitFreqOffsetDelta_ppm) * (-16));
   //XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [End]

   //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
   // To force G.dmt Annex A if NLNF measurement is enabled.
   // This gives better performance for NLNF.
   // This can be enabled by CMV bit-2 of DSL 13 0
   // (default "0" means enabled)
   // and "cw test 7 0 0x7FD0" without SW API support
   // or enabaled by cw cntl 0 0 0x09 with SW API support.
   //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (start_end)
  if (((gt_ApiOptions.us_Opt_Offset0 & CMV_BIT2_TO_ENABLEE_NLNF_STARTUP) &&
      (TESTArray[TEST_RxSubState] == CMV_TEST70_RX_NLNF_TRIGGERED)) ||
      (CNTLArray[CNTL_ModemControl] == CNTL_ModemNLNF))
  {
      OPTNArray[OPTN_ModeControl] = (int16) OPTN_ConfigMode_G992_1_A;
      OPTNArray[OPTN_StateMachineCtrl] &= (~OPTN_FFT1024_Enable);
  }
#endif //#ifndef ISDN
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)

   /* =============================================================================== */
   /* Select DMT or BIS (or both?)     */
   /* =============================================================================== */
   gul_ModeControl = ((uint32)OPTNArray[OPTN_ModeControl]&0xFFFF) |  (uint32)(OPTNArray[OPTN_ModeControl1]<<16);
   if ( (gul_ModeControl & (STAT_ConfigMode_G992_3_ALL | STAT_ConfigMode_G992_5_ALL)) != 0) // Bis or plus bit is set
   {
      gft_ModemType = G_DMT_BIS;

      // We delay the initialization of some G.HS BisInfo Tx members here
      // because those info are controlled via CMV. Therefore we have
      // to wait until all the CMVs have been processed
      /* Initialize Bis (ADSL2) Information in TxInfo */
      for (i = 0; i < NUM_G992_3_ANNEX_SUPPORTED; i++)
      {
         gs_Preferred_PSDMask_G9923x[i] = sa_Preferred_PSDMask_G9923x[i];
         InitGlobalVariables2_BisInfoTx(gpt_TxInfo->pta_G9923xInfo[i], i);
         InitGlobalVariables2_BisInfoRx(gpt_RxInfo->pta_G9923xInfo[i], i);
      }
      for (i = 0; i < NUM_G992_5_ANNEX_SUPPORTED; i++)
      {
         gs_Preferred_PSDMask_G9925x[i] = sa_Preferred_PSDMask_G9925x[i];
         InitGlobalVariables2_BisPlusInfoTx(gpt_TxInfo->pta_G9925xInfo[i], i);
         InitGlobalVariables2_BisPlusInfoRx(gpt_RxInfo->pta_G9925xInfo[i], i);
      }

      if((OPTNArray[OPTN_AlgControl] & OPTN_MedleyControlMask) != 0) // MedleyTdqOff, MultiTdq, MultiSync or MedleyFdq is on
         gt_RMsgs1_bis.uc_CA_MEDLEYds = guc_R_C_MEDLEY_LENGTH_DIV_512;    // Regular length
      else
         gt_RMsgs1_bis.uc_CA_MEDLEYds = guc_R_C_MEDLEY_LENGTH_DIV_512_DEBUG; // short length

      if ((gul_ModeControl & STAT_ConfigMode_G992_5_ALL) != 0)
      {
         if ((OPTNArray[OPTN_StateMachineCtrl] & OPTN_G992_5_14thOrderPRBS_Enable) )
            gt_RMsgFmt_bis.uc_MedleyPRBSus = 1;          /* use 14th order medley sequence */
         else
            gt_RMsgFmt_bis.uc_MedleyPRBSus = 0;          /* default use dmt medley sequence */
      }

   }
   else{
      gft_ModemType = G_DMT;
   }

#ifndef HERC_API
   /* =============================================================================== */
   /* Set STAT CMV to indicate that TDQ runs at 1.1MHz if necessary */
   /* =============================================================================== */
   if (OPTNArray[OPTN_AlgControl] & OPTN_Run_TDQ_at_1104)
   {
      STATArray[STAT_Misc] |= STAT_TDQ_at_1104;
   }
#endif // #ifndef HERC_API


   /* =============================================================================== */
   /* Update Tx FFT length and registers for a chosen IFFT size*/
   /* =============================================================================== */
#ifdef IFFT128
   /* IFFT size is always 128 in HWEngine 3.0 (Socrates Plus chip) since we use emulated 64 pt IFFT if required */
   gs_TxFftLength = 128;
   gs_TxCPLength = (int16) (gs_TxFftLength>>4);

   /* Compute log2(gs_TxFftLength)-1 = log2(gs_TxFftLength/2) */
   gs_TxLog2FftLength1 = 0;
   s_temp = (gs_TxFftLength >> 1);
   while((s_temp&1) == 0)
   {
      gs_TxLog2FftLength1++;
      s_temp >>= 1;
   }
#endif //#ifdef IFFT128



   /* =============================================================================== */
   /* Update Rx FFT length for 1024 point IFFT */
   /* =============================================================================== */

   if ((OPTNArray[OPTN_StateMachineCtrl] & OPTN_FFT1024_Enable))
   {
      /* Update f/w variables to correspond to using 1024 pt FFT */
      gs_RxFftLength = 1024;
      gs_RxNumTones = 512;
      gs_numAecLMSIterations = 12;  /* we run out of MIPS here with 1024 samples/frame with default value of 16 */
                              /* Empirically, 12 iterations seems to be fine with 1024 samples/frame on Socrates+ */
#ifdef TARGET_HW
      gs_presync_stepsize = 2;
#endif

      // gs_RxFftLength would have changed.
      gs_RxCPLength = gs_RxFftLength >> 4;
      gs_RxSamplesPerFrame = gs_RxFftLength;
      /* Compute log2(gs_RxFftLength)-1 = log2(gs_FftLength/2) */
      gs_RxLog2FftLength1 = 0;
      s_temp = (gs_RxFftLength >> 1);
      while((s_temp&1) == 0)
      {
         gs_RxLog2FftLength1++;
         s_temp >>= 1;
      }
      /* Compute log2rxnumsamples */
      s_temp = gs_RxSamplesPerFrame;
      gs_Log2RxSamplesPerFrame = 0;
      while((s_temp&1) == 0)
      {
         gs_Log2RxSamplesPerFrame++;
         s_temp >>= 1;
      }

      // gs_RxNumTones would have changed.
      gs_RxLastChannel = gs_RxNumTones-1;
      gus_Rx_MaxToneIndx = gs_RxNumTones-1;
      DisableFDQ();  // Reload UnityFdq
   }

#ifdef ADSL_62 //ADSL_62 requires the gs_TxFftLength >=gs_RxFFtLength
   /* =============================================================================== */
   /* Update Tx FFT length and registers for a chosen IFFT size*/
   /* =============================================================================== */
   /* IFFT size is always 128 in HWEngine 3.0 (Socrates Plus chip) since we use emulated 64 pt IFFT if required */
   if (gft_V14 ==1)
   {
      gs_TxFftLength_Oversample = 512;
      gs_TxCPLength_Oversample = 32;
      gs_TxLog2FftLength1_Oversample = 8;
   }
   else
   {
      gs_TxFftLength_Oversample = gs_RxFftLength;
      gs_TxCPLength_Oversample = gs_RxCPLength;
      gs_TxLog2FftLength1_Oversample = gs_RxLog2FftLength1;
   }

#endif //#ifdef ADSL_62

   /* =============================================================================== */
   /* Update DEC Upsampling factor based on Rx FFT and Tx IFFT Lengths */
   /* =============================================================================== */
#ifndef ADSL_62
    for(gs_DECUpsamplingFactor=1, s_temp=gs_TxFftLength; s_temp<gs_RxSamplesPerFrame; s_temp<<=1)
        gs_DECUpsamplingFactor <<= 1;
#else
   for(gs_DECUpsamplingFactor=1, s_temp=gs_TxFftLength_Oversample; s_temp<gs_RxSamplesPerFrame; s_temp<<=1)
        gs_DECUpsamplingFactor <<= 1;
#endif


   /* =============================================================================== */
   /* Update Iridia based on Rx FFT and Tx IFFT Lengths                       */
   /* =============================================================================== */
   Reconfig_IRI();

#ifndef ADSL_62
    /* =============================================================================== */
   /* Update Strymons SMODE Register based on Rx FFT and Tx IFFT Lengths            */
   /* =============================================================================== */
   Reconfig_STR_SMODE();
#else
    /* ==================================================================================== */
   /* update Strymons sample rate (input rate of each block) due to fft/ifft length change */
   /* =====================================================================================*/
    Reconfig_DFE_SampleRate();
#endif

   /* =============================================================================== */
   /* Update Strymons Filters based on above reconfigs (SMODE registers/DEC Length)   */
   /* =============================================================================== */
   Reconfig_DFE_Rx();
   Reconfig_DFE_Tx();

   /****************************************************************************/
   /* We cannot truly multimode yet. Hence we set some firmware settings based */
   /* on specific modes that OPTNArray[OPTN_ModeControl] supports          */
   /****************************************************************************/
   gs_min_pga_setting = AFED_MinPGASetting(); //-17dB
   gs_min_pga_setting_RefPCB = -12 << 8;

#ifdef ISDN /* Annex B/J/M */
   /* Digital and Analog filters to be used */

   /* Reconfig strymon s/w filter coefs for Annex B/M/J operation */
   /* Use the most Annex-B filters in oISDN binary                 */
   /* Reconfigure them post-handshake again based on selected mode */

   //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (Start)
   // PSD violation in ADSL G.Hs if Annex-J mode is enabled - Jira XDSLRTFW-258
   // In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
   // in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
   // tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
   // PSDs because of the reconfiguration of the tx-path after G.Hs
   // As Annex-J activation tones are currently not used in any field deployment the activation
   // tones and G.Hs filter configurations are hard-coded to Annex-B.
   // this part of the code is called only in LinkStartForTest.c

    //Reconfig_STR_FW(ANNEX_B);

   // XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs (Start)
    // Configure link start with Annex J setting before GHS.
   // This will configure the Tx IIR filter to Annex J (Mask 5-9) filter
   // After GHs the mode is determined. Then, use the appropriate Annex B filter
   // if the mode is Annex B or use the appropriate Annex J filter if the mode is Annex J
   Reconfig_STR_FW(ANNEX_J);
    // // XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs (End)

   //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (End)

   /* Reconfig AFE filters for Annex B/M/J operation */
   /* Specifically, AFE High pass filters */
   /* No reconfiguration required post-handshake given multi-mode between B/J/M */
      if (gs_ForceGainPofi_dB != -1)
      {
         //memset(sa_PilotToneIdxArray, (int16)(-1), sizeof(int16)*MAX_NUM_RX_BANDS);
         gsa_gain_pofi_dB[BYPASSED]    = gs_ForceGainPofi_dB;
         gsa_gain_pofi_dB[VDSL35b_CPE] = gs_ForceGainPofi_dB;
         gsa_gain_pofi_dB[VDSL17_CPE]  = gs_ForceGainPofi_dB;
         gsa_gain_pofi_dB[VDSL8_CPE]   = gs_ForceGainPofi_dB;
         gsa_gain_pofi_dB[ADSL2_CPE]   = gs_ForceGainPofi_dB;
         gsa_gain_pofi_dB[VDSL30_CPE]  = gs_ForceGainPofi_dB;
      }

      //Initialize DFI with 17a configuration since,
      //both FFT & IFFT will be configured with 4K tones before G.hs.
      //Do the reconfigure once more after the profile is selected.

      //DFE-AFE Startup Sequence as in Page 101 of Strymon-VFDF_xDSL_CPE_bonded_v3.1 04
      //The startup handshake between the DFE and AFE needs to follow a proper sequence otherwise the expected behaviour
      //cannot be ensured. The sequence below details the order in which the various modules are enabled. The sequence is for
      //the data path and should only be done after the power sequence. There maybe other steps or configurations between
      //each step, but the following sequence needs to be adhered to.
      //1. Put Strymon in reset state by setting RESET_STATEN=0
      //2. Configure Strymon/DFI for both Tx and Rx. This step setup the time domain modules to the desried data rate
      //and profiles.
      //3. Configure AFE for both Tx and Rx via the FCSI-D interface for data rate that matched to the DFE side,
      //4. Only after both DFE and AFE are setup correctly and enabled, then DFE-AFE interface FIFO can be
      //enabled.No read/write of the FIFO can happen before it is enabled. Any read attempt will return 0 and write
      //attempt is ignored.
      //5. Put Strymon out of reset by setting RESET_STATEN=1

      gul_Afe_flowtest |=0x100;

      //CHECK_VRX518AFE
      //Initialize DFI with 17a configuration since,
      //both FFT & IFFT will be configured with 4K tones before G.hs
      /// In VRX318, DFE/DFI is configured for 17 a mode, But only AFE RX path configured for ADSL2 mode
      //With that change GHS loop reach increased by 500M. This type of change may not be possible on VRX518 because
      // DFE if configured for 17a means 288MSPS and AFE RX in ADSL means 144 MSPS NOT a valid configuration,

      {
         //Later if someone wants to try other than 17a before GHS
          gus_AFE_RxMode = ADSL2_CPE;
          gus_AFE_TxMode = ADSL2_CPE;
      }
      //Used below hybrid setting for handshake. when we change the hyb for HSK, then we have to update this variable gs_HybridGainRef
      //{ 0x0253,     0x063F,          0x0414,       0xF84F},  //  0   -7.6930   123  210     1600   145   1p   133   off   1p Null Loop
      //gs_HybridGainRef = (int16)  0xF84F;//   -7.6930  CHECK_VRX518AFE
      //AFED_ModeConfig();
      AFED_HskQlnHlogSetHybrid();
      gs_Hyb_Hsk_QlnHlog = 2; //QLN/HLOG
      //Reconfig_AFE();
      gul_Afe_flowtest |=0x200;

#else /* Annex A/I/M */
   /* Load appropriate filters for sleep mode based on preferred mode and mask. */
  //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
   if ((CNTLArray[CNTL_ModemControl] & CNTL_ModemSleep) ||
       (CNTLArray[CNTL_ModemControl] == CNTL_ModemNLNF))
#else
  if (CNTLArray[CNTL_ModemControl] & CNTL_ModemSleep)
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
   {
      /* Use 512 point FFT in DMT, Lite, and Annex A/L Bis modes; use 1024 point FFT in all other modes. */
      if ((gul_ModeControl & (~(STAT_ConfigMode_G992_1_ALL | STAT_ConfigMode_G992_2_ALL | STAT_ConfigMode_G992_3_A | STAT_ConfigMode_G992_3_L))) == 0)
      {
         OPTNArray[OPTN_StateMachineCtrl] &= (~OPTN_FFT1024_Enable);
      }
      /* Reconfigure filters and AFE for Annex M. */
      if (gul_ModeControl & STAT_ConfigMode_AnnexM_ALL)
      {
         Reconfig_STR_FW(ANNEX_M);
         gul_Afe_flowtest |=0x400;

            //CHECK_VRX518AFE
            //Initialize DFI with 17a configuration since,
            //both FFT & IFFT will be configured with 4K tones before G.hs
            /// In VRX318, DFE/DFI is configured for 17 a mode, But only AFE RX path configured for ADSL2 mode
            //With that change GHS loop reach increased by 500M. This type of change may not be possible on VRX518 because
            // DFE if configured for 17a means 288MSPS and AFE RX in ADSL means 144 MSPS NOT a valid configuration,

            {
               //Later if someone wants to try other than 17a before GHS
                gus_AFE_RxMode = ADSL2_CPE;
                gus_AFE_TxMode = ADSL2_CPE;
            }
            //Used below hybrid setting for handshake. when we change the hyb for HSK, then we have to update this variable gs_HybridGainRef
            //{ 0x0253,     0x063F,          0x0414,       0xF84F},  //  0   -7.6930   123  210     1600   145   1p   133   off   1p Null Loop
            //gs_HybridGainRef = (int16)  0xF84F;//   -7.6930  CHECK_VRX518AFE
         //AFED_ModeConfig();
         AFED_HskQlnHlogSetHybrid();
         gs_Hyb_Hsk_QlnHlog = 2; //QLN/HLOG
         //Reconfig_AFE();

      }
      /* Reconfigure filters for Annex L mask 2. */
      else if ((gul_ModeControl & STAT_ConfigMode_AnnexL_ALL) && ((OPTNArray[OPTN_AnnexControl] & OPTN_G992_3_AnnexA_PreferredModeMask) == OPTN_G992_3_AnnexA_PreferredModeL2))
      {
         STATArray[STAT_Misc] |= STAT_AnnexL_US_Mask2_PSD;
         Reconfig_STR_FW(ANNEX_L);
      }
   }
   /* Reconfig AFE filters for Annex A/I/M operation */
   /* Specifically, AFE High pass filters  now happens  */
   /*  post-handshake for multi-mode between A/I && M */
#endif

#if 0
   // Debug - Overwriting the Tx, Rx Mode registers
   if(gft_AFE_RxMode_Overwrite == TRUE)
   {
     VR9_ConfigAFERxPath_Forced();
   }
   if(gft_AFE_TxMode_Overwrite == TRUE)
   {
     VR9_ConfigAFETxPath_Forced();
   }
#endif
   /* =============================================================================== */
   /* Load TX Sine Gain */
   /* =============================================================================== */
   gus_TxSineGain = gus_TxGain_NoCutBack;
   LoadTxSineGain();

   /* =============================================================================== */
   /* Take Strymon out of reset. */
   /* =============================================================================== */
   Strymon_ClearResetState();

   /* =============================================================================== */
   /* If Alphaeus is enabled, we may want to put it in transparent mode */
   /* =============================================================================== */

   if ((TESTArray[TEST_Control] & TEST_AlphaeusControl) != 0
      && (TESTArray[TEST_Control] & TEST_AlphaeusTPEnable) != 0)
   {
      EnableAAI_TPMODE();
   }


   // Set default values to fft buffer control OPTN
   // TEMPORARY-- Until we get rid of this altogether
   OPTNArray[OPTN_FFTBufferControl] =  OPTN_ShowtimeScenario3 | OPTN_TrainScenario1 ;
#ifndef ADSL_62_DEC_DEBUG
   SetInitialTDQ();

   LoadDECTDQ();
#endif
   if (OPTNArray[OPTN_StateMachineCtrl] &OPTN_ForceExplicitRate)
      CNTLArray[0] |= CNTL_ExpilictRate;

#ifndef TARGET_HW
   //Enable time-slot control
   EnableTSC();
#endif

   //XDSLRTFW-3708 Control of GPIO14 to indicate dying gasp for ADSL (Start)
   if (gus_Cnfg_Misc & CNFG_MISC_VRX518_ENABLE_GPIO14_FOR_DYING_GASP)
   {
      InitVRX518Regs_for_Gpio14();
   }
   //XDSLRTFW-3708 Control of GPIO14 to indicate dying gasp for ADSL (End)



}
/*^^^
*-------------------------------------------------------------------
*
*  void LinkStart(void)
*
*  Description:
*
*     This function uses the CMV's to configure the modem when
*  CNTL is used to start a link and G.HS IS the initial state
*  (i.e. during the normal modem mode of operation).
*
*
*-------------------------------------------------------------------
*^^^
*/


void EnableCores_ForLinkStart(void)
{

   //Enable cores through CRI registers
   InitCRI_ForLinkStart();

   //Take Strymon out of reset mode
   EnableStrymon();

}


void LinkStart(void)
{
   int16 *lp_PersistMemPtr = (int16 *)(void *)&gl_SelectedMode;

   CheckModemMonitor0Config();

    //Call the function for updating the tables as per the CMV specific
   vrx5afe_get_dsl_version_init(1);
   ConfigEngineForLinkStart();

   //XDSLRTFW-241: FIX_ALL_ALL_ALL_Clear_Persistent_Memory (Start)
   if (gl_Test_Persistmem != 0x12345678)
   {
      MemSetBuffer( (int16*)lp_PersistMemPtr,0,0,PERSISTENT_MEM_SIZE);
      gl_Test_Persistmem = 0x12345678;
   }
   //XDSLRTFW-241: FIX_ALL_ALL_ALL_Clear_Persistent_Memory (End)

   lp_PersistMemPtr = (int16 *)(void *)&gl_Test_Persistmem_Common;
   if (gl_Test_Persistmem_Common != 0x12345678)
   {
       MemSetBuffer( (int16*)lp_PersistMemPtr, 0, 0, 32);
       gl_Test_Persistmem_Common = 0x12345678;
   }
   ConfigTaskLayerForLinkStart();

#ifndef TARGET_HW
   if ((gul_ModeControl & STAT_ConfigMode_G992_5_ALL) != 0)
      gs_AtoD_PutPtr = (3*(1024+64))/2;
   else
      gs_AtoD_PutPtr = (3*(512+32))/2;
#endif

   /*==============================================================*/
   /* Update STAT */
   /*==============================================================*/

   STATArray[STAT_MacroState] = STAT_ReadyState;
   gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ReadyState;
   gusa_HercADSL_MONIMap_Curr[0] = MONI_READY;


   //XDSLRTFW-960 (start)
   gt_HercADSL_STATMap_ModeSelect.s_Offset0 = 0;
   gt_HercADSL_STATMap_ModeSelect.s_Offset1 = 0;
   //XDSLRTFW-960 (end)





}


