/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   LinkStartForTest.c
 *
 *
 *----------------------------------------------------------------------------
 */
#include "const.h"
#include "file_io.h"
#include "gdata.h"
#include <stdio.h>
#include <stdlib.h>
#include "modem_hw.h"
#include "InitBMf.h"
#include "trail.h"
#include "trailend.h"
#include "file_io3.h"
#include "ghs.h"
#include "string.h"
#include "cmv.h"
#include "channel.h"
#include "bert.h"
#include "STR_IOf.h"
#include "ALP_IOf.h"
#include "stateini.h"
#include "ec_data.h"
#include "gdata_bis.h"
#include "sach.h"    // For Sachmo channel
#include "cnfg_eng.h"
#include "cnfg_task.h"
#include "iri_ini.h"
#include "LinkStart.h"
#include "codeswap.h"
#include "DSLEngin.h"
#include "str_ini.h"
#include "statein1.h"
#include "hndshk_Data.h"
#include "bitload_const.h"
#include "hs_misc.h"
#include "post_hsk.h"

//#define ADSL_62_DEC_DEBUG

#ifdef TARGET_SIM

/*-------------------------------------------------------------------
   *
   *  void ConfigForLinkStartAndTest(void)
   *
   *  Description:
   *
   *
   *
   *-------------------------------------------------------------------
   *^^^
   */
void ConfigForLinkStartAndTest(void)
{

   if (OPTNArray[OPTN_ModeControl] & (OPTN_ConfigMode_G992_1_B  | OPTN_ConfigMode_G992_3_B))
      gs_downSampleCnt = 8;   /* DLI Tx input at 552 KHz*/
   else
      gs_downSampleCnt = 16;  /* DLI Tx input at 276 KHz*/

   /*==============================================================*/
   /* The following items default OFF           */
   /* and may be turned on via TEST control     */
   /*==============================================================*/

   if ((TESTArray[TEST_Control] & TEST_BertControl) != 0)
   {
      MPHandler_BERT();
   }
   if ((TESTArray[TEST_Control] & TEST_BertSFControl) != 0)
   {
      MPHandler_BERT_SF();
   }
   if ((OPTNArray[OPTN_AlgControl] & OPTN_TCM_Disable) == 0)
   {
      MPHandler_TCM();
   }
   if (gft_ModemType == G_DMT_BIS && ((TESTArray[TEST_Control] & TEST_BISUSTCMDisable) == 0))
   {
      gft_TcmFlag_bis_US = TRUE;
   }
   if ((TESTArray[TEST_Control] & TEST_ConnControl) != 0)
   {
      MPHandler_CONN();
   }

   if ((TESTArray[TEST_Control] & TEST_StryControl) == 0)
   {
      /* Bypass Strymon core for testing */
      MPHandler_STRY();
   }
   else
   {
      /*==============================================================
      Whenever we run the Strymon core (call GetRxInputSample()),
          we always call channel to do interpolation, even if
          we do not run the actual channel filter.  The following
          function call selects the proper upsampling ratio and the
          corresponding interpolation filter.
         ==============================================================*/
            InitInterp();
   }


   ConfigBERT();

   /*==============================================================*/
   /* Adjustments based on IFFT size            */
   /*                                  */
   /*==============================================================*/

#ifdef IFFT128

    if (gs_TxFftLength == 128) {

      gs_IridiaUpClockPeriod = 384;
      gs_FirstTimeCounter = 0;
   }
    else {


      gs_IridiaUpClockPeriod = 512;


      gs_FirstTimeCounter = 4;
   }

   /* Set the default input/output buffer sizes */
   gs_Tx_OutBuf_Size = gs_TxFftLength;

#endif //IFFT128
}
/*^^^
*-------------------------------------------------------------------
*
* void LinkStartForInitialState(void)
*
*  Description:
*
*     This function uses the CMV's to configure the modem when
*  CNTL is used to start a link and G.HS is NOT the initial state
*  (i.e. during a test mode of operation).
*
*
*
*-------------------------------------------------------------------
*^^^
*/
void LinkStartForInitialState(void)
{
   int16 s_LEN_C_PARAMS_BITS, i;

   gul_ModeControl = ((uint32)OPTNArray[OPTN_ModeControl]&0xFFFF) |  (OPTNArray[OPTN_ModeControl1]<<16);

   // We delay the initialization here because those info are controlled via CMV.
   // Therefore we have to wait until all the CMVs have been processed
   /* Initialize Bis (ADSL2) Information in TxInfo */
   for (i = 0; i < NUM_G992_3_ANNEX_SUPPORTED; i++)
   {
      InitGlobalVariables2_BisInfoTx(gpt_TxInfo->pta_G9923xInfo[i], i);
   }
   for (i = 0; i < NUM_G992_5_ANNEX_SUPPORTED; i++)
   {
      InitGlobalVariables2_BisPlusInfoTx(gpt_TxInfo->pta_G9925xInfo[i], i);
   }

   //==========================================================================
   // If not running handshake, need to load the codeswap pages for the initial state
   // (Socrates)
   //==========================================================================
   LoadCodeSwapPagesForInitialState();

   //==========================================================================
   // Set Tx/Rx configuration numbers
   //==========================================================================

   gus_tx_config_num = (uint16)TESTArray[TEST_TxConfigNum];
   gus_rx_config_num = (uint16)TESTArray[TEST_RxConfigNum];

#ifndef HERC_API
   /* Set STAT CMV to indicate that TDQ runs at 1.1MHz if necessary */
   if (OPTNArray[OPTN_AlgControl] & OPTN_Run_TDQ_at_1104)
      STATArray[STAT_Misc] |= STAT_TDQ_at_1104;
#endif // #ifndef HERC_API

   // If not running handshake, need to set the Link status (STATArray[STAT_Mode]),
   // manually according to the specified link type (OPTNArray[OPTN_ModeControl]).
   // Also need to do post-handshake initialization.

   ConfigEngineForLinkStart();

   if (TESTArray[TEST_InitState] != TEST_GhsInitState)
   {
      /* Set STAT CMV to indicate Lite mode if necessary */
      if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_2_AB) != 0)
         SetSelectedModeAnnex(G992_2_AB);



      if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_5_A) != 0)
         SetSelectedModeAnnex(G992_5_A);
      else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_5_B) != 0)
         SetSelectedModeAnnex(G992_5_B);
      else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_5_I) != 0)
         SetSelectedModeAnnex(G992_5_I);
      else if ((OPTNArray[OPTN_ModeControl1] & OPTN_ConfigMode_G992_5_M) != 0)
         SetSelectedModeAnnex(G992_5_M);
      else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_A) != 0)
         SetSelectedModeAnnex(G992_3_A);
      else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_I) != 0)
         SetSelectedModeAnnex(G992_3_I);
      else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_B) != 0)
         SetSelectedModeAnnex(G992_3_B);
      else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_3_M) != 0)
         SetSelectedModeAnnex(G992_3_M);
      else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_1_A) != 0)
         SetSelectedModeAnnex(G992_1_A);
      else if ((OPTNArray[OPTN_ModeControl] & OPTN_ConfigMode_G992_1_B) != 0)
         SetSelectedModeAnnex(G992_1_B);


      if (( gl_SelectedMode & (MODE_ADSL2)  ))
      {

         if(TESTArray[TEST_InitState] == TEST_ShowtimeInitState)
         {
            // preset R_C_PCB_Msg length for showtime only test
            if(gt_RCMsgFmt_bis.us_FMT_C_MSG_PCB == 0)
            gs_C_PCB_Frame_Len = ((int16)(R_C_MSG_PCB_RX_LEN1_BIS) - (int16)(C_MSGFMT_CRC_NUM_OF_SYMBOLS))/24;
            else
            gs_C_PCB_Frame_Len = ((int16)(R_C_MSG_PCB_RX_LEN2_BIS) - (int16)(C_MSGFMT_CRC_NUM_OF_SYMBOLS))/24;

            // preset R_C_Params msg length for showtime only test
            if (( gl_SelectedMode & (MODE_G992_5)  ))
               s_LEN_C_PARAMS_BITS = (((LEN_C_PARAMS_PMD_HEADER + 2 + 2*(gs_TxNumTones-1) + 2*(gs_TxNumTones-1)) + LEN_C_PARAMS_PMS + LEN_C_PARAMS_CRC))*8;
            else
               s_LEN_C_PARAMS_BITS = (((LEN_C_PARAMS_PMD_HEADER + 1 + 2*(gs_TxNumTones-1) + (gs_TxNumTones-1)) + LEN_C_PARAMS_PMS + LEN_C_PARAMS_CRC))*8;

            gs_C_Params_Frame_Len = s_LEN_C_PARAMS_BITS/(2*NSC_C_PARAMS);
            if((gs_C_Params_Frame_Len*2*NSC_C_PARAMS) < s_LEN_C_PARAMS_BITS)
               gs_C_Params_Frame_Len++;

            // Define Supported set and clear medley set
               for (i=0 ; i<gs_RxNumTones ; i++)
            {
               CLEARTONEFLAG(p_MEDLEYset_DS, i);
               SETTONEFLAG(p_SUPPORTEDset_DS, i);
            }


         }

      }

      //initialize Transfer mode for BIS, by default as ATM
      for (i = 0; i < NUM_DS_BEARER_CHANNELS_SUPPORTED; i++)
         guca_DS_TransferMode_bis[i] = ATM;

      for (i = 0; i < NUM_US_BEARER_CHANNELS_SUPPORTED; i++)
         guca_US_TransferMode_bis[i] = ATM;
#ifdef ADSL_62_DEC_DEBUG
        gft_PilotOnDecTraining = FALSE;
#else
      /* Assume R-ACK2 if skipping handshake. */
      gft_PilotOnDecTraining = TRUE;
#endif

      SetLinkModeDependentVariables(); /* call before InitModemTasks_PostHandshake() */
      BGInitModem_PostHandshake();
   }

   /* =============================================================================== */
   /* Update Iridia based on post-handshake Rx FFT Length                        */
   /* =============================================================================== */
   Reconfig_IRI();

#ifndef ADSL_62
    /* =============================================================================== */
   /* Update Strymons SMODE Register based on Rx FFT and Tx IFFT Lengths            */
   /* =============================================================================== */
   Reconfig_STR_SMODE();
#else
    /* ==================================================================================== */
   /* update Strymons sample rate (input rate of each block) due to fft/ifft length change */
   /* =====================================================================================*/
    Reconfig_DFE_SampleRate();
#endif

   /* =============================================================================== */
   /* Update Strymons Filters based on SMODE registers                           */
   /* =============================================================================== */
   Reconfig_DFE_Rx();
   Reconfig_DFE_Tx();


   if ((OPTNArray[OPTN_ModeControl] & STAT_ConfigMode_G992_5_ALL) != 0)
      gs_AtoD_PutPtr = (3*(1024+64))/2;
   else
      gs_AtoD_PutPtr = (3*(512+32))/2;




   /*==============================================================*/
   // Perform portion of configuration that depends on the test type (initial state),
   /* i.e., G.hs, full init, showtime, fast retrain, etc.
   /*==============================================================*/

   ConfigForLinkStartAndTest();
   ConfigTaskLayerForInitialState();
   ConfigEngineForInitialState();
}


#endif   // TARGET_SIM
