/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   main_hw.c
 *
 *   Exec for Bit true models
 *
 *---------------------------------------------------------------------------
 */

#include "const_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "cmv.h"
#include "bert.h"
#include "enc_gain.h"
#include "tone_ord.h"
#include "dec_gain.h"
#include "cnfg_task_utils.h"
#include "olr_Bpn_check.h"
#include "showinit_olr.h"
#include "states.h"

int32 gl_StartingRxSymbolCount=0;

/*^^^
*-------------------------------------------------------------------
*
*  void SimulateOLR(void)
*
*  Description:
*
*     This function initiates the OLR state machine
*
*-------------------------------------------------------------------
*^^^
*/
void SimulateOLR(void)
{
   static int16 s_rxReconfigCount=0;

   // OLRs require a valid showtime SNR.
   if (gus_ShowtimeSNRUpdateCount == 0)
      return;

   if (gl_StartingRxSymbolCount == 0)
      gl_StartingRxSymbolCount = gl_RxSymbolCount;

   /* Kick off the SRA test in superframe 3 */
   if((s_rxReconfigCount == 0) && (gl_RxSymbolCount == gl_StartingRxSymbolCount + 3*69))
   {
      /* Enable the SRA test */
      TESTArray[TEST_ReconfigControl] |= TEST_TestOLR;

      /* Add to LP0 data path */
      TESTArray[TEST_OLR_Lp0Delta] = -2;
      TESTArray[TEST_OLR_Lp1Delta] = 5;

      TESTArray[TEST_OLR_BC0Delta] = -1;
      TESTArray[TEST_OLR_BC1Delta] = 2;


//    TESTArray[TEST_OLRGainDelta] = 0x2000;
      s_rxReconfigCount++;
   }

   /* Kick off the DRR test in superframe 20 */
   if((s_rxReconfigCount == 1) && (gl_RxSymbolCount == gl_StartingRxSymbolCount + 20*69))
   {
      /* Enable the DRR test */
      TESTArray[TEST_ReconfigControl] |= TEST_TestOLR;

      /* Add to LP0 data path and subtract from LP1 data path */
      TESTArray[TEST_OLR_Lp0Delta] = 2;
      TESTArray[TEST_OLR_Lp1Delta] = -2;
      TESTArray[TEST_OLR_BC0Delta] = 0;
      TESTArray[TEST_OLR_BC1Delta] = 0;
      s_rxReconfigCount++;
   }



   /* Kick off the bitswap test in superframe 30 */
   if((s_rxReconfigCount == 2) &&(gl_RxSymbolCount == gl_StartingRxSymbolCount + 30*69))
   {
      /* Enable the bitswap test */
      TESTArray[TEST_ReconfigControl] |= TEST_TestBitswap;

      TESTArray[TEST_BitSwapFromTone] = 0x28;
      TESTArray[TEST_BitSwapToTone] = 0x29;
      s_rxReconfigCount++;
   }

}

void SimulateOLRPMOvhdMsg(void)
{
   // Bis bit is set, Simulate OLR/PM/OvhdMsg tests for BIS mode only
   if (OPTNArray[OPTN_ModeControl] & STAT_ConfigMode_G992_5_ALL) // Bis or plus bit is set
   {
      /* If testing OLR/PM with messaging ie. simulation at only rx (cpe) end */
      if((TESTArray[TEST_ReconfigControl] & TEST_OvhdMessaging) != 0)
      {
         SimulateOLR();
      }
   }

}

