/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   File Name: RunCores.c
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "cri_cocomo_interface.h"
#include "DetectInterrupts.h"
#include "cmv.h"
#include "corexec.h"
#include "modem_hw.h"

extern FlagT PollForExitRequest(void);
extern int16 gs_TmpTxOutBufIndex_Oversample;
/*
*-------------------------------------------------------------------------------
*
*  Prototype: int16 RunCores(void)
*
*  This function clock cores until an interrupt occurs.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

int16 RunCores(void)
{
   int16 s_Interrupt_Detected;
   static FlagT ft_ExitRequest=0;
   uint32 ula_int0[2], ula_int1[2];
   int16 s_ReturnVal;

   s_Interrupt_Detected = 0;

   while(!s_Interrupt_Detected && !ft_ExitRequest)
   {
        if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState)
            ClockCores_NoStrymon(1, ula_int0, ula_int1);
        else
      ClockCores(1, ula_int0, ula_int1);

      if((ula_int0[guc_ch_id] != 0) || (ula_int1[guc_ch_id] != 0))
         s_Interrupt_Detected = DetectInterrupts();

   }

   if (gs_rxFrameInt == 1) {
      gs_rxFrameInt = 0;
      gl_RxFrameCnt++;
   }


   if (gs_txFrameInt == 1) {
      // for DLI connectivity only
      if ((TESTArray[TEST_Control] & TEST_ConnControl) &&
         ((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0) &&
         ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0)) {
         // for SHOW connectivity
         if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState) {
            if (!(OPTNArray[OPTN_ModeControl] & (OPTN_ConfigMode_G992_1_B | OPTN_ConfigMode_G992_3_B))) {
               if (gs_TxFftLength == 128) {
                  // down sample by 2 (Downsampler in SWE has a gain of 2)
                  DownSampler(gsa_TmpTxOutBuf,gsa_TmpTxOutBuf,gs_TmpTxOutBufIndex, 2);
                  gs_TmpTxOutBufIndex >>= 1;
               }
            }
            if (gl_TxFrameCnt >= R_PRE_SHOWTIME_LEN) {
               if (!DliHandler(gsa_TmpTxOutBuf, gs_TmpTxOutBufIndex, gs_Tx_OutBuf_Size, &gft_ResetDmaPtr))
                  ft_ExitRequest = 1;
            }
         // for GHS and TRAIN connectivity
         } else {
            if (!DliHandler(gsa_TmpTxOutBuf, gs_TmpTxOutBufIndex, gs_Tx_OutBuf_Size, &gft_ResetDmaPtr))
               ft_ExitRequest = 1;
         }
         if (gs_FirstTimeCounter == 0)
            gs_Tx_OutBuf_Size = gs_TmpTxOutBufIndex;
         else
            gs_FirstTimeCounter--;
      }
      gs_TmpTxOutBufIndex = 0;
        gs_TmpTxOutBufIndex_Oversample = 0;
      gs_txFrameInt = 0;
      gl_TxFrameCnt++;
   }

   if(ft_ExitRequest)
      s_ReturnVal = (int16)FAIL;
   else
      s_ReturnVal = (int16)SUCCEED;

   return (s_ReturnVal);
}
