/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   RunModem.sc
 *
 *   Exec for Bit true models
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "mtkernel.h"
#include "cmv.h"
#include "fifo.h"
#include "ovhd_bis.h"
#include "tx_ovrhd_bis.h"
#include "rx_ovrhd_bis.h"
#include "bert.h"
#include "states.h"
#ifdef DEBUG_STREAMING
#include "DebugBuffer.h"
#endif

extern int16 FGActive;

/*****************************************************************************
;  Prototype:  int16 RunModem(void)
;
;  This subroutine is called to service interrupts (time-critical and
;  non-time-critical tasks) and to run background tasks. The state
;  machine is run as a non-time-critical task. Background tasks are
;  initiated by the state machine.
;
;  Input Arguments: none
;
;  Output Arguments: none
;
;  Return:
;     SUCCEED           - continue
;     FAIL           - stop/exit
;
;  Global Variables:
;     gs_RxState        - (I) current RX state
;     gs_RxDoneState    - (I) RX done state
;     gs_RxStopState    - (I) TX stop state
;     gs_RxNextState    - (I) RX next state
;     gs_TxState        - (I) current TX state
;     gs_TxDoneState    - (I) TX done state
;     gs_TxStopState    - (I) TX stop state
;     gs_RxNextState    - (I) TX next state
;
;****************************************************************************/
int16 RunModem(void)
{
   void (*BGTask)(void);

   /* ================================================================================ */
   /* Service interrupts and run state machine.                            */
    /* ================================================================================ */
   MasterIntHandler();

   /* =============================================================================== */
   /*  if processing is done, break */
   /* =============================================================================== */
   if ((gs_TxState == gs_TxDoneState) && (gs_RxState == gs_RxDoneState)) {
      fprintf(stderr, "processing halted (RX and TX done state)\n");
      return((int16)FAIL);
   }

   if (isShowtime()) {
      if ((gs_bert_sf_cnt > 0) && (gl_TxSymbolCount > (gs_bert_sf_cnt*69+1))) {
         fprintf(stderr, "processing halted (reached max superframe count)\n");
         return((int16)FAIL);
        }
   }

   /* =============================================================================== */
   /*  check for any failures  */
   /* (Warning: this check should be commented out if it is desired to */
   /* make the program truely stops at stop state) */
   /* =============================================================================== */
   if ( (gs_RxNextState == gs_RxStopState) || (gs_TxNextState == gs_TxStopState) ) {
      fprintf(stderr, "processing halted (RX or TX stop state)\n");
      return((int16)FAIL);
   }

   /* =============================================================================== */
   /*  BackgroundTask processing */
   /* =============================================================================== */

   /* If there are pending Background processes, run them here */
   while(RemoveFunctionFromBkgdFifo(gp_BGTaskFifo , &BGTask))
      (BGTask)();

   if(gft_ModemType == G_DMT_BIS)
   {
      /* Process the overhead byte to be transmitted here */
      if (gs_TxState == 47)
         TxHDLCProcessor();

      /* Process the received overhead byte here */
      if (gs_RxState == 94)
         RxHDLCProcessor();
   }

   return((int16)SUCCEED);
}
