/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

// ******************************************************************
// Vr9_1port_debug_data.c
//
// History
//
// 24/06/2011 Kannan: Added debug feature to measure the residual Echo on BT loops.
//                    It is disabled by default. It can be enabled using
//                    "VR9_DEC_TRAIN_DBG" defined ec_data.h
//                    Grep for XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA
//
// 12/08/2011 Vinjam/Kannan: Changed the memory location for "gsa_RxHlogDS[]" to get some free space in Bulk data memory.
//           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2   // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 30/12/2011 Sriram Shastry : Indicate VDSL2 annex bit and the corresponding Full CLR code points in handshake  during Full CLR message
//              Grep for XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 14/06/2012 Kannan:
//          1. FIFO3 can be used to get the debug data in Rx Path
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 18/06/2012 Raghu M L2 and Annex M changes
//                                              grep for        XDSLRTFQ-416 : Enhancement_ALL_BisPLus_ALL_L2
//                                                              XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M
//
// 07/06/2012 Vinjam: Added global buffer "gsa_RxWithOutVnSnrBuf[ ]"
//            to store the SNR with out virtual noise during show time, if DS virtual noise feature is triggered.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
// 08/11/2012 Anantha: 1. Added global array to store previous Average and present average margin per window
//                                         2. Added variable to store last loaded bin
//                              grep for XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
//
// 07/01/2013 Ram: Added fix for JIRA 575.
//                 Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//
// 27/2/2013 Vinjam: Memory Layout, Buffers Re-Shuffling to get free space in "BULK_DATA_RAM_DMSWAP".
//           Moved buffers (guca_fe_SystemVendorID[], guca_fe_SystemVersionNum[], guca_fe_SystemSerialNum[])
//           from "BULK_DATA_RAM_DMSWAP" to "ONE_PORT_DEBUG_DATA"
//           Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 22/03/2013 Ram: Added variables for profiling code and for L2 fixes
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//26-03-2013 Anantha: Added data structure to trigger bitswap over stored SNR to increase bitswap speed
//                                        during RFI test
//                              grep pattern XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap
// 27/03/2013 Mahesh Set proper fuse data in AFE regs BIAS1 & DAC1_MISC1 & finetune PSD for all modes
//                                                Grep for XDSLRTFW-785: Bug_All_All_All_PsdAfeReg
// 22-04-2012 Anantha:Added data structres needed forshow time pilot tone averaging
//                                      grep for XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg
//
// 25/06/2013 Kannan: Added debug code to debug the DEC struck issue.
//            Grep for "XDSLRTFW-959 BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest"
//
// 14/11/2013 : Sriram Shastry : BroadCom CO goes to indefinite stuck state against VR9 based Arcadyan board.
// It has been observed that Arcardyan board perform the splitter switch during first
// training to configure the splitter during first training.
// CPE is not computing the downstream power cut back based on the C-Comb2 siganl due to internal computaion error.
// The solution is : Apply 3dB DSPCB against Broadcom CO upto 2000M . After 2Km apply 1dB of DSPCB against
// Broadcom CO in Annex-J mode only ( Applicable for 3J and 5J mode)
//                      Grep for XDSLRTFW-732 Feature_DS_B43_GHsTones_for_oISDN
//
// 04/01/2015 Anantha Ramu/TV Ram: Added fix for uncorrected DTUs due to Q full condition.
//            Grep for XDSLRTFW-1223.
// 18/11/2014 Vinay : Added a new CMV (INFO 241) to capture the configuration of ADSL as a debug feature.
//       Grep for XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES
// 30/11/2015 Fuss: No switch from ADSL binary to VDSL binary in case of 35b profile
//       Grep for XDSLRTFW-2513
//
//  2/12/2015 Sriram Shastry : Observed Quartz instabilities with  AVM  fritzbox[7490]. Added Detection algorithm for frequency drift and  phase drift
//  such that PLL adapt's to  fast setting  instead of  showtime setting .It helps to avoid showtime link drops in field
//
// Grep for : XDSLRTFW-2464
//
// *****************************************************************************************************************************

#include "common.h"
#include "zep_memmap_cnfg.h"
#ifdef HERC_API
#include "hmp.h"
#endif //HERC_API
// XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START)
#include "ec_data.h"
// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg(Start_End)
#include "ghs.h"





// XDSLRTFQ-416 : Enhancement_ALL_BisPLus_ALL_L2 (START)
uint8  guca_HistImp[16];
uint16 gusa_HistMetric[8];
// XDSLRTFQ-416 : Enhancement_ALL_BisPLus_ALL_L2 (END)

//XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start)
//Memory optimization. Moved the following "3" buffers from gadata.c file to VR9_1port_debug_data.c file
// (ADSL2 only) The system vendor info is obtained by sending an Inventory message to the CO.
uint8 guca_fe_SystemVendorID[VENDOR_ID_LENGTH];
uint8 guca_fe_SystemVersionNum[VERSION_NUM_LENGTH];
uint8 guca_fe_SystemSerialNum[SERIAL_NUM_LENGTH];
//XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (End)


//XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (START)
//int16 gus_TxGain_ADSL2_AnnexM[9]     = {5156,4868,9400,9230,10884,10394,10041,9800,9180};
// 9/Aug/2012, Mahesh: From Kais mail we see that AnxM PSD has to be reduced by 2.4,2,1.8,1.7,2.8,2.5,1.9,2,1.3dB
// for masks 1-9 respectively. Changing the above array accordingly
        //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
int16 gus_TxGain_ADSL2_AnnexM[9]     = {-24,-25,-26,-25,-29,-27,-25,-26,-28};       // XDSLRTFW-1850 : Cleanup of Tx path configuration(Start_End)


//int16 gus_TxGain_ADSL2Plus_AnnexM[9] = {5785,5461,10288,9825,12519,12087,11676,11280,10897};
// 7/Aug/2012, Mahesh: From Kais mail we see that AnxM PSD has to be reduced by 3.7, 2.7, 2.4, 2,2,1.6,1.7,1,0.4dB for
// masks 1-9 respectively. Changing the above array accordingly
        //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
  int16 gus_TxGain_ADSL2Plus_AnnexM[9] = {-23,-23,-23,-23,-2,-3,-3,-3,-2};       // XDSLRTFW-1850 : Cleanup of Tx path configuration(Start_End)
//XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (END)

// XDSLRTFW-443 FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)
//bit allocation saved before Bitswap
uint8 guca_RxBat_Before_BS[RX_NUM_TONES];
// XDSLRTFW-443 FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)
//grep for XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg(start)
int32 gla_RxPilotSum[2];
int16 gs_ClkCount1 = 0;
uint32 gul_ClkCount2 = 0;
int16 gsa_RxPilotAvg[2];
int16  gs_ClkAvgFact = 0;
int16 gs_LogClkAvgFact = 0;
//grep for XDSLRTFW-673: Enh_DS_ALL_ALL_ClkChg(end)

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//For debug
//int16 gs_dbg_idx;
//uint8 guca_ReTx_debug[10];

QretxTableEntry_t gta_QretxTable[QRETX_TRANS_TABLE_SIZE];
//XDSLRTFW-1634 (Start_End)
ReTxConfigInfo_t gt_ReTxConfigInfo;
ReTX_Stats_t gt_ReTXStats;
ReTX_Params_t gt_ReTXParams;
//XDSLRTFW-1223 Qrx Full Fix (Start)
#ifdef ENABLE_THREE_NEEDLE_TEST
uint8 guc_StartThreeNeedle;
uint8 guc_ThreeNeedleBadDTUCount;
uint8 guc_ThreeNeedleCount;
uint8 guc_CountToNextNeedle;
uint16 gus_ThreeNeedleDurationCount;
uint16 gus_ThreeNeedleDuration;
#endif

QueueNode_t gt_NodeList[QRETX_TRANS_TABLE_SIZE];
QueueStatus_t gt_FreeBufList;
uint8 guca_InpBufList[ILVB_WRPTR_TABLE_SIZE_LW];
uint8 guc_InpBufListIndx;
uint32 gula_ZrIlvbWrPtrTable[ILVB_WRPTR_TABLE_SIZE_LW];
//XDSLRTFW-1223 Qrx Full Fix (End)
uint32 gul_LEFTR_Defect_sec_cnt = 0;
uint32 gul_error_free_bit_cnt = 0;
uint32 gul_RETX_EFTR_min = 0;
uint32 gul_ReTx_ETR = 0;

uint32 gul_curr_EFTR;
uint32 gul_prev_EFTR;
uint32 gul_leftr_thresh;
uint32 gul_RxDtuCorrectedCNT=0;
uint32 gul_RxReTxDtuUncorrectedCNT=0;
uint32 gul_prev_RxReTxDtuUncorr;
//uint32 gul_EFD = 0;
// Add seftr as per Homework on BroadCom comment.
uint32 gul_sev_eftr = 0;
uint32 gul_DTUuc;

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
//XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start)
int16 gsa_dsPrevSNRMargnPerBand[32];
int16 gsa_dsPresentSNRMargnPerBand[32];
int16 gs_lastLoadedBin;
//XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(end)
#ifdef VR9_DEC_TRAIN_DBG
int16 gsa_RxDecTrainSilenceBuf[1024];
int16 gsa_RxDecTrainMedleyBuf[1024];
#endif //VR9_DEC_TRAIN_DBG
// XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (END)
int16 gsa_deccapturedata[1024];
// define your debug data here
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START - END)
#if     defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)
uint32 gula_fifo3_dbg[1024];
#endif //#if    defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)

#ifdef ADSL_62
// temporary variables
int16 gs_save_computed_decdelay, gs_dec_path_delay;
#ifdef HERCULES_ADSL_CPE
int32 gla_g997_cell_bit_errs[NUM_DATA_PATHS];



// XDSLRTFW-575: Counter Write back in ADSL mode (Start)
//int32 gla_g997_CRC_Runningcnt[NUM_DATA_PATHS];
//int32 gla_g997_FEC_Runningcnt[3*NUM_DATA_PATHS];
//int32 gla_g997_FE_CRC_Runningcnt[NUM_DATA_PATHS];
//int32 gla_g997_FE_FEC_Runningcnt[NUM_DATA_PATHS];
// XDSLRTFW-575: Counter Write back in ADSL mode (End)
#endif // HERCULES_ADSL_CPE

//XDSLRTFW-1727
int16 gsa_OffsetSnrBuf[512];
//int16 gsa_NewGains[512];


/*  Reed-Solomon error counters */
int16 gsa_CorrectedRSErrors[NUM_DATA_PATHS] = { 0 , 0 }; // # of corrected Reed-Solomon errors (not # of corrected codewords) in each latency path since start of showtime.
// XDSLRTFW-575: Counter Write back in ADSL mode (Start)
uint32 gula_UncorrectableRSCodewordCnt[NUM_DATA_PATHS]; // # of uncorrectable Reed-Solomon codewords in each latency path since start of showtime.
// XDSLRTFW-575: Counter Write back in ADSL mode (End)
uint32 gula_CorrectedRSErrors[NUM_DATA_PATHS];    // 32bit # of corrected Reed-Solomon errors in each latency path since start of showtime
int16 gsa_RSi_err_count[NUM_RS_CODE];                                   // RS error count, interleaved path

#endif
uint32 gula_CRC_count_Prev[NUM_DATA_PATHS] = { 0 , 0 };
uint32 gula_CorrectedRSErrors_Prev[NUM_DATA_PATHS]= { 0 , 0 };
uint32 gula_UncorrectableRSCodewordCnt_Prev[NUM_DATA_PATHS] ={ 0 , 0 };
int16 gs_RCRecovBurstCnt;

//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
//Data Memory location changed to get some free space in BULK Memory
#if 1
// For DIAGNOSTICS_MODE_PARAMS
int16 gsa_RxHlogDS[RX_NUM_TONES>>1];  // 256 words for DS channel transfer function in log domain
#endif
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)
// XDSLRTFW-732 Feature_DS_B43_GHsTones_for_oISDN(Start_End)
DebugCutBack_t DebugCutBack;

int16 gsa_SignalPSD[(HYB_DECIM_POINTS+1)*28];
//#define DEBUG_ZEP_MEMMAP
int32 gla_tmpBuf[1026];
int16 gsa_ReverbSnrBuf[RX_NUM_TONES];                           /*  REVERB SNR buffer without echo */
int16 gsa_ReverbEchoSnrBuf[RX_NUM_TONES];
int16 gsa_MedleySnrBuf[RX_NUM_TONES];
int16 gsa_TxTimeBuf[1024];
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
#ifdef PPE_ENGINE
uint32 gula_DREG_AR_OVDROP_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_CERRN_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_CERRNP_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_CVN_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32 gula_DREG_AR_CVNP_CNT_Shadow[NUM_BEARER_CHANNELS];
uint32  gul_CRC_P_cnt = 0;      //CRC_P
uint32  gul_CVC_P_cnt = 0;     //CVC_P
uint32  gul_CRC_NP_cnt = 0; //CRC_NP
uint32  gul_CVC_NP_cnt = 0;     //CVC_NP
uint8   guc_TPSTCoptions = 1;   // CMV control parameter, set to 1 as default for testing purpose
//Sriram : For Debug status
FlagT gft_enable_PpeExtraRead;
#endif
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)

//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START_END)
int16 gsa_RxWithOutVnSnrBuf[RX_NUM_TONES];
//DsVnPSDDescriptorTable_t gt_DS_RefVirtNoiseLevel_ADSL2; //reverted back to gdata.c file to section "DATA_BULKO1_BEGIN"
//XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap(start)
//Reusing the Virtual Noise memory for SNR backup in DMT mode
int16 *gpsa_TempSnrBuff;
//XDSLRTFW-686: PERF_DS_DMT_ALL_Bitswap(end)

//XDSLRTFW-438 : During integration of Downstream Virtual Noise feature, build failed due to exceeding memory limit of "BSS_DEILV2_BIS"
//As temporary workaround, this buffer is moved from "Gdata_bis.c" file to "Vr9_1port_debug_data.c" file (valid for single port ADSL2 mode)
//Pending: Resolve memory crunch due to increased size of guca_RCMsgPCBTab[ ].
uint8 guca_RCMsgPCBTab[LEN_C_MSGPCB]; //size of this array increased to store virtual noise break points also - XDSLRTFW-438

// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
uint16 gus_US_Hlogf_m[TX_NUM_TONES];
uint8 guca_US_Quiet_Line_Noise[TX_NUM_TONES];
uint8 guca_US_ShowtimeSNR[TX_NUM_TONES];
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)

// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg (Start)
#ifdef HERC_API
int16 gs_OPTN_ConfigMode_G993_2_Control = 0;
uint8 guc_VDSL2_SI_Spar2_Octet1 = (V2_PROFILES | V2_DFT_SIZE);  // 0x11
uint8 guc_VDSL2_SI_Spar2_Octet2 = (ANNEX_A_US0 | ANNEX_B_US0);  // 0x3
// XDSLRTFW-251
int16 gs_Vdsl2_Profile_Supported = (((V2_PROFILE_35B|V2_PROFILE_30A|V2_PROFILE_17A) << 6) |
                                     V2_PROFILE_12B|V2_PROFILE_12A|V2_PROFILE_8D|V2_PROFILE_8C|V2_PROFILE_8B|V2_PROFILE_8A);
int16 gs_NumOfRFIBands  = 10;
int16 guc_Initial_IDFT_size = 0xD;


// SPAR2 & NPAR3 for SPAR1-Octet-2
uint8 guc_Annex_A_US0_EU_32_52 = 0x3F;  // Support for EU Mask from 32 to 52
uint8 guc_Annex_A_US0_EU_56_64 = 0x7;   // Support for EU Mask from 32 to 52, 128 is a part of the standard but it is excluded for the time being
uint8 guc_Annex_A_US0_ADLU_32_52 = 0x3F;        // Support for ADLU Mask from 32 to 52
uint8 guc_Annex_A_US0_ADLU_56_64 = 0x7; // Support for ADLU Mask from 32 to 52, 128 is a part of the standard but it is excluded for the time being
uint8 guc_US0_supported_profile_12b_17a = 0x3;  // US0 supported in profile 12b,17a

uint8 guc_Annex_B_US0_Profile_25_138KHzA_276KHzM_120_276KHz = 0x7;
uint8 guc_Annex_B_US0_Profile_12b_17a = 0x3;

uint8 guc_Annex_C_US0_Profile_25_138KHzb_276KHzb_type = 0x3;
uint8 guc_Annex_C_US0_Profile_25_138KHzco_276KHzco_type = 0x3;
uint8 guc_Annex_C_US0_Profile_12b_17a = 0x3;
int32 gla_CELength = 0xFFFFF;
#endif
// XDSLRTFW-321 Feature_AB_ALL_ALL_ALL_VDSL_HSK_InADSLFullCLR_Msg (End)

// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (START)
Debug_ProfileInfo_t gt_Decoded_ProfileInfo_t;
// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (END)

// Saved overflow counters for selected states
// Rx States
uint16 gusa_RCReverb2_RxOverflowCnts[NUM_RX_OVFLOW_CNTRS];
uint16 gusa_RCPilot3_RxOverflowCnts[NUM_RX_OVFLOW_CNTRS];
uint16 gusa_RCReverb3_RxOverflowCnts[NUM_RX_OVFLOW_CNTRS];
uint16 gusa_RCMedley_RxOverflowCnts[NUM_RX_OVFLOW_CNTRS];

// Tx States
uint16 gusa_RReverb2_TxOverflowCnts[NUM_TX_OVFLOW_CNTRS];
uint16 gusa_REct_TxOverflowCnts[NUM_TX_OVFLOW_CNTRS];
uint16 gusa_RMedley_TxOverflowCnts[NUM_TX_OVFLOW_CNTRS];

#ifdef DEBUG_ZEP_MEMMAP
    //All the following three addresses are the offset from the beginning of IIBRAM in bytes
    int32 gl_tlex;

    int32 jgZEP_RAM_TX_RX_UCODE_BASE = ZEP_RAM_TX_RX_UCODE_BASE         ;// // ZEP_RAM_TX_RX_UCODE_BASE ;

    int32 jgZEP_RAM_TX_LP0_UCODE_ADDR   = ZEP_RAM_TX_LP0_UCODE_ADDR     ;// //  ZEP_RAM_TX_LP0_UCODE_ADDR ;
    int32 jgZEP_RAM_TX_LP1_UCODE_ADDR   = ZEP_RAM_TX_LP1_UCODE_ADDR     ;// //  ZEP_RAM_TX_LP1_UCODE_ADDR;
    int32 jgZEP_RAM_RX_LP0_UCODE_ADDR   = ZEP_RAM_RX_LP0_UCODE_ADDR     ;// //  ZEP_RAM_RX_LP1_UCODE_ADDR;
    int32 jgZEP_RAM_RX_LP1_UCODE_ADDR   = ZEP_RAM_RX_LP1_UCODE_ADDR     ;// //  ZEP_RAM_RX_LP1_UCODE_ADDR;

    int32 jgZEP_PRAM_BASE = ZEP_PRAM_BASE;              ;// //  ZEP_PRAM_BASE;
    int32 jgZEP_PRAM_BLOCK_SIZE = ZEP_PRAM_BLOCK_SIZE; // // ZEP_PRAM_BLOCK_SIZE;//

    int32 jgZEP_REG_TX_PRAM_SIZE  = ZEP_REG_TX_PRAM_SIZE*4;
    int32 jgZEP_REG_RX_PRAM_SIZE  = ZEP_REG_RX_PRAM_SIZE*4;

    int32 jgZEP_PRAM_TX_LP0_START_ADDR; // = ZEP_PRAM_TX_LP0_START_ADDR;
    int32 jgZEP_PRAM_TX_LP1_START_ADDR; // = ZEP_PRAM_TX_LP1_START_ADDR;

    int32 jgZEP_PRAM_RX_LP0_START_ADDR; // = ZEP_PRAM_RX_LP0_START_ADDR;
    int32 jgZEP_PRAM_RX_LP1_START_ADDR; // = ZEP_PRAM_RX_LP1_START_ADDR;

    int32 jgZEP_RAM_OHFIFO_BASE  = ZEP_RAM_OHFIFO_BASE  ;// //  ZEP_RAM_OHFIFO_BASE;

    int32 jgZEP_RAM_ILV_DLIV_BASE  = ZEP_RAM_ILV_DLIV_BASE ;// //       ZEP_RAM_ILV_DLIV_BASE   ;

    int32 jgZEP_RAM_ILV_BASE  = ZEP_RAM_ILV_BASE ;// // ZEP_RAM_ILV_DLIV_BASE   ;
    int32 jgZEP_RAM_DILV_BASE  = ZEP_RAM_DILV_BASE ;// //       ZEP_RAM_ILV_DLIV_BASE   ;

    int32 jgZEP_PRAM_ZR_FIFO_BASE0_LP0_ADDR = ZEP_PRAM_ZR_FIFO_BASE0_LP0_ADDR;

    //========= Configure DTB memory addresses (in 32-bit words) ==================================


    int32 jgZEP_ILV_RAM_TXDTB_LP0_BASE  = ZEP_ILV_RAM_TXDTB_LP0_BASE ;// //     ZEP_ILV_RAM_TXDTB_LP0_BASE       ;// Base of the DTB in 32-bit words

    int32 jgZEP_ILV_RAM_RXDTB_LP0_BASE  = ZEP_ILV_RAM_RXDTB_LP0_BASE    ;// // ZEP_ILV_RAM_RXDTB_LP0_BASE ;

    int32 jgZEP_ILV_RAM_TXDTB_OFFSET    = ZEP_ILV_RAM_TXDTB_OFFSET      ;// // ZEP_ILV_RAM_RXDTB_LP0_BASE ;

    int32 jgZEP_ILV_RAM_RXDTB_OFFSET    = ZEP_ILV_RAM_RXDTB_OFFSET      ;// // ZEP_ILV_RAM_RXDTB_LP0_BASE ;

    //======= Configure the interleaver/deinterleaver memory address (in bytes) =================


    int32 jgZEP_ILV_LP0_BASE = ZEP_ILV_LP0_BASE         ;//     =       ZEP_ILV_LP0_BASE;
    //#define ZEP_ILV_LP1_BASE                          (ZEP_ILV_LP0_BASE+ZEP_ILV_LP0_BLOCK_SIZE)
    int32 jgZEP_DILV_LP0_BASE   = ZEP_DILV_LP0_BASE     ;//     =       ZEP_DILV_LP0_BASE;
    //#define ZEP_DILV_LP1_BASE                         (ZEP_DILV_LP0_BASE+ZEP_DILV_LP0_BLOCK_SIZE)


    //======= Configure the micro-code address (in bytes) =======================================
    int32 jgZEP_RAM_TX_LP0_OHFIFO0_OFFSET       = ZEP_RAM_TX_LP0_OHFIFO0_OFFSET ;// // ZEP_RAM_TX_LP0_OHFIFO0_OFFSET;
    int32 jgZEP_RAM_RX_LP0_OHFIFO0_OFFSET = ZEP_RAM_RX_LP0_OHFIFO0_OFFSET;// //ZEP_RAM_RX_LP0_OHFIFO0_OFFSET;
#endif




//int16 gs_margin_store[480];
#ifdef LOG_HMP_CMV_WRITES
    int16 gs_HmpLogIndex, gsa_HmpLogBuf[HMP_LOG_BUF_SIZE];
#endif

// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
#ifdef L2_RES_DBG
uint8 guc_L2Residue[8];
uint8  guc_L2ResIdx;
uint8 guc_L2ResData[8];
#endif


uint8 guc_IntoL2 = 0;
FlagT gft_SkipDECDownload = FALSE;
int32 gl_dbgFGMaxMips = 0;
int32 gl_dbgTCMaxMips = 0;
int32 gl_dbgFGMaxMips_Training = 0;
int32 gl_dbgTCMaxMips_Training = 0;
int32 gl_dbgMaxTxTCMips = 0;
int32 gl_dbgMaxRxTCMips = 0;
int32 gla_L0ToL2Mips[4] = {0};
uint32 gu_L2SymbCount = 0;
uint32 gul_NumDECSkip = 0;
uint32 gul_NumFalseRevDetect = 0;

//XDSLRTFW-959 BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
//DbgDec gt_DbgDec[119];
DbgDec *gt_DbgDec = (DbgDec *)0x57000;  //change the location to which the data can be logged in showtime.
int16 *gpsa_DbgData;
#endif //#ifdef DEBUG_DEC_ADAPT
//XDSLRTFW-959 BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)


// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

#ifdef DEBUG_STREAMING
uint8 guca_DSH_RX_EOC_msg_buffer[DSH_EOC_BUFFER_LENGTH];
uint8 guca_DSH_TX_EOC_msg_buffer[DSH_EOC_BUFFER_LENGTH];
uint16 gus_DSH_RX_EOC_idx = 0;
uint16 gus_DSH_TX_EOC_idx = 0;
#endif

// XDSLRTFW-1481 (Start)
DsStPilotDescriptorTable_t gt_DS_StPilotDescriptorTable;
// XDSLRTFW-1481 (End)
//XDSLRTFW-2033 (Start)
uint32 gul_PGAResetSec;
uint32 gul_ToneDetectSymbCount;
//XDSLRTFW-2033 (End)
uint32 gul_MedleySymbCount;            //debug
uint32 gul_TotMedpRev4SymbCount;       //debug
uint32 gul_MedleyToRCRatesSymbCount;   //debug
FlagT  gft_MedleyCntUpdate;


int16 gs_hsk_power_dB_Comp; // Used for matching Reference platforms "gs_hsk_tone_power_dB" used for several fixes so matching with Ref platforms required for ex; DSPCB
int16 gs_PGA_required_In_RCComb1_Comp;
int16 gs_hsk_power_dB_VendorComp; //XDSLRTFW-3291


