/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   FILE: channel.h
*
*-------------------------------------------------------------------------
*/
#ifndef _CHANNEL_H
#define _CHANNEL_H

#include "typedef.h"

#define MAX_UPSAMPLING_FACTOR 4
#define MIN_UPSAMPLING_FACTOR 2

typedef struct {
   uint16   us_Length;           /* length of impulse response */
   float64  *pda_Fir;            /* pointer to impulse response */
   int16 *psa_State;          /* pointer to state vector */
   int16 s_OutputShift;       /* Shift applied to contents of the */
                           /* accumulator to produce the output. */
   uint16   us_UpsamplingFactor; /* upsampling factor */

} InterpFirfp_t;
void AecChannel(const int16 *ps_AecDacInBuf, int16 *ps_AecChannelOutBuf);
void Channel(const int16 sa_InBuf[], uint16 us_InBufSize, int16 sa_OutBuf[]);
void InitInterp(void);
InterpFirfp_t *GetInterp(void);
void EchoSim(const int16 *ps_TxInSample, int16 *ps_EchoOutSample);
void ApplyPga(int16 *ps_sample);
#endif /* _CHANNEL_H */
