/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _FILE_IO3_H
#define _FILE_IO3_H
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   file_io3.h
*
*
*-------------------------------------------------------------------------
*/
#include "typedef.h"

extern int16 gs_EndOfRxInputData;

extern int16 gs_downSampleCnt;

/**********************************************************************
 * Functions *
 **********************************************************************/
int16 Mphandler(void);
void  MPHandler_InitialState(void);
int16 MPHandler_BERT(void);
int16 MPHandler_BERT_SF(void);
int16 MPHandler_STRY(void);

int16 ProcCommand(int argc, char *argv[]);
int16 ReadRxInputFile(void);
int16 OpenFiles(void);
int16 CloseFiles(void);
void Close_MP(void);
int16 ReadAnInputSample(int16 *sample);
int16 WriteAnOutputSample(int16 sample);
void Afeif_RxGetSampleForVfdf(int16 *ps_SamplePtr);
void Afeif_TxPutSampleFromVfdf(int16 *ps_SamplePtr);
void Afeif_AecPutSampleFromFdf(int16 *ps_SamplePtr);



int16 ReadTxInputFile(void);
int16 OpenTX_Files(void);
int16 OpenRX_Files(void);
void Update_Sync_Action_Counters(void);
void Check_Sync_Action(FlagT ft_SyncAvailable_Flag, US_FrameParms_t *pt_PathParms);

void SaveRxCells(void);
void LoadTxCells(void);

void ConfigEngineForInitialState(void);
int16 ProcCfg4Modem(void);

#endif /* FILE_IO3_H */

