/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   main_hw.c
 *
 *   Exec for Bit true models
 *
 *----------------------------------------------------------------------------
 */

#include <stdlib.h>
#include "common.h"
#include "gdata.h"
#include "file_io.h"
#include "modem_hw.h"
#include "InitBMf.h"
#include "trail.h"
#include "trailend.h"
#include "file_io3.h"
#include "cmv.h"
#include "nmp_plfm.h"
#include "sach.h"    // For Sachmo channel
#include "LinkStart.h"
#include "LinkStartForTest.h"
#include "states.h"
#include "sleep.h"
#include "AllocateDataBuffers_PreHndshk.h"
#include "dli.h"
#include "cri_ini.h"
#include "RunCores.h"
#include "RunModem.h"

/*Used for TESTMODE_DFE */
#include <conio.h>

extern releaseDLI_t fnReleaseDLI;

static void ExitChannel(void);

void SimulateOLRPMOvhdMsg(void);
/*-------------------------------------------------------------------
*
*  void main(int argc, char *argv[])
*
*  Description: This is the main program for running G.lite CPE C-Modem Simulation.
*
*  Command line arguments:
*
*   main tx_infile tx_outfile rx_infile rx_outfile initial_state [tx_conf rx_conf]
*     tx_infile      - input to tx process (binary unsigned byte file)
*     tx_outfile     - output from tx process (binary int16 file)
*     rx_infile      - input to rx process (binary int16 file)
*       rx_outfile      - output from rx process (binary unsiged byte file)
*     intial_state   - tx state to kick off processing with, current options are
*        GHS            (start in G.handshake state)
*        TRAIN       (proceed directly to trainsceiver training)
*        SHOWTIME    (proceed directly to showtime)
*        RETRAIN        (proceed directly to fast retrain)
*
*     tx_conf:    - optional TX configuration number, determines which set
*                 of (R, S, D, FrameSize, BAT) values are used (see config.c)
*                 default is 0
*     rx_conf:    - optional RX configuration number, determines which set
*                 of (R, S, D, FrameSize, BAT) values are used (see config.c)
*                 default is 0
*
*
*-------------------------------------------------------------------
*^^^
*/

void hw_reset_isr(void);

extern FILE *trail_fid;
FILE *Input_Files_fid = NULL;

FILE *fpmp;

void main(int argc, char *argv[]) {

   int16 s_ExitProgram = 1;
   int16 s_ExitMainLoop = 0;

    int16 l_ch;

   /*  Initialize Behavioral Models */
   InitBMs();

#ifdef ADSL_62
#ifndef TARGET_HW
    // some core inits (especially CRI) during hardware reset
    hw_reset_isr();
#endif
#endif

   // Allocate data buffers and define buffer pointers that are
   // only used for handshake
   AllocateDataBuffers_PreHndshk();

   /* ======================================================================= */
   /*  Initialize CMV's */
   /* ======================================================================= */
   CMVInit_PreHandshake();

   /* ======================================================================= */
   /*  Process command line arguments */
   /* ======================================================================= */
   if(ProcCommand(argc, argv) == FAIL)
      exit(-1);

   /* Initialize Clock, Reset, Interrupt Controller  */
   InitCRI();

    /* ============================================================================= */
   /*  Perform Pre-Handshake Modem Initialization */
   /* ============================================================================= */
   if(InitModem_PreHandshake() == FAIL)
   {
      fprintf(stderr, "Pre-handshake modem initialization fails, exit program!\n");
      exit(-1);
   }
   /* Initialize cmv to Enable Utopia workaround if using 3.0 BMs */
   CMVInit_UtopiaFix();

   /* ==================================================================== */
   /* process File MP message                                  */
   /* MPHandler should be run in the BG -- currently we process         */
   /* one line of the Mp_infid each time Mphandler() is called.         */
   /* ==================================================================== */

   if (gs_MpFileControl == 1)
   {
      while(Mphandler() != FAIL)
      {
         continue;
      }
   }


   /* ======================================================================= */
   /*  Attempt WINHOST connectivity */
   /* ======================================================================= */

   if (AttachMPDLL() == FAIL)
      gs_MpWinhostControl = 0;

   if (gs_MpWinhostControl == 1)
   {
      NewMPInitialize();
   }

   /* ======================================================================= */
   /*  Check that either File or WINHOST MP control is available           */
   /* ======================================================================= */

   if ((gs_MpFileControl == 0) && (gs_MpWinhostControl == 0))
   {
      fprintf(stderr, "Error: No MP Control Available.\n");
      exit(-1);
   }

   // process input script file
   ProcCfg4Modem();

   /* ==================================================================== */
   /*  Processing Data */
   /* ==================================================================== */
   while (s_ExitMainLoop == 0) {

      /* ==================================================================== */
      /* process WINHOST MP message */
      /* ==================================================================== */


      if (gs_ModemOperationRequired == TRUE)
         {
            gs_ModemOperationRequired = 0;

            switch(CNTLArray[0] & 0x000F)
            {
               case 0:     /* Soft Restart   */
                        /* Exit Main Loop, but wait in post loop  */

                  s_ExitMainLoop = 1;
                  s_ExitProgram = 0;
                  break;

               case 1:     /* clear s_ExitProgram to pause after loop   */
                        /* completion  */

                  s_ExitProgram = 0;
                  break;

               case 2:     /* Link Start  */

                  if (TESTArray[TEST_InitState] == TEST_GhsInitState){
                     LinkStart();
                     ConfigForLinkStartAndTest();
                  }
                  else{
                     LinkStartForInitialState();
                  }

                  if (argc == 1) {
                     if ((Input_Files_fid = fopen(SetInputDir("inputfiles.txt"), "rt")) == NULL)
                     {
                        if ((TESTArray[TEST_Control] & TEST_BertControl) == 0) {
                           // ATM idle cells may be transmitted if BERT is disabled
                           // no need to exit here
                        }

                        if ((TESTArray[TEST_Control] & TEST_ConnControl) == 0)
                        {
                        fprintf(stderr,"Must specify RX input file when CONN disabled\n");
                        fprintf(stderr,"Input files may be specified using \"inputfiles.txt\"\n");
                        fprintf(stderr,"when running without command line arguments\n");
                        exit(-1);
                        }
                     }
                     else
                     {
                        fprintf(stderr,"Loading input file from inputfiles.txt\n");
                        fscanf(Input_Files_fid, "%s %s %s %s",
                           Tx_Infile_Name, Tx_Outfile_Name, Rx_Infile_Name, Rx_Outfile_Name);
                        fclose(Input_Files_fid);

                        if ((TESTArray[TEST_Control] & TEST_BertControl) == 0){
                           gs_TxInputFile  = 1;
                        }
                        if ((TESTArray[TEST_Control] & TEST_ConnControl) == 0){
                           gs_TxOutputFile = 1;
                           gs_RxInputFile  = 1;
                        }
                        gs_TxConfigFile = 1;
                        gs_RxConfigFile = 1;
                        gs_RxOutputFile = 1;
                     }
                  }

                  /* ================================================================= */
                  /* if arguments are available, then open input/output files */
                  /* ================================================================= */
                  if (OpenFiles() == FAIL)
                     exit(-1);

#ifdef LEAVE_TRAIL
                  if (gs_TrailFile == 1) {
                     PrnHeader();
                  }
#endif

                  break;

               case 8:     /* sleep mode */

#ifndef TARGET_HW
                  gft_StrymonLpbkMode = STR_TX_RX_LPBK;
#endif

                  if (TESTArray[TEST_InitState] == TEST_GhsInitState){
                     LinkStart();
                     ConfigForLinkStartAndTest();

                  }
                  else{
                     LinkStartForInitialState();
                  }

                  if (argc == 1) {
                     if ((Input_Files_fid = fopen(SetInputDir("inputfiles.txt"), "rt")) == NULL)
                     {
                        if ((TESTArray[TEST_Control] & TEST_BertControl) == 0) {
                           // ATM idle cells may be transmitted if BERT is disabled
                           // no need to exit here
                        }
                        if ((TESTArray[TEST_Control] & TEST_ConnControl) == 0) {
                           fprintf(stderr,"Must specify RX input file when CONN disabled\n");
                           fprintf(stderr,"Input files may be specified using \"inputfiles.txt\"\n");
                           fprintf(stderr,"when running without command line arguments\n");
                           exit(-1);

                        }
                     }
                     else
                     {
                        fprintf(stderr,"Loading input file from inputfiles.txt\n");
                        fscanf(Input_Files_fid, "%s %s %s %s",
                           Tx_Infile_Name, Tx_Outfile_Name, Rx_Infile_Name, Rx_Outfile_Name);
                        fclose(Input_Files_fid);

                        if ((TESTArray[TEST_Control] & TEST_BertControl) == 0){
                           gs_TxInputFile  = 1;
                        }
                        if ((TESTArray[TEST_Control] & TEST_ConnControl) == 0){
                           gs_TxOutputFile = 1;
                           gs_RxInputFile  = 1;
                        }
                        gs_TxConfigFile = 1;
                        gs_RxConfigFile = 1;
                        gs_RxOutputFile = 1;
                     }
                  }

                  /* ================================================================= */
                  /* if arguments are available, then open input/output files */
                  /* ================================================================= */
                  if (OpenFiles() == FAIL)
                     exit(-1);

#ifdef LEAVE_TRAIL
                  if (gs_TrailFile == 1) {
                     PrnHeader();
                  }
#endif

                  gs_TxNextState = SLEEP_TX;
                  gs_RxNextState = SLEEP_RX;
                  gpF_TxStateFunc = (PtrToFunc)RSleepTxF;
                  gpF_RxStateFunc = (PtrToFunc)RSleepRxF;
                  break;

               case 0x0f:     /* Exit Loop and Program   */

                  s_ExitMainLoop = 1;
                  s_ExitProgram = 1;
                  break;
            }
         }


      /* ==================================================================== */
      /* wait for START MP command  */
      /* ==================================================================== */

      if (STATArray[STAT_MacroState] == STAT_InitState){
         if (gs_MpWinhostControl == 1)
         {
            if (NewMPCheckMessage(VBM_MAILBOX)!= 0)
            {
               gs_ModemOperationRequired = NewMPHandleMessage(VBM_MAILBOX);
            }
         }
         continue;
      }

        if ((TESTArray[TEST_Control] & TEST_ConnControl) != 0)
        {
         if ( (gs_TxState == R_SHOWTIME_TX) && (gft_ShowTimeFirstPassTx == 1) )
         {
            gft_ShowTimeFirstPassTx = 2;

            fprintf(stderr,"*** CPE TX SHOWTIME Starts *** \n\n");

         }

         if ( (gs_RxState == R_C_SHOWTIME_RX) && (gft_ShowTimeFirstPassRx == 1) ) {
            gft_ShowTimeFirstPassRx = 2;

            fprintf(stderr,"*** CPE RX SHOWTIME Starts *** \n\n");

         }

         if((gft_ShowTimeFirstPassTx == 2) && (gft_ShowTimeFirstPassRx == 2)) {
            gft_ShowTimeFirstPassTx++;
            gft_ShowTimeFirstPassRx++;
            fprintf(stderr, "Press key \"f\" to go to Fast Retrain\n");
            fprintf(stderr,"Press key \"e\" to end program\n\n");
            fflush(stderr);
         }

         //Check if key strike
         if(_kbhit()) {
            //Get the key being hit
            l_ch = _getch();
            //E is for Exit
            if(l_ch == 'e' || l_ch == 'E') {
               ExitChannel();
               break;
            }
         } //if(_kbhit()) {

   }   // if connected

      /* =================================================================== */
      /* Process data with the cores. Also read and write i/o data files.    */
      /* =================================================================== */
      if(RunCores() == FAIL)
         break;

      /* =================================================================== */
      /* Service interrupts: run time-critical and non time-critical tasks.  */
      /* Also run background tasks.                                          */
      /* =================================================================== */
      if(RunModem() == FAIL)
         break;

      /* =================================================================== */
      /* Simulate OLR, PM with or without Overhead Messaging                 */
      /* =================================================================== */
      SimulateOLRPMOvhdMsg();

      /* =============================================================================== */
      /*  if processing is done, break */
      /* =============================================================================== */
      if ((gs_TxState == gs_TxDoneState) && (gs_RxState == gs_RxDoneState)) {
         fprintf(stderr, "processing halted (RX and TX done state)\n");
         break;
      }
   }

   /* ==================================================================== */
   /* Process MP until exit command */
   /* ==================================================================== */

   /* Indicate to ME that we are in IDLE state */
   STATArray[STAT_MacroState] = STAT_IdleState;

   while (s_ExitProgram == 0)
   {
      if (NewMPCheckMessage(VBM_MAILBOX)!= 0)
      {
         if(NewMPHandleMessage(VBM_MAILBOX) == TRUE)
         {
            switch(CNTLArray[0] & 0x000F)
            {
               case 0x0f:
                  s_ExitProgram = 1;
                  break;
            }
         }
      }
   }

   if((TESTArray[TEST_Control] & TEST_ConnControl) != 0)
   {
      /*Synch with the other modem so both sides will go to exit*/
      ExitChannel();
   }

   /* ==================================================================== */
   /* Shut down modem */
   /* ==================================================================== */
   PrnResults();
   //ShutDownModem();

   if((TESTArray[TEST_Control] & TEST_ConnControl) != 0)
   {

      fprintf(stderr, "----- CPE Modem Exits -------\n");

   }

   if (gs_MpWinhostControl == TRUE)
      ReleaseMPDLL();

   /* ============================================================================ */
   /*  Close input and output files */
   /* ============================================================================ */
   CloseFiles();
   Close_MP();

   exit(0);
}


/*^^^
*-------------------------------------------------------------------
*
*  void ExitChannel(void)
*
*  Description:
*
*     This function shuts down the connectivity channel.
*
*-------------------------------------------------------------------
*^^^
*/
static void ExitChannel(void)
{
   if((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0)
   {
      if((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0)
      {
         // DLI-based connectivity
         ExitRequest();
         ReleaseEventHandlers();
         ReleaseDLL();
      }
      else
         fnReleaseDLI();      // Sample-based DLI
   }
   else {
      // Sachmo-based connectivity
      SACHMO_TerminateChannel();
   }
}
