/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: modem_hw.c
*
*   This file contains exec layer functions, and platform specific functions
*  to be called inside ClockCores().
*
*-------------------------------------------------------------------------------
*/

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "mtkernel.h"
#include "statein1.h"
#include "cmv.h"
#include "str_const.h"
#include "str_cocomo_interface.h"
#include "ft_cocomo_interface.h"
#include "modem_hw.h"
#include "file_io3.h"
#include "dli.h"

int32 gl_tx_count=0, gl_rx_count=0;

FlagT gft_first_skip =1;
int16 gs_skip_cnt =0;
extern processDLI_t fnProcessDLI;

int16 gsa_TmpTxOutBuf[150];
int16 gs_TmpTxOutBufIndex = 0;
int16 gs_TmpTxOutBufIndex_Oversample = 0;

int16 gsa_TxDtoABuf[TX_OUTBUF_FRAME_SIZE]; // output from TX filter (D/A input)
int16 gsa_RxAtoDBuf[RX_ADCBUF_SIZE]; // input ADC buffer
int16 gs_AtoD_PutPtr; // ADC buffer put pointer
int16 gs_AtoD_GetPtr; // ADC buffer get pointer

int16 gs_rxFrameInt, gs_txFrameInt;
int32 gl_TxFrameCnt;
int32 gl_RxFrameCnt;
int16 gs_FirstTimeCounter;

int16 gs_AecDacSample;
int16 gs_AecDacSampleValid;

int16 gs_bypass_strymon = 0;
int16 gs_IridiaUpClockPeriod = 512;
int16 gs_Up_Sample_Clock = 0;
int16 gs_Dn_Sample_Clock = 0;
int16 gs_Strymon_Clock = 0;
int16 gs_TxSampleIndex = 0;
int16 gs_RxSampleIndex = 0;
int16 gs_ZeroSample = 0;
int16 gs_upIndex;
int16 gs_sampleCnt;
int16 gs_skipSampleCnt;
uint32 gl_TotalRxSampleCount = 0;
int16  gs_txifft_dli_downsample = 1;

extern void FTB_ReadFdfIfftSample(uc_port, ul_address, uc_last_samp, uc_clr_samp, l_data);
extern void FTB_WriteFdfFftSample(uc_port, ul_address, uc_last_samp, uc_write_samp, l_data);
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void Afeif_TxPutSampleFromVfdf(int16 *ps_SamplePtr)
*
*  This function is called from ClockCores().
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void Afeif_TxPutSampleFromVfdf(int16 *ps_SamplePtr)
{
    WriteAnOutputSample(*ps_SamplePtr);
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void StrymonCPE_Bypass_Support(void)
*
*  This function is called from ClockCores().
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

#define IRIDIA_DN_CLOCK_PERIOD_4416MHZ  (1) // 4.416 MHz
#define IRIDIA_DN_CLOCK_PERIOD_2208MHZ  (2) // 2.208 MHz

#ifdef INTERPDEC
#define TX_IFFT_DLI_DOWNSAMPLE_PLUS   (4)
#define TX_IRIDIA_UPCLOCK_PERIOD_PLUS (2)
#else
#define TX_IFFT_DLI_DOWNSAMPLE_PLUS   (8)
#define TX_IRIDIA_UPCLOCK_PERIOD_PLUS (1)
#endif //INTERPDEC
#define TX_IFFT_DLI_DOWNSAMPLE_BIS    (4)
#define TX_IRIDIA_UPCLOCK_PERIOD_BIS  (2)

void StrymonCPE_Bypass_Support(void)
{
   int16 s_IRIDIA_DN_CLOCK_PERIOD;

   gs_Strymon_Clock++;
   gs_Dn_Sample_Clock++;
   gs_Up_Sample_Clock++;


   if (gs_bypass_strymon == 1) {

#if 1
      if (gs_RxFftLength == 1024)
      {
         s_IRIDIA_DN_CLOCK_PERIOD = IRIDIA_DN_CLOCK_PERIOD_4416MHZ;
         gs_txifft_dli_downsample =TX_IFFT_DLI_DOWNSAMPLE_PLUS;
         gs_IridiaUpClockPeriod = TX_IRIDIA_UPCLOCK_PERIOD_PLUS;
      }
      else
      {
         s_IRIDIA_DN_CLOCK_PERIOD = IRIDIA_DN_CLOCK_PERIOD_2208MHZ;
         gs_txifft_dli_downsample = TX_IFFT_DLI_DOWNSAMPLE_BIS;
         gs_IridiaUpClockPeriod =TX_IRIDIA_UPCLOCK_PERIOD_BIS;
      }
#endif


      if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState) {
//       gft_TxDataPump_On = FALSE;
         gs_skipSampleCnt = 0;
      } else {
         if (gs_RxFftLength == 1024)
            gs_skipSampleCnt = 64;
         else
            gs_skipSampleCnt = 32;
      }

      // For Sachmo, check for Tx samples to be written before
      // checking for Rx samples to be read in order to meet the
      // channel's causality requirement.
      // Existing code had checked for Rx samples first.  There
      // may be no functional difference in checking for one before
      // the other, but until this is confirmed we handle the Sachmo
      // connectivity case separately and leave the file I/O and
      // DLI-connectivity cases unchanged. (T.Tsakiris).

      if ((TESTArray[TEST_Control] & TEST_ConnControl) &&
         ((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) != 0) &&
         ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) == 0)) { // Sachmo-based connectivity

         if (gs_Up_Sample_Clock == gs_IridiaUpClockPeriod)
            OutputIridiaTxSample();

         if (gs_Dn_Sample_Clock == s_IRIDIA_DN_CLOCK_PERIOD)
            InputIridiaRxSample();

      } else { // DLI or Sample-based DLI connectivity

         if (gs_Dn_Sample_Clock == s_IRIDIA_DN_CLOCK_PERIOD)
            {

                InputIridiaRxSample();
                gl_rx_count++;
               if(gl_rx_count== gs_RxFftLength +gs_RxCPLength)
                  gl_rx_count=0;
            }

         if (gs_Up_Sample_Clock == gs_IridiaUpClockPeriod)
            {

            OutputIridiaTxSample();
                gl_tx_count++;
               if(gl_tx_count== gs_TxFftLength_Oversample +gs_TxCPLength_Oversample)
                  gl_tx_count=0;
            }
      }
   }
}

#undef IRIDIA_DN_CLOCK_PERIOD_4416MHZ
#undef IRIDIA_DN_CLOCK_PERIOD_2208MHZ

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void OutputIridiaTxSample(void)
*
*  This function provides samples to DLI (bypassing Strymon).
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void OutputIridiaTxSample(void)
{
   int16 s_DataSample;
   int16 DliRxBuffer[256];
   int32 l_TxInput;

   gs_Up_Sample_Clock = 0;


   //HWE5.0
   //IRI_FT_ReadTxSample(&l_TxInput, &uc_CsBetaStart, &uc_WindowStart, &us_BetaSize, &uc_OffsetIn, &uc_OffsetEr, FDF_IO);

    /*********************************************************************************
   TX cp is inserted  and fed to DLI. In HW6.2, CP Insertion is handled by Strymon
   Since Strymon is bypassed in showtime only test, insert CP through software.
   *********************************************************************************/
     if (gl_tx_count == gs_TxFftLength_Oversample + gs_TxCPLength_Oversample - 1)  //generate bufferswap
         FTB_ReadFdfIfftSample(0, gl_tx_count- gs_TxCPLength_Oversample, 1, 1, &l_TxInput);

     else if (gl_tx_count >= gs_TxCPLength_Oversample)
         FTB_ReadFdfIfftSample(0, gl_tx_count- gs_TxCPLength_Oversample, 0, 1, &l_TxInput);

     else //if (gl_tx_count < gs_TxCPLength_Oversample)  //duplicate and generate CP
         FTB_ReadFdfIfftSample(0, gs_TxFftLength_Oversample -gs_TxCPLength_Oversample + gl_tx_count , 0, 0, &l_TxInput);

     s_DataSample = (int16)(l_TxInput >> 2);

   gs_TxSampleIndex++; //!!! crashes at 8388
   if (gs_TxSampleIndex == 8384)
      gs_TxSampleIndex += gs_Up_Sample_Clock;

    // handle adsl 62 oversampled tx and gsa_TmpTxOutBuf
   // gs_txifft_dli_downsample = tx_ifft_length/128
    if (gs_TmpTxOutBufIndex_Oversample % gs_txifft_dli_downsample  ==0)
    {
      gsa_TmpTxOutBuf[gs_TmpTxOutBufIndex++] = s_DataSample;
    }
    gs_TmpTxOutBufIndex_Oversample++;

   // sample-based DLI connectivity
   if ((TESTArray[TEST_Control] & TEST_ConnControl) &&
      ((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) == 0) &&
      ((TESTArray[TEST_Control2] & TEST_ConnTypeBit1) != 0)) {

      if ((gs_TxFftLength == 128) && (gs_TmpTxOutBufIndex == 8) ||
         (gs_TxFftLength == 64) && (gs_TmpTxOutBufIndex == 4)) {

         if (gs_TxFftLength == 128)
            DownSampler(gsa_TmpTxOutBuf, gsa_TmpTxOutBuf, gs_TmpTxOutBufIndex, 2);

         if (fnProcessDLI(gsa_TmpTxOutBuf, 4, DliRxBuffer) != 0)
            gs_EndOfRxInputData = 1;

         if (gs_AtoD_PutPtr < RX_ADCBUF_SIZE - (gs_RxFftLength >> 4)) {
            memcpy(&gsa_RxAtoDBuf[gs_AtoD_PutPtr], DliRxBuffer, (gs_RxFftLength >> 4)*sizeof(int16));
            gs_AtoD_PutPtr += (gs_RxFftLength >> 4);
         } else {
            memcpy(&gsa_RxAtoDBuf[gs_AtoD_PutPtr], DliRxBuffer, (RX_ADCBUF_SIZE - gs_AtoD_PutPtr)*sizeof(int16));
            memcpy(&gsa_RxAtoDBuf[0], &DliRxBuffer[RX_ADCBUF_SIZE - gs_AtoD_PutPtr], ((gs_RxFftLength >> 4) - (RX_ADCBUF_SIZE - gs_AtoD_PutPtr))*sizeof(int16));
            gs_AtoD_PutPtr = ((gs_RxFftLength >> 4) - (RX_ADCBUF_SIZE - gs_AtoD_PutPtr));
         }

         gs_TmpTxOutBufIndex = 0;
      }
   }

   // if it is DLI or Sample-based DLI mode, then the TmpTxOutBuf
   // is used to copy into dli shared memory
   if (!(TESTArray[TEST_Control] & TEST_ConnControl) ||
      ((TESTArray[TEST_Control2] & TEST_ConnTypeBit0) != 0)) {
      WriteAnOutputSample((int16)s_DataSample);
   }

   gs_upIndex++;
}

#undef TX_IFFT_DLI_DOWNSAMPLE_PLUS
#undef TX_IFFT_DLI_DOWNSAMPLE_BIS
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void InputIridiaRxSample(void)
*
*  This function provides samples to FT core (bypassing Strymon).
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InputIridiaRxSample(void)
{
   int16 s_DataSample;
   uint8 uc_tmp[3]; // used to supply dummy params to IRI_FT_WriteRxSample
   uint16 us_tmp; // used to supply dummy params to IRI_FT_WriteRxSample


   gs_Dn_Sample_Clock = 0;

   if (gs_ZeroSample == 0) {
      if (gs_sampleCnt < gs_skipSampleCnt) {
         gs_sampleCnt++;
         s_DataSample = 0;
      } else {
         if (ReadAnInputSample(&s_DataSample) == FAIL) {
            // ran out of Rx input data. set flag to end simulation
            // but finish processing for this clock cycle.
            gs_EndOfRxInputData = 1;
         }
      }

//    IRI_FT_WriteRxSample(s_DataSample, &uc_tmp[0], &uc_tmp[1], &us_tmp,
//       &uc_tmp[2], RX_TDQ_OUTPUT_DELAY, RX_WINDOW_OUTPUT_DELAY, RX_VARGAIN_OUTPUT_DELAY, FDF_IO);
//        FTB_WriteFdfFftSample(uc_port, ul_address, uc_last_samp, uc_write_samp, l_data);


if (!gft_first_skip)
{
     if (gl_rx_count == gs_RxFftLength+ gs_RxCPLength-1)
         FTB_WriteFdfFftSample(0, gl_rx_count-gs_RxCPLength, 1, 1, s_DataSample);
     else if (gl_rx_count >= gs_RxCPLength)
         FTB_WriteFdfFftSample(0, gl_rx_count-gs_RxCPLength , 0, 1, s_DataSample);

      gs_RxSampleIndex++;
      gl_TotalRxSampleCount++; // useful for debugging.

      if (TESTArray[TEST_Control] & TEST_UpsampleControl) {
         gs_ZeroSample = 1; // insert 0 samples
      }
}
else
{
    if(gl_rx_count>gs_skip_cnt) gft_first_skip=0;
}

   } else {
      // write one more sample for lite
      IRI_FT_WriteRxSample((int16)0, &uc_tmp[0], &uc_tmp[1], &us_tmp,
         &uc_tmp[2], RX_TDQ_OUTPUT_DELAY, RX_WINDOW_OUTPUT_DELAY, RX_VARGAIN_OUTPUT_DELAY, FDF_IO);
      gs_ZeroSample = 0;
   }
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void DownSampler(int16 *psa_inbuf, int16 *psa_outbuf,
*     int16 s_length, int16 s_factor)
*
*  This function downsamples the input by s_factor.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void DownSampler(int16 *psa_inbuf, int16 *psa_outbuf, int16 s_length, int16 s_factor)
{
   int16 i;

   for (i=0;i<(s_length/s_factor);i++)
      psa_outbuf[i] = psa_inbuf[i*s_factor];
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void Pause(int16 s_Marker)
*
*  This function stops the DSL cores (necessary) and allows external debug
*  reads and writes to be performed, dummy here
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void Pause(int16 s_Marker)
{
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: int16 InitModem_PreHandshake(void)
*
*  This function performs pre-GHS initialization for modem (Cocomo version).
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

int16 InitModem_PreHandshake(void)
{
   KernelInit();

   InitGlobalVariables();

   InitModemTasks_PreHandshake();

   InitEngine(); // rename this InitEngine_PreHandshake() ?
   Enable_MTEtoDFE_TxRx();

   return((int16)SUCCEED);
}
