/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   mtkernel_62.c
*
*   Routines to implement multi-tasking kernel.
*   Currently, this file is only used by TARGET_HW build
*-------------------------------------------------------------------------
*/

// ******************************************************************
// mtkernel_62.c
//
// History
//
// 30/8/2011 Vinjam: Integrated "DSL_PPE_CLOCK_CONTROL" code from VR9 VDSL2 code (544316)
//          Add PPE clock change CMV as DSL 15. Bits 0:1 are the new clock setting,
//           Bit 4 is a trigger bit that will be cleared by FW after the register write is done.
//           Grep for XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL
//
// 22/03/2013 Ram: Added code for getting profiling information, as part of L2 Fixes task.
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
// *******************************************************************************************

#include <stdio.h>
#include "common.h"
#include "typedef.h"
#include "xception.h"
#include "mtkernel.h"
#include "gdata.h"
#include "profdbg.h"
#include "DetectInterrupts.h"
#include "cri_iof.h"
#include "fifo.h"
#include "aux_regs.h"
#include "interrupt.h"
#include "hmp_data.h"
#include "hmp_funcs.h"
#include "cmv_Data.h"
#include "trail.h"
#include "AFED_Functions.h"

// enable this macro will reduce loading in FG processing
//#define PROCESS_MP_DURING_QTSTALLS

FlagT gft_stallcontroldisable =0;
int16 gs_stall_cnt=0;

/*****************************************************************************
;  Prototype: void ForegroundHandler(void);
;
;  This function runs the calls to all foreground DSP tasks (including both time
;   critical (TC) and non-time critical (NTC), and both TX and RX. Based on the multiport HW
;   task scheduling method. The RX TC tasks are called first, followed by the TX TC task,
;   TX NTC task and then RX NTC tasks.
;
;  Input Arguments: none.
;
;  Output Arguments: none.
;
;  Return: none.
;
;  Global Variables:
;     gs_InterruptSource - (I) containing the interrupt sources
;     gt_TaskArray[] -- (I) the array of task function pointers
;     gs_RxNextState -- (I) the next RX state
;     gs_RxState -- (I) the current RX state
;
;****************************************************************************/


extern uint8 guc_ftb_rx_qt_stalls;
extern uint8 guc_ftb_tx_qt_stalls;

// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
extern uint8 guc_IntoL2;
extern int32 gl_dbgFGMaxMips;
extern int32 gl_dbgTCMaxMips;
extern int32 gl_dbgFGMaxMips_Training;
extern int32 gl_dbgTCMaxMips_Training;
extern int32 gl_dbgMaxTxTCMips;
extern int32 gl_dbgMaxRxTCMips;
extern int32 gla_L0ToL2Mips[];
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

void ForegroundHandler(void)
{
   FlagT ft_TxQtRun, ft_RxQtRun, ft_RxPmsRun;
   static int16 gs_RxPmsDelayCnt = 1;

   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
   int32 l_Mips = 0;
   int32 l_Mips1 = 0;
   int32 l_Mips2 = 0;
   int32 l_Mips3 = 0;

   l_Mips1 = (int32) ReadRxTimer();
   l_Mips2 = l_Mips1;
   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

   //Check if TX or RX QT is stalled or not
   ft_TxQtRun = !CheckQtStall((uint8)TX);
   ft_RxQtRun = !CheckQtStall((uint8)RX);


   if (gft_stallcontroldisable == 1)
   {
      ft_TxQtRun= 1;
      ft_RxQtRun = 1;
   }

   if(ft_RxQtRun) //If QT is not stalled
      gs_stall_cnt++;
   else
      gs_stall_cnt=0;


   //This flag synchronizes the RX FC NTC run with RX FC TC run
   ft_RxPmsRun = 0;

   //Run DSP tasks in the following order as required in the time-slotted scheduling method
   //1. RX time critical, 2. TX time critical, 3. TX non-time critical, 4. RX non-time critical
   if(ft_RxQtRun) //If QT is not stalled
   {
      //RX time critical test
      if(gs_InterruptMask & (1<<RX_TSC_INT))
      {

          if (gt_TaskArray[RX_TSC_INT].TimeCriticalTask != NULL)
          {
         gt_TaskArray[RX_TSC_INT].TimeCriticalTask();
          }
      }
    }
   else
   {
        //Disable QTP for this frame
      DisableRxQtp();


        // allow at most 2 consecutive stalls  guc_ftb_rx_qt_stalls = 0,1
        if (guc_ftb_rx_qt_stalls == 0)
        {
            guc_ftb_rx_qt_stalls++;

            //Enable QTP in the next frame
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableRxQtp);

            if((gs_RxNextState == R_C_SHOWTIME_RX) || (gs_RxState == R_C_SHOWTIME_RX))
            {
                //we will disable PMS one frame later
                DisableRxPms();

                //Set the bit to enable RX PMS next frame
                AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableRxPms);
            }
        }

      ClearRxStall();
   }

#if 0
  //ProcessTime
    if(gs_InterruptMask & (1<<RX_FRAME_START))
    {
         /* Run RxForeGround after RxProcessTones() */
         if (gt_TaskArray[RX_FRAME_START].TimeCriticalTask != NULL)
         gt_TaskArray[RX_FRAME_START].TimeCriticalTask();
    }
#endif

   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
   l_Mips3 = (int32) ReadRxTimer();

   l_Mips = l_Mips3 - l_Mips2;
   /* Account for fact that timer resets to zero at frame start */
   if (l_Mips < 0) {
      if (gft_RxCPInserted == FALSE) {
         l_Mips += TIME_PER_FRAME_NO_CP;
      } else {
         l_Mips += TIME_PER_FRAME_CP;
      }
   }

   if ((l_Mips > gl_dbgMaxRxTCMips) && (gs_RxState == R_C_SHOWTIME_RX)) {
      gl_dbgMaxRxTCMips = l_Mips;
   }

   l_Mips2 = (int32) ReadRxTimer();
   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

   //TX time critical task
   if(ft_TxQtRun) //If QT is not stalled
   {
      if(gs_InterruptMask & (1<<RX_TSC_INT))
        {
         if (gt_TaskArray[TX_FRAME_START].TimeCriticalTask != NULL)
            {
            gt_TaskArray[TX_FRAME_START].TimeCriticalTask();
            }
        }
   }
   else
   {
      //Disable QTP for this frame
      DisableTxQtp();


        // allow at most 2 consecutive stalls  guc_ftb_tx_qt_stalls = 0,1
        if (guc_ftb_tx_qt_stalls == 0)
        {
            guc_ftb_tx_qt_stalls++;

            //Enable QTP in the next frame
            AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxQtp);

            if((gs_TxNextState == R_SHOWTIME_TX) || (gs_TxState == R_SHOWTIME_TX))
            {
                //Disable PMS for this frame
                DisableTxPms();

                //Enable PMS in the next frame
                AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxPms);
            }
        }

      ClearTxStall();
   }

   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
   l_Mips3 = (int32) ReadRxTimer();
   l_Mips = l_Mips3 - l_Mips2;
   /* Account for fact that timer resets to zero at frame start */
   if (l_Mips < 0) {
      if (gft_RxCPInserted == FALSE) {
         l_Mips += TIME_PER_FRAME_NO_CP;
      } else {
         l_Mips += TIME_PER_FRAME_CP;
      }
   }

   if ((l_Mips > gl_dbgMaxTxTCMips) && (gs_RxState == R_C_SHOWTIME_RX)) {
      gl_dbgMaxTxTCMips = l_Mips;
   }

   l_Mips2 = (int32) ReadRxTimer();
   l_Mips = l_Mips2 - l_Mips1;
   /* Account for fact that timer resets to zero at frame start */
   if (l_Mips < 0) {
      if (gft_RxCPInserted == FALSE) {
         l_Mips += TIME_PER_FRAME_NO_CP;
      } else {
         l_Mips += TIME_PER_FRAME_CP;
      }
   }

   if (gs_RxState != R_C_SHOWTIME_RX) {
      if (l_Mips > gl_dbgTCMaxMips_Training) {
         gl_dbgTCMaxMips_Training = l_Mips;
      }
   } else {
      if (l_Mips > gl_dbgTCMaxMips) {
         gl_dbgTCMaxMips = l_Mips;
      }
   }

   if (guc_IntoL2 > 0) {
      gla_L0ToL2Mips[guc_IntoL2 - 1] = l_Mips;
      guc_IntoL2 = (guc_IntoL2 + 1) & 3;
   }
   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)


   //TX non-time critical task
   if(ft_TxQtRun) //If QT is not stalled
   {
      if(gs_InterruptMask & (1<<RX_TSC_INT))
      {
         if (gt_TaskArray[TX_FRAME_START].NonTimeCriticalTask != NULL)
            {
            gt_TaskArray[TX_FRAME_START].NonTimeCriticalTask();
            }
      }

   }

   //RX non-time critical task
   if (ft_RxQtRun)   //If QT is not stalled
   {
      if(gs_InterruptMask & (1<<RX_TSC_INT))
      {
            if (gt_TaskArray[RX_TSC_INT].NonTimeCriticalTask != NULL)
            {
            gt_TaskArray[RX_TSC_INT].NonTimeCriticalTask();
            }

#ifdef VR9_FIXME
            if(ft_RxPmsRun)
         {

            gt_TaskArray[RX_TSC_INT].NonTimeCriticalTask();
         }
#endif
      }
   }
#ifdef PROCESS_MP_DURING_QTSTALLS
    else
    {
        // run MP msg in rx-stalled frame only
        if (NewMPCheckMessage(0)!= 0)
        {
            gs_ModemOperationRequired = NewMPHandleMessage(0);
        }
    }
#endif


#if 0
//ProcessTime
    if(gs_InterruptMask & (1<<RX_FRAME_START))
    {
        if (gt_TaskArray[RX_FRAME_START].NonTimeCriticalTask != NULL)
      gt_TaskArray[RX_FRAME_START].NonTimeCriticalTask();
    }
#endif

} //ForegroundHandler()


void EnableCores_ForLinkStart(void);
extern uint8 guc_PortActive;
extern int16 FGActive;
int32 gl_IntrCnt;

//#define DEBUG_ZEP_MEMMAP

#ifdef DEBUG_ZEP_MEMMAP
   #include "zep_memmap_cnfg.h"
   extern int32 jgZEP_PRAM_TX_LP0_START_ADDR; // = ZEP_PRAM_TX_LP0_START_ADDR;
   extern int32 jgZEP_PRAM_TX_LP1_START_ADDR; // = ZEP_PRAM_TX_LP1_START_ADDR;

   extern int32 jgZEP_PRAM_RX_LP0_START_ADDR; // = ZEP_PRAM_RX_LP0_START_ADDR;
   extern int32 jgZEP_PRAM_RX_LP1_START_ADDR; // = ZEP_PRAM_RX_LP1_START_ADDR;
#endif

void MasterIntHandler(void)
{
   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
   int32 l_Mips = 0;
   int32 l_Mips1 = 0;
   int32 l_Mips2 = 0;
   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

#ifdef DEBUG_ZEP_MEMMAP
    jgZEP_PRAM_TX_LP0_START_ADDR= ZEP_PRAM_TX_LP0_START_ADDR;
    jgZEP_PRAM_TX_LP1_START_ADDR= ZEP_PRAM_TX_LP1_START_ADDR;
    jgZEP_PRAM_RX_LP0_START_ADDR= ZEP_PRAM_RX_LP0_START_ADDR;
    jgZEP_PRAM_RX_LP1_START_ADDR= ZEP_PRAM_RX_LP1_START_ADDR;
#endif

    gl_IntrCnt++;
    DetectInterrupts();


   if (guc_PortActive == 2)    // the very first frame after LinkStart; cores not enabled yet
    {
        // this function has to be called here; otherwise it will never
        // be called due to TC task only called during QT-run frame.
        // the system starts with QT-stall frames.
        EnableCores_ForLinkStart();

      guc_PortActive = 1;


    }

    if (guc_PortActive == 1)
    {
        //If the previous foreground task has not finished, issue the real-time exception
        if(FGActive == 1)
        {
            // currently, interrutps are disabled until TC/NTC finished so this
            // we never get to this exception; however, if interrupts are erroneously enabled
            // this will keep system from crashing. Also, later when system stable, we might
            // enable interrupts before NTC.
            KernelException((E_CODE_REAL_TIME_EXCEPTION & 0xffff));
        }
        else
        {
           // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
            l_Mips1 = (int32) ReadRxTimer();

            FGActive = 1;
            ForegroundHandler();
            FGActive = 0;

            l_Mips2 = (int32) ReadRxTimer();
            l_Mips = l_Mips2 - l_Mips1;
            /* Account for fact that timer resets to zero at frame start */
            if (l_Mips < 0) {
               if (gft_RxCPInserted == FALSE) {
                  l_Mips += TIME_PER_FRAME_NO_CP;
               } else {
                  l_Mips += TIME_PER_FRAME_CP;
               }
            }

            if (gs_RxState != R_C_SHOWTIME_RX) {
               if (l_Mips > gl_dbgFGMaxMips_Training) {
                  gl_dbgFGMaxMips_Training = l_Mips;
               }
            } else {
               if (l_Mips > gl_dbgFGMaxMips) {
                  gl_dbgFGMaxMips = l_Mips;
               }
            }
            // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

         CheckStackOverflow((int16)E_CODE_STACK_OVERFLOW_IN_NTC);
        }
    }
#ifdef PROCESS_MP_DURING_QTSTALLS
    else
#endif
    {
        // FG is not reachable yet
        if (NewMPCheckMessage(0)!= 0)
        {
            gs_ModemOperationRequired = NewMPHandleMessage(0);
        }
    }

} //void MasterIntHandler(void)

