/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*******************************************************************************
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone: (781) 276 - 4000
*   Fax:   (781) 276 - 4001
*
*   filename: CCloop.c
*
*   This file contains the CircCorrLoop function used in CircularCorrelate (in tdq_init.c).
*
*******************************************************************************/
#include "common.h"
#include "acc40.h"

/*******************************************************************************
*
*   Prototype: void CircCorrLoop(int16 *psa_Signal1, int16 *psa_Signal2,
*                       int16 s_signal1len, int16 s_signal2len, int16 s_offset)
*
*   Description:
*       This function is called by CircularCorrelate to compute the loop
*       for circular correlation of two input signals.
*
*   Arguments:
*       int16 *psa_Signal1    - pointer to 16-bit input signal1
*     int16 *psa_Signal2      - pointer to 16-bit input signal2
*     int16 s_signal1len      - length of input signal1
*     int16 s_signal2len      - length of input signal2
*     int16 s_offset       - offset given
*
*   Return Value:
*
*   Global Variables:
*     int32 l_acc48H       - HI part of the correlation result
*     int32 l_acc48L       - LO part of the correlation result
*
*******************************************************************************/
int32 l_acc48H;
int32 l_acc48L;

void CircCorrLoop(int16 *psa_Signal1, int16 *psa_Signal2, int16 s_signal1len, int16 s_signal2len, int16 s_offset) {

   int16 j;
   int32 l_Prod;
   int32 l_acc40H, l_acc40L;
   int16 s_loop;

   int16 *p_sig1ptr;
   int16 *p_sig2ptr;
   int16 *p_sig2end;


   /* make sure s_Index is within range of signal2 buffer */

   if (s_offset < 0)
      s_offset += s_signal2len;
   if(s_offset >= s_signal2len)
      s_offset -= s_signal2len;

   /* initialize buffer pointer variables */

   p_sig1ptr = psa_Signal1;
   p_sig2ptr = psa_Signal2 + s_offset;
   p_sig2end = psa_Signal2 + s_signal2len;

   /* To insure that the 40 bit accumulator does not saturate,    */
   /* break down the MAC's into blocks <= 512                  */

   do {
      l_acc40L = 0;
      l_acc40H = 0;

      if(s_signal1len > (1<<ACC40_NUM_GUARD_BITS))
         s_loop = (1<<ACC40_NUM_GUARD_BITS);
      else
         s_loop = s_signal1len;

      s_signal1len -= (1<<ACC40_NUM_GUARD_BITS);

      for(j=0; j<s_loop; j++) {
         l_Prod = (int32) (*p_sig1ptr++)*(int32)(*p_sig2ptr++);
         accum40(&l_acc40H, &l_acc40L, l_Prod);

         /* "circularize" the Signal2 buffer by rolling     */
         /* over to buffer start upon reaching buffer end   */
         if (p_sig2ptr == p_sig2end){
            p_sig2ptr = psa_Signal2;
         }

      }

      addAcc40ToAcc48(&l_acc48H, &l_acc48L, l_acc40H, l_acc40L);
   } while(s_signal1len > 0);
}
