/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   Generates Medley sequence
 *
 *------------------------------------------------------------------------
 */


#include "common.h"
#include "gdata.h"
#include "DSLEngin.h"
#include "tx_ops_bis.h"
#include "GenMedly.h"
#include "gdata_bis.h"
#include "Gen_MedleyBisTones.h"



/*^^^
 *------------------------------------------------------------------------
 *
 *  Prototype: void GenerateReferenceSignal(int16 *psa_ref_tones, int16 *psa_reference_signal_out, int16 s_offset, int16 s_modulo, int16 s_fft_length)
 *
 *  Description: Generates Medley sequence
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *
 *------------------------------------------------------------------------
 *^^^
 */

C_SCOPE void GenerateReferenceSignal(int16 *psa_ref_tones, int16 *psa_reference_signal_out, int16 s_offset, int16 s_modulo, int16 s_fft_length)
{
// if(gft_ModemType == G_DMT)
// {

   if (gft_G992_5_Medley14thOrderPRBS == TRUE)
   {
      // Modulate into tone buffer
      Gen_MedleyBisTones(psa_reference_signal_out, guca_RxMedleyBuffer_sav, (int16)NUM_R_C_MEDLEY_BYTES, gs_RxNumTones, gs_RxFirstChannel, (int16)DEC_QPSK_GAIN);
   }
   else
   {
      GenerateMedley(psa_ref_tones, psa_reference_signal_out, s_offset, s_modulo, s_fft_length);
   }

   // }
// else if(gft_ModemType == G_DMT_BIS)
// {
//    // Modulate into tone buffer
//    Gen_MedleyBisTones(psa_reference_signal_out, guca_RxMedleyBuffer_sav, (int16)NUM_R_C_MEDLEY_BYTES, gs_RxNumTones, gs_RxFirstChannel, (int16)DEC_QPSK_GAIN);
// }
}
