/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   trail.c
*
*  Some of the functions used for generating the trail log file.
*  These are functions needed to open and update the log file during
*  execution.
*  The file 'trailend.c' contains additional printing functions needed
*  only after completion of execution.
*
*-------------------------------------------------------------------------
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include "typedef.h"
#include "common.h"
#include "ghs.h"
#include "hndshk_Data.h"
#include "cmv.h"
#include "rt_state.h"
#include "trailfileio_defs.h"
#include "trail_data_const.h"
#include "data_alloc.h"
#include "gdata.h"
#include "bert.h"
#include "trail.h"
#include "const_bis.h"
#include "rx_ib.h"
#include "gdata_bis.h"
#include "tx_plam.h" //for vars referenced in logShowtimeEvent
#include "pll.h"


/*****************************************************************************
;  Prototype: void logShowtimeEventA(uint32 ul_code, int16 s_data)
;
;  Description:
;  A function that is called from the modem code to log debugging information
;  into the statesTrail buffer when a 'bad' event happens in showtime.

;   The logged info is:
               us_marker ,             [AAAx ] to delimit data in the buffer.
               gl_RxSymbolCount,       Lower part of symbol count.
               s_data                  Event dependent info
               gsa_RxToneBuf[toneIndex]      Value of a sync frame tone (to catch CO line drop).
               gs_RxMinMargin,            MinMargin
               gs_crc_cnt              Crc count THIS second.
               gs_contiguous_bad_sec_cnt
               - gs_contiguous_good_sec_cnt CRC history. Has it been clean prior to event?

;
;  The bad events are:code 0> Avg Snr is negative. (Note the signal to the CO is delaed this is not)
;                 code 1> a SEF sync frame occurred.
;                 code 2> a LOS indication from the pilot power calculation.
;
;  Arguments: code (0,1,2)
;           data which is a variable that the calling function wanted to log.
;           For event NegMargin ,  data-> gs_rxAvmargin.
;                 SEF            sef_TotalCount;
                  LOS            gs_LOSCount

;  Return:-
;
;  Global Variables:
;
;****************************************************************************/
void logShowtimeEventA(uint32 ul_code, int16 s_data){
   uint16 us_marker;
   int8 *gca_ShowTimeEventTrig = (void *)&gl_ShowTimeEventTrig;

   ul_code &=3 ; //to protect against bugs in calling routine from crashing. Not really needed.

   ; // in rsegue4txf this is set to 0
   if (gca_ShowTimeEventTrig[ul_code]< NUM_EVENTS_TO_LOG)
   {
      gca_ShowTimeEventTrig[ul_code]++;
      us_marker = (uint16)(0xAAA0 | ul_code);

      DebugTrail(7,DEBUG_LOG_SHOW_EVENT ,
               us_marker , (int16) gl_RxSymbolCount, s_data ,
               gsa_RxToneBuf[2*gt_debugTrailTriggerControl.s_toneIndex], gs_RxMinMargin,
               gs_crc_cnt, (gs_contiguous_bad_sec_cnt - gs_contiguous_good_sec_cnt)    );
   }

}
