/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: accum32.c
;
;  This file contains function accum16to32()
;
;***************************************************************************/

#include "typedef.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : Accum16to32
 *
 *  Description:
 *
 *    accumulates 16 bit data array into a 32 bit accumulator
 *    array.
 *
 *  Prototype:
 *    Accum16to32(int32 *l_accumbuf, int16 *s_databuf, int16 s_length)
 *
 *
 *  Input Arguments:
 *    int32 *l_accumbbuf - Pointer to 32 bit accumulation array
 *    int16 *s_databuf - Pointer to 16 bit data array
 *    int16 s_length - length of both arrays
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void Accum16to32(int32 *l_accumbuf, int16 s_offset1, int16 *s_databuf, int16 s_offset2, int16 s_length)
{
   int16 i;
   l_accumbuf += s_offset1;
   s_databuf += s_offset2;
   for (i = 0; i < s_length; i++)
   {
      (*l_accumbuf++) += (int32)(*s_databuf++);
   }

}



