/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   AFE.c
 *
 *   AFE related functions
 *
 *
 *----------------------------------------------------------------------------
 */

#include "typedef.h"
#include "afe.h"
#include "gdata.h"
#include "math.h"
#include "pga_set.h"
#include "delay.h"



/****************************************************************************
 ;
 ; Subroutine Name : void SetPGA()
 ;
 ; Abstract:  Function for applying computed PGA offset to hardware.
 ;  Checks to see that computed offset does not exceed the capabilities
 ;  of hardware.
 ;
 ; Input Arguments:
 ;      none
 ;
 ; Output Arguments:
 ;      none
 ;
 ; Global Variables
 ;      gs_PGA_set      (I/O)   Current setting of PGA, in dB (Q8.8)
 ;      gs_PGA_offset   (I)     Offset to be applied, in dB (Q8.8)
 ;
 ;  Return:
 ;      none
 ;
 *****************************************************************************/
void SetPGA(void)
{
    int16 s_new_PGA;

    /* apply recommended cutback to current PGA setting */
    s_new_PGA = gs_PGA_required;

    /*  check to see that new setting will not exceed */
    /*  capabilities of hardware */
    if (s_new_PGA > (int16)MAX_PGA) s_new_PGA = (int16)MAX_PGA;
    if (s_new_PGA < (int16)MIN_PGA) s_new_PGA = (int16)MIN_PGA;

    /* ============================================= */
    /*  Hardware specific operation to apply new PGA */
    /*  setting should be placed here */
    /* ============================================= */

    /*  save new setting */
    gs_PGA_set = s_new_PGA;
   gs_CumulAnlgGain = gs_PGA_set;

    gf_Pga = (float)pow(10.0,(double)(s_new_PGA/(20.0*256.0)));
}

void SetInitialPgaToMax()
{

   gs_PGA_required = 23*256; /* use 23dB to avoid Cocomo testvector changes */

}


void AdjustPathGain(void)
{
}

void Reconfig_AFE(void)
{
}
