/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   codeswap.c
*
*  Codeswapping functions.
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// codeswap.c
//
// History
//
//
// 16/05/2013 Kannan: Type of variable "uint16 gus_ExceptionState" is
//  changed to "uint32 gus_ExceptionState" and is declared in
//  "gdata.h", hence declaring here is not required.
//  Note: Though the variable name looks like 16bit, but it is 32 bit.
//  Grep for "XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException"
// ******************************************************************
#include "typedef.h"
#include "const.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "flcswap.h"
#include "nmp_plfm.h"
#include "nmp.h"
#include "gdata.h"
#include "trailphaserr.h"
#include "pll.h"

/* Codeswap global variables */
int16 gs_CodeSwapCount;
int16 gs_CodeSwapSection;
int16 gs_CodeSwapStatus;
int16 gsa_CodeSwapStartState[NUM_SWAP_SECTIONS+1];
int16 gsa_CodeSwapTxStartState[NUM_SWAP_SECTIONS+1];
int32 gla_CodeSwapStartSymbol[NUM_SWAP_SECTIONS+1];
int16 gsa_CodeSwapNextSection[NUM_SWAP_SECTIONS+1];

/* external variables */
extern int16 gs_RxState, gs_RxNextState;
extern int32 gl_RxSymbolCount;


/****************************************************************************
;  Prototype: void SendCodeSwapRequest(void)
;
;  Description:
;       Sends a codeswap request to host.
;
;  Arguments:
;     CodeSwapSection  -- (I) Number indicating the segment to be swapped in.
;
;  Return Value:
;     none
;
;  Global Variables:
;
;****************************************************************************/
void SendCodeSwapRequest(void) {

}

/****************************************************************************
;  Prototype: void InitCodeSwap(void);
;
;  Description:
;       Sets up various global variables for codeswapping.
;
;  Arguments:
;       none
;
;  Return Value:
;     none
;
;  Global Variables:
;     gs_CodeSwapSection   -- (I) Number indicating the segment to be
;                                  swapped in.
;       gsa_CodeSwapStartState[]  -- (I/O) Array of RX state to start
;                                          codeswapping.
;       gla_CodeSwapStartSymbol[] -- (I/O) Array of RX symbolcount to start
;                                          codeswapping.
;     gsa_CodeSwapNextSection[] -- (I/O) Array of next sections to be
;                                          swapped in.
;
;****************************************************************************/
void InitCodeSwap(void) {


}

/****************************************************************************
;  Prototype: int16 HandleCodeSwap(void);
;
;  Description:
;       Swaps 1 packet of code.
;
;  Arguments:
;     none
;
;  Return Value:
;     1 if swap is successful, 0 otherwise.
;
;  Global Variables:
;
;
;****************************************************************************/
void HandleCodeSwap()
{

}

/****************************************************************************
;  Prototype: void FinishCodeSwap(int16 CodeSwapSection);
;
;  Description:
;       Wraps up the current code swap operation.
;
;  Arguments:
;     CodeSwapSection  -- (I) Number indicating the segment swapped in.
;
;  Return Value:
;     none
;
;  Global Variables:
;
;
;****************************************************************************/
void FinishCodeSwap(int16 CodeSwapSection) {


}

/****************************************************************************
;  Prototype: void CheckForCodeSwap(void);
;
;  Description:
;       This function is called in RxForeGround().
;     This function sends a codeswap request to the host and then checks
;       for and processes codeswapping messages until codeswap is completed.
;
;  Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;     gs_RxState        -- (I) Current RX state
;     gl_RxSymbolCount  -- (I) Current RX symbol count
;       gs_CodeSwapCount    -- (I/O) Count indicating how many successful
;                                    codeswap messages have been processed.
;     gs_CodeSwapStatus   -- (I/O) Current codeswap status
;     gs_CodeSwapSection   -- (I) Number indicating the segment to be
;                                  swapped in.
;       gs_CodeSwapStartState  -- (I) RX state to start codeswapping.
;       gl_CodeSwapStartSymbol -- (I) RX symbolcount to start codeswapping.
;       gs_CodeSwapEndState    -- (I) RX state by which codeswapping needs to
;                                     be done.
;       gl_CodeSwapEndSymbol   -- (I) RX symbolcount by which codeswapping
;                                     needs to be done.
;
;****************************************************************************/
void CheckForCodeSwap(void)
{
      if(gft_EnablePLL){
         TrailPhaseError(); //Log the phase error from PLL
      }
}

/****************************************************************************
;  Prototype: FlagT LoadCodeSwapPagesForInitialState(void)
;
;  Description:
;       This function loads in any codeswap pages needed for the initial test
;     state.
;
;  Arguments:
;     none
;
;  Return Value:
;     FlagT ft_LoadComplete: indicate whether Load is complete or not
;
;  Global Variables:
;     TESTArray[TEST_InitState]  (I) the initial state for the test
;
;****************************************************************************/
FlagT LoadCodeSwapPagesForInitialState(void) {
   return (TRUE);
}
