/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*******************************************************************************
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone: (781) 276 - 4000
*   Fax:   (781) 276 - 4001
*
*   filename: decxcorr.c
*
*   This file contains the DECXcorr function used in DEC training.
*
*******************************************************************************/

#include "typedef.h"
#include "acc40.h"

/*******************************************************************************
*
*   Prototype: void DECXcorr(int16 * ps_Signal1Begin, int16 * ps_Signal2Begin,
*           int16 s_Signal1Length, int16 s_Signal2Length,
*           int16 s_Signal1Offset, int16 s_Signal2Offset,
*           int32 * pl_Xcorr, int16 s_cnt, int16 s_pitch, int16 s_RS)
*
*   Description:
*       This function is called by DECTrain2b to help compute the inner loop
*       of the circular cross correlation between the received sequence
*       (DEC_TRAINING_PERIOD*gs_RxSamplesPerFrame) and a "decorrelating
*       sequence" (length = DEC_TRAINING_PERIOD*TxFftLength).
*
*   Arguments:
*     ps_Signal1Begin: (I) pointer to the starting address of the de-correlating sequence
*     ps_Signal2Begin: (I) pointer to the starting address of the received sequence
*     s_Signal1Length: (I) length of the de-correlating sequence
*     s_Signal2Length: (I) length of the received sequence
*     s_Signal1Offset: (I) offset to the de-correlating sequence
*     s_Signal2Offset: (I) offset to the received sequence
*       pl_Xcorr:       (I/O)    pointer to the cross-correlation
*       s_cnt:          (I)   number of times to execute the loop
*       s_pitch:     (I)   ratio of sampling rate of received sequence to
*                          the sampling rate of the decorrelating sequence
*       s_RS:        (I)   amount to scale down accumulator
*
*   Return Value:
*
*   Global Variables:
*
*******************************************************************************/

void DECXcorr(int16 * ps_Signal1Begin, int16 * ps_Signal2Begin,
            int16 s_Signal1Length, int16 s_Signal2Length,
            int16 s_Signal1Offset, int16 s_Signal2Offset,
            int32 * pl_Xcorr, int16 s_cnt, int16 s_pitch, int16 s_RS)
{
   int16 n;
   int32 l_Acc;
   int32 l_Acc40H, l_Acc40L;
   int16 * ps_Signal1End, * ps_Signal2End;
   int16 * psa_TxDataBuf, * psa_RxInBuf;

   psa_TxDataBuf = ps_Signal1Begin + s_Signal1Offset;
   psa_RxInBuf = ps_Signal2Begin + s_Signal2Offset;

   ps_Signal1End = ps_Signal1Begin + s_Signal1Length;
   ps_Signal2End = ps_Signal2Begin + s_Signal2Length;

   if (psa_TxDataBuf >= ps_Signal1End)
      psa_TxDataBuf -= s_Signal1Length;
   if (psa_RxInBuf >= ps_Signal2End)
      psa_RxInBuf -= s_Signal2Length;

   l_Acc40L = 0;
   l_Acc40H = 0;

   for (n=0; n<s_cnt; n++) {
      l_Acc = ((int32) *psa_RxInBuf) * (*psa_TxDataBuf++);
      accum40(&l_Acc40H, &l_Acc40L, l_Acc);
      psa_RxInBuf += s_pitch;

      if (psa_TxDataBuf >= ps_Signal1End)
         psa_TxDataBuf -= s_Signal1Length;
      if (psa_RxInBuf >= ps_Signal2End)
         psa_RxInBuf -= s_Signal2Length;
   }

     *pl_Xcorr += round_acc40(l_Acc40H, l_Acc40L, s_RS);
}

/*******************************************************************************/
