/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        dxc_comp.c
*
* DESCRIPTION:     computes the DEC cross-correlation sequence
*
**************************************************************************/
#include "typedef.h"

/*******************************************************************************
*
*   Prototype: void ComputeDECXcorrSequence(int16 *psa_TxDataBuf, int16 *psa_RxInBuf, int32 *pla_Xcorr,
*              int16 s_TxSignalLen, int16 s_RxSignalLen,
*              int16 s_Log2TxSignalLen, int16 s_XCorrelationLength,
*              int16 s_DECUpsamplingFactor, int16 s_Log2DECUpsamplingFactor)
*
*   Description:
*       This function computes the circular cross-correlation between the received
*       sequence (DEC_TRAINING_PERIOD*gs_RxSamplesPerFrame) and a "decorrelating
*       sequence" (length = DEC_TRAINING_PERIOD*TxFftLengh).
*
*   Arguments:
*       psa_TxDataBuf:             (I)   pointer to the decorrelating sequence
*       psa_RxInBuf:               (I)   pointer to the received sequence
*       pla_Xcorr:                 (I/O) pointer to the cross-correlation buffer
*       s_TxSignalLen:             (I)   length of the decorrelating sequence (must be even)
*     s_RxSignalLen:          (I)   length of the received sequence
*       s_Log2TxSignalLen:         (I)   log2(s_TxSignalLen)
*       s_XCorrelationLength:      (I)   length of the output cross-correlation sequence
*       s_DECUpsamplingFactor:     (I)   ratio of sampling rate of received sequence to
*           the sampling rate of the decorrelating sequence
*       s_Log2DECUpsamplingFactor: (I)   log2(s_DECUpsamplingFactor)
*
*   Return Value:
*       none
*
*   Global Variables:
*
*******************************************************************************/

void DECXcorr(int16 *psa_TxDataBuf, int16 *psa_RxInBuf,
         int16 s_TxSignalLen, int16 s_RxSignalLen,
         int16 s_Offset1, int16 s_Offset2,
         int32 *pl_Xcorr, int16 s_cnt, int16 s_pitch, int16 s_RS);

void ComputeDECXcorrSequence(int16 *psa_TxDataBuf, int16 *psa_RxInBuf, int32 *pla_Xcorr,
               int16 s_TxSignalLen, int16 s_RxSignalLen,
               int16 s_Log2TxSignalLen, int16 s_XCorrelationLength,
               int16 s_DECUpsamplingFactor, int16 s_Log2DECUpsamplingFactor) {
   int16 j, k;
   int32 l_Xcorr;
   int16 s_Offset1, s_Offset2;

   for(j=0; j<s_XCorrelationLength; j++) {

      /* Compute k = (int)(j/gs_DECUpsamplingFactor) */
      k = (j>>s_Log2DECUpsamplingFactor);

      /* Accumulate Xcorrelation */
      l_Xcorr = 0;

      s_Offset1 = -k + s_TxSignalLen;
      s_Offset2 = -k*s_DECUpsamplingFactor+j;

      DECXcorr(psa_TxDataBuf, psa_RxInBuf, s_TxSignalLen, s_RxSignalLen,
         s_Offset1, s_Offset2, &l_Xcorr, s_TxSignalLen,
         s_DECUpsamplingFactor, s_Log2TxSignalLen);

      pla_Xcorr[j] = -l_Xcorr;
   }
}
