/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*******************************************************************************
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone: (781) 276 - 4000
*   Fax:   (781) 276 - 4001
*
*   filename: dxc_init.c
*
*   This file contains the DECXcorr function used in DEC training.
*
*******************************************************************************/
#include "typedef.h"

/*******************************************************************************
*
*   Prototype: FlagT InitDECXcorr(int16 *psa_TxDataBuf, int16 *psa_RxInBuf,
*                      int16 s_TxBufLen, int16 s_RxBufLen, int16 s_pitch);
*
*   Description:
*       This function is called by DECTrain2b to prepare for the computation
*       of the circular cross correlation between the received sequence
*       (DEC_TRAINING_PERIOD*gs_RxSamplesPerFrame) and a "decorrelating
*       sequence" (length = DEC_TRAINING_PERIOD*TxFftLength).
*
*   Arguments:
*       psa_TxDataBuf: (I) pointer to the decorrelating sequence
*       psa_RxInBuf:   (I) pointer to the received sequence
*       s_TxBufLen:    (I) length of the decorrelating sequence (must be even)
*       s_RxBufLen:    (I) length of the received sequence (must be even)
*       s_pitch:       (I) ratio of sampling rate of received sequence to
*           the sampling rate of the decorrelating sequence
*
*   Return Value:
*       TRUE:  successful setup
*       FALSE: setup did not complete
*
*   Global Variables:
*
*******************************************************************************/
FlagT InitDECXcorr(int16 *psa_TxDataBuf, int16 *psa_RxInBuf, int16 s_TxBufLen, int16 s_RxBufLen, int16 s_pitch)
{
   return TRUE;
}
